/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.agent.NoSize;
import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.IntVector;
import chemaxon.descriptors.MarkushDescriptor;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.descriptors.ReactionFingerprint;
import chemaxon.jchem.db.CachePool;
import chemaxon.jchem.db.CacheRegistrationUtil;
import chemaxon.jchem.db.DatabaseOptions;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.DatabaseSearchException;
import chemaxon.jchem.db.FingerprintHandler;
import chemaxon.jchem.db.JChemCache;
import chemaxon.jchem.db.JChemObserverImpl;
import chemaxon.jchem.db.MDTableHandler;
import chemaxon.jchem.db.ScreenedQueueHandler;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.db.UpdateHandler;
import chemaxon.sss.screen.DefaultMarkushScreenOptions;
import chemaxon.sss.screen.handler.ScreenHandler;
import chemaxon.sss.search.JChemSearchOptions;
import chemaxon.struc.Molecule;
import chemaxon.util.BinaryDataUtil;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.DatabaseTools;
import chemaxon.util.SmilesCompressor;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;

final class OldCache
extends JChemCache {
    private static final int BLOCK_SIZE = 32768;
    int initialCapacity;
    final float capacityIncrementRatio = 1.5f;
    final float dataIncrementRatio = 1.25f;
    private int[][] data = null;
    int block;
    int pos;
    private BitSet noRingInfoInFP;
    private byte[][] markushColumn;
    private byte[][][] markushMD;
    private int[] blockIndex;
    private short[] positionInBlock;
    private short[] smilesLength;
    int fpColumnCount;
    int cfpColumnCount;
    private boolean compressSmiles = true;
    @NoSize
    private SmilesCompressor smilesCompressor = null;
    boolean reactionTable = false;
    boolean markushTable = false;
    boolean queryTable = false;
    boolean indexTable = false;
    String[] markushDescriptorNames = new String[]{"MSCR"};
    String[] markushDescriptorTables;
    private boolean isRegistered = false;
    private long registrationTime = 0L;
    private boolean readOnlyDatabase = false;
    private final JChemObserverImpl obs = JChemObserverImpl.create(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OldCache(ConnectionHandler conh, String tableName, String cacheHashKey, int columnsToCache, int initialCapacity, boolean indexTable, CachePool cachePool, String timeStamp, JChemObserverImpl jcoImpl) throws SQLException, DatabaseSearchException {
        super(conh, tableName, cacheHashKey, TableInfo.getLogTableName(tableName), CacheRegistrationUtil.getCacheID(), 1000, cachePool, timeStamp, indexTable, jcoImpl);
        this.initialCapacity = initialCapacity;
        this.cachePool = cachePool;
        this.dbProp = new DatabaseProperties(conh, indexTable);
        this.con = conh.getConnection();
        this.dbProp.setConnectionHandler(conh);
        if (this.compressSmiles) {
            this.smilesCompressor = new SmilesCompressor();
        }
        this.fpColumnCount = columnsToCache;
        if (this.fpColumnCount == 0) {
            int numberOfBits = 0;
            numberOfBits = FingerprintHandler.getNumberOfBits(conh, tableName, indexTable);
            if (numberOfBits == Integer.MIN_VALUE) {
                throw new DatabaseSearchException("No fingerprint information for " + tableName + "\n" + " Run \"jcman -t\" or check the JChemProperties table for structure tables");
            }
            this.cfpColumnCount = BinaryDataUtil.translateBitCountToIntCount(numberOfBits);
            this.fpColumnCount = this.cfpColumnCount + FingerprintHandler.getNumberOfStructuralFPColumns(conh, tableName, indexTable);
        }
        this.cacheHashKey = cacheHashKey;
        this.rdbms = DatabaseOptions.getDBMSType(this.con);
        int tableType = this.dbProp.getTableType(tableName);
        this.reactionTable = tableType == 1;
        this.markushTable = tableType == 3;
        boolean bl = this.queryTable = tableType == 4;
        if (this.markushTable) {
            int descLength = this.markushDescriptorNames.length;
            this.markushDescriptorTables = new String[descLength];
            for (int descIndex = 0; descIndex < descLength; ++descIndex) {
                this.markushDescriptorTables[descIndex] = MDTableHandler.getMDTableName(tableName, this.markushDescriptorNames[descIndex]);
                try {
                    Statement stmt = this.con.createStatement();
                    try {
                        stmt.execute("SELECT * FROM " + this.markushDescriptorTables[0] + " WHERE 1 = 0");
                        continue;
                    }
                    finally {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, e.getMessage());
                    }
                    this.markushDescriptorTables = new String[0];
                    this.markushDescriptorNames = new String[0];
                    descLength = 0;
                }
            }
        } else {
            this.markushDescriptorTables = new String[0];
        }
        if (this.queryTable) {
            this.compressSmiles = false;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "\nStructure cache created.\n** Cache ID: " + this.cacheID + "\n** Table name: " + tableName + "\n** Logtable name: " + this.logTableName + "\n** Cache hash key: " + cacheHashKey + "\n** FP columns: " + this.fpColumnCount);
        }
    }

    private String getQueryString(boolean idNeeded) {
        int i;
        StringBuffer sb = new StringBuffer("SELECT ");
        if (idNeeded) {
            sb.append("a.");
            sb.append("cd_id");
            sb.append(",");
        }
        for (int i2 = 0; i2 < this.fpColumnCount; ++i2) {
            sb.append(" a.");
            sb.append("cd_fp");
            sb.append(i2 + 1);
            sb.append(",");
        }
        if (this.queryTable) {
            sb.append(" a.");
            sb.append("cd_smarts");
        } else {
            sb.append(" a.");
            sb.append("cd_smiles");
        }
        sb.append(",");
        sb.append(" a.");
        sb.append("cd_flags");
        int mdLength = this.markushDescriptorTables.length;
        if (this.markushTable) {
            sb.append(",");
            sb.append(" a.");
            sb.append("cd_markush");
            for (i = 0; i < mdLength; ++i) {
                sb.append(", a" + i + "." + "md_data");
            }
        }
        sb.append(" FROM ");
        if (this.markushTable) {
            for (i = 0; i < mdLength; ++i) {
                sb.append("(");
            }
        }
        sb.append(this.tableName);
        sb.append(" a");
        if (this.markushTable) {
            for (i = 0; i < mdLength; ++i) {
                sb.append(" LEFT OUTER JOIN ");
                sb.append(this.markushDescriptorTables[i]);
                sb.append(" a" + i);
                sb.append(" ON a.cd_id = a" + i);
                sb.append(".cd_id");
                sb.append(")");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private synchronized int load(ConnectionHandler conh) throws SQLException {
        block28: {
            block27: {
                status = 0;
                this.con = conh.getConnection();
                finerLogEnabled = OldCache.logger.isLoggable(Level.FINER);
                if (this.loaded && (this.isRegistered || this.readOnlyDatabase)) break block27;
                al = new ArrayList<String>();
                al.add(this.cacheID);
                table = new Vector<String>(1, 0);
                table.add(this.tableName);
                CachePool.removeLogsForExpiredCaches(conh, al, table, this.obs);
                if (finerLogEnabled) {
                    OldCache.logger.log(Level.FINER, "\nTotal loading of cache for table " + this.tableName);
                }
                status |= 1;
                status |= this.load((IntVector)null);
                break block28;
            }
            if (this.readOnlyDatabase) break block28;
            status |= 2;
            updates = new IntVector();
            inserts = new IntVector();
            deletes = new IntVector();
            loadByComparingIDList = false;
            loadAll = false;
            cacheMarker = CacheRegistrationUtil.generateRandomID();
            CachePool.markLogRecords(this.cacheID, this.logTableName, cacheMarker, conh, this.obs);
            sql = "SELECT update_info FROM " + this.logTableName + " WHERE " + "cache_id" + "='" + cacheMarker + "'";
            if (finerLogEnabled) {
                OldCache.logger.log(Level.FINER, "\nSQL for marking log records:\n  " + sql);
            }
            pstmt = this.con.prepareStatement(sql);
            try {
                rs = pstmt.executeQuery();
lbl33:
                // 2 sources

                try {
                    while (rs.next()) {
                        block29: {
                            change = rs.getString(1);
                            if (change == null || change.equals("Updates")) {
                                loadAll = true;
                                break;
                            }
                            if (change.startsWith("Update:")) {
                                num = change.substring(7);
                                updates.addElement(Integer.parseInt(num));
                                continue;
                            }
                            if (!change.startsWith("Insert:")) break block29;
                            ids = change.substring(7);
                            nums = ids.split(";");
                            for (i = 0; i < nums.length; ++i) {
                                inserts.addElement(Integer.parseInt(nums[i]));
                            }
                            ** GOTO lbl33
                        }
                        if (change.startsWith("Deleted:")) {
                            num = change.substring(8);
                            deletes.addElement(Integer.parseInt(num));
                            continue;
                        }
                        if (!change.equals("Inserts") && !change.equals("Deletes")) continue;
                        loadByComparingIDList = true;
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                pstmt.close();
            }
            if (loadAll) {
                if (finerLogEnabled) {
                    OldCache.logger.log(Level.FINER, "Total reload of cache " + this.tableName + "!");
                }
                status |= this.load((IntVector)null);
                status |= 1;
            } else {
                if (loadByComparingIDList) {
                    if (finerLogEnabled) {
                        OldCache.logger.log(Level.FINER, "Load of cache " + this.tableName + " by comparing ID list");
                    }
                    idList = this.getMissingMarkDeleted(updates);
                    status |= this.load(idList);
                } else {
                    if (finerLogEnabled) {
                        OldCache.logger.log(Level.FINER, "Loading inserted structures only into " + this.tableName);
                    }
                    this.markAsInvalid(deletes);
                    status |= this.load(inserts);
                }
                if ((status & 4) > 0) {
                    return status;
                }
                this.markAsInvalid(updates);
                if (10 * this.invalidItems > this.itemCount) {
                    if (finerLogEnabled) {
                        OldCache.logger.log(Level.FINER, "Total reload of " + this.tableName + ", number of invalid cache rows is greater than 10%!" + "\nInvalid rows: " + this.invalidItems + "\nRow count: " + this.itemCount);
                    }
                    status |= this.load((IntVector)null);
                    status |= 1;
                } else {
                    if (finerLogEnabled) {
                        OldCache.logger.log(Level.FINER, "Loading updated structures only in " + this.tableName);
                    }
                    status |= this.load(updates);
                }
            }
            CachePool.deleteMarkedLogRecords(this.logTableName, cacheMarker, conh, this.obs);
        }
        if ((status & 4) > 0) {
            return status;
        }
        this.sort();
        this.loaded = true;
        return status;
    }

    private void markAsInvalid(IntVector idList) {
        for (int x = 0; x < idList.size(); ++x) {
            int idx = this.findID(idList.elementAt(x));
            if (idx == -1) continue;
            this.fails.remove(this.cd_id[idx]);
            this.cd_id[idx] = -1;
            ++this.invalidItems;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IntVector getMissingMarkDeleted(IntVector exclude) throws SQLException {
        IntVector newList = new IntVector();
        boolean[] found = new boolean[this.cd_id.length];
        Statement stmt = this.con.createStatement();
        try {
            DatabaseOptions.setFetchSize(stmt, 2000, this.rdbms);
            exclude.sort();
            String sql = "SELECT cd_id FROM " + this.tableName;
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "\nSQL for selecting cd_ids:\n  " + sql);
            }
            ResultSet rs = stmt.executeQuery(sql);
            try {
                while (rs.next()) {
                    int id = rs.getInt(1);
                    int idx = this.findID(id);
                    if (idx == -1) {
                        if (exclude.indexOfWithBinarySearch(id) != -1) continue;
                        newList.addElement(id);
                        continue;
                    }
                    found[idx] = true;
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        for (int x = 0; x < this.itemCount; ++x) {
            if (found[x]) continue;
            this.cd_id[x] = -1;
            ++this.invalidItems;
        }
        return newList;
    }

    private synchronized int load(IntVector idList) throws SQLException {
        int status = 0;
        if (idList == null) {
            this.resetCache();
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Cache " + this.tableName + " is reset");
            }
        } else if (idList.size() == 0) {
            return status;
        }
        if (DatabaseOptions.getDBMSType(this.con) == 8) {
            if (idList == null) {
                return this.loadHSQLDB();
            }
            return this.loadHSQLDBList(idList);
        }
        if (DatabaseOptions.getDBMSType(this.con) == 3 && idList == null) {
            String qstring = this.getQueryString(true);
            return this.loadMySQL(qstring);
        }
        boolean prevAutoCommit = false;
        if (this.rdbms == 7 && (prevAutoCommit = this.con.getAutoCommit())) {
            this.con.setAutoCommit(false);
        }
        boolean moreBatchToRead = false;
        int bpos = 0;
        do {
            int cd_id;
            String qstring = this.getQueryString(true);
            if (idList != null) {
                StringBuffer sb = new StringBuffer(" WHERE a.cd_id IN (");
                int endPos = bpos + 1000;
                if (endPos > idList.size() - 1) {
                    endPos = idList.size();
                    moreBatchToRead = false;
                } else {
                    moreBatchToRead = true;
                }
                for (int x = bpos; x < endPos; ++x) {
                    cd_id = idList.elementAt(x);
                    if (x != bpos) {
                        sb.append(",");
                    }
                    sb.append(cd_id);
                }
                sb.append(")");
                qstring = qstring + sb;
                bpos = endPos;
            }
            Statement stmt = this.con.createStatement();
            DatabaseOptions.setFetchSize(stmt, 2000, this.rdbms);
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "\nSQL for cache " + this.tableName + " loading in load() (general case): \n  " + qstring);
            }
            ResultSet rs = stmt.executeQuery(qstring);
            int[] intFP = new int[this.fpColumnCount];
            while (rs.next()) {
                cd_id = rs.getInt(1);
                try {
                    boolean noRingInFP;
                    for (int i = 0; i < this.fpColumnCount; ++i) {
                        intFP[i] = rs.getInt(i + 2);
                    }
                    String smiles = DatabaseTools.readString(rs, this.fpColumnCount + 2);
                    String flags = rs.getString(this.fpColumnCount + 3);
                    byte[] markush = null;
                    Object markushMD = null;
                    if (this.markushTable) {
                        markush = DatabaseTools.readBytes(rs, this.fpColumnCount + 4);
                        markushMD = new byte[this.markushDescriptorTables.length][];
                        for (int i = 0; i < this.markushDescriptorTables.length; ++i) {
                            markushMD[i] = rs.getBytes(this.fpColumnCount + 5 + i);
                        }
                    }
                    if (this.addStructure(cd_id, smiles, intFP, noRingInFP = UpdateHandler.flagsIndicateNoRingInfoInFP(flags), markush, (byte[][])markushMD)) continue;
                    status |= 8;
                    rs.close();
                    stmt.close();
                    return status |= 4;
                }
                catch (Exception e) {
                    this.fails.put(cd_id, e);
                }
            }
            rs.close();
            stmt.close();
        } while (moreBatchToRead);
        if (this.rdbms == 7 && prevAutoCommit) {
            this.con.setAutoCommit(true);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "\nCache " + this.tableName + " loading is ended in load() (general case)." + "\nCache status: " + status);
            this.logCachedTables();
        }
        return status;
    }

    private synchronized int loadHSQLDB() throws SQLException {
        boolean success;
        int status = 0;
        int blockSize = 1024;
        String sql = this.getQueryString(true) + " WHERE cd_id>?";
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "\nSQL for cache " + this.tableName + " loading in loadHSQLDB(): \n  " + sql);
        }
        PreparedStatement pstmt = this.con.prepareStatement(sql);
        DatabaseOptions.setFetchSize(pstmt, blockSize, this.rdbms);
        pstmt.setMaxRows(blockSize);
        int[] intFP = new int[this.fpColumnCount];
        int maxId = 0;
        do {
            int cd_id = 0;
            pstmt.setInt(1, maxId);
            ResultSet rs = pstmt.executeQuery();
            success = false;
            while (rs.next()) {
                boolean noRingInFP;
                success = true;
                cd_id = rs.getInt(1);
                if (cd_id > maxId) {
                    maxId = cd_id;
                }
                for (int i = 0; i < this.fpColumnCount; ++i) {
                    intFP[i] = rs.getInt(i + 2);
                }
                String smiles = DatabaseTools.readString(rs, this.fpColumnCount + 2);
                String flags = rs.getString(this.fpColumnCount + 3);
                byte[] markush = null;
                Object markushMD = null;
                if (this.markushTable) {
                    markush = DatabaseTools.readBytes(rs, this.fpColumnCount + 4);
                    markushMD = new byte[this.markushDescriptorTables.length][];
                    for (int i = 0; i < this.markushDescriptorTables.length; ++i) {
                        markushMD[i] = rs.getBytes(this.fpColumnCount + 5 + i);
                    }
                }
                if (this.addStructure(cd_id, smiles, intFP, noRingInFP = UpdateHandler.flagsIndicateNoRingInfoInFP(flags), markush, (byte[][])markushMD)) continue;
                status |= 8;
                status |= 4;
                success = false;
                break;
            }
            rs.close();
        } while (success);
        pstmt.close();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("\nCache " + this.tableName + " loading is ended in loadHSQLDB()." + "\nCache status: " + status);
            this.logCachedTables();
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int loadHSQLDBList(IntVector idList) throws SQLException {
        int status = 0;
        String sql = this.getQueryString(false) + " WHERE a.cd_id=?";
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "\nSQL for cache " + this.tableName + " loading in loadHSQLDBList(): \n  " + sql);
        }
        PreparedStatement pstmt = this.con.prepareStatement(sql);
        try {
            int[] intFP = new int[this.fpColumnCount];
            for (int x = 0; x < idList.size(); ++x) {
                int cd_id = 0;
                cd_id = idList.elementAt(x);
                pstmt.setInt(1, cd_id);
                ResultSet rs = pstmt.executeQuery();
                try {
                    boolean noRingInFP;
                    if (!rs.next()) continue;
                    for (int i = 0; i < this.fpColumnCount; ++i) {
                        intFP[i] = rs.getInt(i + 1);
                    }
                    String smiles = DatabaseTools.readString(rs, this.fpColumnCount + 1);
                    String flags = rs.getString(this.fpColumnCount + 2);
                    byte[] markush = null;
                    Object markushMD = null;
                    if (this.markushTable) {
                        markush = DatabaseTools.readBytes(rs, this.fpColumnCount + 3);
                        markushMD = new byte[this.markushDescriptorTables.length][];
                        for (int i = 0; i < this.markushDescriptorTables.length; ++i) {
                            markushMD[i] = rs.getBytes(this.fpColumnCount + 4 + i);
                        }
                    }
                    if (this.addStructure(cd_id, smiles, intFP, noRingInFP = UpdateHandler.flagsIndicateNoRingInfoInFP(flags), markush, (byte[][])markushMD)) continue;
                    status |= 8;
                    status |= 4;
                    break;
                }
                finally {
                    rs.close();
                }
            }
        }
        finally {
            pstmt.close();
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("\nCache " + this.tableName + " loading is ended in loadHSQLDBList()." + "\nCache status: " + status);
            this.logCachedTables();
        }
        return status;
    }

    private boolean addStructure(int id, String smiles, int[] intFP, boolean noRingsInFP, byte[] markush, byte[][] markushMD) {
        if (this.itemCount % 1000 == 0 && !this.cachePool.freeMemoryIfNecessary(this)) {
            return false;
        }
        this.ensureCapacity(this.itemCount + 1);
        this.cd_id[this.itemCount] = id;
        this.noRingInfoInFP.set(this.itemCount, noRingsInFP);
        if (this.markushTable) {
            this.markushColumn[this.itemCount] = markush;
            this.markushMD[this.itemCount] = markushMD;
        }
        this.addData(intFP, false);
        this.blockIndex[this.itemCount] = this.block;
        this.positionInBlock[this.itemCount] = (short)(this.pos - intFP.length);
        int length = 0;
        try {
            byte[] bytes = null;
            if (smiles != null) {
                bytes = smiles.getBytes("ASCII");
                if (this.compressSmiles) {
                    bytes = this.smilesCompressor.compress(bytes);
                }
                this.addData(bytes);
                length = bytes.length;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error while compressing id=" + id + ", smiles=" + smiles + ", intFP=" + Arrays.toString(intFP) + ", noRingsInFP=" + noRingsInFP + ", markush=" + Arrays.toString(markush), e);
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("ERROR: compressed smiles exceeded maximum length");
        }
        this.smilesLength[this.itemCount] = (short)length;
        ++this.itemCount;
        return true;
    }

    private void addData(byte[] bytes) {
        int size = BinaryDataUtil.translateBitCountToIntCount(bytes.length << 3);
        int[] ints = BinaryDataUtil.getBytesInInts(bytes, 0, size);
        this.addData(ints, true);
    }

    @Override
    protected void resetCache() {
        super.resetCache();
        this.itemCount = 0;
        this.invalidItems = 0;
        this.data = new int[1][];
        this.data[0] = new int[32768];
        this.cd_id = new int[this.initialCapacity];
        this.noRingInfoInFP = new BitSet(this.initialCapacity);
        if (this.markushTable) {
            this.markushColumn = new byte[this.initialCapacity][];
            this.markushMD = new byte[this.initialCapacity][][];
        }
        this.blockIndex = new int[this.initialCapacity];
        this.positionInBlock = new short[this.initialCapacity];
        this.smilesLength = new short[this.initialCapacity];
        this.pos = 0;
        this.block = 0;
        this.fails.clear();
    }

    private void addData(int[] ints, boolean canCrossBoundary) {
        int size = ints.length;
        int x = 0;
        if (this.pos + size >= 32768) {
            this.addBlock();
            if (canCrossBoundary) {
                while (this.pos < 32768) {
                    this.data[this.block - 1][this.pos++] = ints[x++];
                }
            }
            this.pos = 0;
        }
        for (int i = x; i < size; ++i) {
            this.data[this.block][this.pos++] = ints[i];
        }
    }

    private void addBlock() {
        ++this.block;
        if (this.block >= this.data.length) {
            int[][] newData = new int[(int)((float)this.data.length * 1.25f) + 1][];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        this.data[this.block] = new int[32768];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int loadMySQL(String statement) throws SQLException {
        int status = 0;
        int blockSize = 1000;
        int minid = -1;
        int maxid = -1;
        Statement stmt = this.con.createStatement();
        try {
            ResultSet rs = stmt.executeQuery("SELECT MIN(CD_ID) FROM " + this.tableName);
            try {
                if (!rs.next()) {
                    throw new SQLException("Can't get lowest CD_ID");
                }
                minid = rs.getInt(1);
            }
            finally {
                rs.close();
            }
            rs = stmt.executeQuery("SELECT MAX(CD_ID) FROM " + this.tableName);
            try {
                if (!rs.next()) {
                    throw new SQLException("Can't get highest CD_ID");
                }
                maxid = rs.getInt(1);
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        if (minid == -1 || maxid == -1) {
            throw new SQLException("Can't get lowest or highest CD_ID");
        }
        int current_id = minid;
        statement = statement + " WHERE a.CD_ID>=? AND a.CD_ID<?";
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "\nSQL for cache " + this.tableName + " loading in loadMySQL(): \n  " + statement);
        }
        PreparedStatement pstmt = this.con.prepareStatement(statement);
        try {
            DatabaseOptions.setFetchSize(pstmt, 2000, this.rdbms);
            int[] intFP = new int[this.fpColumnCount];
            while (current_id <= maxid) {
                pstmt.setInt(1, current_id);
                pstmt.setInt(2, current_id + 1000);
                ResultSet rs = pstmt.executeQuery();
                try {
                    while (true) {
                        if (rs.next()) {
                            boolean noRingInFP;
                            int cd_id = rs.getInt(1);
                            for (int i = 0; i < this.fpColumnCount; ++i) {
                                intFP[i] = rs.getInt(i + 2);
                            }
                            String smiles = DatabaseTools.readString(rs, this.fpColumnCount + 2);
                            String flags = rs.getString(this.fpColumnCount + 3);
                            byte[] markush = null;
                            Object markushMD = null;
                            if (this.markushTable) {
                                markush = DatabaseTools.readBytes(rs, this.fpColumnCount + 4);
                                markushMD = new byte[this.markushDescriptorTables.length][];
                                for (int i = 0; i < this.markushDescriptorTables.length; ++i) {
                                    markushMD[i] = rs.getBytes(this.fpColumnCount + 5 + i);
                                }
                            }
                            if (this.addStructure(cd_id, smiles, intFP, noRingInFP = UpdateHandler.flagsIndicateNoRingInfoInFP(flags), markush, (byte[][])markushMD)) continue;
                            status |= 8;
                            int n = status |= 4;
                            return n;
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    rs.close();
                }
                current_id += 1000;
            }
        }
        finally {
            pstmt.close();
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("\nCache " + this.tableName + " loading is ended in loadMySQL()." + "\nCache status: " + status);
            this.logCachedTables();
        }
        return status;
    }

    private void logCachedTables() {
        logger.log(Level.FINEST, "\nLoaded caches:");
        Hashtable<String, Long> cachedTables = this.cachePool.getCachedTables(false);
        for (Map.Entry<String, Long> element : cachedTables.entrySet()) {
            logger.log(Level.FINEST, "** Hash key: " + element.getKey() + ", estimated size: " + element.getValue());
        }
    }

    @Override
    protected void ensureCapacity(int newCapacity) {
        super.ensureCapacity(newCapacity);
        if (this.blockIndex.length < this.cd_id.length) {
            int newSize = this.cd_id.length;
            this.blockIndex = ArrayTools.extendArray(this.blockIndex, newSize);
            this.positionInBlock = ArrayTools.extendArray(this.positionInBlock, newSize);
            this.smilesLength = ArrayTools.extendArray(this.smilesLength, newSize);
            this.noRingInfoInFP.or(new BitSet(newSize));
            if (this.markushTable) {
                byte[][] newMarkushColumn = new byte[this.cd_id.length][];
                System.arraycopy(this.markushColumn, 0, newMarkushColumn, 0, this.markushColumn.length);
                this.markushColumn = newMarkushColumn;
                byte[][][] newMarkushMD = new byte[this.cd_id.length][][];
                System.arraycopy(this.markushMD, 0, newMarkushMD, 0, this.markushMD.length);
                this.markushMD = newMarkushMD;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int loadCache(ConnectionHandler conh, boolean registerCache) throws SQLException {
        boolean cacheAdministration;
        int status = 0;
        boolean bl = cacheAdministration = System.currentTimeMillis() - CachePool.cacheAdministrationTimeout > this.registrationTime;
        if (cacheAdministration) {
            this.cachePool.purgeExpiredTables(this.tableName, this.cacheHashKey, DatabaseProperties.getExistingTables(conh));
        }
        DatabaseProperties dp = new DatabaseProperties(conh, this.indexTable);
        this.readOnlyDatabase = dp.isDatabaseReadonly();
        if (!this.readOnlyDatabase && registerCache && cacheAdministration) {
            boolean permanentCache = CacheRegistrationUtil.isPermanent();
            this.isRegistered = false;
            CachePool.deleteExpiredCacheRegistrationsAndLogs(this.cacheID, conh, this.obs);
            this.registrationTime = System.currentTimeMillis();
            CachePool.manageRegistration(this.cacheID, permanentCache, this.registrationTime, conh, this.observer);
            String timestamp = new Timestamp(System.currentTimeMillis()).toString();
            CacheRegistrationUtil cru = new CacheRegistrationUtil(conh);
            cru.updateValidityTimestamp(timestamp);
            this.isRegistered = true;
        }
        if (!this.isRegistered || !this.isValid(conh)) {
            CachePool cachePool = this.cachePool;
            synchronized (cachePool) {
                if (this.cachePool.maxCacheMemory == 0L) {
                    status |= 4;
                    status |= 8;
                } else {
                    status |= this.load(conh);
                }
                if ((status & 4) > 0) {
                    this.cachePool.cacheHash.remove(this.cacheHashKey);
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "\nCache " + this.tableName + " load was unsuccesful, " + "(hash key: " + this.cacheHashKey + ") has been removed from cache pool.");
                    }
                    if (logger.isLoggable(Level.FINEST)) {
                        this.logCachedTables();
                    }
                }
            }
        }
        return status;
    }

    @Override
    public int getFPColumnCount() {
        if (this.markushTable) {
            return 0;
        }
        return this.fpColumnCount;
    }

    @Override
    public final int getID(int index) {
        return this.cd_id[index];
    }

    @Override
    public final void getSimilarityDescriptor(int index, int[] fp) {
        int size = this.fpColumnCount;
        int block = this.blockIndex[index];
        int p = this.positionInBlock[index];
        for (int x = 0; x < size; ++x) {
            fp[x] = this.data[block][p];
            ++p;
        }
    }

    private final void putScreenedToQueue(int[] fp, int[] fp_noRing, boolean forSuperstructure, boolean forFullSearch, IntVector candidates, boolean isIndices, IntVector nonHits, ScreenedQueueHandler sqh) {
        if (this.reactionTable) {
            this.putScreenedReactionToQueue(fp, fp_noRing, forSuperstructure, forFullSearch, candidates, isIndices, nonHits, sqh);
            return;
        }
        boolean notScreenedIsNeeded = nonHits != null;
        int size = candidates.size();
        for (int i = 0; i < size; ++i) {
            int index = this.getIndex(candidates.get(i), isIndices);
            if (index == -1) continue;
            boolean noRingInfo = this.noRingInfoInFP.get(index);
            int block = this.blockIndex[index];
            int p = this.positionInBlock[index];
            int[] d = this.data[block];
            boolean match = true;
            int x = 0;
            while (x < this.fpColumnCount && match) {
                int query;
                int n = query = noRingInfo ? fp_noRing[x] : fp[x];
                match = forFullSearch && !noRingInfo ? query == d[p] : (forSuperstructure ? (d[p] & query) == d[p] : (d[p] & query) == query);
                ++x;
                ++p;
            }
            if (!match) {
                if (!notScreenedIsNeeded) continue;
                nonHits.addElement(this.cd_id[index]);
                continue;
            }
            sqh.put(this.cd_id[index], index, false);
        }
    }

    private final void putScreenedReactionToQueue(int[] fp, int[] fp_noRing, boolean forSuperstructure, boolean forFullSearch, IntVector candidates, boolean isIndices, IntVector nonHits, ScreenedQueueHandler sqh) {
        boolean notScreenedIsNeeded = nonHits != null;
        int size = candidates.size();
        for (int i = 0; i < size; ++i) {
            int index = this.getIndex(candidates.get(i), isIndices);
            if (index == -1) continue;
            boolean noRingInfo = this.noRingInfoInFP.get(index);
            int block = this.blockIndex[index];
            int[] d = this.data[block];
            short p = this.positionInBlock[index];
            int totalCols = this.fpColumnCount;
            int[] t_fp = new int[this.fpColumnCount];
            System.arraycopy(d, p, t_fp, 0, this.fpColumnCount);
            if (this.reactionTable) {
                int[] r_fp = ReactionFingerprint.getChemicalHashedFingerprint(t_fp, this.cfpColumnCount);
                int structuralKeyColumns = this.fpColumnCount - this.cfpColumnCount;
                totalCols = r_fp.length + structuralKeyColumns;
                int[] fp_new = new int[totalCols];
                System.arraycopy(r_fp, 0, fp_new, 0, r_fp.length);
                System.arraycopy(t_fp, this.cfpColumnCount, fp_new, r_fp.length, structuralKeyColumns);
                t_fp = fp_new;
            }
            boolean match = true;
            for (int x = 0; x < totalCols; ++x) {
                int query = noRingInfo ? fp_noRing[x] : fp[x];
                int target = t_fp[x];
                match = forFullSearch && !noRingInfo ? query == target : (forSuperstructure ? (target & query) == target : (target & query) == query);
            }
            if (!match) {
                if (!notScreenedIsNeeded) continue;
                nonHits.addElement(this.cd_id[index]);
                continue;
            }
            sqh.put(this.cd_id[index], index, false);
        }
    }

    private void putScreenedToQueue(Molecule query, JChemSearchOptions searchOptions, IntVector candidates, boolean isIndices, IntVector nonHits, ScreenedQueueHandler sqh) {
        if (!searchOptions.isMarkushScreeningEnabled()) {
            this.acceptAllScreenCandidates(candidates, isIndices, sqh, false);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Markush screening finished");
            }
            return;
        }
        int descLength = this.markushDescriptorNames.length;
        MarkushDescriptor[] queryDesc = new MarkushDescriptor[descLength];
        for (int descIndex = 0; descIndex < descLength; ++descIndex) {
            try {
                queryDesc[descIndex] = this.createMarkushDescriptor(this.markushDescriptorNames[descIndex]);
                DefaultMarkushScreenOptions screenOptions = new DefaultMarkushScreenOptions(searchOptions);
                queryDesc[descIndex].generateQueryDescriptor(query, screenOptions);
                continue;
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Error in first phase of Markush screening: " + e.getMessage());
                }
                this.acceptAllScreenCandidates(candidates, isIndices, sqh, false);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Markush screening finished");
                }
                return;
            }
        }
        boolean notScreenedIsNeeded = nonHits != null;
        int size = candidates.size();
        for (int i = 0; i < size; ++i) {
            int index = this.getIndex(candidates.get(i), isIndices);
            if (index == -1) continue;
            boolean match = true;
            for (int descIndex = 0; descIndex < descLength && match; ++descIndex) {
                if (this.markushMD[index][descIndex] == null) continue;
                try {
                    MarkushDescriptor targetDesc = this.createMarkushDescriptor(this.markushDescriptorNames[descIndex]);
                    targetDesc.fromData(this.markushMD[index][descIndex]);
                    match = queryDesc[descIndex].acceptTarget(targetDesc);
                    continue;
                }
                catch (SQLException e) {
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine("Error while creating " + this.markushDescriptorNames[descIndex] + "markush descriptor for target: " + e.getMessage());
                }
            }
            if (!match) {
                if (!notScreenedIsNeeded) continue;
                nonHits.addElement(this.cd_id[index]);
                continue;
            }
            sqh.put(this.cd_id[index], index, false);
        }
    }

    @Override
    public IntVector getBeforeEnumScreened(int[] fp, int[] fpNoRing, byte[] queryDescr, JChemSearchOptions searchOptions, IntVector candidates, boolean isIndices, IntVector nonHits) {
        return candidates.cloneIntVector();
    }

    private MarkushDescriptor createMarkushDescriptor(String descName) throws SQLException {
        String type = this.dbProp.getMDTableProperty(this.tableName, descName, "Type");
        String settings = this.dbProp.getMDTableProperty(this.tableName, descName, "Settings");
        MarkushDescriptor desc = (MarkushDescriptor)MolecularDescriptor.newInstance(type);
        desc.setParameters(settings);
        return desc;
    }

    private void acceptAllScreenCandidates(ScreenedQueueHandler sqh, boolean checkDuplicates) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Cache screening accepts all candidates ...");
        }
        IntVector indices = this.getAllIndices();
        IntVector ids = indices.cloneIntVector();
        this.convertIndicesToID(ids);
        sqh.put(ids, indices, checkDuplicates);
    }

    @Override
    public final void getSimilarityDescritporInBytes(int index, byte[] fp) {
        int size = this.fpColumnCount;
        int block = this.blockIndex[index];
        int p = this.positionInBlock[index];
        int[] d = this.data[block];
        int j = 0;
        for (int x = 0; x < size; ++x) {
            int i = d[p];
            fp[j++] = (byte)(i >>> 24 & 0xFF);
            fp[j++] = (byte)(i >>> 16 & 0xFF);
            fp[j++] = (byte)(i >>> 8 & 0xFF);
            fp[j++] = (byte)(i & 0xFF);
            if (++p < 32768) continue;
            p = 0;
            d = this.data[++block];
        }
    }

    @Override
    public final byte[] getStructureStringInBytes(int index) {
        if (this.markushTable) {
            return this.markushColumn[index];
        }
        short length = this.smilesLength[index];
        if (length == 0) {
            return null;
        }
        byte[] result = new byte[length];
        int block = this.blockIndex[index];
        int p = this.positionInBlock[index] + this.fpColumnCount;
        short x = 0;
        boolean endOfString = false;
        while (!endOfString) {
            if (p >= 32768) {
                p = 0;
                ++block;
            }
            int i = this.data[block][p];
            for (int y = 0; y < 4 && !endOfString; ++y) {
                result[x] = BinaryDataUtil.getByte(i, 3 - y);
                if (++x != length) continue;
                endOfString = true;
            }
            ++p;
        }
        if (this.compressSmiles) {
            result = this.smilesCompressor.decompress(result);
        }
        return result;
    }

    @Override
    public final String getStructureString(int index) {
        if (this.markushTable) {
            return "";
        }
        byte[] bytes = this.getStructureStringInBytes(index);
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int getStructureCount() {
        return this.itemCount;
    }

    @Override
    public ScreenHandler getScreenHandler() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValid(ConnectionHandler conh) throws SQLException {
        this.con = conh.getConnection();
        if (!this.loaded) {
            return false;
        }
        boolean ret = false;
        Statement stmt = this.con.createStatement();
        try {
            String sql = "SELECT cache_id FROM " + this.logTableName + " WHERE " + "cache_id" + "='" + this.cacheID + "'";
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "\nSQL for checking new log records for this cache: \n" + sql);
            }
            ResultSet rs = stmt.executeQuery(sql);
            try {
                ret = !rs.next();
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        return ret;
    }

    @Override
    public IntVector getAllIDs() {
        IntVector result = new IntVector(this.itemCount);
        for (int x = 0; x < this.itemCount; ++x) {
            int id = this.cd_id[x];
            if (id == -1) continue;
            result.addElement(id);
        }
        return result;
    }

    @Override
    public IntVector getAllIndices() {
        IntVector result = new IntVector(this.itemCount);
        for (int x = 0; x < this.itemCount; ++x) {
            if (this.cd_id[x] == -1) continue;
            result.add(x);
        }
        return result;
    }

    @Override
    public IntVector convertIndicesToID(IntVector list) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            list.set(i, this.cd_id[list.get(i)]);
        }
        return list;
    }

    @Override
    public IntVector convertIDsToIndices(IntVector list) {
        int j = 0;
        int index = -1;
        for (int i = 0; i < list.size(); ++i) {
            index = this.findID(list.get(i));
            if (index == -1) continue;
            list.set(j, index);
            ++j;
        }
        list.setSize(j);
        return list;
    }

    private void sort() {
        this.sort1(0, this.itemCount);
    }

    private boolean compare(int i1, int i2) {
        return this.cd_id[i1] > this.cd_id[i2];
    }

    @Override
    public int findID(int key) {
        int pos = Arrays.binarySearch(this.cd_id, 0, this.itemCount, key);
        return pos >= 0 ? pos : -1;
    }

    @Override
    public long getSize() {
        long result = 4L * (long)this.block * 32768L + 16L;
        if (this.data != null) {
            result += (long)this.data.length * 4L + 16L;
        }
        if (this.cd_id != null) {
            result += (long)this.cd_id.length * 4L + 16L;
        }
        if (this.noRingInfoInFP != null) {
            result += (long)(this.noRingInfoInFP.size() / 8 + 8);
        }
        if (this.blockIndex != null) {
            result += (long)this.blockIndex.length * 4L + 16L;
        }
        if (this.positionInBlock != null) {
            result += (long)this.positionInBlock.length * 2L + 16L;
        }
        if (this.smilesLength != null) {
            result += (long)this.smilesLength.length * 2L + 16L;
        }
        if (this.markushTable) {
            result += (long)this.markushColumn.length * 4L + 16L;
            for (int x = 0; x < this.markushColumn.length; ++x) {
                byte[] markush = this.markushColumn[x];
                if (markush == null) continue;
                result += (long)(markush.length + 16);
            }
            result += (long)this.markushMD.length * 4L + 16L;
            for (int i = 0; i < this.itemCount; ++i) {
                result += (long)(this.markushMD[i].length * 4 + 16);
                for (int j = 0; j < this.markushMD[i].length; ++j) {
                    if (this.markushMD[i][j] == null) continue;
                    result += (long)(this.markushMD[i][j].length + 16);
                }
            }
        }
        return result;
    }

    private void sort1(int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && this.compare(j - 1, j); --j) {
                    this.swap(j, j - 1);
                }
            }
            return;
        }
        int m = off + len / 2;
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = this.med3(l, l + s, l + 2 * s);
                m = this.med3(m - s, m, m + s);
                n = this.med3(n - 2 * s, n - s, n);
            }
            m = this.med3(l, m, n);
        }
        int v = this.cd_id[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && this.cd_id[b] <= v) {
                if (this.cd_id[b] == v) {
                    this.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && this.cd_id[c] >= v) {
                if (this.cd_id[c] == v) {
                    this.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        this.vecswap(off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecswap(b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.sort1(off, s);
        }
        if ((s = d - c) > 1) {
            this.sort1(n - s, s);
        }
    }

    private int med3(int a, int b, int c) {
        int av = this.cd_id[a];
        int bv = this.cd_id[b];
        int cv = this.cd_id[c];
        return av < bv ? (bv < cv ? b : (av < cv ? c : a)) : (bv > cv ? b : (av > cv ? c : a));
    }

    private void vecswap(int a, int b, int n) {
        int i = 0;
        while (i < n) {
            this.swap(a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    @Override
    protected void swap(int i1, int i2) {
        super.swap(i1, i2);
        int tmp2 = this.blockIndex[i1];
        this.blockIndex[i1] = this.blockIndex[i2];
        this.blockIndex[i2] = tmp2;
        short tmp3 = this.positionInBlock[i1];
        this.positionInBlock[i1] = this.positionInBlock[i2];
        this.positionInBlock[i2] = tmp3;
        short tmp4 = this.smilesLength[i1];
        this.smilesLength[i1] = this.smilesLength[i2];
        this.smilesLength[i2] = tmp4;
        boolean tmp5 = this.noRingInfoInFP.get(i1);
        this.noRingInfoInFP.set(i1, this.noRingInfoInFP.get(i2));
        this.noRingInfoInFP.set(i2, tmp5);
        if (this.markushTable) {
            byte[] tmp6 = this.markushColumn[i1];
            this.markushColumn[i1] = this.markushColumn[i2];
            this.markushColumn[i2] = tmp6;
            byte[][] markushDesc = this.markushMD[i1];
            this.markushMD[i1] = this.markushMD[i2];
            this.markushMD[i2] = markushDesc;
        }
    }

    @Override
    protected String getSQLSelectionString() {
        return "";
    }

    @Override
    protected void putScreenedToQueue0(int[] fp, int[] fp_noRing, Molecule query, JChemSearchOptions searchOptions, boolean forFullSearch, IntVector candidates, boolean isIndices, ScreenedQueueHandler sqh, IntVector nonHits) {
        if (this.markushTable) {
            this.putScreenedToQueue(query, searchOptions, candidates, isIndices, nonHits, sqh);
        } else {
            this.putScreenedToQueue(fp, fp_noRing, searchOptions.getSearchType() == 6, forFullSearch, candidates, isIndices, nonHits, sqh);
        }
    }

    @Override
    protected boolean processResultSet(ResultSet rs) {
        return true;
    }
}

