/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.jchem.db.FieldInfo;
import chemaxon.jchem.db.PropertyNotSetException;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.db.TransferException;
import chemaxon.jchem.db.UpdateHandler;
import chemaxon.jchem.db.UpdateHandlerException;
import chemaxon.jchem.file.FieldData;
import chemaxon.jchem.file.FileInfo;
import chemaxon.jchem.file.MolRecord;
import chemaxon.jchem.file.ProgressWriter;
import chemaxon.jchem.gui.ProgressReporter;
import chemaxon.marvin.io.MRecord;
import chemaxon.marvin.io.MolExportException;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.Molecule;
import chemaxon.util.Cancelable;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.IntArray;
import chemaxon.util.concurrent.ConcurrentProcessor;
import chemaxon.util.concurrent.InputProducer;
import chemaxon.util.concurrent.WorkUnit;
import chemaxon.util.concurrent.WorkUnitFactory;
import chemaxon.util.concurrent.processors.ConcurrentProcessors;
import chemaxon.util.concurrent.util.AbstractWorkUnit;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParallelStructTableUpdater
implements Cancelable {
    public static Log log = LogFactory.getLog(ParallelStructTableUpdater.class);
    private ConnectionHandler conh;
    private String tableName;
    private boolean autoIncImport;
    private volatile boolean cancelled;
    private PrintStream infoStream;
    private ProgressWriter progressWriter;
    private static final String notePrefix = "Molecule count: ";
    private ArrayList<FieldInfo> additionalColumns;
    private String additionalFields;
    private int processed;
    private int duplicates;
    private int empty;
    private int imported;
    private ArrayList<Integer> duplicateIDs;
    private IntArray importedIDs;
    private TableInfo tableInfo;
    private InputProducer molSource;
    private final AtomicReference<ConcurrentProcessor> orderedProcessor = new AtomicReference();
    private int resultOrder = 1;
    private long commitInterval;
    private boolean timing;
    private long totalDbTime;

    private UpdateHandler createUpdateHandler(boolean isHaltOnError) throws SQLException, PropertyNotSetException {
        UpdateHandler updateHandler = this.autoIncImport ? new UpdateHandler(this.conh, 1, this.tableName, this.additionalFields) : new UpdateHandler(this.conh, 2, this.tableName, this.additionalFields);
        updateHandler.setEmptyStructuresAllowed(true);
        updateHandler.setIgnoreChemicalTermsExceptions(!isHaltOnError);
        return updateHandler;
    }

    public void setInfoStream(PrintStream st) {
        this.infoStream = st;
    }

    private void setValues(TableInfo tableInfo, MolRecord record) throws Exception {
        tableInfo.clearValues();
        Enumeration<FieldInfo> eInfo = tableInfo.elements();
        block0: while (eInfo.hasMoreElements()) {
            FieldInfo fieldInfo = eInfo.nextElement();
            if (!fieldInfo.isConnected() || fieldInfo.isChemTermBased() || fieldInfo == tableInfo.getIdField() && this.autoIncImport) continue;
            if (fieldInfo == tableInfo.getStructureField()) {
                String mol = record.getMolfile();
                fieldInfo.setValue(mol, fieldInfo.getType());
                continue;
            }
            for (int i = 0; i < record.getFieldCount(); ++i) {
                FieldData field = record.getField(i);
                if (!field.getName().equals(fieldInfo.getOtherName())) continue;
                fieldInfo.setValue(field.getValue(), fieldInfo.getType());
                continue block0;
            }
        }
    }

    private void setUpdateHandler(UpdateHandler uh, TableInfo tableInfo) throws UpdateHandlerException, SQLException, MolFormatException {
        if (!this.autoIncImport) {
            try {
                uh.setID((Integer)tableInfo.getIdField().getValue());
            }
            catch (ClassCastException e) {
                uh.setID(Integer.parseInt(tableInfo.getIdField().getValue().toString()));
            }
        }
        for (int i = 0; i < this.additionalColumns.size(); ++i) {
            FieldInfo fieldInfo = this.additionalColumns.get(i);
            uh.setValueForAdditionalColumn(i + 1, fieldInfo.getValue(), fieldInfo.getType());
        }
    }

    private void initAdditionalColumnsAndFields() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        this.additionalColumns = new ArrayList();
        for (int i = 0; i < this.tableInfo.size(); ++i) {
            FieldInfo fieldInfo = this.tableInfo.fieldAt(i);
            String fieldName = fieldInfo.getName().toUpperCase();
            if (FieldInfo.isReservedColumnName(fieldName) || !fieldInfo.isConnected() || fieldInfo.isChemTermBased()) continue;
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(fieldName);
            this.additionalColumns.add(fieldInfo);
        }
        this.additionalFields = sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int importFile(ConnectionHandler conh, String tableName, InputProducer molSource, ProgressWriter pw, TableInfo tableInfo, boolean isHaltAtError, int duplicateFilteringOption, boolean setChiralFlag, boolean allowEmptyStructures, boolean printDuplicates, boolean printNonDuplicates, PrintStream os, FileInfo fileInfo, boolean doNotImport, boolean storeDuplicates, boolean storeImported, String nameField, int count) throws SQLException, MolExportException, IOException, PropertyNotSetException, ExecutionException {
        this.conh = conh;
        this.tableName = tableName;
        this.molSource = molSource;
        this.progressWriter = pw;
        this.tableInfo = tableInfo;
        long timingStart = 0L;
        long timingStop = 0L;
        if (this.timing) {
            this.totalDbTime = 0L;
        }
        this.autoIncImport = tableInfo.getIdField().isAutoIncremented();
        this.progressWriter.setNote(notePrefix);
        if (this.commitInterval > 1L && conh.getConnection().getAutoCommit() && log.isWarnEnabled()) {
            log.warn((Object)("commitInterval=" + this.commitInterval + ", but autocommit is on"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("commitInterval=" + this.commitInterval + ", autoCommit=" + conh.getConnection().getAutoCommit()));
        }
        MolExporter exporter = null;
        String outFormat = null;
        if (printDuplicates || printNonDuplicates) {
            outFormat = fileInfo.getFormatString();
            if (outFormat == null) {
                outFormat = "mrv";
            }
            if (outFormat.startsWith("smiles") || outFormat.startsWith("cxsmiles") || outFormat.startsWith("smarts") || outFormat.startsWith("cxsmarts")) {
                outFormat = outFormat + ":T";
                Vector<String> fields = fileInfo.fieldNames;
                for (int x = 0; x < fields.size(); ++x) {
                    if (x > 0) {
                        outFormat = outFormat + ":";
                    }
                    outFormat = outFormat + fields.get(x);
                }
            }
            try {
                exporter = new MolExporter(os, outFormat);
            }
            catch (IllegalArgumentException e) {
                throw new MolExportException("Initialized with invalid format", e);
            }
        }
        this.initAdditionalColumnsAndFields();
        boolean autoCommit = conh.getConnection().getAutoCommit();
        UpdateHandler uh = this.createUpdateHandler(isHaltAtError);
        try {
            uh.setSetChiralFlag(setChiralFlag);
            if (duplicateFilteringOption != 0) {
                uh.setDuplicateFiltering(duplicateFilteringOption);
            }
            if (doNotImport) {
                uh.setImportDisabled(true);
            }
            if (nameField != null) {
                uh.setStructureNameField(nameField);
            }
            this.duplicateIDs = new ArrayList();
            this.importedIDs = new IntArray();
            ConcurrentProcessor wup = this.createWorkUnitProcessor(isHaltAtError);
            try {
                this.orderedProcessor.set(wup);
                wup.start();
                while (!this.isCanceled() && wup.hasNext()) {
                    try {
                        if (count != -1 && this.processed >= count) break;
                        ++this.processed;
                        UpdateHandler.RowData rd = (UpdateHandler.RowData)wup.getNext();
                        if (!(this.progressWriter instanceof ProgressReporter)) {
                            this.progressWriter.setProgress(this.processed);
                        }
                        if (this.processed <= 10 || this.processed % 10 == 0) {
                            this.progressWriter.setNote(notePrefix + this.processed);
                        }
                        MolRecord record = rd.molRecord;
                        Molecule mol = rd.molecule;
                        if (nameField != null) {
                            rd.molName = mol.getName();
                        }
                        if (!allowEmptyStructures && mol.getAtomCount() == 0) {
                            if (this.infoStream != null) {
                                this.infoStream.println("Structure " + this.processed + " is " + "an empty structure, skipped.");
                            }
                            ++this.empty;
                            continue;
                        }
                        this.setValues(tableInfo, record);
                        this.setUpdateHandler(uh, tableInfo);
                        uh.setRowData(rd);
                        boolean cannotImport = false;
                        if (this.timing) {
                            timingStart = System.currentTimeMillis();
                        }
                        int dupID = uh.execute(storeImported);
                        if (this.timing) {
                            timingStop = System.currentTimeMillis();
                            this.totalDbTime += timingStop - timingStart;
                        }
                        if (dupID < 0) {
                            dupID = -dupID;
                            ++this.duplicates;
                            String errorString = "Structure " + this.processed + " already exists" + " (cd_id=" + dupID + ")";
                            if (storeDuplicates) {
                                this.duplicateIDs.add(new Integer(dupID));
                            }
                            cannotImport = true;
                            if (this.infoStream != null) {
                                this.infoStream.println(errorString);
                            }
                        } else {
                            if (storeImported) {
                                this.importedIDs.add(dupID);
                            }
                            ++this.imported;
                        }
                        if (!autoCommit && (long)this.imported % this.commitInterval == 0L) {
                            uh.saveUpdateLogs();
                            conh.getConnection().commit();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Committed at 'imported'=" + this.imported));
                            }
                        }
                        if ((!printDuplicates || !cannotImport) && (!printNonDuplicates || cannotImport)) continue;
                        Molecule molToPrint = MolImporter.importMol(record.getMolfile());
                        MRecord mrec = record.getMRecord();
                        MPropertyContainer props = mrec.getPropertyContainer();
                        String[] keys = props.getKeys();
                        for (int x = 0; x < keys.length; ++x) {
                            String key = keys[x];
                            Object value = props.getObject(key);
                            molToPrint.setPropertyObject(key, value);
                        }
                        exporter.write(molToPrint);
                    }
                    catch (Throwable e) {
                        System.err.println("Error in molecule " + this.processed);
                        if (this.infoStream != null && this.infoStream != System.err) {
                            this.infoStream.println("Error in molecule " + this.processed);
                        }
                        if (isHaltAtError) {
                            if (this.infoStream != null && this.infoStream != System.err) {
                                e.printStackTrace(this.infoStream);
                            }
                            log.warn((Object)"Unexpected error during DB import", e);
                            throw new TransferException("Unexpected error during DB import: " + e.getMessage(), e);
                        }
                        log.warn((Object)"Unexpected error during DB import", e);
                    }
                }
                if (this.isCanceled()) {
                    wup.cancel();
                }
            }
            catch (Throwable throwable) {
                throw new ExecutionException(throwable);
            }
            finally {
                block50: {
                    try {
                        wup.cleanup(Long.MAX_VALUE);
                    }
                    catch (Throwable tbl) {
                        if (!isHaltAtError) break block50;
                        throw new ExecutionException(tbl);
                    }
                }
            }
        }
        finally {
            if (exporter != null) {
                exporter.close();
            }
            uh.close();
            this.progressWriter.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)("processed=" + this.processed + ", duplicates=" + this.duplicates + ", imported=" + this.imported));
            }
        }
        return this.imported;
    }

    private ConcurrentProcessor createWorkUnitProcessor(final boolean isHaltOnError) {
        WorkUnitFactory workUnitFactory = new WorkUnitFactory(){

            @Override
            public WorkUnit createWorkUnit() throws Exception {
                return new UpdateHandlerAdapter(ParallelStructTableUpdater.this.createUpdateHandler(isHaltOnError));
            }
        };
        return ConcurrentProcessors.create(this.resultOrder, this.molSource, workUnitFactory);
    }

    @Override
    public void cancel() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"canceled at: ", (Throwable)new Exception());
        }
        this.cancelled = true;
    }

    public ArrayList<Integer> getDuplicateIDs() {
        return this.duplicateIDs;
    }

    public IntArray getImportedIDs() {
        return this.importedIDs;
    }

    public int getDuplicates() {
        return this.duplicates;
    }

    public int getEmpty() {
        return this.empty;
    }

    public int getProcessed() {
        return this.processed;
    }

    public int getImported() {
        return this.imported;
    }

    @Override
    public boolean isCanceled() {
        boolean retval;
        boolean bl = retval = this.progressWriter.isCanceled() || this.cancelled;
        if (log.isDebugEnabled() && retval) {
            log.debug((Object)("progressWriter.isCancelled()=" + this.progressWriter.isCanceled() + ", this.cancelled=" + this.cancelled));
        }
        return retval;
    }

    public void setCommitInterval(long commitInterval) {
        ParallelStructTableUpdater.checkCommitInterval(commitInterval);
        this.commitInterval = commitInterval;
    }

    public static void checkCommitInterval(long commitInterval) {
        if (commitInterval < 1L) {
            throw new IllegalArgumentException("Commit interval must be greater than zero");
        }
    }

    public boolean isTiming() {
        return this.timing;
    }

    public void setTiming(boolean timing) {
        this.timing = timing;
    }

    public long getTotalDbTime() {
        return this.totalDbTime;
    }

    public int getResultOrder() {
        return this.resultOrder;
    }

    public void setResultOrder(int rowOrderPolicy) {
        switch (rowOrderPolicy) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Row order policy: " + rowOrderPolicy);
            }
        }
        this.resultOrder = rowOrderPolicy;
    }

    private static class UpdateHandlerAdapter
    extends AbstractWorkUnit {
        private final UpdateHandler uh;

        public UpdateHandlerAdapter(UpdateHandler uh) {
            this.uh = uh;
        }

        @Override
        public Object process(Object input) throws Exception {
            MolRecord mr = (MolRecord)input;
            byte[] molBytes = mr.getMRecord().getMolBytes();
            UpdateHandler.RowData rd = molBytes != null ? this.uh.createRowData(molBytes) : this.uh.createRowData(mr.getMolfile());
            rd.molRecord = mr;
            return rd;
        }
    }
}

