/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.jchem.db.FileToSQLHandler;
import chemaxon.jchem.file.ProgressWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

public class ProgressWriterInputStream
extends FilterInputStream {
    private int nread = 0;
    private int size = 0;
    private ProgressWriter pw;
    private FileToSQLHandler handler;
    private String handlerText;

    public ProgressWriterInputStream(String message, InputStream in, long inputSize) {
        super(in);
        try {
            this.size = in.available();
        }
        catch (IOException ioe) {
            this.size = 0;
        }
        this.pw = new ProgressWriter(message, 0L, inputSize);
    }

    public void connectFileToSQLHandler(String message, FileToSQLHandler handler) {
        this.handler = handler;
        this.handlerText = message;
    }

    public ProgressWriter getProgressWriter() {
        return this.pw;
    }

    @Override
    public int read() throws IOException {
        int c = this.in.read();
        if (c >= 0) {
            ++this.nread;
            this.pw.setProgress(this.nread);
            if (this.handler != null) {
                this.pw.setText(this.composeHandlerDataString(this.handler));
            }
        }
        this.cancelCheck();
        return c;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int nr = this.in.read(b);
        if (nr > 0) {
            this.nread += nr;
            this.pw.setProgress(this.nread);
            if (this.handler != null) {
                this.pw.setText(this.composeHandlerDataString(this.handler));
            }
        }
        this.cancelCheck();
        return nr;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int nr = this.in.read(b, off, len);
        if (nr > 0) {
            this.nread += nr;
            this.pw.setProgress(this.nread);
            if (this.handler != null) {
                this.pw.setText(this.composeHandlerDataString(this.handler));
            }
        }
        this.cancelCheck();
        return nr;
    }

    @Override
    public long skip(long n) throws IOException {
        long nr = this.in.skip(n);
        if (nr > 0L) {
            this.nread = (int)((long)this.nread + nr);
            this.pw.setProgress(this.nread);
            if (this.handler != null) {
                this.pw.setText(this.composeHandlerDataString(this.handler));
            }
        }
        return nr;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.pw.close();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
        this.nread = this.size - this.in.available();
        this.pw.setProgress(this.nread);
        if (this.handler != null) {
            this.pw.setText(this.composeHandlerDataString(this.handler));
        }
    }

    private void cancelCheck() throws InterruptedIOException {
        if (this.pw.isCanceled()) {
            if (this.handler == null) {
                InterruptedIOException x = new InterruptedIOException("Work has been cancelled.");
                x.bytesTransferred = this.nread;
                throw x;
            }
            this.handler.stop();
        }
    }

    private String composeHandlerDataString(FileToSQLHandler handler) {
        return this.handlerText + " processed: " + handler.getProcessed() + ", imported: " + handler.getImported() + ", duplicates: " + handler.getDuplicates() + ", empty: " + handler.getEmpty() + " ";
    }
}

