/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.RegenerationConstants;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.db.TableNames;
import chemaxon.jchem.file.ProgressWriter;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.util.ConnectionHandler;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RegenerationChecker {
    protected static Document xml = null;
    protected static String xmlName = null;
    protected static final String defaultXmlFile = "chemaxon/jchem/regeneration.xml";
    public static final String TAG_TABLE_VERSION = "version";
    public static final String TAG_CONDITION = "condition";
    public static final String TAG_PROPERTY = "property";
    public static final String TAG_PROPERTY_NAME = "name";
    public static final String TAG_PROPERTY_VALUE = "value";
    public static final String TAG_FULL = "full";
    public static final String TAG_CT = "ct";
    public static final String TAG_NOCT = "noct";
    public static final String TAG_MD = "md";
    public static final String ATTR_ID = "id";
    public static final String ATTR_OPERATION = "operation";
    public static final String OPER_EQUALS = "eq";
    public static final String OPER_NOT_EQUALS = "noteq";
    private static final Log log = LogFactory.getLog(RegenerationChecker.class);

    public static Document getXml(String xmlFileName) {
        if (xmlFileName == null) {
            xmlFileName = defaultXmlFile;
        }
        if (!xmlFileName.equals(xmlName)) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                InputStream inStream = RegenerationChecker.class.getClassLoader().getResourceAsStream(xmlFileName);
                xml = db.parse(inStream);
                xmlName = xmlFileName;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        return xml;
    }

    public static int isRegenerationNeeded(String tableName, DatabaseProperties dp) throws SQLException {
        return RegenerationChecker.isRegenerationNeeded(tableName, dp, 4);
    }

    public static int isRegenerationNeeded(String tableName, DatabaseProperties dp, int regenerationType) throws SQLException {
        return RegenerationChecker.isRegenerationNeeded(tableName, dp, RegenerationChecker.getXml(null), regenerationType);
    }

    public static int isRegenerationNeeded(String tableName, DatabaseProperties dp, Document xml, int regenerationType) throws SQLException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("isRegenerationNeeded - regenerationType :" + regenerationType));
        }
        HashMap<Integer, Integer> chkRes = new HashMap<Integer, Integer>();
        for (int type : RegenerationConstants.GROUP_TYPE_ANY) {
            int regenResult = RegenerationChecker.isRegenerationNeededExact(tableName, dp, xml, type);
            if (regenResult == 2) {
                return 2;
            }
            chkRes.put(type, regenResult);
        }
        switch (regenerationType) {
            case 4: {
                for (int type : RegenerationConstants.GROUP_TYPE_ANY) {
                    if ((Integer)chkRes.get(type) != 1) continue;
                    return 1;
                }
                break;
            }
            case 1: {
                if ((Integer)chkRes.get(1) != 1 || (Integer)chkRes.get(2) == 1) break;
                return 1;
            }
            case 2: {
                if ((Integer)chkRes.get(2) != 1 || (Integer)chkRes.get(1) == 1) break;
                return 1;
            }
            case 0: {
                if ((Integer)chkRes.get(0) != 1 && ((Integer)chkRes.get(1) != 1 || (Integer)chkRes.get(2) != 1)) break;
                return 1;
            }
        }
        if (chkRes.containsKey(regenerationType)) {
            return (Integer)chkRes.get(regenerationType);
        }
        return 0;
    }

    public static int isRegenerationNeededExact(String tableName, DatabaseProperties dp, Document xml, int regenerationType) throws SQLException {
        Map<String, String> tableProps = dp.getTableProperties(tableName);
        if (tableProps.size() == 0) {
            throw new SQLException("Table '" + tableName + "' does not exist");
        }
        if (regenerationType == 1 && dp.getChemTermColumns(tableName).length < 1 || regenerationType == 3 && dp.getMolecularDescriptors(tableName).length < 1) {
            return 0;
        }
        String property = TAG_TABLE_VERSION;
        if (regenerationType == 1) {
            property = "ctVersion";
        } else if (regenerationType == 3) {
            property = "mdVersion";
        }
        int tableVersion = 0;
        try {
            tableVersion = Integer.parseInt(tableProps.get(property));
        }
        catch (NumberFormatException e) {
            return 1;
        }
        if (tableVersion < VersionInfo.JCHEM_TABLE_VERSION) {
            Element rootElem = xml.getDocumentElement();
            NodeList versions = rootElem.getElementsByTagName(TAG_TABLE_VERSION);
            if (versions != null && versions.getLength() > 0) {
                for (int i = 0; i < versions.getLength(); ++i) {
                    Element versionElem = (Element)versions.item(i);
                    int version = 0;
                    try {
                        version = Integer.parseInt(versionElem.getAttribute(ATTR_ID));
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    if (version <= tableVersion || version > VersionInfo.JCHEM_TABLE_VERSION) continue;
                    String tag = "";
                    switch (regenerationType) {
                        case 0: {
                            tag = TAG_FULL;
                            break;
                        }
                        case 2: {
                            tag = TAG_NOCT;
                            break;
                        }
                        case 1: {
                            tag = TAG_CT;
                            break;
                        }
                        case 3: {
                            tag = TAG_MD;
                            break;
                        }
                    }
                    Element tagElem = (Element)versionElem.getElementsByTagName(tag).item(0);
                    if (tagElem == null) continue;
                    NodeList conditions = tagElem.getElementsByTagName(TAG_CONDITION);
                    if (conditions.getLength() == 0) {
                        return 1;
                    }
                    for (int j = 0; j < conditions.getLength(); ++j) {
                        if (!RegenerationChecker.processCondition((Element)conditions.item(j), tableProps)) continue;
                        return 1;
                    }
                }
            }
        } else if (tableVersion > VersionInfo.JCHEM_TABLE_VERSION) {
            return 2;
        }
        return 0;
    }

    public static int deduceTableVersion(String tableName, DatabaseProperties dp) throws SQLException {
        return RegenerationChecker.deduceTableVersion(tableName, dp, 4);
    }

    public static int deduceTableVersion(String tableName, DatabaseProperties dp, int regenerationType) throws SQLException {
        Map<String, String> tableProps = dp.getTableProperties(tableName);
        Document xml = RegenerationChecker.getXml(null);
        Element rootElem = xml.getDocumentElement();
        NodeList versions = rootElem.getElementsByTagName(TAG_TABLE_VERSION);
        if (versions != null && versions.getLength() > 0) {
            for (int i = versions.getLength() - 1; i >= 0; --i) {
                NodeList conditions;
                Element versionElem = (Element)versions.item(i);
                int version = 0;
                try {
                    version = Integer.parseInt(versionElem.getAttribute(ATTR_ID));
                }
                catch (NumberFormatException e) {
                    continue;
                }
                String tag = "";
                switch (regenerationType) {
                    case 0: {
                        tag = TAG_FULL;
                        break;
                    }
                    case 2: {
                        tag = TAG_NOCT;
                        break;
                    }
                    case 1: {
                        tag = TAG_CT;
                        break;
                    }
                    case 3: {
                        tag = TAG_MD;
                        break;
                    }
                }
                Element tagElem = null;
                tagElem = tag.equals("") ? versionElem : (Element)versionElem.getElementsByTagName(tag).item(0);
                if (tagElem == null) {
                    if (regenerationType == 2 || regenerationType == 1) {
                        tagElem = (Element)versionElem.getElementsByTagName(TAG_FULL).item(0);
                    }
                    if (tagElem == null) continue;
                }
                if ((conditions = tagElem.getElementsByTagName(TAG_CONDITION)).getLength() == 0) {
                    return version;
                }
                for (int j = 0; j < conditions.getLength(); ++j) {
                    if (!RegenerationChecker.processCondition((Element)conditions.item(j), tableProps)) continue;
                    return version;
                }
            }
        }
        return VersionInfo.JCHEM_TABLE_VERSION;
    }

    private static boolean processCondition(Element conditionElem, Map<String, String> tableProps) {
        NodeList properties = conditionElem.getElementsByTagName(TAG_PROPERTY);
        for (int k = 0; k < properties.getLength(); ++k) {
            Element propertyElem = (Element)properties.item(k);
            Element nameElem = (Element)propertyElem.getElementsByTagName(TAG_PROPERTY_NAME).item(0);
            String operation = nameElem.getAttribute(ATTR_OPERATION);
            String name = nameElem.getFirstChild().getNodeValue();
            Vector<String> valueList = new Vector<String>();
            NodeList values = propertyElem.getElementsByTagName(TAG_PROPERTY_VALUE);
            for (int l = 0; l < values.getLength(); ++l) {
                Element valueElem = (Element)values.item(l);
                valueList.add(valueElem.getFirstChild().getNodeValue().toLowerCase());
            }
            String property = tableProps.get(name);
            if (property == null) {
                property = RegenerationChecker.getDefaultProperty(name);
            }
            if (property == null) continue;
            property = property.toLowerCase();
            if (operation.equals(OPER_EQUALS) && property.equals(valueList.get(0))) {
                return true;
            }
            if (!operation.equals(OPER_NOT_EQUALS) || property.equals(valueList.get(0))) continue;
            return true;
        }
        return false;
    }

    public static List<String> getTablesToRegenerate(ConnectionHandler conh, int regenerationType) throws SQLException {
        return RegenerationChecker.getTablesToRegenerate(conh, regenerationType, null);
    }

    public static List<String> getTablesToRegenerate(ConnectionHandler conh, int regenerationType, ProgressWriter pw) throws SQLException {
        Vector<String> regenTables = new Vector<String>();
        DatabaseProperties dp = new DatabaseProperties(conh);
        if (log.isTraceEnabled()) {
            log.trace((Object)TableInfo.stackTraceToString(new Throwable("getTablesToRegenerate")));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Structure table references found in jchemproperties table:");
            Vector<String> names = dp.getStructureTableNames();
            for (int i = 0; i < names.size(); ++i) {
                log.debug(names.get(i));
            }
        }
        Iterator<String> tables = TableNames.iterator(conh, pw);
        while (tables.hasNext()) {
            String tableName = tables.next();
            if (RegenerationChecker.isRegenerationNeeded(tableName, dp, regenerationType) != 1) continue;
            regenTables.add(tableName);
        }
        return regenTables;
    }

    public static int getRegenerationTypeForTable(DatabaseProperties dp, String tableName) throws SQLException {
        for (int type : RegenerationConstants.GROUP_TYPE_ANY) {
            if (type == 3 || RegenerationChecker.isRegenerationNeeded(tableName, dp, type) != 1) continue;
            return type;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getColumnsToRegenerate(ConnectionHandler conh, String tableName, int regenerationType) throws SQLException {
        Vector<String> regenColumns;
        block12: {
            regenColumns = new Vector<String>();
            Vector<String> ctCols = new Vector<String>();
            if (regenerationType == 1 || regenerationType == 0) {
                for (String ctColumn : new DatabaseProperties(conh).getChemTermColumns(tableName)) {
                    ctCols.add(ctColumn.toLowerCase());
                }
            }
            if (regenerationType == 2 || regenerationType == 0) {
                Vector<String> excludedCols = new Vector<String>();
                for (String exColumn : RegenerationConstants.EXCLUDED_CD_FIELDS) {
                    excludedCols.add(exColumn);
                }
                Statement stmt = conh.getConnection().createStatement();
                try {
                    ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName + " WHERE 1=2");
                    try {
                        ResultSetMetaData rsmd = rs.getMetaData();
                        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                            String columnName = rsmd.getColumnName(i).toLowerCase();
                            if ((!columnName.startsWith("cd_") || excludedCols.contains(columnName)) && !ctCols.contains(columnName)) continue;
                            regenColumns.add(columnName);
                        }
                        break block12;
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    stmt.close();
                }
            }
            if (regenerationType == 1) {
                regenColumns = ctCols;
            }
        }
        return regenColumns;
    }

    private static String getDefaultProperty(String name) {
        if (name.equals("tautomerDuplicateFiltering")) {
            return "false";
        }
        if (name.equals("tableType")) {
            return "2";
        }
        return null;
    }
}

