/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.jchem.db.DatabaseOptions;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.FingerprintHandler;
import chemaxon.jchem.db.TableInfo;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.NumberUtil;
import chemaxon.util.SmilesCompressor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class TableStatistics {
    private ConnectionHandler conh;
    Connection con;
    String tableName;
    String tableVersion;
    DatabaseProperties dbProp;
    int cfpColumnCount;
    int cfpBitLength;
    int fpColumnCount;
    int rdbms;
    SmilesCompressor smilesCompressor;
    private long smilesLengthSum;
    private int nullSmilesCount;
    private int rowCount;
    private int markushCount;
    private long compressedSmilesLengthSum;
    private int cfpBitsMax;
    private int cfpBitsMax_id;
    private int cfpBitsMin;
    private int cfpBitsMin_id;
    private long cfpBitsSum;
    private int[] cfpPercentageBuckets;
    private final boolean indexTable;
    private static final int BUCKET_COUNT = 10;

    public TableStatistics(boolean indexTable) {
        this.indexTable = indexTable;
    }

    public TableStatistics() {
        this(false);
    }

    public void collectStatisitcs(ConnectionHandler conh, String tableName) throws SQLException {
        System.out.print(this.getPrintableStats(conh, tableName));
    }

    private void init() throws SQLException {
        this.con = this.conh.getConnection();
        this.dbProp = new DatabaseProperties(this.conh, this.indexTable);
        this.smilesCompressor = new SmilesCompressor();
        this.tableName = TableInfo.getTableNameWithSchema(this.conh.getConnection(), this.tableName);
        this.cfpColumnCount = FingerprintHandler.getNumberOfInts(this.conh, this.tableName, this.indexTable);
        this.cfpBitLength = this.cfpColumnCount * 32;
        this.fpColumnCount = this.cfpColumnCount + FingerprintHandler.getNumberOfStructuralFPColumns(this.conh, this.tableName, this.indexTable);
        this.rdbms = DatabaseOptions.getDBMSType(this.con);
        this.smilesLengthSum = 0L;
        this.nullSmilesCount = 0;
        this.rowCount = 0;
        this.markushCount = 0;
        this.tableVersion = this.dbProp.getTableProperty(this.tableName, "version");
        this.compressedSmilesLengthSum = 0L;
        this.cfpBitsMax = 0;
        this.cfpBitsMax_id = 0;
        this.cfpBitsMin = Integer.MAX_VALUE;
        this.cfpBitsMin_id = 0;
        this.cfpBitsSum = 0L;
        this.cfpPercentageBuckets = new int[10];
    }

    public String getPrintableStats(ConnectionHandler conh, String tableName) throws SQLException {
        this.conh = conh;
        this.tableName = tableName;
        this.init();
        if (this.rdbms == 3) {
            this.collectMySQL();
        } else if (this.rdbms == 8) {
            this.collectHSQLDB();
        } else {
            this.collect();
        }
        return this.getPrintableStats();
    }

    private String getPrintableStats() throws SQLException {
        StringWriter sw = new StringWriter();
        PrintWriter pwriter = new PrintWriter(sw);
        pwriter.println("\nStatistics for table: " + this.tableName);
        pwriter.println("--------------------");
        pwriter.println("Version: " + this.tableVersion);
        pwriter.println("Row count: " + this.rowCount);
        pwriter.println("NULL SMILES count: " + this.nullSmilesCount);
        int smilesCount = this.rowCount - this.nullSmilesCount;
        pwriter.println("Average SMILES length: " + this.getAverageString(this.smilesLengthSum, smilesCount));
        pwriter.println("Average compressed SMILES length: " + this.getAverageString(this.compressedSmilesLengthSum, smilesCount));
        pwriter.println("Markush structure count: " + this.markushCount + " (" + this.getPercentString(this.markushCount, this.rowCount) + "%)");
        int numberOfBits = FingerprintHandler.getNumberOfBits(this.conh, this.tableName, this.indexTable);
        int numberOfOnes = FingerprintHandler.getNumberOfOnes(this.conh, this.tableName, this.indexTable);
        int numberOfEdges = FingerprintHandler.getNumberOfEdges(this.conh, this.tableName, this.indexTable);
        pwriter.println("\nFingerprint settings:\n");
        pwriter.println("Length (bits): " + numberOfBits + "\nPattern length: " + numberOfEdges + "\nBits set per pattern: " + numberOfOnes);
        pwriter.println();
        pwriter.println("Min. CFP darkness: " + this.getPercentString(this.cfpBitsMin, this.cfpBitLength) + "%" + "\t  cd_id: " + this.cfpBitsMin_id);
        pwriter.println("Max. CFP darkness: " + this.getPercentString(this.cfpBitsMax, this.cfpBitLength) + "%" + "\t  cd_id: " + this.cfpBitsMax_id);
        pwriter.println("Avg. CFP darkness: " + this.getPercentString(this.cfpBitsSum, (long)this.cfpBitLength * (long)this.rowCount) + "%");
        pwriter.println("\nChemical Fingerpint distribution:");
        pwriter.println("--------------------------------");
        for (int x = 0; x < 10; ++x) {
            int lowLimit = 100 * x / 10;
            int highLimit = 100 * (x + 1) / 10;
            pwriter.println(lowLimit + "% - " + highLimit + "% : " + this.getPercentString(this.cfpPercentageBuckets[x], this.rowCount) + " %");
        }
        return sw.toString();
    }

    private String getAverageString(long sum, long count) {
        double avg = (double)sum / (double)count;
        avg = (double)((int)(avg * 100.0)) / 100.0;
        return "" + avg;
    }

    private String getPercentString(long count, long totalCount) {
        double percent = 100.0 * (double)count / (double)totalCount;
        percent = (double)((int)(percent * 100.0)) / 100.0;
        return "" + percent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collect() throws SQLException {
        Statement stmt = this.con.createStatement();
        try {
            DatabaseOptions.setFetchSize(stmt, 2000, this.rdbms);
            String qstring = this.getQueryString(true);
            ResultSet rs = stmt.executeQuery(qstring);
            try {
                int[] intFP = new int[this.fpColumnCount];
                while (rs.next()) {
                    int cd_id = rs.getInt(1);
                    for (int i = 0; i < this.fpColumnCount; ++i) {
                        intFP[i] = rs.getInt(i + 2);
                    }
                    String smiles = rs.getString(this.fpColumnCount + 2);
                    String flags = rs.getString(this.fpColumnCount + 3);
                    this.addRow(cd_id, smiles, intFP, flags);
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int collectMySQL() throws SQLException {
        int status = 0;
        int blockSize = 1000;
        int minid = -1;
        int maxid = -1;
        Statement stmt = this.con.createStatement();
        try {
            ResultSet rs = stmt.executeQuery("SELECT MIN(CD_ID) FROM " + this.tableName);
            try {
                if (!rs.next()) {
                    throw new SQLException("Can't get lowest CD_ID");
                }
                minid = rs.getInt(1);
            }
            finally {
                rs.close();
            }
            rs = stmt.executeQuery("SELECT MAX(CD_ID) FROM " + this.tableName);
            try {
                if (!rs.next()) {
                    throw new SQLException("Can't get highest CD_ID");
                }
                maxid = rs.getInt(1);
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        if (minid == -1 || maxid == -1) {
            throw new SQLException("Can't get lowest or highest CD_ID");
        }
        String qstring = this.getQueryString(true);
        qstring = qstring + " WHERE CD_ID>=? AND CD_ID<?";
        PreparedStatement pstmt = this.con.prepareStatement(qstring);
        try {
            DatabaseOptions.setFetchSize(pstmt, 2000, this.rdbms);
            int[] intFP = new int[this.fpColumnCount];
            for (int current_id = minid; current_id <= maxid; current_id += 1000) {
                pstmt.setInt(1, current_id);
                pstmt.setInt(2, current_id + 1000);
                ResultSet rs = pstmt.executeQuery();
                try {
                    while (rs.next()) {
                        int cd_id = rs.getInt(1);
                        for (int i = 0; i < this.fpColumnCount; ++i) {
                            intFP[i] = rs.getInt(i + 2);
                        }
                        String smiles = rs.getString(this.fpColumnCount + 2);
                        String flags = rs.getString(this.fpColumnCount + 3);
                        this.addRow(cd_id, smiles, intFP, flags);
                    }
                    continue;
                }
                finally {
                    rs.close();
                }
            }
        }
        finally {
            pstmt.close();
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int collectHSQLDB() throws SQLException {
        int status = 0;
        int blockSize = 1024;
        PreparedStatement pstmt = this.con.prepareStatement(this.getQueryString(true) + " WHERE cd_id>?");
        try {
            boolean success;
            DatabaseOptions.setFetchSize(pstmt, blockSize, this.rdbms);
            pstmt.setMaxRows(blockSize);
            int[] intFP = new int[this.fpColumnCount];
            int maxId = 0;
            do {
                int cd_id = 0;
                pstmt.setInt(1, maxId);
                ResultSet rs = pstmt.executeQuery();
                success = false;
                try {
                    while (rs.next()) {
                        success = true;
                        cd_id = rs.getInt(1);
                        if (cd_id > maxId) {
                            maxId = cd_id;
                        }
                        for (int i = 0; i < this.fpColumnCount; ++i) {
                            intFP[i] = rs.getInt(i + 2);
                        }
                        String smiles = rs.getString(this.fpColumnCount + 2);
                        String flags = rs.getString(this.fpColumnCount + 3);
                        this.addRow(cd_id, smiles, intFP, flags);
                    }
                }
                finally {
                    rs.close();
                }
            } while (success);
        }
        finally {
            pstmt.close();
        }
        return status;
    }

    private void addRow(int cd_id, String smiles, int[] intFP, String flags) {
        boolean isMarkush;
        ++this.rowCount;
        try {
            byte[] bytes = null;
            if (smiles != null) {
                this.smilesLengthSum += (long)smiles.length();
                bytes = smiles.getBytes("ASCII");
                bytes = this.smilesCompressor.compress(bytes);
                this.compressedSmilesLengthSum += (long)bytes.length;
            } else {
                ++this.nullSmilesCount;
            }
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        int cfpBitCount = this.getBitCount(intFP, 0, this.cfpColumnCount - 1);
        this.cfpBitsSum += (long)cfpBitCount;
        int idx = (int)Math.ceil(10.0 * (double)cfpBitCount / (double)this.cfpBitLength);
        if (idx == 0) {
            idx = 1;
        }
        int n = idx - 1;
        this.cfpPercentageBuckets[n] = this.cfpPercentageBuckets[n] + 1;
        if (cfpBitCount > this.cfpBitsMax) {
            this.cfpBitsMax = cfpBitCount;
            this.cfpBitsMax_id = cd_id;
        }
        if (cfpBitCount < this.cfpBitsMin) {
            this.cfpBitsMin = cfpBitCount;
            this.cfpBitsMin_id = cd_id;
        }
        boolean bl = isMarkush = flags != null && flags.indexOf(109) != -1;
        if (isMarkush) {
            ++this.markushCount;
        }
    }

    private int getBitCount(int[] intFP, int start, int end) {
        int count = 0;
        for (int x = start; x < end; ++x) {
            count += this.getBitCount(intFP[x]);
        }
        return count;
    }

    private int getBitCount(int i) {
        boolean[] bits = NumberUtil.intToBooleanArray(i);
        int count = 0;
        for (int x = 0; x < bits.length; ++x) {
            if (!bits[x]) continue;
            ++count;
        }
        return count;
    }

    private String getQueryString(boolean idNeeded) {
        StringBuffer sb = new StringBuffer("SELECT ");
        if (idNeeded) {
            sb.append("cd_id");
            sb.append(",");
        }
        for (int i = 0; i < this.fpColumnCount; ++i) {
            sb.append("cd_fp");
            sb.append(i + 1);
            sb.append(",");
        }
        sb.append("cd_smiles");
        sb.append(",");
        sb.append("cd_flags");
        sb.append(" FROM ");
        sb.append(this.tableName);
        return sb.toString();
    }
}

