/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;

public class UpdateLogCache {
    private static final int UPDATE_LOG_CACHE_SIZE = 10000;
    public static final String LOG_TEXT_UPDATE = "Update:";
    public static final String LOG_TEXT_UPDATES = "Updates";
    public static final String LOG_TEXT_DELETE = "Deleted:";
    public static final String LOG_TEXT_DELETES = "Deletes";
    public static final String LOG_TEXT_INSERT = "Insert:";
    public static final String LOG_TEXT_INSERTS = "Inserts";
    public static final byte CACHE_TYPE_UPDATE = 0;
    public static final byte CACHE_TYPE_UPDATES = 1;
    public static final byte CACHE_TYPE_DELETE = 2;
    public static final byte CACHE_TYPE_DELETES = 3;
    public static final byte CACHE_TYPE_INSERT = 4;
    public static final byte CACHE_TYPE_INSERTS = 5;
    private byte[] updateTypeCache = new byte[10000];
    private int[] updateIDCache = new int[10000];
    private int cacheIndex = 0;
    private int cachedUpdates = 0;

    public void storeUpdate(byte type, int id) {
        this.updateTypeCache[this.cacheIndex] = type;
        this.updateIDCache[this.cacheIndex] = id;
        this.cacheIndex = (this.cacheIndex + 1) % 10000;
        if (this.cachedUpdates < 10000) {
            ++this.cachedUpdates;
        }
    }

    public void logsForNewCaches(ArrayList caches, PreparedStatement pstmt) throws SQLException {
        for (int i = 0; i < this.cachedUpdates; ++i) {
            String updateInfo = UpdateLogCache.createLogInfo(this.updateTypeCache[i], this.updateIDCache[i], false);
            pstmt.setString(1, updateInfo);
            for (int j = 0; j < caches.size(); ++j) {
                pstmt.setString(2, (String)caches.get(j));
                pstmt.execute();
            }
        }
    }

    public static String createLogInfo(byte updateCode, int cdID, boolean supportDelete) {
        String ret = null;
        switch (updateCode) {
            case 0: {
                ret = LOG_TEXT_UPDATE + cdID;
                break;
            }
            case 1: {
                ret = LOG_TEXT_UPDATES;
                break;
            }
            case 2: {
                if (!supportDelete) break;
                ret = LOG_TEXT_DELETE + cdID;
                break;
            }
            case 3: {
                if (!supportDelete) break;
                ret = LOG_TEXT_DELETES;
                break;
            }
            case 4: {
                ret = LOG_TEXT_INSERT + cdID;
                break;
            }
            case 5: {
                ret = LOG_TEXT_INSERTS;
                break;
            }
        }
        return ret;
    }
}

