/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.jchem.db.DBUtil;
import chemaxon.jchem.db.DatabaseOptions;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.MarkushTableInfo;
import chemaxon.jchem.db.PreRegeneration;
import chemaxon.jchem.db.RegenerationChecker;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.db.TableNames;
import chemaxon.jchem.db.UpdateHandler;
import chemaxon.jchem.db.sql.TypeConverter;
import chemaxon.jchem.file.ProgressWriter;
import chemaxon.util.ConnectionHandler;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Updater {
    private ConnectionHandler conh = null;
    private int currentStep = 0;
    private static final int MAX_STEPS = 20;
    private String[] lastEntityList = null;
    private static final Log log = LogFactory.getLog(Updater.class);
    private List<String> tablesToLookAt;

    public Updater(ConnectionHandler conh) {
        this.conh = conh;
        this.currentStep = 0;
    }

    public Updater(ConnectionHandler conh, List<String> tablesToConsider) {
        this(conh);
        this.tablesToLookAt = tablesToConsider;
    }

    public UpdateInfo getNextUpdateInfo() throws SQLException {
        return this.getNextUpdateInfo(null);
    }

    public UpdateInfo getNextUpdateInfo(ProgressWriter pw) throws SQLException {
        UpdateInfo ui = null;
        while (ui == null && this.currentStep < 20) {
            ++this.currentStep;
            if (log.isDebugEnabled()) {
                log.debug((Object)("currentStep in getNextUpdateInfo: " + this.currentStep));
            }
            if (pw != null) {
                pw.setNote(Updater.getUpdateInfoMessage(this.currentStep));
            }
            Iterator<String> tables = this.currentStep == 1 || this.currentStep >= 4 && this.currentStep <= 11 ? TableNames.iterator(this.conh, pw) : null;
            try {
                switch (this.currentStep) {
                    case 1: {
                        ui = this.getUpdateInfoForMissingPgSchemaPrefix(tables);
                        break;
                    }
                    case 2: {
                        ui = this.getUpdateInfoForPropertyTableUpdate();
                        break;
                    }
                    case 3: {
                        ui = this.getUpdateInfoForGlobalProperties();
                        break;
                    }
                    case 4: {
                        ui = this.getUpdateInfoForTableProperties(tables);
                        break;
                    }
                    case 5: {
                        ui = this.getUpdateInfoForAddingHashColumn(tables);
                        break;
                    }
                    case 6: {
                        ui = this.getUpdateInfoForCacheTables(tables);
                        break;
                    }
                    case 7: {
                        ui = this.getUpdateInfoForAddingSortableFormulaColumn(tables);
                        break;
                    }
                    case 8: {
                        ui = this.getUpdateInfoForUpdatingSortableFormulaColumn(tables);
                        break;
                    }
                    case 9: {
                        ui = this.getUpdateInfoForAddingPreCalculatedColumn(tables);
                        break;
                    }
                    case 10: {
                        ui = this.getUpdateInfoForModifyingLogTables(tables);
                        break;
                    }
                    case 11: {
                        ui = this.getUpdateInfoForUpgradingMarkushDescriptorTables(tables);
                        break;
                    }
                    case 12: {
                        ui = this.getUpdateInfoForPreCalculatedData(pw);
                        break;
                    }
                    case 13: {
                        ui = this.getUpdateInfoForRegeneratingMDTables(pw);
                        break;
                    }
                    case 14: {
                        ui = this.getUpdateInfoForRegeneratingCTColumns(pw);
                        break;
                    }
                    case 15: {
                        ui = this.getUpdateInfoForRegeneratingWithoutCTColumns(pw);
                        break;
                    }
                    case 16: {
                        ui = this.getUpdateInfoForRegeneratingTables(pw);
                        break;
                    }
                    default: {
                        ui = null;
                        break;
                    }
                }
            }
            catch (NoSuchElementException e) {
                log.debug((Object)"------- INTERRUPT -------");
                assert (pw != null && pw.isCanceled());
                ui = null;
                break;
            }
        }
        this.storeEntityList(ui);
        return ui;
    }

    private static String getUpdateInfoMessage(int step) {
        switch (step) {
            case 1: {
                return "Tables with missing schema prefix ...";
            }
            case 2: {
                return "Deciding Property table update ...";
            }
            case 3: {
                return "Global properties ...";
            }
            case 4: {
                return "Table properties ...";
            }
            case 5: {
                return "Tables with adition of hash column ...";
            }
            case 6: {
                return "Cache tables ...";
            }
            case 7: {
                return "Tables with addition of sortable forumla column ...";
            }
            case 8: {
                return "Tables with sortable formula column ....";
            }
            case 9: {
                return "Tables with addition of precalculated column ...";
            }
            case 10: {
                return "Log tables ...";
            }
            case 11: {
                return "Markush descriptor tables ...";
            }
            case 12: {
                return "Precalculated data ...";
            }
            case 13: {
                return "MD tables ...";
            }
            case 14: {
                return "Tables with CT columns ...";
            }
            case 15: {
                return "Tables without CT columns ...";
            }
            case 16: {
                return "Tables to regenerate ...";
            }
        }
        return "";
    }

    public boolean isUpdateNeededForTable(String tableName) throws SQLException {
        UpdateInfo ui;
        tableName = TableInfo.getTableNameWithoutSchema(tableName);
        while ((ui = this.getNextUpdateInfo()) != null) {
            if (!ui.isOperationRequired || !ui.isStructuralChange || ui.isProgressMonitoringSupported) continue;
            if (ui.entityList == null) {
                return true;
            }
            for (String entity : ui.entityList) {
                if (!(entity = TableInfo.getTableNameWithoutSchema(entity)).equalsIgnoreCase(tableName)) continue;
                return true;
            }
        }
        return false;
    }

    public String performCurrentUpdate() throws SQLException {
        return this.performCurrentUpdate(null);
    }

    public String performCurrentUpdate(ProgressWriter pw) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("currentStep in performCurrentUpdate: " + this.currentStep));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)TableInfo.stackTraceToString(new Throwable("performCurrentUpdate")));
        }
        switch (this.currentStep) {
            case 1: {
                return Updater.addPgSchemaPrefix(this.conh, this.lastEntityList);
            }
            case 2: {
                return Updater.updatePropertyTable(this.conh);
            }
            case 3: {
                return Updater.ensureGlobalProperties(this.conh, this.lastEntityList);
            }
            case 4: {
                return Updater.ensureTableProperties(this.conh, this.lastEntityList);
            }
            case 5: {
                return Updater.addHashColumn(this.conh, this.lastEntityList);
            }
            case 6: {
                return Updater.createCacheTables(this.conh, this.lastEntityList);
            }
            case 7: {
                return Updater.addSortableFormulaColumn(this.conh, this.lastEntityList);
            }
            case 8: {
                return Updater.dropSortableFormulaColumn(this.conh, this.lastEntityList);
            }
            case 9: {
                return Updater.addPreCalculatedColumn(this.conh, this.lastEntityList);
            }
            case 10: {
                return Updater.modifyUpdateLogTables(this.conh, this.lastEntityList);
            }
            case 11: {
                return Updater.upgradeMarkushDescriptorTables(this.conh, this.lastEntityList);
            }
            case 12: {
                return Updater.applyPreCalculatedData(this.conh, this.lastEntityList, pw);
            }
            case 13: {
                return Updater.regenerateMDTables(this.conh, this.lastEntityList, pw);
            }
            case 14: {
                return Updater.regenerateCTColumns(this.conh, this.lastEntityList, pw);
            }
            case 15: {
                return Updater.regenerateAllButCTColumns(this.conh, this.lastEntityList, pw);
            }
            case 16: {
                return Updater.regenerateTables(this.conh, this.lastEntityList, pw);
            }
        }
        return null;
    }

    private String[] intersectTables(List<String> oldTables) {
        if (oldTables.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No tables were found");
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            if (this.tablesToLookAt == null) {
                log.debug((Object)"No table names defined for filtering");
            } else {
                for (String t : this.tablesToLookAt) {
                    log.debug((Object)t);
                }
            }
        }
        ArrayList<String> l = new ArrayList<String>();
        int count = oldTables.size();
        for (int x = 0; x < count; ++x) {
            String table = oldTables.get(x);
            if (this.tablesToLookAt != null && !this.tablesToLookAt.contains(table)) continue;
            l.add(table);
        }
        if (l.isEmpty()) {
            return null;
        }
        String[] tables = new String[l.size()];
        l.toArray(tables);
        return tables;
    }

    private void storeEntityList(UpdateInfo ui) {
        this.lastEntityList = ui == null ? null : ui.entityList;
    }

    private UpdateInfo getUpdateInfoForPropertyTableUpdate() throws SQLException {
        if (!Updater.propertyTableUpdateNeeded(this.conh)) {
            return null;
        }
        String propTable = this.conh.getPropertyTable();
        UpdateInfo ui = new UpdateInfo();
        ui.message = "\nJChem has detected that property table \"" + propTable + "\" was created with an older version of JChem.\n\n" + "Do you want JChem to upgrade the table now?\n\n" + "Before you select Proceed, please stop all other JChem applications.\n" + "NOTE: You must have the sufficient rights to ALTER this table.";
        ui.processingMessage = "Upgrading property table \"" + propTable + "\"";
        return ui;
    }

    private UpdateInfo getUpdateInfoForGlobalProperties() throws SQLException {
        UpdateInfo ui = new UpdateInfo();
        ArrayList<String> generalPropertiesToCheck = new ArrayList<String>();
        generalPropertiesToCheck.add("propertytable.identifier");
        DatabaseProperties dbProps = new DatabaseProperties(this.conh, false);
        ArrayList<String> missingProps = new ArrayList<String>();
        for (String prop : generalPropertiesToCheck) {
            if (dbProps.getProperty(prop) != null) continue;
            missingProps.add(prop);
        }
        if (missingProps.isEmpty()) {
            return null;
        }
        ui.message = "\nJChem has detected that some important properties are missing from the property table.\n\nDo you want JChem to add these properties now?\n\nNOTE: You must have the sufficient rights to UPDATE the property table.";
        ui.processingMessage = "Adding new properties";
        ui.entityList = missingProps.toArray(new String[0]);
        ui.isOperationRequired = false;
        return ui;
    }

    private UpdateInfo getUpdateInfoForTableProperties(Iterator<String> tables) throws SQLException {
        UpdateInfo ui = new UpdateInfo();
        ArrayList<String> oldTables = new ArrayList<String>();
        while (tables.hasNext()) {
            String tableName = tables.next();
            if (TableInfo.checkRequiredGeneralProperties(this.conh, false, tableName)) continue;
            oldTables.add(tableName);
        }
        if (oldTables.isEmpty()) {
            return null;
        }
        ui.message = "\nJChem has detected that some important table properties are missing from the property table.\n\nDo you want JChem to add these properties now?\n\nNOTE: You must have the sufficient rights to UPDATE the property table.";
        ui.processingMessage = "Adding new table properties";
        ui.entityList = oldTables.toArray(new String[0]);
        ui.isOperationRequired = false;
        return ui;
    }

    private UpdateInfo getUpdateInfoForAddingHashColumn(Iterator<String> tables) throws SQLException {
        List<String> oldTables = Updater.getTablesWithColumnMissing(this.conh, "cd_hash", tables);
        String[] alterTables = this.intersectTables(oldTables);
        if (alterTables == null) {
            return null;
        }
        UpdateInfo ui = new UpdateInfo();
        ui.message = "\nJChem has detected that some tables were created with an older version of JChem, and should be altered to be usable with this version.\n\nDo you want JChem to upgrade these tables now?\n\nBefore you select Proceed, please stop all other JChem applications.\nNOTE: You must have the sufficient rights to ALTER these tables.";
        ui.processingMessage = "Altering tables";
        ui.entityList = alterTables;
        return ui;
    }

    private static List<String> getTablesWithWrongSortableFormulaColumn(ConnectionHandler conh, Iterator<String> tables) throws SQLException {
        ArrayList<String> oldTables = new ArrayList<String>();
        Connection con = conh.getConnection();
        int dbmsType = DatabaseOptions.getDBMSType(con);
        if (dbmsType == 3) {
            DatabaseMetaData metaData = con.getMetaData();
            int dataBaseVersion = 0;
            try {
                dataBaseVersion = metaData.getDatabaseMajorVersion();
            }
            catch (AbstractMethodError e) {
                return new ArrayList<String>();
            }
            if (dataBaseVersion < 5) {
                while (tables.hasNext()) {
                    String tName = tables.next();
                    int version = TableInfo.getTableVersion(conh, tName);
                    if (version != 107) continue;
                    oldTables.add(tName);
                }
            }
        }
        return oldTables;
    }

    private UpdateInfo getUpdateInfoForUpdatingSortableFormulaColumn(Iterator<String> tables) throws SQLException {
        List<String> oldTables = Updater.getTablesWithWrongSortableFormulaColumn(this.conh, tables);
        String[] alterTables = this.intersectTables(oldTables);
        if (alterTables == null) {
            return null;
        }
        UpdateInfo ui = new UpdateInfo();
        ui.message = "\nJChem has detected that some tables were created with an older version of JChem, and the column type \"of cd_sortable_formula\" has changed in this version.\n\nDo you want JChem to upgrade these tables now?\n\nBefore you select Proceed, please stop all other JChem applications.\nNOTE: You must have the sufficient rights to ALTER these tables.";
        ui.processingMessage = "Altering tables";
        ui.entityList = alterTables;
        return ui;
    }

    private UpdateInfo getUpdateInfoForAddingSortableFormulaColumn(Iterator<String> tables) throws SQLException {
        List<String> oldTables = Updater.getTablesWithColumnMissing(this.conh, "cd_sortable_formula", tables);
        String[] alterTables = this.intersectTables(oldTables);
        if (alterTables == null) {
            return null;
        }
        UpdateInfo ui = new UpdateInfo();
        ui.message = "\nJChem has detected that some tables were created with an older version of JChem, and the column \"cd_sortable_formula\" should be added to be usable with this version.\n\nDo you want JChem to upgrade these tables now?\n\nBefore you select Proceed, please stop all other JChem applications.\nNOTE: You must have the sufficient rights to ALTER these tables.";
        ui.processingMessage = "Altering tables";
        ui.entityList = alterTables;
        return ui;
    }

    private UpdateInfo getUpdateInfoForAddingPreCalculatedColumn(Iterator<String> tables) throws SQLException {
        List<String> oldTables = Updater.getTablesWithColumnMissing(this.conh, "cd_pre_calculated", tables);
        String[] alterTables = this.intersectTables(oldTables);
        if (alterTables == null) {
            return null;
        }
        UpdateInfo ui = new UpdateInfo();
        ui.message = "\nJChem has detected that some tables were created with an older version of JChem, and the column \"cd_pre_calculated\" should be added to be usable with this version.\n\nDo you want JChem to upgrade these tables now?\n\n(this may take several minutes for large tables)\nBefore you select Proceed, please stop all other JChem applications.\nNOTE: You must have the sufficient rights to ALTER these tables.";
        ui.processingMessage = "Altering tables";
        ui.entityList = alterTables;
        return ui;
    }

    private UpdateInfo getUpdateInfoForCacheTables(Iterator<String> tables) throws SQLException {
        List<String> oldTables = Updater.getTablesForWrongLogTables(this.conh, tables);
        String[] alterTables = this.intersectTables(oldTables);
        DatabaseProperties dbProps = new DatabaseProperties(this.conh, false);
        String regTableName = dbProps.getCacheRegistrationTableName();
        if (alterTables == null && regTableName != null && TableInfo.isTableExists(this.conh, regTableName)) {
            return null;
        }
        UpdateInfo ui = new UpdateInfo();
        ui.message = "JChem has detected that some tables were created with an older version of JChem, and cache tables should be created for them to be usable with this version.\n\nDo you want JChem to create these cache tables now?\n\nBefore you select Proceed, please stop all JChem operations and searches.\nNOTE: You must have the CREATE TABLE right for this.";
        ui.processingMessage = "Creating log tables";
        ui.entityList = alterTables;
        return ui;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateInfo getUpdateInfoForModifyingLogTables(Iterator<String> stTables) throws SQLException {
        ArrayList<String> ulTables = new ArrayList<String>();
        while (stTables.hasNext()) {
            String table = stTables.next();
            String ulTable = TableInfo.getLogTableName(table);
            String sql = "SELECT update_info FROM " + ulTable + " WHERE 1 = 2";
            Statement stmt = this.conh.getConnection().createStatement();
            try {
                ResultSet rs = stmt.executeQuery(sql);
                ResultSetMetaData rsmd = rs.getMetaData();
                if (rsmd.getColumnDisplaySize(1) == 120) continue;
                ulTables.add(ulTable);
            }
            finally {
                stmt.close();
            }
        }
        String[] tables = this.intersectTables(ulTables);
        if (tables == null) {
            return null;
        }
        UpdateInfo ui = new UpdateInfo();
        ui.message = "JChem has detected that some tables were created with an older version of JChem\nand the field definition of the corresponding cache log tables are obsolete.\n\nDo you want JChem to update cache log tables now?\n\nBefore you select Proceed, please stop all JChem operations and searches.\nNOTE: You must have the ALTER TABLE right for this.";
        ui.processingMessage = "Modifying log tables";
        ui.isOperationRequired = false;
        ui.entityList = tables;
        return ui;
    }

    private UpdateInfo getUpdateInfoForUpgradingMarkushDescriptorTables(Iterator<String> tables) throws SQLException {
        List<String> oldTables = Updater.getMarkushTablesToUpgrade(this.conh, tables);
        String[] uiTables = this.intersectTables(oldTables);
        if (uiTables == null) {
            return null;
        }
        UpdateInfo ui = new UpdateInfo();
        ui.message = "JChem has detected that some Markush library tables were created with an older version of JChem,\nand internal descriptor tables should be created or upgraded for them to be usable with this version.\n\nDo you want JChem to upgrade these tables now?\n\nBefore you select Proceed, please stop all other JChem applications.\nNOTE: You must have the sufficient rights to upgrade descriptor tables.";
        ui.processingMessage = "Upgrading internal Markush descriptor tables";
        ui.entityList = uiTables;
        return ui;
    }

    private UpdateInfo getUpdateInfoForPreCalculatedData(ProgressWriter pw) throws SQLException {
        String[] tables;
        if (log.isTraceEnabled()) {
            log.trace((Object)TableInfo.stackTraceToString(new Throwable("getUpdateInfoForPreCalculatedData")));
        }
        List<String> oldTables = RegenerationChecker.getTablesToRegenerate(this.conh, 0, pw);
        oldTables.addAll(RegenerationChecker.getTablesToRegenerate(this.conh, 1, pw));
        oldTables.addAll(RegenerationChecker.getTablesToRegenerate(this.conh, 2, pw));
        ArrayList<String> preCalcTables = new ArrayList<String>();
        PreRegeneration pr = new PreRegeneration(this.conh);
        for (String table : oldTables) {
            if (!pr.preRegeneratedDataExist(table)) continue;
            preCalcTables.add(table);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"These tables are examined if they need to be regenerated:");
            for (String tableName : preCalcTables) {
                log.debug((Object)tableName);
            }
        }
        if ((tables = this.intersectTables(preCalcTables)) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"nothing to do");
            }
            return null;
        }
        UpdateInfo ui = new UpdateInfo();
        ui.message = "JChem has detected that some tables were precalculated with this version of JChem.\n\nDo you want JChem to apply these changes ?\n\n(this may take some time, depending on the size of your database)\nIf you select Skip, recalculation may be needed on the live system.\n";
        ui.processingMessage = "Applying precalculated data";
        ui.entityList = tables;
        ui.isProgressMonitoringSupported = true;
        ui.isOperationRequired = false;
        ui.isStructuralChange = false;
        return ui;
    }

    private UpdateInfo getUpdateInfoForRegeneratingTables(ProgressWriter pw) throws SQLException {
        List<String> oldTables = RegenerationChecker.getTablesToRegenerate(this.conh, 0, pw);
        String[] tables = this.intersectTables(oldTables);
        if (tables == null) {
            return null;
        }
        UpdateInfo ui = new UpdateInfo();
        ui.message = "JChem has detected that some tables were created with an older version of JChem,\nand may contain obsolete calculated values or Chemical Terms data that need\nfull recalculation.\n\nDo you want JChem to recalculate these tables?\n\n(this may take some time, possibly hours, depending on the size of your database)\nIf you select Skip, search results will be inaccurate for these tables.\n";
        ui.processingMessage = "Recalculating structure tables";
        ui.entityList = tables;
        ui.isRegeneration = true;
        ui.isProgressMonitoringSupported = true;
        ui.regenerationType = 0;
        ui.isStructuralChange = false;
        return ui;
    }

    private UpdateInfo getUpdateInfoForRegeneratingWithoutCTColumns(ProgressWriter pw) throws SQLException {
        List<String> oldTables = RegenerationChecker.getTablesToRegenerate(this.conh, 2, pw);
        String[] tables = this.intersectTables(oldTables);
        if (tables == null) {
            return null;
        }
        UpdateInfo ui = new UpdateInfo();
        ui.message = "JChem has detected that some tables were created with an older version of JChem,\nand may contain obsolete calculated values that need recalculation.\n\nDo you want JChem to recalculate these tables?\n\n(this may take some time, possibly hours, depending on the size of your database)\nIf you select Skip, search results will be inaccurate for these tables.\n";
        ui.processingMessage = "Recalculating structure tables";
        ui.entityList = tables;
        ui.isProgressMonitoringSupported = true;
        ui.regenerationType = 2;
        ui.isStructuralChange = false;
        return ui;
    }

    private UpdateInfo getUpdateInfoForRegeneratingCTColumns(ProgressWriter pw) throws SQLException {
        List<String> oldTables = RegenerationChecker.getTablesToRegenerate(this.conh, 1, pw);
        String[] tables = this.intersectTables(oldTables);
        if (tables == null) {
            return null;
        }
        UpdateInfo ui = new UpdateInfo();
        ui.message = "JChem has detected that some tables were created with an older version of JChem,\nand may contain obsolete Chemical Terms data that need to be recalculated.\n\nDo you want JChem to recalculate these tables?\n\n(this may take some time, possibly hours, depending on the size of your database)\nIf you select Skip, search results will be inaccurate for these tables.\n";
        ui.processingMessage = "Recalculating chemical terms in structure tables";
        ui.entityList = tables;
        ui.isProgressMonitoringSupported = true;
        ui.regenerationType = 1;
        ui.isStructuralChange = false;
        return ui;
    }

    private UpdateInfo getUpdateInfoForRegeneratingMDTables(ProgressWriter pw) throws SQLException {
        List<String> oldTables = RegenerationChecker.getTablesToRegenerate(this.conh, 3, pw);
        String[] tables = this.intersectTables(oldTables);
        if (tables == null) {
            return null;
        }
        UpdateInfo ui = new UpdateInfo();
        ui.message = "JChem has detected that some tables were created with an older version of JChem,\nand may contain obsolete Molecular Decriptors that need to be recalculated.\n\nDo you want JChem to recalculate these tables?\n\n(this may take some time, possibly hours, depending on the size of your database)\nIf you select Skip, search results will be inaccurate for these tables.\n";
        ui.processingMessage = "Recalculating molecular descriptors";
        ui.entityList = tables;
        ui.isProgressMonitoringSupported = true;
        ui.regenerationType = 3;
        ui.isStructuralChange = false;
        return ui;
    }

    private UpdateInfo getUpdateInfoForMissingPgSchemaPrefix(Iterator<String> tables) throws SQLException {
        if (DatabaseOptions.getDBMSType(this.conh.getConnection()) != 7) {
            return null;
        }
        List<String> tablesToProcess = Updater.getTablesWithMissingPgSchemaPrefix(this.conh, tables);
        String[] uiTables = this.intersectTables(tablesToProcess);
        if (uiTables == null) {
            return null;
        }
        UpdateInfo ui = new UpdateInfo();
        ui.message = "JChem has detected that some tables were created with an older version of JChem,\nand their names in the JChemProperties table are not schema-prefixed.\n In order for these tables to work properly with the current version of JChem, \nthe names of these tables must be prefixed with the proper schema name.\n\nDo you want JChem to add the schema-prefixes now?\n\nBefore you select Proceed, please stop all other JChem applications.\n";
        ui.processingMessage = "Prefixing names of structure tables";
        ui.entityList = uiTables;
        return ui;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean propertyTableUpdateNeeded(ConnectionHandler conh) throws SQLException {
        String propTable = conh.getPropertyTable();
        Connection con = conh.getConnection();
        String sql = "SELECT * FROM " + propTable + " WHERE 1=2";
        boolean result = true;
        Statement stmt = con.createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sql);
            try {
                ResultSetMetaData rsmd = rs.getMetaData();
                if (rsmd.getColumnCount() == 3) {
                    result = false;
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String updatePropertyTable(ConnectionHandler conh) throws SQLException {
        Connection con = conh.getConnection();
        String propTable = conh.getPropertyTable();
        int dbmsType = DatabaseOptions.getDBMSType(con);
        TypeConverter tc = new TypeConverter(con);
        String typeName = tc.getLocalTypeByCode(-4);
        if (dbmsType == 6) {
            typeName = typeName + "(1M)";
        }
        String sql = "ALTER TABLE " + propTable + " ADD " + "prop_value_ext" + " " + typeName;
        if (dbmsType != 6 && dbmsType != 5) {
            sql = sql + " NULL";
        }
        Statement stmt = con.createStatement();
        try {
            stmt.executeUpdate(sql);
        }
        finally {
            stmt.close();
        }
        return "Property table " + propTable + " has been upgraded successfully";
    }

    private static String ensureGlobalProperties(ConnectionHandler conh, String[] properties) throws SQLException {
        DatabaseProperties dbProps = new DatabaseProperties(conh, false);
        for (String prop : properties) {
            if (!prop.equals("propertytable.identifier")) continue;
            DatabaseOptions.setPropertyTableIdentifier(dbProps);
        }
        return "Properties have been added successfully";
    }

    private static String ensureTableProperties(ConnectionHandler conh, String[] oldTables) throws SQLException {
        for (String tName : oldTables) {
            TableInfo.ensureRequiredGeneralProperties(conh, false, tName);
        }
        return "Table properties have been added successfully";
    }

    private static List<String> getTablesWithColumnMissing(ConnectionHandler conh, String colName, Iterator<String> tables) throws SQLException {
        ArrayList<String> oldTables = new ArrayList<String>();
        while (tables.hasNext()) {
            String tName = tables.next();
            boolean containsColumn = false;
            try {
                containsColumn = TableInfo.containsColumn(conh, tName, colName);
            }
            catch (SQLException e) {
                System.err.println("Error for table " + tName);
                e.printStackTrace();
                continue;
            }
            if (containsColumn) continue;
            oldTables.add(tName);
        }
        return oldTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String addHashColumn(ConnectionHandler conh, String[] oldTables) throws SQLException {
        Connection con = conh.getConnection();
        int dbmsType = DatabaseOptions.getDBMSType(con);
        String timeStamp = DatabaseOptions.getTimestamp(dbmsType);
        Statement stmt = con.createStatement();
        try {
            for (int x = 0; x < oldTables.length; ++x) {
                String tableName = oldTables[x];
                TypeConverter tc = new TypeConverter(con);
                String typeName = tc.getLocalTypeByCode(4);
                String hashDef = "cd_hash " + typeName;
                if (dbmsType != 7) {
                    if (dbmsType != 4) {
                        hashDef = hashDef + " DEFAULT 0 ";
                    }
                    hashDef = hashDef + " NOT NULL";
                }
                String flagsDef = "cd_flags " + tc.getLocalTypeByCode(12) + "(" + 20 + ")";
                if (dbmsType != 6 && dbmsType != 5) {
                    flagsDef = flagsDef + " NULL";
                }
                String timeStampDef = "cd_timestamp " + tc.getLocalTypeByCode(93);
                if (dbmsType != 7) {
                    if (dbmsType != 3 && dbmsType != 4) {
                        timeStampDef = timeStampDef + " DEFAULT " + timeStamp;
                    }
                    timeStampDef = timeStampDef + " NOT NULL";
                }
                String sql = null;
                if (dbmsType != 4 && dbmsType != 5 && dbmsType != 6 && dbmsType != 7) {
                    sql = "ALTER TABLE " + tableName + " ADD ";
                    if (dbmsType != 2) {
                        sql = sql + "(";
                    }
                    sql = sql + hashDef + ", " + flagsDef + ", " + timeStampDef;
                    if (dbmsType != 2) {
                        sql = sql + ")";
                    }
                    stmt.executeUpdate(sql);
                } else {
                    String column = dbmsType == 4 ? "COLUMN " : "";
                    sql = "ALTER TABLE " + tableName + " ADD " + column + hashDef;
                    stmt.executeUpdate(sql);
                    sql = "ALTER TABLE " + tableName + " ADD " + column + flagsDef;
                    stmt.executeUpdate(sql);
                    sql = "ALTER TABLE " + tableName + " ADD " + column + timeStampDef;
                    stmt.executeUpdate(sql);
                }
                if (dbmsType == 3 || dbmsType == 4 || dbmsType == 7 || dbmsType == 5) {
                    sql = "UPDATE " + tableName + " SET " + "cd_timestamp" + "=" + timeStamp;
                    stmt.executeUpdate(sql);
                }
                if (dbmsType == 7) {
                    sql = "ALTER TABLE " + tableName + " ALTER COLUMN " + "cd_hash" + " SET NOT NULL";
                    stmt.executeUpdate(sql);
                    sql = "ALTER TABLE " + tableName + " ALTER COLUMN " + "cd_timestamp" + " SET NOT NULL";
                    stmt.executeUpdate(sql);
                }
                try {
                    sql = "DROP INDEX ";
                    if (dbmsType == 2) {
                        sql = sql + tableName + ".";
                    }
                    sql = sql + tableName + "_fp";
                    if (dbmsType == 3 || dbmsType == 4) {
                        sql = sql + " ON " + tableName;
                    }
                    stmt.execute(sql);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                sql = TableInfo.createCreateIndexOnHashStatement(con, tableName);
                stmt.execute(sql);
                if (dbmsType != 1) continue;
                sql = "CREATE SEQUENCE " + tableName + "_USQ\n" + "INCREMENT BY 1 START WITH 1";
                stmt.execute(sql);
            }
        }
        finally {
            stmt.close();
        }
        return "New columns have been added successfully to structure tables";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String dropSortableFormulaColumn(ConnectionHandler conh, String[] oldTables) throws SQLException {
        String message = "";
        if (oldTables.length != 0) {
            Connection con = conh.getConnection();
            Statement stmt = con.createStatement();
            try {
                for (int x = 0; x < oldTables.length; ++x) {
                    String tableName = oldTables[x];
                    String sql = null;
                    sql = "ALTER TABLE " + tableName + " DROP COLUMN " + "cd_sortable_formula";
                    stmt.executeUpdate(sql);
                }
            }
            finally {
                stmt.close();
            }
            message = Updater.addSortableFormulaColumn(conh, oldTables);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String addSortableFormulaColumn(ConnectionHandler conh, String[] oldTables) throws SQLException {
        Connection con = conh.getConnection();
        int dbmsType = DatabaseOptions.getDBMSType(con);
        Statement stmt = con.createStatement();
        try {
            int sortableFormulaLength = 255;
            if (dbmsType == 1) {
                sortableFormulaLength = 500;
            }
            for (int x = 0; x < oldTables.length; ++x) {
                String tableName = oldTables[x];
                TypeConverter tc = new TypeConverter(con);
                String fieldDef = "cd_sortable_formula " + tc.getLocalTypeByCode(12) + "(" + sortableFormulaLength + ")";
                String sql = null;
                String column = dbmsType == 4 ? "COLUMN " : "";
                sql = "ALTER TABLE " + tableName + " ADD " + column + fieldDef;
                stmt.executeUpdate(sql);
                sql = TableInfo.createCreateIndexOnSortableFormulaStatement(con, tableName);
                stmt.execute(sql);
            }
        }
        finally {
            stmt.close();
        }
        return "Column \"cd_sortable_formula\" has been added successfully to structure tables";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String addPreCalculatedColumn(ConnectionHandler conh, String[] oldTables) throws SQLException {
        Connection con = conh.getConnection();
        int dbmsType = DatabaseOptions.getDBMSType(con);
        Statement stmt = con.createStatement();
        try {
            for (int x = 0; x < oldTables.length; ++x) {
                String tableName = oldTables[x];
                TypeConverter tc = new TypeConverter(con);
                String fieldDef = "cd_pre_calculated " + tc.getLocalTypeByCode(-7) + (dbmsType == 4 ? "" : " DEFAULT 0") + " NOT NULL";
                String column = dbmsType == 4 ? "COLUMN " : "";
                String sql = "ALTER TABLE " + tableName + " ADD " + column + fieldDef;
                stmt.executeUpdate(sql);
                sql = TableInfo.createCreateIndexOnPreCalculatedStatement(con, tableName);
                stmt.execute(sql);
            }
        }
        finally {
            stmt.close();
        }
        return "Column \"cd_pre_calculated\" has been added successfully to structure tables";
    }

    private static List<String> getTablesForWrongLogTables(ConnectionHandler conh, Iterator<String> tables) throws SQLException {
        ArrayList<String> oldTables = new ArrayList<String>();
        String[] neededColumns = new String[]{"update_id", "update_info", "cache_id"};
        while (tables.hasNext()) {
            String tName = tables.next();
            if (!Updater.isTableStructureInvalid(conh, neededColumns, tName)) continue;
            oldTables.add(tName);
        }
        return oldTables;
    }

    private static boolean isTableStructureInvalid(ConnectionHandler conh, String[] neededColumns, String tName) throws SQLException {
        List<String> columns = TableInfo.getLogTableColumns(conh, tName);
        return columns == null || !columns.containsAll(Arrays.asList(neededColumns));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createCacheTables(ConnectionHandler conh, String[] oldTables) throws SQLException {
        Connection con = conh.getConnection();
        DatabaseOptions dbOptions = new DatabaseOptions(conh);
        if (oldTables != null) {
            for (String tableName : oldTables) {
                if (TableInfo.isTableExists(conh, TableInfo.getLogTableName(tableName))) {
                    DBUtil.dropTable(con, TableInfo.getLogTableName(tableName));
                }
                TableInfo.createLogTable(con, dbOptions, tableName, null);
            }
        }
        TableInfo.createCacheRegistrationTableWithProperty(conh);
        String propTable = conh.getPropertyTable();
        String msg = "Cache tables have been created successfully";
        try {
            Statement stmt = con.createStatement();
            try {
                String sql = "DELETE FROM " + propTable + " WHERE " + "prop_name LIKE 'table.%.updateCounter' OR " + "prop_name LIKE 'update.%'";
                stmt.execute(sql);
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException e) {
            msg = e.getMessage() + "\n" + msg;
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String modifyUpdateLogTables(ConnectionHandler conh, String[] ulTables) throws SQLException {
        for (String ulTable : ulTables) {
            int dbms = DatabaseOptions.getDBMSType(conh);
            String sql = dbms == 7 ? "ALTER TABLE " + ulTable + " ALTER COLUMN update_info TYPE " : (dbms == 2 || dbms == 4 ? "ALTER TABLE " + ulTable + " ALTER COLUMN update_info " : (dbms == 9 ? "ALTER TABLE " + ulTable + " ALTER update_info SET DATA TYPE " : "ALTER TABLE " + ulTable + " MODIFY update_info "));
            sql = sql + new TypeConverter(conh.getConnection()).getLocalTypeByCode(12) + "(" + 120 + ")";
            Statement stmt = conh.getConnection().createStatement();
            try {
                stmt.executeUpdate(sql);
            }
            finally {
                stmt.close();
            }
        }
        return "Cache log tables have been modified successfully";
    }

    private static List<String> getMarkushTablesToUpgrade(ConnectionHandler conh, Iterator<String> tables) throws SQLException {
        ArrayList<String> oldTables = new ArrayList<String>();
        DatabaseProperties dp = new DatabaseProperties(conh, false);
        while (tables.hasNext()) {
            String tName = tables.next();
            if (dp.getTableType(tName) != 3 || MarkushTableInfo.checkMarkushDescriptorTables(conh, tName)) continue;
            oldTables.add(tName);
        }
        return oldTables;
    }

    private static String upgradeMarkushDescriptorTables(ConnectionHandler conh, String[] oldTables) throws SQLException {
        for (String tName : oldTables) {
            MarkushTableInfo.upgradeMarkushDescriptorTables(conh, tName);
        }
        return "Internal Markush descriptor tables have been upgraded successfully";
    }

    private static String applyPreCalculatedData(ConnectionHandler conh, String[] preCalculatedTables, ProgressWriter pw) throws SQLException {
        if (log.isTraceEnabled()) {
            log.trace((Object)TableInfo.stackTraceToString(new Throwable("applyPreCalculatedData")));
        }
        boolean success = true;
        PreRegeneration pr = new PreRegeneration(conh);
        for (String table : preCalculatedTables) {
            if (!pr.preRegeneratedDataExist(table)) continue;
            if (pw != null) {
                pw.reset();
                pw.setText("Applying precalculated data for " + table + "...\n");
            }
            pr.applyRegeneratedData(table);
            int regenType = pr.getPreRegenerationType(table);
            if (regenType == -1) {
                System.err.println("Recalculation type not found for table: " + table);
                continue;
            }
            try {
                if (regenType == 0 && !UpdateHandler.recalculateTable(conh, table, false, null, null, null, pw, 2)) {
                    success = false;
                } else if (regenType == 2 && !UpdateHandler.recalculateWithoutCTColumns(conh, table, false, null, null, pw, 2)) {
                    success = false;
                } else if (regenType == 1 && !UpdateHandler.recalculateCTColumns(conh, table, pr.getDbProperties().getChemTermColumns(table), pw, 2)) {
                    success = false;
                }
                if (success) {
                    pr.removeTempTable(table);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SQLException(e.getMessage());
            }
            if (pw == null || !pw.isCanceled()) continue;
            if (success) {
                return "Applying precalculation results cancelled";
            }
            return "Applying precalculation results canceled. Please, check the console output because errors have occured during recalculation";
        }
        if (success) {
            return "Precalculation results have been set successfully";
        }
        return "Errors have occurred during the application of precalculated results, please, check the console output for details";
    }

    private static String regenerateTables(ConnectionHandler conh, String[] oldTables, ProgressWriter pw) throws SQLException {
        boolean success = true;
        for (int x = 0; x < oldTables.length; ++x) {
            String tableName = oldTables[x];
            if (pw != null) {
                pw.reset();
                pw.setText("Recalculating " + tableName + "...\n");
            }
            try {
                if (!UpdateHandler.recalculateTable(conh, tableName, false, null, null, null, pw)) {
                    success = false;
                }
                if (pw == null || !pw.isCanceled()) continue;
                if (success) {
                    return "Recalculation cancelled";
                }
                return "Recalculation cancelled. Please, check the console output because errors have occured during recalculation";
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SQLException(e.getMessage());
            }
        }
        if (success) {
            return "Tables have been recalculated successfully";
        }
        return "Errors have occurred during recalculation, please, check the console output for details";
    }

    private static String regenerateAllButCTColumns(ConnectionHandler conh, String[] oldTables, ProgressWriter pw) throws SQLException {
        boolean success = true;
        for (int x = 0; x < oldTables.length; ++x) {
            String tableName = oldTables[x];
            if (pw != null) {
                pw.reset();
                pw.setText("Recalculating " + tableName + "...\n");
            }
            try {
                if (!UpdateHandler.recalculateWithoutCTColumns(conh, tableName, false, null, null, pw)) {
                    success = false;
                }
                if (pw == null || !pw.isCanceled()) continue;
                if (success) {
                    return "Recalculation cancelled";
                }
                return "Recalculation cancelled. Please, check the console output because errors have occured during recalculation";
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SQLException(e.getMessage());
            }
        }
        if (success) {
            return "Tables have been recalculated successfully";
        }
        return "Errors have occurred during recalculation, please, check the console output for details";
    }

    private static String regenerateCTColumns(ConnectionHandler conh, String[] oldTables, ProgressWriter pw) throws SQLException {
        boolean success = true;
        DatabaseProperties dbProp = new DatabaseProperties(conh, false);
        for (int x = 0; x < oldTables.length; ++x) {
            String tableName = oldTables[x];
            if (pw != null) {
                pw.reset();
                pw.setText("Recalculating Chemical Terms of " + tableName + "...\n");
            }
            try {
                if (!UpdateHandler.recalculateCTColumns(conh, tableName, dbProp.getChemTermColumns(tableName), pw)) {
                    success = false;
                }
                if (pw == null || !pw.isCanceled()) continue;
                if (success) {
                    return "Chemical Terms recalculation cancelled";
                }
                return "Chemical Terms recalculation cancelled. Please, check the console output because errors have occured during recalculation";
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SQLException(e.getMessage());
            }
        }
        if (success) {
            return "Chemical Terms columns have been recalculated successfully";
        }
        return "Errors have occurred during Chermical Terms recalculation, please, check the console output for details";
    }

    private static String regenerateMDTables(ConnectionHandler conh, String[] oldTables, ProgressWriter pw) throws SQLException {
        boolean success = true;
        for (int x = 0; x < oldTables.length; ++x) {
            String tableName = oldTables[x];
            if (pw != null) {
                pw.reset();
                pw.setText("Recalculating Molecular Descriptors of " + tableName + "...\n");
            }
            try {
                if (!UpdateHandler.recalculateMDTables(conh, tableName, pw)) {
                    success = false;
                }
                if (pw == null || !pw.isCanceled()) continue;
                if (success) {
                    return "Molecular Descriptors recalculation cancelled";
                }
                return "Molecular Descriptors recalculation cancelled. Please, check the console output because errors have occured during recalculation";
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SQLException(e.getMessage());
            }
        }
        if (success) {
            return "Molecular Descriptors have been recalculated successfully";
        }
        return "Errors have occurred during Molecular Descriptors recalculation, please, check the console output for details";
    }

    private static List<String> getTablesWithMissingPgSchemaPrefix(ConnectionHandler conh, Iterator<String> tables) throws SQLException {
        ArrayList<String> tablesWithMissingPrefix = new ArrayList<String>();
        while (tables.hasNext()) {
            String schemaName;
            String tName = tables.next();
            if (tName.indexOf(46) != -1 || (schemaName = TableInfo.getPgSchemaName(conh.getConnection(), tName)) == null) continue;
            tablesWithMissingPrefix.add(tName);
        }
        return tablesWithMissingPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String addPgSchemaPrefix(ConnectionHandler conh, String[] tables) throws SQLException {
        Connection con = conh.getConnection();
        String sqlSelect = "select prop_name from " + conh.getPropertyTable() + " where upper(prop_name) like ?";
        PreparedStatement psSelect = con.prepareStatement(sqlSelect);
        try {
            String sqlUpdate = "update " + conh.getPropertyTable() + " set prop_name = ? where prop_name = ?";
            PreparedStatement psUpdate = con.prepareStatement(sqlUpdate);
            try {
                for (int x = 0; x < tables.length; ++x) {
                    String tableName = tables[x];
                    String schemaName = TableInfo.getPgSchemaName(con, tableName);
                    DatabaseProperties dbProp = new DatabaseProperties(conh, false);
                    String propNamePattern = dbProp.tablePrefix(tableName) + "%";
                    propNamePattern = propNamePattern.toUpperCase();
                    psSelect.setString(1, propNamePattern);
                    ResultSet rs = psSelect.executeQuery();
                    try {
                        while (rs.next()) {
                            String oldPropName = rs.getString(1);
                            StringBuffer propName = new StringBuffer(oldPropName);
                            int firstDotPos = propName.indexOf(".");
                            propName.insert(firstDotPos + 1, schemaName + ".");
                            psUpdate.setString(1, propName.toString());
                            psUpdate.setString(2, oldPropName);
                            psUpdate.execute();
                        }
                        continue;
                    }
                    finally {
                        rs.close();
                    }
                }
                con.commit();
            }
            finally {
                psUpdate.close();
            }
        }
        finally {
            psSelect.close();
        }
        return "Schema-prefixes have been added successfully";
    }

    public class UpdateInfo
    implements Serializable {
        public String message = null;
        public String[] entityList = null;
        public String processingMessage = null;
        @Deprecated
        public boolean isRegeneration = false;
        public boolean isProgressMonitoringSupported = false;
        public int regenerationType = -1;
        public boolean isOperationRequired = true;
        public boolean isStructuralChange = true;
    }
}

