/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db.cdmarkush;

import chemaxon.jchem.db.cdmarkush.CDMarkushFromDB;
import chemaxon.jchem.db.cdmarkush.CDMarkushHandler;
import chemaxon.jchem.db.cdmarkush.CDMarkushUtil;
import java.util.ServiceConfigurationError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CDMarkushHandlerCache {
    private Log log = LogFactory.getLog(CDMarkushHandlerCache.class);
    private final ThreadSafety threadSafety;
    private final CacheBehavior cacheBehavior;
    private CDMarkushHandler markushHandler = null;

    public CDMarkushHandlerCache() {
        this(ThreadSafety.SYNCHRONIZED, CacheBehavior.CACHEFIRST);
    }

    public CDMarkushHandlerCache(ThreadSafety threadSafety, CacheBehavior cacheBehavior) {
        this.threadSafety = threadSafety;
        this.cacheBehavior = cacheBehavior;
    }

    public CDMarkushFromDB parseWithCompatibleHandler(byte[] markushSource) throws IllegalArgumentException, ServiceConfigurationError {
        return this.getCompatibleHandler(markushSource).parseData(markushSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CDMarkushHandler getCompatibleHandler(byte[] markushSource) throws IllegalArgumentException, ServiceConfigurationError {
        switch (this.threadSafety) {
            case NOTSYNCHRONIZED: {
                return this.getCompatibleHandler0(markushSource);
            }
            case SYNCHRONIZED: {
                CDMarkushHandlerCache cDMarkushHandlerCache = this;
                synchronized (cDMarkushHandlerCache) {
                    return this.getCompatibleHandler0(markushSource);
                }
            }
        }
        throw new AssertionError();
    }

    private CDMarkushHandler getCompatibleHandler0(byte[] markushSource) throws IllegalArgumentException, ServiceConfigurationError {
        if (this.markushHandler == null) {
            this.markushHandler = CDMarkushUtil.getCompatibleHandler(markushSource);
            return this.markushHandler;
        }
        if (this.markushHandler.isCompatible(markushSource)) {
            return this.markushHandler;
        }
        CDMarkushHandler ret = CDMarkushUtil.getCompatibleHandler(markushSource);
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)"Markush data incompatible with cached handler.");
        }
        if (this.cacheBehavior == CacheBehavior.CACHELAST) {
            this.markushHandler = ret;
        }
        return ret;
    }

    public static enum CacheBehavior {
        CACHEFIRST,
        CACHELAST;

    }

    public static enum ThreadSafety {
        SYNCHRONIZED,
        NOTSYNCHRONIZED;

    }
}

