/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db.cdmarkush;

import chemaxon.enumeration.ExpansionUtil;
import chemaxon.jchem.db.cdmarkush.CDMarkushHandler;
import chemaxon.jchem.db.cdmarkush.CDMarkushHandlerDefault;
import chemaxon.struc.Molecule;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public class CDMarkushUtil {
    public static MarkushCode calcMarkushCode(Molecule structure) {
        return ExpansionUtil.isSearchable(structure) ? MarkushCode.OK : MarkushCode.UNSEARCHABLE;
    }

    public static byte[] prependMagicBytes(byte[] data, byte[] magic, MarkushCode code) {
        byte[] ret = new byte[magic.length + 1 + data.length];
        System.arraycopy(magic, 0, ret, 0, magic.length);
        ret[magic.length] = code.getAsByte();
        System.arraycopy(data, 0, ret, magic.length + 1, data.length);
        return ret;
    }

    public static boolean checkMagicBytes(byte[] data, byte[] magic) {
        return Arrays.equals(CDMarkushUtil.extractMagicBytes(data, magic.length), magic);
    }

    public static byte[] extractMagicBytes(byte[] data, int maxLength) {
        int retLen = 0;
        while (retLen < data.length && retLen < maxLength) {
            if (data[retLen++] != 0) continue;
            byte[] ret = new byte[retLen];
            System.arraycopy(data, 0, ret, 0, retLen);
            return ret;
        }
        return null;
    }

    public static String toString(byte[] data) {
        return CDMarkushUtil.toString(data, data.length);
    }

    public static String toString(byte[] data, int maxLength) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < data.length && i < maxLength; ++i) {
            char ci = (char)data[i];
            if (Character.isLetterOrDigit(ci) || ci == ' ') {
                ret.append(ci);
                continue;
            }
            ret.append("(#");
            ret.append(Integer.toHexString(data[i] >> 4));
            ret.append(Integer.toHexString(data[i] & 0xF));
            ret.append(") ");
        }
        return ret.toString();
    }

    public static CDMarkushHandler getDefaultHandler() throws ServiceConfigurationError {
        ServiceLoader<CDMarkushHandlerDefault> loader = ServiceLoader.load(CDMarkushHandlerDefault.class);
        Iterator<CDMarkushHandlerDefault> iterator = loader.iterator();
        if (!iterator.hasNext()) {
            throw new ServiceConfigurationError("No implementation found for " + CDMarkushHandlerDefault.class.getCanonicalName());
        }
        CDMarkushHandler ret = iterator.next();
        if (iterator.hasNext()) {
            throw new ServiceConfigurationError("Multiple implementations found for " + CDMarkushHandlerDefault.class.getCanonicalName() + " (" + ret.getClass().getCanonicalName() + ", " + iterator.next().getClass().getCanonicalName() + (iterator.hasNext() ? ", ... )" : ")"));
        }
        return ret;
    }

    public static CDMarkushHandler getCompatibleHandler(byte[] data) throws ServiceConfigurationError, IllegalArgumentException {
        ServiceLoader<CDMarkushHandler> loader = ServiceLoader.load(CDMarkushHandler.class);
        Iterator<CDMarkushHandler> iterator = loader.iterator();
        if (!iterator.hasNext()) {
            throw new ServiceConfigurationError("No implementation found for " + CDMarkushHandler.class.getCanonicalName());
        }
        while (iterator.hasNext()) {
            CDMarkushHandler ret = iterator.next();
            if (!ret.isCompatible(data)) continue;
            return ret;
        }
        byte[] magic = CDMarkushUtil.extractMagicBytes(data, 40);
        String msg = magic != null ? "No compatible CDMarkushHandler found. Magic string: " + CDMarkushUtil.toString(magic) : (data.length <= 40 ? "No compatible CDMarkushHandler found. Data record: " + CDMarkushUtil.toString(data) : "No compatible CDMarkushHandler found. Data record prefix: " + CDMarkushUtil.toString(data, 40) + " ...");
        throw new IllegalArgumentException(msg);
    }

    public static enum MarkushCode {
        OK(0),
        UNSEARCHABLE(1);

        private byte code;

        private MarkushCode(byte b) {
            this.code = b;
        }

        public byte getAsByte() {
            return this.code;
        }

        public static MarkushCode valueOf(byte b) {
            MarkushCode[] values;
            for (MarkushCode value : values = MarkushCode.values()) {
                if (value.getAsByte() != b) continue;
                return value;
            }
            return null;
        }
    }
}

