/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db.cdmarkush.serializer;

import chemaxon.jchem.db.cdmarkush.CDMarkushFromDB;
import chemaxon.jchem.db.cdmarkush.CDMarkushHandlerDefault;
import chemaxon.jchem.db.cdmarkush.CDMarkushToDB;
import chemaxon.jchem.db.cdmarkush.CDMarkushUtil;
import chemaxon.jchem.db.cdmarkush.serializer.CDMarkushSerializerFromDB;
import chemaxon.jchem.db.cdmarkush.serializer.CDMarkushSerializerToDB;
import chemaxon.struc.Molecule;

public abstract class CDMarkushSerializer
implements CDMarkushHandlerDefault {
    private Compression compression;
    private Serialization serialization;
    private SupergraphSaving supergraphSaving;

    protected CDMarkushSerializer(Compression compression, Serialization serialization, SupergraphSaving supergraphSaving) {
        this.compression = compression;
        this.serialization = serialization;
        this.supergraphSaving = supergraphSaving;
    }

    @Override
    public boolean isCompatible(byte[] data) {
        return CDMarkushUtil.checkMagicBytes(data, this.getMagicBytes());
    }

    protected abstract byte[] getMagicBytes();

    @Override
    public CDMarkushToDB createData(Molecule structure) {
        return new CDMarkushSerializerToDB(structure, this.getMagicBytes(), this.compression, this.serialization, this.supergraphSaving);
    }

    @Override
    public CDMarkushFromDB parseData(byte[] data) throws IllegalArgumentException {
        return new CDMarkushSerializerFromDB(data, this.getMagicBytes(), this.compression, this.serialization, this.supergraphSaving);
    }

    public static enum SupergraphSaving {
        NO,
        YES;

    }

    public static enum Serialization {
        MRV,
        OBJECT,
        OLDMRV;

    }

    public static enum Compression {
        NONE,
        GZIP;

    }
}

