/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db.create;

import chemaxon.jchem.db.create.FieldDescriptor;
import chemaxon.jchem.db.create.TableDescriptor;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class IntegerEditor
extends DefaultCellEditor {
    JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
    NumberFormat integerFormat;
    NumberFormatter intFormatter;
    private Integer minimum;
    private Integer maximum;
    private boolean DEBUG = false;
    private JTable table;
    private TableDescriptor descriptor;

    public IntegerEditor(int min, int max, JTable sTable, TableDescriptor tableDescriptor) {
        super(new JFormattedTextField());
        this.minimum = new Integer(min);
        this.maximum = new Integer(max);
        this.table = sTable;
        this.descriptor = tableDescriptor;
        this.integerFormat = NumberFormat.getIntegerInstance();
        this.intFormatter = new NumberFormatter(this.integerFormat);
        this.intFormatter.setFormat(this.integerFormat);
        this.intFormatter.setMinimum(this.minimum);
        this.intFormatter.setMaximum(this.maximum);
        this.ftf.setFormatterFactory(new DefaultFormatterFactory(this.intFormatter));
        this.ftf.setValue(this.minimum);
        this.ftf.setHorizontalAlignment(11);
        this.ftf.setFocusLostBehavior(3);
        this.ftf.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
        this.ftf.getActionMap().put("check", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntegerEditor.this.intFormatter.setMaximum(IntegerEditor.this.updatedMaximum());
                if (!IntegerEditor.this.ftf.isEditValid()) {
                    if (IntegerEditor.this.userSaysRevert()) {
                        IntegerEditor.this.ftf.postActionEvent();
                    }
                } else {
                    try {
                        IntegerEditor.this.ftf.commitEdit();
                        IntegerEditor.this.ftf.postActionEvent();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    protected Integer updatedMaximum() {
        int row = this.table.getSelectedRow();
        int column = this.table.getSelectedColumn();
        System.out.println("row: " + row + ", " + "column: " + column);
        if (row > 0) {
            FieldDescriptor fieldDescriptor = (FieldDescriptor)this.descriptor.getFields().get(row);
            if (column == 4) {
                return new Integer(fieldDescriptor.getType().getMaxSize());
            }
            if (column == 5) {
                return new Integer(fieldDescriptor.getType().getMaxScale());
            }
        }
        return null;
    }

    protected Integer updatedMinimum() {
        return new Integer(0);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JFormattedTextField ftf = (JFormattedTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        ftf.setValue(value);
        return ftf;
    }

    @Override
    public Object getCellEditorValue() {
        JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
        Object o = ftf.getValue();
        if (o instanceof Integer) {
            return o;
        }
        if (o instanceof Number) {
            return new Integer(((Number)o).intValue());
        }
        if (this.DEBUG) {
            System.out.println("getCellEditorValue: o isn't a Number");
        }
        try {
            return this.integerFormat.parseObject(o.toString());
        }
        catch (ParseException exc) {
            System.err.println("getCellEditorValue: can't parse o: " + o);
            return null;
        }
    }

    @Override
    public boolean stopCellEditing() {
        JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
        if (ftf.isEditValid()) {
            try {
                ftf.commitEdit();
            }
            catch (ParseException parseException) {}
        } else if (!this.userSaysRevert()) {
            return false;
        }
        return super.stopCellEditing();
    }

    protected boolean userSaysRevert() {
        Toolkit.getDefaultToolkit().beep();
        this.ftf.selectAll();
        Object[] options = new Object[]{"Edit", "Revert"};
        int answer = JOptionPane.showOptionDialog(SwingUtilities.getWindowAncestor(this.ftf), "The value must be an integer between " + this.intFormatter.getMinimum() + " and " + this.intFormatter.getMaximum() + ".\n" + "You can either continue editing " + "or revert to the last valid value.", "Invalid Text Entered", 0, 0, null, options, options[1]);
        if (answer == 1) {
            this.ftf.setValue(this.ftf.getValue());
            return true;
        }
        return false;
    }

    public Integer getMaximum() {
        return this.maximum;
    }

    public void setMaximum(Integer maximum) {
        this.maximum = maximum;
    }

    public Integer getMinimum() {
        return this.minimum;
    }

    public void setMinimum(Integer minimum) {
        this.minimum = minimum;
    }
}

