/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db.create;

import chemaxon.jchem.db.create.DataType;
import chemaxon.jchem.db.create.FieldDescriptor;
import java.util.ArrayList;

public class TableDescriptor {
    private String name = new String();
    private ArrayList dataTypes = new ArrayList();
    private ArrayList fields = new ArrayList();

    public void setDataTypes(DataType[] types) {
        for (int i = 0; i < types.length; ++i) {
            this.dataTypes.add(types[i]);
        }
    }

    public void addDataType(DataType type) {
        this.dataTypes.add(type);
    }

    public void addDataType(int index, DataType type) {
        this.dataTypes.add(index, type);
    }

    public void addField(FieldDescriptor fieldDescriptor) {
        this.fields.add(fieldDescriptor);
    }

    public void addField(int index, FieldDescriptor fieldDescriptor) {
        this.fields.add(index, fieldDescriptor);
    }

    public void print() {
        int i;
        System.out.print("Table descriptor:");
        System.out.println();
        System.out.print("  Types:  ");
        System.out.println();
        for (i = 0; i < this.dataTypes.size(); ++i) {
            System.out.print("     " + this.dataTypes.get(i));
            System.out.println();
        }
        System.out.print("  Rows:  ");
        System.out.println();
        for (i = 0; i < this.fields.size(); ++i) {
            FieldDescriptor descriptor = (FieldDescriptor)this.fields.get(i);
            System.out.print("     " + i + ". row:");
            System.out.println();
            descriptor.print();
            System.out.println();
        }
    }

    public int fieldCount() {
        return this.fields.size();
    }

    public void removeField(int field) {
        this.fields.remove(field);
    }

    public ArrayList getAllowedDataTypes(int field) {
        return ((FieldDescriptor)this.fields.get(field)).getAllowedTypes();
    }

    public ArrayList getDataTypes() {
        return this.dataTypes;
    }

    public void setDataTypes(ArrayList dataTypes) {
        this.dataTypes = dataTypes;
    }

    public ArrayList getFields() {
        return this.fields;
    }

    public void setFields(ArrayList fields) {
        this.fields = fields;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

