/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db.sql;

import chemaxon.jchem.db.DatabaseOptions;
import chemaxon.jchem.db.sql.DataType;
import chemaxon.util.DatabaseTools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class TypeConverter {
    Connection con;
    int dbType = 0;
    DataType[] typeArray;

    public TypeConverter(Connection con) throws SQLException {
        this.con = con;
        this.dbType = DatabaseOptions.getDBMSType(con);
        this.typesCreate();
    }

    public static Object convert(String value, int sqlType) throws SQLException {
        if (value == null) {
            return null;
        }
        if (!DatabaseTools.isTextType(sqlType) && value.length() == 0) {
            return null;
        }
        switch (sqlType) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return value;
            }
            case 2: 
            case 3: {
                return new BigDecimal(value);
            }
            case -7: {
                return new Boolean(value);
            }
            case -6: 
            case 4: 
            case 5: {
                return new Integer(value);
            }
            case -5: {
                return new Long(value);
            }
            case 7: {
                return new Float(value);
            }
            case 6: 
            case 8: {
                return new Double(value);
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return value.getBytes();
            }
            case 91: {
                try {
                    SimpleDateFormat df = new SimpleDateFormat("mm/dd/yyyy");
                    java.util.Date d = df.parse(value);
                    df.applyPattern("yyyy-mm-dd");
                    String s = df.format(d);
                    return Date.valueOf(s);
                }
                catch (Exception e) {
                    throw new SQLException(value + " can not be converted to date");
                }
            }
            case 92: {
                try {
                    DateFormat df = DateFormat.getTimeInstance();
                    java.util.Date d = df.parse(value);
                    String s = df.format(d);
                    return Time.valueOf(s);
                }
                catch (Exception e) {
                    throw new SQLException(value + " can not be converted to time");
                }
            }
            case 93: {
                try {
                    DateFormat df = DateFormat.getDateTimeInstance();
                    java.util.Date d = df.parse(value);
                    String s = df.format(d);
                    return Timestamp.valueOf(s);
                }
                catch (Exception e) {
                    throw new SQLException(value + " can not be converted to timestamp");
                }
            }
        }
        throw new SQLException("Unknown type: " + sqlType);
    }

    public static String getInput(String prompt) {
        System.out.print(prompt);
        System.out.flush();
        try {
            BufferedReader bin = new BufferedReader(new InputStreamReader(System.in));
            String result = bin.readLine();
            return result;
        }
        catch (IOException ex) {
            System.out.println("Caught java.io.IOException:");
            System.out.println(ex.getMessage());
            return "";
        }
    }

    public String getLocalTypeByCode(int code) {
        for (int i = 0; i < this.typeArray.length; ++i) {
            DataType dataType = this.typeArray[i];
            if (dataType.getCode() != code) continue;
            String name = dataType.getLocalType();
            if (this.dbType == 1 && code == 4 && (name == null || name.equals("NUMBER"))) {
                return "NUMBER(10,0)";
            }
            if (this.dbType == 1 && code == 93) {
                return "DATE";
            }
            if (this.dbType == 7 && code == 93) {
                return "TIMESTAMP";
            }
            if (this.dbType == 7 && code == 12 && (name == null || name.equals("name"))) {
                return "VARCHAR";
            }
            if (this.dbType == 7 && code == 1) {
                return "CHAR";
            }
            if (code == -7) {
                if (this.dbType == 1) {
                    return "NUMBER(1,0)";
                }
                if (this.dbType == 3) {
                    return "TINYINT(1)";
                }
                if (this.dbType == 9 || this.dbType == 7) {
                    return "SMALLINT";
                }
                if (this.dbType == 4) {
                    return "Byte";
                }
                if (this.dbType == 6) {
                    return "DECIMAL(1)";
                }
                if (this.dbType == 8) {
                    return "TINYINT";
                }
            }
            if (code == -4 || code == 2004) {
                if (this.dbType == 6) {
                    return "BLOB";
                }
                if (this.dbType == 9) {
                    return "BLOB";
                }
                if (this.dbType == 7) {
                    return "BYTEA";
                }
                if (this.dbType == 4) {
                    return "LONGBINARY";
                }
                if (this.dbType == 3) {
                    return "MEDIUMBLOB";
                }
                if (this.dbType == 2) {
                    return "IMAGE";
                }
                if (this.dbType == 8 && name == null) {
                    return "BLOB";
                }
            }
            if (code == -1 || code == 2005) {
                if (this.dbType == 4) {
                    return "TEXT";
                }
                if (this.dbType == 3) {
                    return "MEDIUMTEXT";
                }
                if (this.dbType == 7) {
                    return "TEXT";
                }
                if (this.dbType == 2) {
                    return "TEXT";
                }
            }
            if (code == 8 && name == null) {
                return this.getLocalTypeByCode(6);
            }
            return name;
        }
        return null;
    }

    public String getLocalTypeBySQLType(String SQLType2) throws SQLException {
        for (int i = 0; i < this.typeArray.length; ++i) {
            DataType dataType = this.typeArray[i];
            if (!dataType.getSQLType().equals(SQLType2)) continue;
            String name = dataType.getLocalType();
            if (this.dbType == 1 && SQLType2.equals("INTEGER") && (name == null || name.equals("NUMBER"))) {
                return "NUMBER(10,0)";
            }
            if (this.dbType == 7 && SQLType2.equals("VARCHAR") && (name == null || name.equals("name"))) {
                return "VARCHAR";
            }
            return name;
        }
        return null;
    }

    public String getSQLTypeByCode(int code) throws SQLException {
        for (int i = 0; i < this.typeArray.length; ++i) {
            DataType dataType = this.typeArray[i];
            if (dataType.getCode() != code) continue;
            return dataType.getSQLType();
        }
        return null;
    }

    public String getSQLTypeByLocalType(String localType) throws SQLException {
        for (int i = 0; i < this.typeArray.length; ++i) {
            DataType dataType = this.typeArray[i];
            if (dataType.getLocalType() != localType) continue;
            return dataType.getSQLType();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void typesCreate() throws SQLException {
        DataType[] ta = new DataType[]{new DataType(-7, "BIT"), new DataType(-6, "TINYINT"), new DataType(5, "SMALLINT"), new DataType(4, "INTEGER"), new DataType(-5, "BIGINT"), new DataType(6, "FLOAT"), new DataType(7, "REAL"), new DataType(8, "DOUBLE"), new DataType(2, "NUMERIC"), new DataType(3, "DECIMAL"), new DataType(1, "CHAR"), new DataType(12, "VARCHAR"), new DataType(-1, "LONGVARCHAR"), new DataType(91, "DATE"), new DataType(92, "TIME"), new DataType(93, "TIMESTAMP"), new DataType(-2, "BINARY"), new DataType(-3, "VARBINARY"), new DataType(-4, "LONGVARBINARY"), new DataType(2004, "BLOB"), new DataType(2005, "CLOB"), new DataType(0, "NULL"), new DataType(1111, "OTHER")};
        this.typeArray = ta;
        DatabaseMetaData dbmd = this.con.getMetaData();
        ResultSet rs = dbmd.getTypeInfo();
        try {
            int i;
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            int idDataType = 0;
            int idTypeName = 0;
            int idCreateParams = 0;
            for (i = 1; i <= columnCount; ++i) {
                String cName = rsmd.getColumnName(i);
                if (cName.equals("DATA_TYPE")) {
                    idDataType = i;
                    continue;
                }
                if (cName.equals("TYPE_NAME")) {
                    idTypeName = i;
                    continue;
                }
                if (!cName.equals("CREATE_PARAMS")) continue;
                idCreateParams = i;
            }
            while (rs.next()) {
                String dbmsName = rs.getString(idTypeName);
                int codeNumber = rs.getInt(idDataType);
                String createParams = rs.getString(idCreateParams);
                for (int i2 = 0; i2 < this.typeArray.length; ++i2) {
                    if (this.typeArray[i2].getCode() != codeNumber) continue;
                    this.typeArray[i2].setLocalTypeAndParams(dbmsName, createParams);
                }
            }
            if (this.dbType == 3) {
                for (i = 0; i < this.typeArray.length; ++i) {
                    if (this.typeArray[i].getCode() != 6) continue;
                    this.typeArray[i].setLocalTypeAndParams("DOUBLE", "");
                }
            }
        }
        finally {
            rs.close();
        }
    }

    public DataType[] getLocalTypes() {
        return this.typeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRowCount(Connection con, String tableName) throws SQLException {
        int count;
        Statement stmt = con.createStatement();
        try {
            String s = "SELECT COUNT(*) FROM " + tableName;
            ResultSet rs = stmt.executeQuery(s);
            try {
                rs.next();
                count = rs.getInt(1);
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        return count;
    }
}

