/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.file;

import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.MolFileHandler;
import chemaxon.jchem.file.FieldData;
import chemaxon.jchem.file.FileInfo;
import chemaxon.jchem.file.MolRecord;
import chemaxon.jchem.file.ProgressWriter;
import chemaxon.marvin.io.MRecord;
import chemaxon.marvin.io.MRecordParseException;
import chemaxon.marvin.io.MRecordReader;
import chemaxon.struc.MPropertyContainer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class ImportFileHandler {
    Vector<String> legalFields;
    private MRecordReader reader = null;

    public ImportFileHandler(InputStream is, Vector<String> legalFields) throws IOException {
        this.legalFields = legalFields;
        this.reader = MFileFormatUtil.createRecordReader(is, null);
    }

    public ImportFileHandler(InputStream is, Vector<String> legalFields, String fileName) throws IOException {
        this.legalFields = legalFields;
        String opts = MFileFormatUtil.getUnguessableFormat(fileName);
        this.reader = MFileFormatUtil.createRecordReader(is, opts, null, fileName);
    }

    public static FileInfo collectFileInfo(InputStream is, ProgressWriter pw, int maxRecords) throws IOException, MRecordParseException {
        return ImportFileHandler.collectFileInfo(is, pw, maxRecords, null);
    }

    public static FileInfo collectFileInfo(InputStream is, ProgressWriter pw, int maxRecords, String fileName) throws IOException, MRecordParseException {
        String formatString;
        Vector collectedFields = new Vector();
        MRecordReader mrr = MolFileHandler.collectFileInfo(is, maxRecords, collectedFields, fileName);
        FileInfo fileInfo = new FileInfo();
        fileInfo.fieldNames = collectedFields;
        fileInfo.setFileName(fileName);
        do {
            formatString = mrr.getRecognizedFormat();
        } while ((mrr = mrr.getEncapsulatedReader()) != null);
        fileInfo.setFormatString(formatString);
        return fileInfo;
    }

    public MolRecord getRecord() throws IOException, MRecordParseException {
        MRecord record = this.reader.nextRecord();
        if (record == null) {
            return null;
        }
        String header = this.reader.getHeaderAsString();
        String footer = this.reader.getFooterAsString();
        StringBuffer source = new StringBuffer();
        if (header != null) {
            source.append(header);
        }
        source.append(record.getString());
        if (footer != null) {
            source.append(footer);
        }
        MolRecord mRec = new MolRecord(source.toString());
        mRec.setMRecord(record);
        MPropertyContainer props = record.getPropertyContainer();
        String[] fields = props.getKeys();
        for (int x = 0; x < fields.length; ++x) {
            String fieldName = fields[x].toUpperCase();
            if (!this.legalFields.contains(fieldName)) continue;
            String fieldValue = props.getString(fields[x]);
            mRec.addField(new FieldData(fieldName, fieldValue));
        }
        return mRec;
    }
}

