/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.file;

import chemaxon.jchem.file.FieldData;
import chemaxon.jchem.file.MolRecord;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class JTFExporter {
    private BufferedWriter w;
    private int format;
    private boolean wasHeader = false;
    private String lineSep = null;
    private String delim = null;
    private String qtm = null;
    private boolean withStructure;

    public JTFExporter(OutputStream os, String eol, String delimiter, String quotation, boolean withStructure) {
        this.w = new BufferedWriter(new OutputStreamWriter(os));
        this.format = this.format;
        this.lineSep = eol;
        this.delim = delimiter;
        this.qtm = quotation;
        this.withStructure = withStructure;
    }

    private void writeField(FieldData field, boolean first) throws IOException {
        String value = field.getValue();
        if (value != null) {
            this.w.write(this.qtm + this.replaceQtm(value, this.qtm) + this.qtm);
        }
        this.w.write(this.delim);
    }

    private void writeHeader(MolRecord mRec) throws IOException {
        StringBuilder header = new StringBuilder();
        int fieldCount = mRec.getFieldCount();
        for (int i = 0; i < fieldCount; ++i) {
            if (i > 0) {
                header.append(this.delim);
            }
            header.append(this.qtm + mRec.getField(i).getName() + this.qtm);
        }
        if (this.withStructure) {
            header.append(this.delim + this.qtm + "CD_STRUCTURE" + this.qtm);
        }
        header.append(this.lineSep);
        this.w.write(new String(header));
    }

    public void write(MolRecord mRec) throws IOException {
        if (!this.wasHeader) {
            this.wasHeader = true;
            this.writeHeader(mRec);
        }
        int fieldCount = mRec.getFieldCount();
        for (int i = 0; i < fieldCount; ++i) {
            this.writeField(mRec.getField(i), i == 0);
            Thread.yield();
        }
        if (this.withStructure) {
            this.w.write(this.qtm + mRec.getMolfile() + this.qtm);
        }
        this.w.write(this.lineSep);
    }

    public void close() throws IOException {
        this.w.close();
    }

    private String replaceQtm(String field, String qtm) {
        if (field == null || qtm == null) {
            return null;
        }
        if (field.length() == 0 || qtm.length() == 0) {
            return null;
        }
        char oldQtm = qtm.charAt(0);
        char newQtm = '\"';
        if (oldQtm == '\"') {
            newQtm = '\'';
        }
        return field.replace(oldQtm, newQtm);
    }
}

