/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.jchem.db.DBUtil;
import chemaxon.jchem.db.DatabaseOptions;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.gui.JChemFrame;
import chemaxon.jchem.gui.MessageDialog;
import chemaxon.jep.ChemJEP;
import chemaxon.jep.Evaluator;
import chemaxon.jep.context.MolContext;
import chemaxon.marvin.util.codeassist.CodeAssistFactory;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.util.ConnectionHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.border.BevelBorder;

class AddColumnDialog
extends JDialog {
    private ConnectionHandler conh;
    private String tableName;
    public static HashMap<String, ArrayList<String>> ctColumns = new HashMap();

    public AddColumnDialog(Frame parent, ConnectionHandler conh, String tableName) throws SQLException {
        super(parent, true);
        this.setTitle("Add column");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AddColumnDialog.this.setVisible(false);
                AddColumnDialog.this.dispose();
            }
        });
        this.conh = conh;
        this.tableName = tableName;
        this.displayAddColumnPanel();
        this.pack();
    }

    private void displayAddColumnPanel() throws SQLException {
        JPanel addColumnPanel = new JPanel();
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.anchor = 17;
        gc.insets = new Insets(20, 5, 5, 5);
        addColumnPanel.setLayout(new GridBagLayout());
        JLabel nameLabel = new JLabel("Name:");
        addColumnPanel.add((Component)nameLabel, gc);
        gc.gridx = 1;
        gc.gridwidth = 3;
        JTextField nameTextField = new JTextField();
        nameTextField.setName("NameTextField");
        nameTextField.setToolTipText("Name of the field");
        nameTextField.setText("");
        nameTextField.setPreferredSize(new Dimension(190, 20));
        addColumnPanel.add((Component)nameTextField, gc);
        gc.insets = new Insets(5, 5, 5, 5);
        gc.gridx = 0;
        ++gc.gridy;
        gc.gridwidth = 1;
        JLabel typeLabel = new JLabel("Type:");
        addColumnPanel.add((Component)typeLabel, gc);
        gc.gridx = 1;
        gc.gridwidth = 3;
        JComboBox<String> fieldTypeComboBox = new JComboBox<String>();
        fieldTypeComboBox.setName("FieldTypeComboBox");
        fieldTypeComboBox.setToolTipText("Select type");
        fieldTypeComboBox.setPreferredSize(new Dimension(190, 25));
        fieldTypeComboBox.setEditable(true);
        Map<String, Integer> fieldTypeMap = DatabaseOptions.getLocalTypes(this.conh.getConnection());
        Connection con = this.conh.getConnection();
        for (String key : fieldTypeMap.keySet()) {
            List<String> newTexts = SQLDataType.getNewTexts(con, key);
            if (newTexts.size() > 0) {
                for (String newText : newTexts) {
                    fieldTypeComboBox.addItem(newText);
                }
                continue;
            }
            fieldTypeComboBox.addItem(key);
        }
        if (fieldTypeMap.size() > 0) {
            fieldTypeComboBox.setSelectedItem(fieldTypeMap.keySet().iterator().next());
        }
        addColumnPanel.add(fieldTypeComboBox, gc);
        gc.gridx = 1;
        ++gc.gridy;
        gc.gridwidth = 2;
        JCheckBox isNullCheckbox = new JCheckBox();
        isNullCheckbox.setName("IsNullCheckbox");
        isNullCheckbox.setText("Can be NULL");
        isNullCheckbox.setSelected(true);
        isNullCheckbox.setEnabled(false);
        addColumnPanel.add((Component)isNullCheckbox, gc);
        gc.gridx = 3;
        gc.gridwidth = 3;
        JCheckBox addIndexCheckbox = new JCheckBox();
        addIndexCheckbox.setName("AddIndexCheckbox");
        addIndexCheckbox.setText("Create index");
        addIndexCheckbox.setSelected(false);
        addColumnPanel.add((Component)addIndexCheckbox, gc);
        JPanel ctPanel = new JPanel();
        ctPanel.setBorder(new BevelBorder(0));
        ctPanel.setLayout(new GridBagLayout());
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 3;
        JLabel ctLabel = new JLabel("Chemical Terms expression");
        ctPanel.add((Component)ctLabel, gc);
        gc.gridx = 1;
        gc.gridy += 2;
        gc.gridwidth = 2;
        gc.insets = new Insets(1, 5, 1, 5);
        JTextPane ctTextPane = CodeAssistFactory.createChemicalTermsTextPane(true);
        ctTextPane.setName("CtTextPane");
        ctTextPane.setToolTipText("Chemical Terms expression (optional)");
        ctTextPane.setPreferredSize(new Dimension(300, 90));
        ctPanel.add((Component)ctTextPane, gc);
        --gc.gridy;
        JToolBar ctToolBar = CodeAssistFactory.getToolBar(ctTextPane);
        ctPanel.add((Component)ctToolBar, gc);
        gc.gridx = 0;
        ++gc.gridy;
        gc.gridwidth = 1;
        JToolBar ctOperatorToolBar = CodeAssistFactory.getOperatorToolBar(ctTextPane);
        ctOperatorToolBar.setOrientation(1);
        ctPanel.add((Component)ctOperatorToolBar, gc);
        gc.gridx = 0;
        ++gc.gridy;
        JLabel emptyCell = new JLabel("");
        emptyCell.setPreferredSize(new Dimension(20, 20));
        ctPanel.add((Component)emptyCell, gc);
        gc.gridx = 1;
        gc.gridwidth = 2;
        gc.insets = new Insets(1, 5, 5, 5);
        JLabel ctCheckLabel = CodeAssistFactory.getValidationResultLabel(ctTextPane);
        ctPanel.add((Component)ctCheckLabel, gc);
        gc.gridx = 0;
        ++gc.gridy;
        gc.gridwidth = 6;
        gc.gridheight = 4;
        gc.insets = new Insets(5, 5, 5, 5);
        addColumnPanel.add((Component)ctPanel, gc);
        gc.gridx = 4;
        gc.gridy += 4;
        gc.gridwidth = 1;
        gc.insets = new Insets(15, 0, 20, 5);
        JButton okButton = new JButton();
        okButton.setText("Ok");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    AddColumnDialog.this.addCustomColumn();
                    MessageDialog.showMessage(AddColumnDialog.this.getParent(), "Column has been added successfully.");
                    AddColumnDialog.this.setVisible(false);
                    AddColumnDialog.this.dispose();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    MessageDialog.showMessage(AddColumnDialog.this.getParent(), "An error occured\n\nPossible causes:\n1. Illegal characters in column name\n2. Length is wrong or not given\n3. Chosen type does not exist in " + DatabaseOptions.DBMSNAMES[DatabaseOptions.getDBMSType(AddColumnDialog.this.conh)]);
                }
                catch (IllegalArgumentException e) {
                    MessageDialog.showMessage(AddColumnDialog.this.getParent(), e.getMessage());
                }
                catch (Exception e) {
                    MessageDialog.showErrorMessage(AddColumnDialog.this.getParent(), e);
                }
            }
        });
        addColumnPanel.add((Component)okButton, gc);
        gc.gridx = 5;
        JButton cancelButton = new JButton();
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddColumnDialog.this.setVisible(false);
                AddColumnDialog.this.dispose();
            }
        });
        addColumnPanel.add((Component)cancelButton, gc);
        this.getContentPane().add((Component)addColumnPanel, "North");
    }

    private void addCustomColumn() throws SQLException, ParseException, MolFormatException {
        Component comp = JChemFrame.getComponentByName(this, "NameTextField");
        String columnName = ((JTextField)comp).getText();
        if (columnName.equals("")) {
            throw new IllegalArgumentException("Column name is empty");
        }
        if (columnName.toLowerCase().startsWith("cd_")) {
            throw new IllegalArgumentException("Column name may not start with \"cd_\"");
        }
        comp = JChemFrame.getComponentByName(this, "FieldTypeComboBox");
        String columnType = (String)((JComboBox)comp).getSelectedItem();
        comp = JChemFrame.getComponentByName(this, "AddIndexCheckbox");
        boolean addIndex = ((JCheckBox)comp).isSelected();
        comp = JChemFrame.getComponentByName(this, "CtTextPane");
        String ctExpression = ((JTextPane)comp).getText();
        if (!ctExpression.equals("")) {
            Evaluator evaluator = new Evaluator();
            ChemJEP chemJEP = evaluator.compile(ctExpression, MolContext.class);
            new MolContext().setMolecule(MolImporter.importMol("CCN"));
            chemJEP.evaluate(null);
        }
        DBUtil.addColumn(this.conh.getConnection(), this.tableName, columnName, columnType);
        if (addIndex) {
            DBUtil.addIndex(this.conh.getConnection(), this.tableName, columnName);
        }
        if (!ctExpression.equals("")) {
            new DatabaseProperties(this.conh).setChemTermForColumn(this.tableName, columnName.toUpperCase(), ctExpression);
            ArrayList<String> columns = new ArrayList<String>();
            if (ctColumns.containsKey(this.tableName)) {
                columns = ctColumns.get(this.tableName);
            }
            columns.add(columnName.toLowerCase());
            ctColumns.put(this.tableName, columns);
        }
    }

    public static class SQLDataType {
        public static final String[] DEFAULT = new String[]{"CHAR", "CHAR(10)", "VARCHAR(10)"};
        public static final String[] ORACLE = new String[]{"NUMBER", "NUMBER(10)", "NUMBER(10,2)", "FLOAT", "FLOAT(5)", "VARCHAR2(255)"};
        public static final String[] MYSQL = new String[]{"BIGINT", "BIGINT(20)", "DECIMAL", "DECIMAL(10)", "DECIMAL(10,2)", "FLOAT", "FLOAT(3,1)", "INTEGER", "INTEGER(10)", "NUMERIC", "NUMERIC(10)", "NUMERIC(10,2)", "SMALLINT", "SMALLINT(5)", "TINYINT", "TINYINT(1)", "VARBINARY(255)"};
        public static final String[] POSTGRESQL = new String[]{"NUMERIC", "NUMERIC(10)", "NUMERIC(10,2)", "TIME", "TIME(5)", "TIMESTAMP", "TIMESTAMP(5)"};
        public static final String[] MSSQLSERVER = new String[]{"BINARY", "BINARY(255)", "DECIMAL", "DECIMAL(10)", "DECIMAL(10,2)", "FLOAT", "FLOAT(5)", "NUMERIC", "NUMERIC(10)", "NUMERIC(10,2)", "NVARCHAR", "NVARCHAR(255)", "VARBINARY", "VARBINARY(255)"};
        public static final String[] DERBY = new String[]{"BLOB", "BLOB(255)", "CLOB", "CLOB(255)", "DECIMAL", "DECIMAL(10)", "DECIMAL(10,2)", "FLOAT", "FLOAT(5)", "NUMERIC", "NUMERIC(10)", "NUMERIC(10,2)", "CHAR (100) FOR BIT DATA", "VARCHAR (100) FOR BIT DATA"};

        public static List<String> getNewTexts(Connection con, String typeText) throws SQLException {
            List<String> newTypes;
            int dbmsType = DatabaseOptions.getDBMSType(con);
            String[] newDataTypeList = null;
            switch (dbmsType) {
                case 1: {
                    newDataTypeList = ORACLE;
                    break;
                }
                case 3: {
                    newDataTypeList = MYSQL;
                    break;
                }
                case 7: {
                    newDataTypeList = POSTGRESQL;
                    break;
                }
                case 2: {
                    newDataTypeList = MSSQLSERVER;
                    break;
                }
                case 9: {
                    newDataTypeList = DERBY;
                }
            }
            if (newDataTypeList != null && (newTypes = SQLDataType.getNewVariants(typeText, newDataTypeList)).size() > 0) {
                return newTypes;
            }
            return SQLDataType.getNewVariants(typeText, DEFAULT);
        }

        private static List<String> getNewVariants(String typeText, String[] newTypeList) {
            typeText = typeText.toUpperCase();
            ArrayList<String> variants = new ArrayList<String>();
            for (String newType : newTypeList) {
                if (!newType.equals(typeText) && !newType.startsWith(typeText + "(") && !newType.replaceAll("[0-9,]+", "").equals(typeText)) continue;
                variants.add(newType);
            }
            return variants;
        }
    }
}

