/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import chemaxon.descriptors.MDGeneratorException;
import chemaxon.jchem.db.DBUtil;
import chemaxon.jchem.db.MDUtilities;
import chemaxon.jchem.gui.JChemFrame;
import chemaxon.jchem.gui.MessageDialog;
import chemaxon.jchem.gui.ProgressReporter;
import chemaxon.jchem.gui.StructureFileFilter;
import chemaxon.util.ConnectionHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AddDescriptorDialog
extends JDialog {
    private ConnectionHandler conh;
    private String tableName;
    private String[] componentTypes = new String[]{"Chemical Fingerprint", "ECFP Fingerprint", "Pharmacophore Fingerprint", "Reaction Fingerprint", "BCUT descriptors", "3D Shape descriptor", "Hydrogen bond Donor count", "Hydrogen bond Acceptor count", "octanol-water distribution coefficient", "octanol-water partition coefficient", "Topological Polar Surface Area", "Mass of molcule", "number of Heavy atoms"};
    private String[] shortTypes = new String[]{"CF", "ECFP", "PF", "RF", "BCUT", "Shape", "HDon", "HAcc", "LogD", "LogP", "TPSA", "Mass", "Heavy"};
    private String descriptorName;

    public AddDescriptorDialog(Frame parent, ConnectionHandler conh, String tableName) throws SQLException {
        super(parent, true);
        this.setTitle("Add molecular descriptor");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AddDescriptorDialog.this.setVisible(false);
                AddDescriptorDialog.this.dispose();
            }
        });
        this.conh = conh;
        this.tableName = tableName;
        this.displayAddDescriptorPanel();
        this.pack();
    }

    public String getDescriptorName() {
        return this.descriptorName;
    }

    private void displayAddDescriptorPanel() throws SQLException {
        JPanel descPanel = new JPanel();
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.anchor = 17;
        gc.insets = new Insets(20, 10, 5, 5);
        descPanel.setLayout(new GridBagLayout());
        JLabel nameLabel = new JLabel("Name:");
        descPanel.add((Component)nameLabel, gc);
        gc.gridx = 1;
        gc.gridwidth = 3;
        JTextField nameTextField = new JTextField();
        nameTextField.setName("NameTextField");
        nameTextField.setToolTipText("Name of the descriptor");
        nameTextField.setText("");
        nameTextField.setPreferredSize(new Dimension(190, 20));
        descPanel.add((Component)nameTextField, gc);
        gc.gridx = 0;
        ++gc.gridy;
        gc.gridwidth = 1;
        gc.insets = new Insets(10, 10, 5, 5);
        JLabel typeLabel = new JLabel("Type:");
        descPanel.add((Component)typeLabel, gc);
        gc.gridx = 1;
        gc.gridwidth = 3;
        JComboBox<String> descTypeComboBox = new JComboBox<String>();
        descTypeComboBox.setName("DescTypeComboBox");
        descTypeComboBox.setToolTipText("Select type");
        descTypeComboBox.setPreferredSize(new Dimension(200, 25));
        for (String type : this.componentTypes) {
            descTypeComboBox.addItem(type);
        }
        descTypeComboBox.setSelectedItem(this.componentTypes[0]);
        descPanel.add(descTypeComboBox, gc);
        ++gc.gridy;
        gc.gridx = 0;
        gc.gridwidth = 2;
        gc.insets = new Insets(20, 10, 5, 5);
        JLabel fileLabel = new JLabel("Descriptor XML file:");
        descPanel.add((Component)fileLabel, gc);
        gc.insets = new Insets(5, 10, 5, 5);
        ++gc.gridy;
        final JTextField fileNameTextField = new JTextField();
        fileNameTextField.setName("FileNameTextField");
        fileNameTextField.setToolTipText("Path of molecular descriptor file");
        fileNameTextField.setText("");
        fileNameTextField.setPreferredSize(new Dimension(150, 20));
        fileNameTextField.setEnabled(false);
        descPanel.add((Component)fileNameTextField, gc);
        gc.gridx = 2;
        gc.anchor = 17;
        JButton browseButton = new JButton();
        browseButton.setName("BrowseButton");
        browseButton.setText("Browse");
        browseButton.setPreferredSize(new Dimension(80, 25));
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFileChooser fc = new JFileChooser();
                fc.setFileSelectionMode(0);
                StructureFileFilter filter = new StructureFileFilter(new String[]{"xml"}, "Molecular descriptor files");
                fc.addChoosableFileFilter(filter);
                try {
                    fc.setAcceptAllFileFilterUsed(false);
                }
                catch (Exception e) {
                    // empty catch block
                }
                fc.showOpenDialog(null);
                if (fc.getSelectedFile() != null) {
                    fileNameTextField.setText(fc.getSelectedFile().getPath());
                }
            }
        });
        descPanel.add((Component)browseButton, gc);
        ++gc.gridy;
        gc.anchor = 13;
        gc.insets = new Insets(40, 5, 5, 5);
        JButton addButton = new JButton();
        addButton.setName("AddButton");
        addButton.setText("Add");
        addButton.setPreferredSize(new Dimension(60, 25));
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        AddDescriptorDialog.this.addDescriptor();
                    }
                }).start();
            }
        });
        descPanel.add((Component)addButton, gc);
        this.getContentPane().add((Component)descPanel, "North");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDescriptor() {
        Component comp = JChemFrame.getComponentByName(this, "NameTextField");
        String descName = ((JTextField)comp).getText();
        if (descName.equals("")) {
            throw new IllegalArgumentException("Descriptor name is empty");
        }
        comp = JChemFrame.getComponentByName(this, "DescTypeComboBox");
        int descType = ((JComboBox)comp).getSelectedIndex();
        comp = JChemFrame.getComponentByName(this, "FileNameTextField");
        String filePath = ((JTextField)comp).getText();
        if (filePath.equals("")) {
            throw new IllegalArgumentException("Descriptor file is not given");
        }
        this.descriptorName = descName;
        ProgressReporter pr = new ProgressReporter(this, "Adding Molecular Descriptors ...", "", true, 1L, 1L);
        MDUtilities.GeneratorThread gt = null;
        try {
            int molNumber = DBUtil.getRowCount(this.conh.getConnection(), this.tableName);
            if (pr != null) {
                pr.reset();
                pr.setMaximum(molNumber);
            }
            MDUtilities mdu = new MDUtilities(this.conh, this.tableName);
            gt = mdu.getThreadForAddingDescriptor(this.shortTypes[descType], this.descriptorName, filePath, pr);
            gt.start();
            gt.isRunning = true;
            while (gt.isRunning && (pr == null || !pr.isCanceled())) {
                if (pr == null) continue;
                int count = gt.generator.getCounter();
                pr.setProgress(count);
                pr.setNote("Molecule count: " + count);
            }
        }
        catch (MDGeneratorException e) {
            e.printStackTrace();
            MessageDialog.showMessage(this, e.getMessage());
        }
        catch (SQLException e) {
            e.printStackTrace();
            MessageDialog.showMessage(this, e.getMessage());
        }
        finally {
            if (gt != null) {
                try {
                    gt.generator.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    MessageDialog.showMessage(this, e.getMessage());
                }
            }
            String msg = "";
            if (pr.isCanceled()) {
                this.descriptorName = null;
                msg = "Molecular Descriptor generation has been cancelled.";
            } else if (gt == null || gt.wasError) {
                this.descriptorName = null;
                msg = "Errors have occured during the descriptor generation. Please, check the console output.";
            } else {
                msg = "Molecular Descriptor has been generated successfully.";
            }
            MessageDialog.showMessage(this, msg);
            if (pr != null) {
                pr.close();
            }
            this.setVisible(false);
            this.dispose();
        }
    }
}

