/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class ClosableTabbedPaneUI
extends BasicTabbedPaneUI {
    private int fixPanels = 0;

    public ClosableTabbedPaneUI() {
    }

    public ClosableTabbedPaneUI(int fixPanels) {
        this.fixPanels = fixPanels;
    }

    @Override
    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
        if (tabIndex < this.fixPanels) {
            return;
        }
        Rectangle rect = rects[tabIndex];
        g.setColor(Color.black);
        g.drawRect(rect.x + 5, rect.y + 5, 10, 10);
        g.drawLine(rect.x + 5, rect.y + 5, rect.x + 15, rect.y + 15);
        g.drawLine(rect.x + 15, rect.y + 5, rect.x + 5, rect.y + 15);
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics2) {
        int width = super.calculateTabWidth(tabPlacement, tabIndex, metrics2);
        if (tabIndex < this.fixPanels) {
            return width;
        }
        return width + 20;
    }

    @Override
    protected MouseListener createMouseListener() {
        return new MyMouseHandler();
    }

    class MyMouseHandler
    extends BasicTabbedPaneUI.MouseHandler {
        public MyMouseHandler() {
            super(ClosableTabbedPaneUI.this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            int tabIndex = -1;
            int tabCount = ClosableTabbedPaneUI.this.tabPane.getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                if (!ClosableTabbedPaneUI.this.rects[i].contains(x, y)) continue;
                tabIndex = i;
                break;
            }
            if (tabIndex >= ClosableTabbedPaneUI.this.fixPanels) {
                Rectangle tabRect = ClosableTabbedPaneUI.this.rects[tabIndex];
                if ((x -= tabRect.x) >= 5 && x <= 15 && (y -= tabRect.y) >= 5 && y <= 15) {
                    ClosableTabbedPaneUI.this.tabPane.remove(tabIndex);
                }
            }
        }
    }
}

