/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import chemaxon.jchem.db.FieldInfo;
import chemaxon.jchem.gui.FieldConnectTableModel;
import java.awt.Component;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;

public class ConnectTableCellEditor
extends DefaultCellEditor {
    Vector fileFields;
    FieldConnectTableModel model;

    public ConnectTableCellEditor(FieldConnectTableModel model, Vector fileFields) {
        super(new JComboBox());
        this.model = model;
        this.fileFields = fileFields;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        FieldInfo fieldInfo = this.model.fieldAt(row);
        int type = fieldInfo.getType();
        JComboBox combo = (JComboBox)this.editorComponent;
        combo.removeAllItems();
        if (fieldInfo.isId()) {
            combo.addItem("[Auto incrementing]");
            for (int i = 0; i < this.fileFields.size(); ++i) {
                combo.addItem(this.fileFields.elementAt(i));
            }
        } else if (fieldInfo.isStructure()) {
            combo.addItem("[Structure]");
        } else if (fieldInfo.isSmiles()) {
            combo.addItem("[Smiles]");
        } else if (fieldInfo.isFingerprint()) {
            combo.addItem("[Fingerprint]");
        } else if (fieldInfo.isHash()) {
            combo.addItem("[Hash code]");
        } else if (fieldInfo.isFlags()) {
            combo.addItem("[Flags]");
        } else if (fieldInfo.isDate()) {
            combo.addItem("[Timestamp]");
        } else if (fieldInfo.isPrecalculated()) {
            combo.addItem("[Is precalculated]");
        } else {
            combo.addItem("[Not connected]");
            if (type == 12 || type == -1) {
                combo.addItem("[Molecule name]");
            }
            for (int i = 0; i < this.fileFields.size(); ++i) {
                combo.addItem(this.fileFields.elementAt(i));
            }
        }
        super.getTableCellEditorComponent(table, value, isSelected, row, column);
        return this.editorComponent;
    }
}

