/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import chemaxon.edu.stanford.ejalbert.BrowserLauncher;
import chemaxon.jchem.db.DatabaseConstants;
import chemaxon.marvin.util.SwingUtil;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.SupportedPlatform;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.html.HTMLEditorKit;

public class ConnectionDialog
extends JDialog
implements CaretListener,
ActionListener {
    private static final Logger logger = Logger.getLogger(ConnectionDialog.class.getName());
    private static final String JVM_WARNING = SupportedPlatform.getJavaVersionErrorString();
    private static final String JVM_DOWNLOAD_MESSAGE = "Supported SUN compatible JREs are available at the ";
    private static final int TEXTFIELD_SIZE = 50;
    private static final int WGAP = 20;
    private static final int BIG_HGAP = 30;
    private static final int HGAP = 20;
    private static final int SMALL_HGAP = 5;
    private static final String HELP_ICON_PATH = "images/help.png";
    private static final String CONNECTION_GUIDE_LABEL = "Connection guide";
    private static final String CONNECTION_GUIDE_LINK = "http://www.chemaxon.com/jchem/doc/admin/index.html#connect";
    private static final String DATABASE_NAME_LABEL = "Database name";
    private static final String JDBC_DRIVER_LABEL = "JDBC driver";
    private static final String DB_URL_LABEL = "URL of database";
    private static final String DB_LOGIN_LABEL = "Database login name";
    private static final String DB_PASSWORD_LABEL = "Database password";
    private static final String DB_REMEMBER_PASSWORD_LABEL = "Remember password";
    private static final String DB_PROPERTY_TABLE_LABEL = "Property table";
    private static final String DB_URL_REPLACEMENT_TEXT = "Replace yellow text parts by specific values.";
    private static final String DATABASE_NAME_TOOLTIP = "<html>Database name,<br>refer to the Connection guide for details.</html>";
    private static final String JDBC_DRIVER_TOOLTIP = "<html>JDBC driver,<br>refer to the Connection guide for details.</html>";
    private static final String DB_URL_TOOLTIP = "<html>Database URL</html>";
    private static final String DB_LOGIN_TOOLTIP = "<html>Database login name,<br>ask your database admin if you are not sure.</html>";
    private static final String DB_PASSWORD_TOOLTIP = "<html>Database password,<br>ask your database admin if you are not sure.</html>";
    private static final String DB_PROPERTY_TABLE_TOOLTIP = "<html>The JChem property table contains information about JChem's tables, <p>registration information and further details about the database. <p>The default name of the table is \"JChemProperties\". <p><b>Do not change this</b> unless you have a specific reason for it.</html>";
    private static final String OTHER_DB_DRIVER_ENTRY = "--- OTHER ---";
    private static final String WAIT_MESSAGE = "Connecting to database. Please wait...";
    private static final String WAIT_MESSAGE_PANEL_NAME = "WAIT_MESSAGE";
    private static final String DRIVER_NOT_FOUND_ERROR_DESCRIPTION = "Invalid JDBC driver, driver class is not found.";
    private static final String DRIVER_NOT_FOUND_ERROR_HELP = ConnectionDialog.getHTMLLinkReferenceText("Connection guide", "http://www.chemaxon.com/jchem/doc/admin/index.html#connect");
    private static final String INVALID_USER_OR_PASSWORD_DESCRIPTION = "Invalid user name or password.";
    private static final String INVALID_USER_OR_PASSWORD_HELP = "Please enter a valid user name with corresponding password.";
    private static final String INVALID_URL_DESCRIPTION = "Invalid database URL.";
    private JPanel textPane = null;
    private ConnectionThread connectionThread = null;
    private JPanel ivjJDialogContentPane = null;
    private JButton ivjConnectButton = null;
    private JButton ivjExitButton = null;
    private JComboBox ivjDatabaseNameComboBox = null;
    private JTextField ivjDriverTextField = null;
    private JTextField ivjLoginTextField = null;
    private JPasswordField ivjPasswordField = null;
    private JCheckBox ivjRememberPasswordCheckBox = null;
    private JTextField ivjPropertyTextField = null;
    private JEditorPane ivjURLField = null;
    private JComponent ivjURLHelp = null;

    private static String getFormattedTemplate(String template) {
        template = template.replaceAll("<", "__<");
        template = template.replaceAll(">", "__>");
        template = template.replaceAll("__<", "<span bgcolor=\"yellow\"><b>&lt;");
        template = template.replaceAll("__>", "&gt;</b></span>");
        template = template.replaceAll("\\[", "<span bgcolor=\"yellow\"><b>[");
        template = template.replaceAll("\\]", "]</b></span>");
        return template;
    }

    private static String getURLTooltip(int index) {
        return "<html><p>" + ConnectionDialog.getFormattedTemplate(DatabaseConstants.DBMS_URL_TEMPLATES[index]) + "<p>" + DB_URL_REPLACEMENT_TEXT + "<p>E.g.: " + DatabaseConstants.DBMS_URL_EXAMPLES[index] + "<p>Refer to the Connection guide for details.";
    }

    public ConnectionDialog() {
        this.initialize();
    }

    public ConnectionDialog(Frame owner) {
        super(owner);
        this.initialize();
    }

    private void enableComponents(boolean enabled) {
        this.ivjConnectButton.setEnabled(enabled);
        this.ivjDatabaseNameComboBox.setEnabled(enabled);
        this.ivjDriverTextField.setEnabled(enabled);
        this.ivjLoginTextField.setEnabled(enabled);
        this.ivjPasswordField.setEnabled(enabled);
        this.ivjRememberPasswordCheckBox.setEnabled(enabled);
        this.ivjPropertyTextField.setEnabled(enabled);
        this.ivjURLField.setEnabled(enabled);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.getConnectButton()) {
            this.connConnectPressed();
        } else if (source == this.getExitButton()) {
            this.connExitPressed();
        } else if (source == this.getDatabaseNameComboBox()) {
            this.connDriverChanged();
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        Object source = e.getSource();
        if (source == this.getDatabaseNameComboBox() || source == this.getDriverTextField()) {
            this.connDriverCaretEvent();
        } else if (source == this.getURLField()) {
            this.connURLCaretEvent();
        } else if (source == this.getPropertyTextField()) {
            this.connPropertyCaretEvent();
        }
    }

    private void connDriverChanged() {
        JComboBox databaseNameCombo = this.getDatabaseNameComboBox();
        JTextField driverTextField = this.getDriverTextField();
        int index = databaseNameCombo.getSelectedIndex();
        int count = databaseNameCombo.getItemCount();
        JEditorPane urlField = this.getURLField();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConnectionDialog.this.clearAllErrors();
                ConnectionDialog.this.pack();
            }
        });
        JComponent urlHelp = this.getURLHelp();
        if (index == count - 1 || index == -1) {
            databaseNameCombo.setEditable(true);
            driverTextField.setEditable(true);
            if (index != -1) {
                driverTextField.setText("");
                urlField.setText("");
            }
            urlField.setToolTipText(DB_URL_TOOLTIP);
            urlHelp.setToolTipText(DB_URL_TOOLTIP);
        } else {
            databaseNameCombo.setEditable(false);
            driverTextField.setEditable(false);
            driverTextField.setText(DatabaseConstants.DBMS_DRIVERS[index]);
            urlField.setText(ConnectionDialog.getFormattedTemplate(DatabaseConstants.DBMS_URL_TEMPLATES[index]));
            String urlTooltip = ConnectionDialog.getURLTooltip(index);
            urlField.setToolTipText(urlTooltip);
            urlHelp.setToolTipText(urlTooltip);
        }
    }

    private static String getFormattedColoredText(String text, String color) {
        if (color == null) {
            return text;
        }
        return "<span color=\"" + color + "\"><b>" + text + "</b></span>";
    }

    private void connExitPressed() {
        try {
            this.setVisible(false);
        }
        catch (Throwable ivjExc) {
            ConnectionDialog.handleError("connExitPressed", ivjExc);
        }
    }

    private void connDriverCaretEvent() {
        try {
            this.textsFilledCheck();
        }
        catch (Throwable ivjExc) {
            ConnectionDialog.handleError("connDriverCaretEvent", ivjExc);
        }
    }

    private void connConnectPressed() {
        if (this.connectionThread != null && this.connectionThread.isAlive()) {
            return;
        }
        this.connectionThread = new ConnectionThread();
        this.connectionThread.start();
    }

    private void showWaitMessage(String message) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setName(WAIT_MESSAGE_PANEL_NAME);
        JComponent pane = ConnectionDialog.createMessagePane(message, "green");
        panel.add(pane);
        this.textPane.add((Component)panel, this.textPane.getComponentCount());
    }

    private void hideWaitMessage() {
        int index = this.findComponentIndex(WAIT_MESSAGE_PANEL_NAME);
        if (index != -1) {
            this.textPane.remove(index);
        }
    }

    private void markError(JComponent[] components, String description, String details, String help) {
        for (JComponent component : components) {
            component.setBorder(BorderFactory.createLineBorder(Color.RED, 2));
        }
        JComponent component = components[components.length - 1];
        int k = this.findComponentPanelIndex(component);
        assert (k != -1);
        k += components.length - 1;
        JComponent errorPane = ConnectionDialog.createMessagePane(description, details, help, "red", "black", null);
        JPanel errorPanel = new JPanel();
        errorPanel.setLayout(new BoxLayout(errorPanel, 0));
        errorPanel.setBorder(BorderFactory.createBevelBorder(0));
        errorPanel.setName(ConnectionDialog.getErrorComponentName(component));
        errorPanel.add(Box.createHorizontalStrut(20));
        errorPanel.add(Box.createHorizontalGlue());
        errorPanel.add(errorPane);
        JPanel panel = new JPanel();
        panel.setName(ConnectionDialog.getErrorComponentName(component));
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(errorPanel);
        panel.add(Box.createVerticalStrut(30));
        this.textPane.add((Component)panel, k + 1);
    }

    private void clearAllErrors() {
        this.clearErrors(new JComponent[]{this.ivjDriverTextField, this.ivjURLField, this.ivjLoginTextField, this.ivjPasswordField, this.ivjPropertyTextField});
    }

    private void clearErrors(JComponent[] components) {
        for (JComponent component : components) {
            int errorComponentIndex;
            Border border = component.getBorder();
            if (!(border instanceof LineBorder) || !((LineBorder)border).getLineColor().equals(Color.RED)) continue;
            component.setBorder(null);
            if (component == this.ivjURLField || component == this.ivjDriverTextField) {
                component.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            }
            if ((errorComponentIndex = this.findErrorComponentIndex(component)) == -1) continue;
            this.textPane.remove(errorComponentIndex);
        }
    }

    private static String getErrorComponentName(JComponent component) {
        String name = component.getName();
        if (name == null) {
            name = "";
        }
        return name + "_ERROR";
    }

    private int findErrorComponentIndex(JComponent component) {
        return this.findComponentIndex(ConnectionDialog.getErrorComponentName(component));
    }

    private int findComponentPanelIndex(JComponent component) {
        return this.findComponentIndex(component.getName());
    }

    private int findComponentIndex(String name) {
        int count = this.textPane.getComponentCount();
        for (int i = 0; i < count; ++i) {
            if (!name.equals(this.textPane.getComponent(i).getName())) continue;
            return i;
        }
        return -1;
    }

    private static JComponent createMessagePane(String text, String color) {
        return ConnectionDialog.createMessagePane(text, null, null, color, null, null);
    }

    private static JComponent createMessagePane(String text1, String text2, String text3, String color1, String color2, String color3) {
        String text = ConnectionDialog.getFormattedColoredText(text1, color1);
        if (text2 != null) {
            text = text + "<br>" + ConnectionDialog.getFormattedColoredText(text2, color2);
        }
        if (text3 != null) {
            text = text + "<br>" + ConnectionDialog.getFormattedColoredText(text3, color3);
        }
        return SwingUtil.createMessagePane(text);
    }

    private void connURLCaretEvent() {
        try {
            this.textsFilledCheck();
        }
        catch (Throwable ivjExc) {
            ConnectionDialog.handleError("connURLCaretEvent", ivjExc);
        }
    }

    private void connPropertyCaretEvent() {
        try {
            this.textsFilledCheck();
        }
        catch (Throwable ivjExc) {
            ConnectionDialog.handleError("connPropertyCaretEvent", ivjExc);
        }
    }

    private JButton getExitButton() {
        if (this.ivjExitButton == null) {
            try {
                this.ivjExitButton = new JButton();
                this.ivjExitButton.setName("ExitButton");
                this.ivjExitButton.setText("Exit");
            }
            catch (Throwable ivjExc) {
                ConnectionDialog.handleError("getExitButton", ivjExc);
            }
        }
        return this.ivjExitButton;
    }

    private static String getPlainText(JEditorPane editorPane) {
        String text = editorPane.getText();
        int k = text.indexOf("<body>");
        if (k == -1) {
            k = text.indexOf("<html>");
        }
        if (k == -1) {
            return text.trim();
        }
        int l = text.lastIndexOf("</body>");
        if (l == -1) {
            l = text.lastIndexOf("</html>");
        }
        if (l == -1) {
            l = text.length();
        }
        return text.substring(k + 6, l).trim();
    }

    private static JComponent createPropertyHelp() {
        return ConnectionDialog.createToolTipMarker(DB_PROPERTY_TABLE_TOOLTIP, CONNECTION_GUIDE_LINK);
    }

    private static JComponent createDriverHelp() {
        return ConnectionDialog.createToolTipMarker(JDBC_DRIVER_TOOLTIP, CONNECTION_GUIDE_LINK);
    }

    private static JComponent createDatabaseNameHelp() {
        return ConnectionDialog.createToolTipMarker(DATABASE_NAME_TOOLTIP, CONNECTION_GUIDE_LINK);
    }

    private JComboBox getDatabaseNameComboBox() {
        if (this.ivjDatabaseNameComboBox == null) {
            try {
                this.ivjDatabaseNameComboBox = new JComboBox<Object>(ConnectionDialog.getDatabaseNames());
                this.ivjDatabaseNameComboBox.setSelectedIndex(this.ivjDatabaseNameComboBox.getItemCount() - 1);
                this.ivjDatabaseNameComboBox.setEditable(true);
                this.ivjDatabaseNameComboBox.setToolTipText(DATABASE_NAME_TOOLTIP);
            }
            catch (Throwable ivjExc) {
                ConnectionDialog.handleError("getDatabaseNameComboBox", ivjExc);
            }
        }
        return this.ivjDatabaseNameComboBox;
    }

    private static Object[] getDatabaseNames() {
        int driverCount = DatabaseConstants.DBMS_NAMES.length;
        Object[] driverNames = new Object[driverCount + 1];
        for (int i = 0; i < driverCount; ++i) {
            driverNames[i] = DatabaseConstants.DBMS_NAMES[i];
        }
        driverNames[driverCount] = OTHER_DB_DRIVER_ENTRY;
        return driverNames;
    }

    private JTextField getDriverTextField() {
        if (this.ivjDriverTextField == null) {
            try {
                this.ivjDriverTextField = new JTextField(50);
                this.ivjDriverTextField.setToolTipText(JDBC_DRIVER_TOOLTIP);
            }
            catch (Throwable ivjExc) {
                ConnectionDialog.handleError("getDriverTextField", ivjExc);
            }
        }
        return this.ivjDriverTextField;
    }

    private void addToGrid(JPanel pane, Component comp, GridBagLayout g, GridBagConstraints c) {
        g.setConstraints(comp, c);
        pane.add(comp);
    }

    private JPanel getJDialogContentPane() {
        if (this.ivjJDialogContentPane == null) {
            try {
                this.ivjJDialogContentPane = new JPanel();
                this.ivjJDialogContentPane.setName("JDialogContentPane");
                this.ivjJDialogContentPane.setLayout(new BorderLayout(10, 10));
                this.textPane = new JPanel();
                this.textPane.setLayout(new BoxLayout(this.textPane, 1));
                this.textPane.add(ConnectionDialog.getConnectionEntryPanel(DATABASE_NAME_LABEL, (JComponent)this.getDatabaseNameComboBox(), ConnectionDialog.createDatabaseNameHelp(), 5));
                this.textPane.add(ConnectionDialog.getConnectionEntryPanel(JDBC_DRIVER_LABEL, (JComponent)this.getDriverTextField(), ConnectionDialog.createDriverHelp(), 20));
                this.textPane.add(ConnectionDialog.getConnectionEntryPanel(DB_URL_LABEL, (JComponent)this.getURLField(), this.getURLHelp(), 20));
                this.textPane.add(ConnectionDialog.getConnectionEntryPanel(DB_LOGIN_LABEL, this.getLoginTextField(), 20));
                this.textPane.add(ConnectionDialog.getConnectionEntryPanel(DB_PASSWORD_LABEL, this.getPasswordField(), 5));
                this.textPane.add(ConnectionDialog.getConnectionEntryPanel(null, this.getRememberPasswordCheckBox(), 20));
                this.textPane.add(ConnectionDialog.getConnectionEntryPanel(DB_PROPERTY_TABLE_LABEL, (JComponent)this.getPropertyTextField(), ConnectionDialog.createPropertyHelp(), 25));
                this.textPane.add(ConnectionDialog.getConnectionEntryPanel(null, ConnectionDialog.createHelpLinkPane(CONNECTION_GUIDE_LABEL, CONNECTION_GUIDE_LINK), ConnectionDialog.createToolTipMarker(CONNECTION_GUIDE_LABEL, CONNECTION_GUIDE_LINK), 20));
                JPanel buttonPane = new JPanel();
                buttonPane.setLayout(new BoxLayout(buttonPane, 0));
                buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
                buttonPane.add(Box.createHorizontalGlue());
                buttonPane.add((Component)this.getConnectButton(), this.getConnectButton().getName());
                buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
                buttonPane.add((Component)this.getExitButton(), this.getExitButton().getName());
                this.ivjJDialogContentPane.add(Box.createRigidArea(new Dimension(10, 10)), "North");
                this.ivjJDialogContentPane.add(Box.createRigidArea(new Dimension(10, 10)), "East");
                this.ivjJDialogContentPane.add(Box.createRigidArea(new Dimension(10, 10)), "West");
                JPanel warningPanel = ConnectionDialog.getJVMWarningPanel();
                if (warningPanel != null) {
                    this.ivjJDialogContentPane.add((Component)warningPanel, "North");
                }
                this.ivjJDialogContentPane.add((Component)this.textPane, "Center");
                this.ivjJDialogContentPane.add((Component)buttonPane, "South");
            }
            catch (Throwable ivjExc) {
                ConnectionDialog.handleError("getJDialogContentPane", ivjExc);
            }
        }
        return this.ivjJDialogContentPane;
    }

    private static JPanel getJVMWarningPanel() {
        if (JVM_WARNING == null) {
            return null;
        }
        JPanel warningPanel = new JPanel();
        warningPanel.add(SwingUtil.createMessagePane("<html><body>" + ConnectionDialog.getFormattedColoredText(JVM_WARNING, "red") + "<br>" + JVM_DOWNLOAD_MESSAGE + ConnectionDialog.getHTMLLink("ORACLE Java SE download page", "http://www.oracle.com/technetwork/java/javase/downloads/index.html") + "." + "</body></html>"));
        return warningPanel;
    }

    private static JPanel getConnectionEntryPanel(String label, JComponent entry, int hgap) {
        return ConnectionDialog.getConnectionEntryPanel(label, entry, entry.getToolTipText(), hgap);
    }

    private static JPanel getConnectionEntryPanel(String label, JComponent entry, String tooltip, int hgap) {
        return ConnectionDialog.getConnectionEntryPanel(label, entry, ConnectionDialog.createToolTipMarker(tooltip), hgap);
    }

    private static JPanel getConnectionEntryPanel(String label, JComponent entry, JComponent tooltip, int hgap) {
        JPanel panel = new JPanel();
        if (label != null) {
            panel.setName(label);
            entry.setName(label);
        }
        panel.setLayout(new BoxLayout(panel, 1));
        if (label != null) {
            JPanel labelPanel = new JPanel();
            labelPanel.setLayout(new BoxLayout(labelPanel, 0));
            labelPanel.add(new JLabel(label));
            labelPanel.add(Box.createHorizontalGlue());
            panel.add(labelPanel);
            panel.add(Box.createRigidArea(new Dimension(0, 3)));
            panel.add(Box.createVerticalGlue());
        }
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 0));
        if (tooltip != null && label == null) {
            mainPanel.add(Box.createRigidArea(new Dimension(10, 0)));
            mainPanel.add(tooltip);
            mainPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        }
        mainPanel.add(entry);
        mainPanel.add(Box.createHorizontalGlue());
        if (tooltip != null && label != null) {
            mainPanel.add(Box.createRigidArea(new Dimension(10, 0)));
            mainPanel.add(tooltip);
            ToolTipManager.sharedInstance().registerComponent(tooltip);
            ToolTipManager.sharedInstance().registerComponent(entry);
        }
        panel.add(mainPanel);
        panel.add(Box.createRigidArea(new Dimension(0, hgap)));
        panel.add(Box.createVerticalGlue());
        return panel;
    }

    private static JComponent createToolTipMarker(String tooltip) {
        return ConnectionDialog.createToolTipMarker(tooltip, null);
    }

    private static JComponent createToolTipMarker(String tooltip, final String url) {
        if (tooltip == null || tooltip.length() == 0) {
            return null;
        }
        JLabel marker = new JLabel(ConnectionDialog.createHelpIcon());
        if (url != null) {
            marker.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    try {
                        BrowserLauncher.openURL(url);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
        marker.setToolTipText(tooltip);
        return marker;
    }

    private static ImageIcon createHelpIcon() {
        return new ImageIcon(ConnectionDialog.class.getResource(HELP_ICON_PATH));
    }

    private JTextField getLoginTextField() {
        if (this.ivjLoginTextField == null) {
            try {
                this.ivjLoginTextField = new JTextField(50);
                this.ivjLoginTextField.setToolTipText(DB_LOGIN_TOOLTIP);
            }
            catch (Throwable ivjExc) {
                ConnectionDialog.handleError("getLoginTextField", ivjExc);
            }
        }
        return this.ivjLoginTextField;
    }

    private JButton getConnectButton() {
        if (this.ivjConnectButton == null) {
            try {
                this.ivjConnectButton = new JButton();
                this.ivjConnectButton.setName("ConnectButton");
                this.ivjConnectButton.setText("Connect");
                this.ivjConnectButton.setDoubleBuffered(true);
                this.ivjConnectButton.setEnabled(false);
            }
            catch (Throwable ivjExc) {
                ConnectionDialog.handleError("getConnectButton", ivjExc);
            }
        }
        return this.ivjConnectButton;
    }

    private JPasswordField getPasswordField() {
        if (this.ivjPasswordField == null) {
            try {
                this.ivjPasswordField = new JPasswordField(50);
                this.ivjPasswordField.setToolTipText(DB_PASSWORD_TOOLTIP);
            }
            catch (Throwable ivjExc) {
                ConnectionDialog.handleError("getPasswordField", ivjExc);
            }
        }
        return this.ivjPasswordField;
    }

    private static JComponent createHelpLinkPane(String text, String url) throws IOException {
        return SwingUtil.createMessagePane("<html><body>" + ConnectionDialog.getHTMLLink(text, url) + "</body></html>");
    }

    private static String getHTMLLinkReferenceText(String text, String url) {
        return "Refer to the " + ConnectionDialog.getHTMLLink(text, url) + " for details.";
    }

    private static String getHTMLLink(String text, String url) {
        return "<a href=\"" + url + "\">" + text + "</a>";
    }

    private JCheckBox getRememberPasswordCheckBox() {
        if (this.ivjRememberPasswordCheckBox == null) {
            try {
                this.ivjRememberPasswordCheckBox = new JCheckBox();
                this.ivjRememberPasswordCheckBox.setName("RememberPasswordCheckBox");
                this.ivjRememberPasswordCheckBox.setText(DB_REMEMBER_PASSWORD_LABEL);
                this.ivjRememberPasswordCheckBox.setHorizontalTextPosition(4);
                this.ivjRememberPasswordCheckBox.setSelected(false);
                this.ivjRememberPasswordCheckBox.setHorizontalAlignment(0);
            }
            catch (Throwable ivjExc) {
                ConnectionDialog.handleError("getRememberPasswordCheckBox", ivjExc);
            }
        }
        return this.ivjRememberPasswordCheckBox;
    }

    private String getURL() {
        return ConnectionDialog.getPlainText(this.getURLField());
    }

    private JEditorPane getURLField() {
        if (this.ivjURLField == null) {
            try {
                this.ivjURLField = new JEditorPane();
                this.ivjURLField.setEditorKit(new HTMLEditorKit());
                this.ivjURLField.setBorder(BorderFactory.createLineBorder(Color.BLACK));
                this.ivjURLField.setToolTipText(DB_URL_TOOLTIP);
                SwingUtil.setDefaultFont(this.ivjURLField);
            }
            catch (Throwable ivjExc) {
                ConnectionDialog.handleError("getURLField", ivjExc);
            }
        }
        return this.ivjURLField;
    }

    private JComponent getURLHelp() {
        if (this.ivjURLHelp == null) {
            this.ivjURLHelp = ConnectionDialog.createToolTipMarker(DB_URL_TOOLTIP, CONNECTION_GUIDE_LINK);
        }
        return this.ivjURLHelp;
    }

    private JTextField getPropertyTextField() {
        if (this.ivjPropertyTextField == null) {
            try {
                this.ivjPropertyTextField = new JTextField(50);
                this.ivjPropertyTextField.setToolTipText(DB_PROPERTY_TABLE_TOOLTIP);
            }
            catch (Throwable ivjExc) {
                ConnectionDialog.handleError("getPropertyTextField", ivjExc);
            }
        }
        return this.ivjPropertyTextField;
    }

    private static void handleError(String method, Throwable error) {
        logger.throwing("ConnectionDialog", method, error);
    }

    private void initConnections() {
        this.getConnectButton().addActionListener(this);
        this.getExitButton().addActionListener(this);
        this.getDatabaseNameComboBox().addActionListener(this);
        this.getDriverTextField().addCaretListener(this);
        this.getURLField().addCaretListener(this);
        this.getPasswordField().addCaretListener(this);
        this.getPropertyTextField().addCaretListener(this);
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ConnectionDialog.this.connConnectPressed();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        };
        this.getDatabaseNameComboBox().addKeyListener(keyListener);
        this.getDriverTextField().addKeyListener(keyListener);
        this.getURLField().addKeyListener(keyListener);
        this.getPropertyTextField().addKeyListener(keyListener);
        this.getLoginTextField().addKeyListener(keyListener);
        this.getPasswordField().addKeyListener(keyListener);
        this.connDriverChanged();
    }

    private void initialize() {
        this.setName("ConnectionDialog");
        this.setDefaultCloseOperation(2);
        this.setTitle("Connecting to a Database");
        this.setModal(true);
        this.setContentPane(this.getJDialogContentPane());
        this.initConnections();
        this.pack();
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
    }

    public void setData(ConnectionHandler conh) {
        if (conh != null) {
            String driver = conh.getDriver();
            this.getDriverTextField().setText(driver);
            int driverIndex = ConnectionDialog.findDriverIndex(driver);
            JComboBox databaseNameCombo = this.getDatabaseNameComboBox();
            databaseNameCombo.setEditable(driverIndex == -1);
            databaseNameCombo.setSelectedIndex(driverIndex);
            if (driverIndex == -1) {
                databaseNameCombo.setSelectedItem(conh.getDriverName());
            }
            this.getURLField().setText(conh.getUrl());
            this.getLoginTextField().setText(conh.getLoginName());
            if (conh.getRememberPassword()) {
                this.getPasswordField().setText(conh.getPassword());
            }
            this.getPropertyTextField().setText(conh.getPropertyTable());
            this.getRememberPasswordCheckBox().getModel().setSelected(conh.getRememberPassword());
        }
        this.textsFilledCheck();
    }

    public ConnectionHandler getData() {
        if (this.connectionThread == null) {
            return null;
        }
        try {
            this.connectionThread.join();
        }
        catch (InterruptedException e) {
            return null;
        }
        return this.connectionThread.conh;
    }

    private static int findDriverIndex(String driver) {
        for (int i = 0; i < DatabaseConstants.DBMS_DRIVERS.length; ++i) {
            if (!DatabaseConstants.DBMS_DRIVERS[i].equals(driver)) continue;
            return i;
        }
        return -1;
    }

    public void textsFilledCheck() {
        String s1 = this.getDriver();
        String s2 = this.getURL();
        this.getConnectButton().setEnabled(s1 != null && !s1.equals("") && s2 != null && !s2.equals(""));
    }

    private String getDatabaseName() {
        return ((String)this.getDatabaseNameComboBox().getSelectedItem()).trim();
    }

    private String getDriver() {
        return this.getDriverTextField().getText().trim();
    }

    class ConnectionThread
    extends Thread {
        ConnectionHandler conh = new ConnectionHandler();

        ConnectionThread() {
            this.conh.setDriverName(ConnectionDialog.this.getDatabaseName());
            this.conh.setDriver(ConnectionDialog.this.getDriver());
            this.conh.setUrl(ConnectionDialog.this.getURL());
            this.conh.setLoginName(ConnectionDialog.this.getLoginTextField().getText().trim());
            this.conh.setPassword(new String(ConnectionDialog.this.getPasswordField().getPassword()).trim());
            this.conh.setRememberPassword(ConnectionDialog.this.getRememberPasswordCheckBox().getModel().isSelected());
            this.conh.setPropertyTable(ConnectionDialog.this.getPropertyTextField().getText().trim());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConnectionDialog.this.enableComponents(false);
                    ConnectionDialog.this.clearAllErrors();
                    ConnectionDialog.this.showWaitMessage(ConnectionDialog.WAIT_MESSAGE);
                    ConnectionDialog.this.pack();
                    ConnectionDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                }
            });
            try {
                this.conh.connectToDatabase();
            }
            catch (ClassNotFoundException e) {
                this.conh = null;
                SwingUtilities.invokeLater(new ErrorDisplayThread(ConnectionDialog.this.getDriverTextField(), ConnectionDialog.DRIVER_NOT_FOUND_ERROR_DESCRIPTION, e.getMessage(), DRIVER_NOT_FOUND_ERROR_HELP));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ConnectionDialog.this.hideWaitMessage();
                        ConnectionDialog.this.enableComponents(true);
                        ConnectionDialog.this.pack();
                        ConnectionDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                });
            }
            catch (SQLException e2) {
                this.conh = null;
                SwingUtilities.invokeLater(new ErrorDisplayThread(e2));
                {
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            try {
                if (this.conh != null) {
                    ConnectionDialog.this.setVisible(false);
                }
            }
            catch (Throwable ivjExc) {
                ConnectionDialog.handleError("run", ivjExc);
            }
        }
    }

    class ErrorDisplayThread
    extends Thread {
        private final JComponent[] components;
        private final String description;
        private final String details;
        private final String help;

        ErrorDisplayThread(JComponent component, String description, String details, String help) {
            this.components = new JComponent[]{component};
            this.description = description;
            this.details = details;
            this.help = help;
        }

        ErrorDisplayThread(SQLException error) {
            this.components = this.getComponents(error);
            this.description = this.getDescription(error);
            this.help = this.getHelp();
            this.details = this.getDetails(error);
        }

        @Override
        public void run() {
            ConnectionDialog.this.enableComponents(false);
            ConnectionDialog.this.clearErrors(this.components);
            ConnectionDialog.this.markError(this.components, this.description, this.details, this.help);
            ConnectionDialog.this.enableComponents(true);
            ConnectionDialog.this.pack();
        }

        private String getDetails(SQLException error) {
            StringBuilder sb = new StringBuilder();
            sb.append(error.getMessage());
            while ((error = error.getNextException()) != null) {
                sb.append("<br>" + error.getMessage());
            }
            return new String(sb);
        }

        private String getHelp() {
            JComponent component = this.components[0];
            if (component == ConnectionDialog.this.ivjPropertyTextField || component == ConnectionDialog.this.ivjDatabaseNameComboBox || component == ConnectionDialog.this.ivjDriverTextField || component == ConnectionDialog.this.ivjURLField) {
                return ConnectionDialog.getHTMLLinkReferenceText(ConnectionDialog.CONNECTION_GUIDE_LABEL, ConnectionDialog.CONNECTION_GUIDE_LINK);
            }
            if (component == ConnectionDialog.this.ivjLoginTextField) {
                return ConnectionDialog.INVALID_USER_OR_PASSWORD_HELP;
            }
            return null;
        }

        private JComponent[] getComponents(SQLException error) {
            String msg = error.getMessage().toLowerCase();
            if (msg.indexOf("authentication") != -1) {
                return new JComponent[]{ConnectionDialog.this.ivjLoginTextField, ConnectionDialog.this.ivjPasswordField};
            }
            return new JComponent[]{ConnectionDialog.this.ivjURLField};
        }

        private String getDescription(SQLException error) {
            String msg = error.getMessage();
            if (msg.indexOf("authentication") != -1) {
                return ConnectionDialog.INVALID_USER_OR_PASSWORD_DESCRIPTION;
            }
            return ConnectionDialog.INVALID_URL_DESCRIPTION;
        }
    }
}

