/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.Updater;
import chemaxon.jchem.file.ProgressWriter;
import chemaxon.jchem.gui.ConnectionDialog;
import chemaxon.jchem.gui.MessageDialog;
import chemaxon.jchem.gui.ProgressReporter;
import chemaxon.marvin.util.SwingUtil;
import chemaxon.util.ConnectionHandler;
import java.awt.Component;
import java.awt.Cursor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Connector {
    private static final Log log = LogFactory.getLog(Connector.class);
    private Properties settings;
    private final JFrame parent;
    private String propertyTableName;
    private static final String UPDATER_INFO = "Checking whether table update is necessary";

    public Connector(JFrame parent, Properties settings) {
        this.settings = settings;
        this.parent = parent;
    }

    private ConnectionHandler connect() {
        ConnectionHandler conh = new ConnectionHandler();
        conh.loadValuesFromProperties(this.settings);
        ConnectionDialog cd = new ConnectionDialog(this.parent);
        cd.setData(conh);
        cd.setVisible(true);
        conh = cd.getData();
        if (conh != null) {
            conh.storeValuesToProperties(this.settings);
        }
        return conh;
    }

    public ConnectionHandler go() {
        try {
            final ConnectionHandler conh = SwingUtil.invokeAndWait(new Callable<ConnectionHandler>(){

                @Override
                public ConnectionHandler call() {
                    return Connector.this.connect();
                }
            });
            if (conh == null) {
                return null;
            }
            if (conh.getConnection() == null) {
                return null;
            }
            if (!DatabaseProperties.propertyTableExists(conh)) {
                boolean createNewEnvironment = SwingUtil.invokeAndWait(new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        return Connector.getNewEnvironmentConfirmation(Connector.this.parent, conh);
                    }
                });
                if (createNewEnvironment) {
                    DatabaseProperties.createPropertyTable(conh);
                    Connector.showNewEnvironmentCreatedMessage(this.parent, conh);
                    return conh;
                }
                conh.close();
                this.settings.setProperty("connection.propertyTable", "JChemProperties");
                return this.go();
            }
            Updater ud = new Updater(conh);
            UpdaterTask task = new UpdaterTask(this.parent, ud);
            task.execute();
            try {
                task.get();
            }
            catch (InterruptedException e) {
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
            return conh;
        }
        catch (SQLException ex) {
            MessageDialog.showSQLMessage(this.parent, ex);
        }
        catch (InvocationTargetException ex) {
            MessageDialog.showErrorMessage(this.parent, ex.getCause());
        }
        catch (Throwable ex) {
            MessageDialog.showErrorMessage(this.parent, ex);
        }
        return null;
    }

    private static boolean getNewEnvironmentConfirmation(Component parent, ConnectionHandler conh) {
        return JOptionPane.showConfirmDialog(parent, "Are you sure that you want to create property table " + conh.getPropertyTable() + "?\n" + "This means creating a new JChem environment.", "", 0) == 0;
    }

    private static void showNewEnvironmentCreatedMessage(Component parent, ConnectionHandler conh) {
        MessageDialog.showMessage(parent, "Table " + conh.getPropertyTable() + " has been created.\n" + "It will store information on tables containing structures.\n" + "If necessary, please grant read/write access rights on\n" + "this table to users\n");
    }

    private static boolean displayMessage(Component parent, Updater.UpdateInfo ui) throws Exception {
        String text;
        String[] parts;
        String[] oldTables = ui.entityList;
        String names = "";
        if (oldTables != null && oldTables.length > 0) {
            names = names + "<ul>";
            for (int x = 0; x < oldTables.length; ++x) {
                names = names + "<li>" + oldTables[x] + "</li>";
                if (x != 19) continue;
                names = names + "<li>... too many objects to display ...</li>";
                break;
            }
            names = names + "</ul>";
        }
        if ((parts = (text = ui.message).split("\n\n")).length == 3) {
            text = parts[0] + "<p><b>" + parts[1] + "</b><p>" + parts[2];
        }
        text = text.replaceAll("\n", "<br>");
        if (names.length() > 0) {
            text = text + "<p>Object list:" + names;
        }
        String content = "<html><body>" + text + "</body></html>";
        String processingMessage = ui.processingMessage;
        return Connector.getProceedUpdateConfirmation(parent, content, processingMessage);
    }

    private static boolean getProceedUpdateConfirmation(Component parent, String content, String processingMessage) {
        JEditorPane textComponent = SwingUtil.createMessagePane(content);
        Object[] options = new String[]{"Proceed", "Skip"};
        return JOptionPane.showOptionDialog(parent, textComponent, processingMessage + "?", 0, 3, null, options, options[0]) == 0;
    }

    private static class UpdaterTask
    extends SwingWorker<Void, Void>
    implements PropertyChangeListener {
        private final Component parent;
        private final Updater updater;
        private final int cursorType;

        UpdaterTask(final Component parent, Updater updater) {
            this.parent = parent;
            this.updater = updater;
            Cursor cursor = null;
            try {
                cursor = parent == null ? null : SwingUtil.invokeAndWait(new Callable<Cursor>(){

                    @Override
                    public Cursor call() {
                        return parent.getCursor();
                    }
                });
            }
            catch (Exception e) {
                log.trace((Object)e);
                cursor = new Cursor(0);
            }
            this.cursorType = cursor.getType();
            this.addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name.equals("parent")) {
                Object newValue = evt.getNewValue();
                if ("enable".equals(newValue)) {
                    log.debug((Object)"parent enable");
                    this.parent.setEnabled(true);
                } else if ("disable".equals(newValue)) {
                    log.debug((Object)"parent disable");
                    this.parent.setEnabled(false);
                }
            } else if (name.equals("cursor")) {
                Object newValue = evt.getNewValue();
                if ("wait".equals(newValue)) {
                    log.debug((Object)"wait cursor");
                    this.parent.setCursor(new Cursor(3));
                } else {
                    log.debug((Object)"restore cursor");
                    this.parent.setCursor(new Cursor(this.cursorType));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void doInBackground() throws Exception {
            if (this.parent != null) {
                this.firePropertyChange("parent", null, "disable");
            }
            try {
                Updater.UpdateInfo ui = null;
                while ((ui = this.getNextUpdateInfo()) != null) {
                    log.debug((Object)("next ui: " + ui.processingMessage));
                    if (Connector.displayMessage(this.parent, ui)) {
                        log.debug((Object)"perform update");
                        this.performUpdate();
                        continue;
                    }
                    if (!ui.isOperationRequired) continue;
                }
                Void void_ = null;
                return void_;
            }
            catch (InterruptedException e) {
                log.debug((Object)"INTERRUPTED");
                Void void_ = null;
                return void_;
            }
            finally {
                if (this.parent != null) {
                    this.firePropertyChange("parent", null, "enable");
                }
            }
        }

        @Override
        protected void done() {
            if (this.parent != null) {
                this.parent.setCursor(new Cursor(0));
                this.parent.setEnabled(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Updater.UpdateInfo getNextUpdateInfo() throws InterruptedException {
            if (this.parent != null) {
                this.firePropertyChange("cursor", null, "wait");
            }
            ProgressReporter pr = new ProgressReporter(this.parent, Connector.UPDATER_INFO, "", true, 1L, 1L);
            Updater.UpdateInfo ui = null;
            boolean canceled = false;
            try {
                ui = this.updater.getNextUpdateInfo(pr);
                canceled = ((ProgressWriter)pr).isCanceled();
            }
            catch (SQLException e) {
                MessageDialog.showSQLMessage(this.parent, e);
                Updater.UpdateInfo updateInfo = null;
                return updateInfo;
            }
            catch (Throwable ex) {
                MessageDialog.showErrorMessage(this.parent, ex);
                Updater.UpdateInfo updateInfo = null;
                return updateInfo;
            }
            finally {
                if (this.parent != null) {
                    this.firePropertyChange("cursor", null, "restore");
                }
                ((ProgressWriter)pr).close();
            }
            if (canceled) {
                throw new InterruptedException();
            }
            return ui;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void performUpdate() throws InterruptedException {
            if (this.parent != null) {
                this.firePropertyChange("cursor", null, "wait");
            }
            ProgressReporter pr = new ProgressReporter(this.parent, "", "", true, 1L, 1L);
            boolean canceled = false;
            try {
                String message = this.updater.performCurrentUpdate(pr);
                canceled = ((ProgressWriter)pr).isCanceled();
                if (message != null) {
                    MessageDialog.showMessage(this.parent, message);
                }
            }
            catch (SQLException e) {
                MessageDialog.showSQLMessage(this.parent, e);
            }
            catch (Throwable ex) {
                MessageDialog.showErrorMessage(this.parent, ex);
            }
            finally {
                if (this.parent != null) {
                    this.firePropertyChange("cursor", null, "restore");
                }
                ((ProgressWriter)pr).close();
            }
            if (canceled) {
                throw new InterruptedException();
            }
        }
    }
}

