/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.db.TransferDialogData;
import chemaxon.jchem.db.UpdateHandler;
import chemaxon.jchem.gui.MessageDialog;
import chemaxon.jchem.gui.TransferDialog;
import chemaxon.util.ConnectionHandler;
import java.awt.Cursor;
import java.awt.Frame;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class Deletor
implements Runnable {
    private JFrame parent;
    private ConnectionHandler conh;
    private Properties settings;

    public Deletor(JFrame parent, ConnectionHandler conh, Properties settings) {
        this.parent = parent;
        this.conh = conh;
        this.settings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block20: {
            this.parent.getJMenuBar().setEnabled(false);
            try {
                boolean confirmed;
                String questionText;
                Vector<String> tables;
                Cursor prevCursor = this.parent.getCursor();
                this.parent.setCursor(new Cursor(3));
                try {
                    DatabaseProperties dbProp = new DatabaseProperties(this.conh, false);
                    tables = dbProp.getStructureTableNames();
                }
                finally {
                    this.parent.setCursor(prevCursor);
                }
                TransferDialogData tdd = this.selectTable(tables);
                if (tdd == null) break block20;
                if (!tdd.isDrop) {
                    questionText = "Are you sure you want to delete rows from table " + tdd.selectedTable + "?";
                    if (!tdd.deleteWhereString.equals("")) {
                        questionText = questionText + "\n (WHERE " + tdd.deleteWhereString + ")";
                    }
                } else {
                    questionText = "Are you sure that you want to remove " + tdd.selectedTable + "?";
                }
                boolean bl = confirmed = JOptionPane.showConfirmDialog(this.parent, questionText, "", 0) == 0;
                if (!confirmed) break block20;
                prevCursor = this.parent.getCursor();
                this.parent.setCursor(new Cursor(3));
                try {
                    if (tdd.isDrop) {
                        TableInfo.deleteTable(this.conh, tdd.selectedTable);
                    } else {
                        String where = "";
                        if (!tdd.deleteWhereString.equals("")) {
                            where = where + " WHERE " + tdd.deleteWhereString;
                        }
                        UpdateHandler.deleteRows(this.conh, tdd.selectedTable, where);
                    }
                }
                finally {
                    this.parent.setCursor(prevCursor);
                }
            }
            catch (SQLException ex) {
                MessageDialog.showSQLMessage(this.parent, ex);
            }
            catch (Throwable ex) {
                MessageDialog.showErrorMessage(this.parent, ex);
            }
            finally {
                this.parent.getJMenuBar().setEnabled(true);
            }
        }
    }

    private TransferDialogData selectTable(Vector tables) {
        TransferDialogData tdd = TransferDialogData.getFromSettings(this.settings, 2);
        tdd.tables = tables;
        TransferDialog d = new TransferDialog((Frame)this.parent, 2);
        d.setData(tdd);
        d.setVisible(true);
        tdd = d.getData();
        if (tdd != null) {
            tdd.save(this.settings);
        }
        return tdd;
    }
}

