/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import chemaxon.jchem.db.FieldInfo;
import chemaxon.jchem.db.TableInfo;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class FieldConnectTableModel
extends AbstractTableModel {
    TableInfo tableInfo;
    private int[] order;

    public FieldConnectTableModel(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
        this.order = new int[tableInfo.size()];
        for (int i = 0; i < this.order.length; ++i) {
            this.order[i] = i;
        }
    }

    public void setOrder() {
        int x;
        ArrayList<Integer> list1 = new ArrayList<Integer>();
        ArrayList<Integer> list2 = new ArrayList<Integer>();
        for (x = 0; x < this.order.length; ++x) {
            String name = ((String)this.getValueAt(x, 0)).toLowerCase();
            if (!name.startsWith("cd_")) {
                list1.add(new Integer(x));
                continue;
            }
            list2.add(new Integer(x));
        }
        list1.addAll(list2);
        for (x = 0; x < list1.size(); ++x) {
            this.order[x] = (Integer)list1.get(x);
        }
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Field in table";
            }
            case 1: {
                return "Field type";
            }
            case 2: {
                return "Field in file";
            }
        }
        return null;
    }

    public TableInfo getTableInfo() {
        return this.tableInfo;
    }

    @Override
    public int getRowCount() {
        return this.tableInfo.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        row = this.order[row];
        switch (col) {
            case 0: {
                return this.tableInfo.fieldAt(row).getName();
            }
            case 1: {
                return this.tableInfo.fieldAt(row).getTypeName();
            }
            case 2: {
                return this.tableInfo.fieldAt(row).getOtherName();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                return this.isRowEnabled(row);
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int row, int col) {
        row = this.order[row];
        FieldInfo field = this.tableInfo.fieldAt(row);
        switch (col) {
            case 2: {
                field.setOtherName((String)aValue);
            }
        }
    }

    protected boolean isRowEnabled(int row) {
        FieldInfo field = this.tableInfo.fieldAt(row = this.order[row]);
        return !field.isStructure() && !field.isFingerprint() && !field.isSmiles() && !field.isFormula() && !field.isSortableFormula() && !field.isMolWeight() && !field.isHash() && !field.isFlags() && !field.isDate() && !field.isPrecalculated() && !field.isChemTermBased();
    }

    public FieldInfo fieldAt(int row) {
        row = this.order[row];
        return this.tableInfo.fieldAt(row);
    }
}

