/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import chemaxon.jchem.db.DatabaseOptions;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.FileToSQLHandler;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.db.TransferDialogData;
import chemaxon.jchem.file.FileInfo;
import chemaxon.jchem.file.ImportFileHandler;
import chemaxon.jchem.gui.FieldConnectDialog;
import chemaxon.jchem.gui.FieldConnectTableModel;
import chemaxon.jchem.gui.MessageDialog;
import chemaxon.jchem.gui.ProgressReporter;
import chemaxon.jchem.gui.ProgressReporterInputStream;
import chemaxon.jchem.gui.TransferDialog;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.DatabaseTools;
import java.awt.Cursor;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.InterruptedIOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFrame;

public class Importer
implements Runnable {
    private final JFrame parent;
    private final ConnectionHandler conh;
    private final Properties settings;

    public Importer(JFrame parent, ConnectionHandler conh, Properties settings) {
        this.parent = parent;
        this.conh = conh;
        this.settings = settings;
    }

    private TableInfo connectFieldNames(TableInfo fields, Vector fieldNames) {
        fields.autoConnectFieldsForImport(fieldNames, this.settings);
        FieldConnectDialog fcd = new FieldConnectDialog(this.parent);
        FieldConnectTableModel model = new FieldConnectTableModel(fields);
        model.setOrder();
        fcd.setModel(model, fieldNames);
        fcd.setVisible(true);
        model = fcd.getModel();
        if (model != null) {
            fields.save(this.settings);
            return fields;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block25: {
            ProgressReporterInputStream pris = null;
            this.parent.getJMenuBar().setEnabled(false);
            try {
                FileInfo fileInfo;
                TableInfo tableFields;
                Vector<String> tables;
                DatabaseProperties dbProp = new DatabaseProperties(this.conh);
                Cursor prevCursor = this.parent.getCursor();
                this.parent.setCursor(new Cursor(3));
                try {
                    tables = new DatabaseProperties(this.conh).getStructureTableNames();
                }
                finally {
                    this.parent.setCursor(prevCursor);
                }
                TransferDialogData tdd = this.selectFileAndTable(tables);
                if (tdd == null) break block25;
                File file = new File(tdd.fileName);
                long fileSize = this.getFileSize(file);
                pris = new ProgressReporterInputStream(this.parent, "Collecting field names from " + file.getName(), tdd.numberOfRecords <= 0, new FileInputStream(file), fileSize);
                ProgressReporter rep = pris.getProgressReporter();
                prevCursor = this.parent.getCursor();
                this.parent.setCursor(new Cursor(3));
                try {
                    tableFields = TableInfo.getTableInfo(this.conh, this.settings, tdd.selectedTable);
                    fileInfo = ImportFileHandler.collectFileInfo(pris, rep, tdd.numberOfRecords, tdd.fileName);
                }
                finally {
                    this.parent.setCursor(prevCursor);
                    pris.close();
                }
                int format2 = fileInfo.getFormat();
                ArrayList additionalFields = DatabaseTools.getFieldNames(this.conh, tdd.selectedTable, null);
                for (int i = 0; i < additionalFields.size(); ++i) {
                    if (!((String)additionalFields.get(i)).toLowerCase().startsWith("cd_")) continue;
                    additionalFields.remove(i);
                    --i;
                }
                if ((format2 == 2 || format2 == 4 || format2 == 5 || format2 == 6 || format2 == 3 || format2 == 12 || format2 == 11 || format2 == 13) && (fileInfo.fieldNames.size() > 0 || additionalFields.size() > 0) || (format2 == 7 || format2 == 1 || format2 == 8) && additionalFields.size() > 0) {
                    tableFields = this.connectFieldNames(tableFields, fileInfo.fieldNames);
                } else {
                    tableFields.autoConnectFieldsForImport(fileInfo.fieldNames, new Properties());
                }
                if (tableFields == null) break block25;
                file = new File(tdd.fileName);
                pris = new ProgressReporterInputStream(this.parent, "Importing " + file.getName(), true, new FileInputStream(file), fileSize);
                rep = pris.getProgressReporter();
                prevCursor = this.parent.getCursor();
                this.parent.setCursor(new Cursor(3));
                this.parent.setEnabled(false);
                FileToSQLHandler handler = new FileToSQLHandler(this.conh, tdd.selectedTable);
                handler.setInfoStream(System.err);
                long startTime = System.currentTimeMillis();
                int duplicateFilteringOption = 0;
                try {
                    DatabaseOptions dbOptions = DatabaseOptions.getFromDatabase(this.conh);
                    handler.importFile(pris, rep, dbOptions, tableFields, format2, fileInfo, tdd.isHaltAtError, duplicateFilteringOption, tdd.setChiralFlag, tdd.allowEmptyStructures, false, false, null, false, false, false, tableFields.removeMolNameField());
                }
                finally {
                    this.parent.setCursor(prevCursor);
                    this.parent.setEnabled(true);
                    this.parent.toFront();
                    boolean canceled = rep.isCanceled();
                    pris.close();
                    long time = System.currentTimeMillis() - startTime;
                    int imported = handler.getImported();
                    int processed = handler.getProcessed();
                    int duplicates = handler.getDuplicates();
                    int empties = handler.getEmpty();
                    String results = "";
                    if (canceled) {
                        results = results + "File import was canceled\n";
                    }
                    results = results + "Total number of processed molecules: " + processed + "\n";
                    if (dbProp.isDuplicateFilteringOption(tdd.selectedTable)) {
                        results = results + "Not imported (duplicates): " + duplicates + "\n";
                    }
                    if (!tdd.allowEmptyStructures) {
                        results = results + "Not imported (empty): " + empties + "\n";
                    }
                    results = results + "Not imported (error): " + (processed - duplicates - empties - imported) + "\n";
                    results = results + "Successfully imported: " + imported;
                    String timeString = "" + (int)Math.ceil((double)time / 1000.0);
                    results = results + "\nElapsed time: " + timeString + " seconds";
                    MessageDialog.showMessage(this.parent, results);
                }
            }
            catch (SQLException ex) {
                MessageDialog.showSQLMessage(this.parent, ex);
            }
            catch (InterruptedIOException ex) {
                MessageDialog.showMessage(this.parent, "File import cancelled");
            }
            catch (Throwable ex) {
                MessageDialog.showErrorMessage(this.parent, ex);
            }
            finally {
                this.parent.getJMenuBar().setEnabled(true);
            }
        }
    }

    private long getFileSize(File f) {
        long size;
        try {
            size = f.length();
        }
        catch (Exception e) {
            size = 0L;
        }
        return size;
    }

    private TransferDialogData selectFileAndTable(Vector<?> tables) {
        TransferDialogData tdd = TransferDialogData.getFromSettings(this.settings, 0);
        tdd.tables = tables;
        TransferDialog d = new TransferDialog((Frame)this.parent, 0);
        d.setData(tdd);
        d.setVisible(true);
        tdd = d.getData();
        if (tdd != null) {
            tdd.save(this.settings);
        }
        return tdd;
    }
}

