/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import chemaxon.edu.stanford.ejalbert.BrowserLauncher;
import chemaxon.jchem.db.DatabaseConstants;
import chemaxon.jchem.db.SettingsHandler;
import chemaxon.jchem.gui.Connector;
import chemaxon.jchem.gui.Creator;
import chemaxon.jchem.gui.Deletor;
import chemaxon.jchem.gui.Exporter;
import chemaxon.jchem.gui.Importer;
import chemaxon.jchem.gui.MessageDialog;
import chemaxon.jchem.gui.ModifyDialog;
import chemaxon.jchem.gui.OptionsHandler;
import chemaxon.jchem.gui.Regenerator;
import chemaxon.jchem.gui.TableOptionsSetter;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class JChemFrame
extends JFrame {
    private JToolBar jToolBar1;
    private JPanel jPanel1;
    private JButton connectButton;
    private JButton createTableButton;
    private JButton importButton;
    private JButton exportButton;
    private JButton modifyButton;
    private JButton deleteButton;
    private JButton optionsButton;
    private JMenuBar jMenuBar1;
    private JMenu jMenu1;
    private JMenu helpMenu;
    private JMenuItem connectMenuItem;
    private JMenuItem createTableMenuItem;
    private JMenuItem importMenuItem;
    private JMenuItem exportMenuItem;
    private JMenuItem modifyMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenuItem tableOptionsMenuItem;
    private JMenuItem optionsMenuItem;
    private JMenu appearanceMenu;
    private JMenuItem regenerateMenuItem;
    private JMenuItem admGuideMenuItem;
    private JMenuItem jchemDocMenuItem;
    private JMenuItem jchemAboutMenuItem;
    private JMenuItem exitMenuItem;
    private ButtonGroup bg = new ButtonGroup();
    private ConnectionHandler conh = null;
    private SettingsHandler settingsHandler;
    Thread activeThread = null;
    private String jchemPath = null;
    private static String JARNAME = "jchem.jar";
    private String cp = null;
    private String fs = null;

    public JChemFrame() {
        this.initComponents();
        this.pack();
        this.setResizable(false);
        try {
            this.settingsHandler = new SettingsHandler(DatabaseConstants.getDefaultDerbySettings());
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.cp = System.getProperty("java.class.path");
            this.fs = File.separator;
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        this.jchemPath = this.getJChemPath();
    }

    private synchronized void setActiveThread(Runnable r) {
        this.activeThread = new Thread(r);
        this.activeThread.setPriority(4);
    }

    private synchronized boolean isActiveThreadRunning() {
        return this.activeThread != null && this.activeThread.isAlive();
    }

    private synchronized void startActiveThread() {
        this.activeThread.start();
    }

    private void initComponents() {
        this.setTitle("JChemManager");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                JChemFrame.this.exitForm();
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenu1.setText("File");
        this.connectMenuItem = new JMenuItem();
        this.connectMenuItem.setText("Connect");
        this.connectMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JChemFrame.this.connectMenuItemActionPerformed();
            }
        });
        this.jMenu1.add(this.connectMenuItem);
        this.createTableMenuItem = new JMenuItem();
        this.createTableMenuItem.setText("Create table");
        this.createTableMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JChemFrame.this.createTableMenuItemActionPerformed();
            }
        });
        this.jMenu1.add(this.createTableMenuItem);
        this.importMenuItem = new JMenuItem();
        this.importMenuItem.setText("Import");
        this.importMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JChemFrame.this.importMenuItemActionPerformed();
            }
        });
        this.jMenu1.add(this.importMenuItem);
        this.exportMenuItem = new JMenuItem();
        this.exportMenuItem.setText("Export");
        this.exportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JChemFrame.this.exportMenuItemActionPerformed();
            }
        });
        this.jMenu1.add(this.exportMenuItem);
        this.modifyMenuItem = new JMenuItem();
        this.modifyMenuItem.setText("Modify");
        this.modifyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    JChemFrame.this.modifyMenuItemActionPerformed();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    MessageDialog.showMessage(JChemFrame.this.getParent(), e.getMessage());
                }
            }
        });
        this.jMenu1.add(this.modifyMenuItem);
        this.deleteMenuItem = new JMenuItem();
        this.deleteMenuItem.setText("Delete");
        this.deleteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JChemFrame.this.deleteMenuItemActionPerformed();
            }
        });
        this.jMenu1.add(this.deleteMenuItem);
        this.tableOptionsMenuItem = new JMenuItem();
        this.tableOptionsMenuItem.setText("Table Options");
        this.tableOptionsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JChemFrame.this.tableOptionsMenuItemActionPerformed();
            }
        });
        this.jMenu1.add(this.tableOptionsMenuItem);
        this.optionsMenuItem = new JMenuItem();
        this.optionsMenuItem.setText("Options");
        this.optionsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JChemFrame.this.optionsMenuItemActionPerformed();
            }
        });
        this.jMenu1.add(this.optionsMenuItem);
        this.jMenu1.addSeparator();
        this.appearanceMenu = new JMenu();
        this.appearanceMenu.setText("Appearance");
        this.jMenu1.add(this.appearanceMenu);
        UIManager.LookAndFeelInfo[] lf = UIManager.getInstalledLookAndFeels();
        this.bg = new ButtonGroup();
        for (int x = 0; x < lf.length; ++x) {
            JRadioButtonMenuItem newItem = new JRadioButtonMenuItem();
            String name = lf[x].getName();
            newItem.setText(name);
            String className = lf[x].getClassName();
            newItem.setName(className);
            if (!this.validLookAndFeel(className)) continue;
            newItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JChemFrame.this.appearanceMenuActionPerformed(evt);
                }
            });
            this.appearanceMenu.add(newItem);
            this.bg.add(newItem);
        }
        this.setLFButtons(this.bg);
        this.jMenu1.addSeparator();
        this.regenerateMenuItem = new JMenuItem();
        this.regenerateMenuItem.setText("Recalculate");
        this.regenerateMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JChemFrame.this.regenerateMenuItemActionPerformed();
            }
        });
        this.jMenu1.add(this.regenerateMenuItem);
        this.jMenu1.addSeparator();
        this.exitMenuItem = new JMenuItem();
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JChemFrame.this.exitMenuItemActionPerformed();
            }
        });
        this.jMenu1.add(this.exitMenuItem);
        this.jMenuBar1.add(this.jMenu1);
        this.helpMenu = new JMenu();
        this.helpMenu.setText("Help");
        this.admGuideMenuItem = new JMenuItem();
        this.admGuideMenuItem.setText("Administration Guide");
        this.admGuideMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JChemFrame.this.admGuideMenuItemActionPerformed();
            }
        });
        this.helpMenu.add(this.admGuideMenuItem);
        this.jchemDocMenuItem = new JMenuItem();
        this.jchemDocMenuItem.setText("JChem Documentation");
        this.jchemDocMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JChemFrame.this.jchemDocMenuItemActionPerformed();
            }
        });
        this.helpMenu.add(this.jchemDocMenuItem);
        this.jchemAboutMenuItem = new JMenuItem();
        this.jchemAboutMenuItem.setText("About");
        this.jchemAboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JChemFrame.this.jchemAboutMenuItemActionPerformed();
            }
        });
        this.helpMenu.add(this.jchemAboutMenuItem);
        this.jMenuBar1.add(this.helpMenu);
        this.setJMenuBar(this.jMenuBar1);
        this.jToolBar1 = new JToolBar();
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setLayout(new BoxLayout(this.jToolBar1, 0));
        this.jPanel1 = new JPanel();
        this.jPanel1.setLayout(new FlowLayout(0, 5, 5));
        this.connectButton = new JButton();
        this.connectButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/jchem/gui/images/connect.gif")));
        this.connectButton.setToolTipText("Connect to database through JDBC");
        this.connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JChemFrame.this.connectButtonActionPerformed();
            }
        });
        this.jPanel1.add(this.connectButton);
        this.createTableButton = new JButton();
        this.createTableButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/jchem/gui/images/create.gif")));
        this.createTableButton.setToolTipText("Create a structure table");
        this.createTableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JChemFrame.this.createTableButtonActionPerformed();
            }
        });
        this.jPanel1.add(this.createTableButton);
        this.importButton = new JButton();
        this.importButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/jchem/gui/images/import.gif")));
        this.importButton.setToolTipText("Import structures");
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JChemFrame.this.importButtonActionPerformed();
            }
        });
        this.jPanel1.add(this.importButton);
        this.exportButton = new JButton();
        this.exportButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/jchem/gui/images/export.gif")));
        this.exportButton.setToolTipText("Export structures");
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JChemFrame.this.exportButtonActionPerformed();
            }
        });
        this.jPanel1.add(this.exportButton);
        this.modifyButton = new JButton();
        this.modifyButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/jchem/gui/images/modify.gif")));
        this.modifyButton.setToolTipText("Modify table");
        this.modifyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    JChemFrame.this.modifyButtonActionPerformed();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    MessageDialog.showMessage(JChemFrame.this.getParent(), e.getMessage());
                }
            }
        });
        this.jPanel1.add(this.modifyButton);
        this.deleteButton = new JButton();
        this.deleteButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/jchem/gui/images/delete.gif")));
        this.deleteButton.setToolTipText("Drop table");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JChemFrame.this.deleteButtonActionPerformed();
            }
        });
        this.jPanel1.add(this.deleteButton);
        this.optionsButton = new JButton();
        this.optionsButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/jchem/gui/images/options.gif")));
        this.optionsButton.setToolTipText("Set options");
        this.optionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JChemFrame.this.optionsButtonActionPerformed();
            }
        });
        this.jPanel1.add(this.optionsButton);
        this.jToolBar1.add(this.jPanel1);
        this.getContentPane().add((Component)this.jToolBar1, "North");
    }

    private void createTableMenuItemActionPerformed() {
        if (!this.isActiveThreadRunning()) {
            Creator creator = new Creator(this, this.conh);
            this.setActiveThread(creator);
            this.startActiveThread();
        }
    }

    private void exportButtonActionPerformed() {
        this.exportMenuItemActionPerformed();
    }

    private void deleteButtonActionPerformed() {
        this.deleteMenuItemActionPerformed();
    }

    private void modifyButtonActionPerformed() throws SQLException {
        this.modifyMenuItemActionPerformed();
    }

    private void optionsButtonActionPerformed() {
        this.optionsMenuItemActionPerformed();
    }

    private void importButtonActionPerformed() {
        this.importMenuItemActionPerformed();
    }

    private void createTableButtonActionPerformed() {
        this.createTableMenuItemActionPerformed();
    }

    private void connectButtonActionPerformed() {
        this.connectMenuItemActionPerformed();
    }

    private void connectMenuItemActionPerformed() {
        if (!this.isActiveThreadRunning()) {
            this.setActiveThread(new ConnectThread());
            this.startActiveThread();
        }
    }

    private void exitMenuItemActionPerformed() {
        this.exitForm();
    }

    private void exportMenuItemActionPerformed() {
        if (!this.isActiveThreadRunning()) {
            Exporter exporter = new Exporter(this, this.conh, this.settingsHandler.getSettings());
            this.setActiveThread(exporter);
            this.startActiveThread();
        }
    }

    private void modifyMenuItemActionPerformed() throws SQLException {
        new ModifyDialog((Frame)this, this.conh, this.settingsHandler.getSettings()).setVisible(true);
    }

    private void deleteMenuItemActionPerformed() {
        if (!this.isActiveThreadRunning()) {
            Deletor deletor = new Deletor(this, this.conh, this.settingsHandler.getSettings());
            this.setActiveThread(deletor);
            this.startActiveThread();
        }
    }

    private void tableOptionsMenuItemActionPerformed() {
        if (!this.isActiveThreadRunning()) {
            TableOptionsSetter opt = new TableOptionsSetter(this, this.conh, this.settingsHandler.getSettings());
            this.setActiveThread(opt);
            this.startActiveThread();
        }
    }

    private void optionsMenuItemActionPerformed() {
        if (!this.isActiveThreadRunning()) {
            OptionsHandler oh = new OptionsHandler(this, this.conh);
            oh.go();
        }
    }

    private void appearanceMenuActionPerformed(ActionEvent evt) {
        if (!this.isActiveThreadRunning()) {
            Object t = evt.getSource();
            if (!(t instanceof JComponent)) {
                return;
            }
            String className = ((JComponent)t).getName();
            try {
                UIManager.setLookAndFeel(className);
                try {
                    this.settingsHandler.getSettings().put("gui.lookAndFeel.className", className);
                    this.settingsHandler.save();
                }
                catch (IOException ie) {}
            }
            catch (Exception e) {
                System.err.println("Could not set Look And Feel:" + className);
                this.setLFButtons(this.bg);
            }
            SwingUtilities.updateComponentTreeUI(this);
            this.pack();
        }
    }

    private void regenerateMenuItemActionPerformed() {
        if (!this.isActiveThreadRunning()) {
            Regenerator regenerator = new Regenerator(this, this.conh, this.settingsHandler.getSettings());
            this.setActiveThread(regenerator);
            this.startActiveThread();
        }
    }

    private void importMenuItemActionPerformed() {
        if (!this.isActiveThreadRunning()) {
            Importer importer = new Importer(this, this.conh, this.settingsHandler.getSettings());
            this.setActiveThread(importer);
            this.startActiveThread();
        }
    }

    private void admGuideMenuItemActionPerformed() {
        try {
            BrowserLauncher.openURL(this.getFullUrl("doc/admin/index.html"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void jchemDocMenuItemActionPerformed() {
        try {
            BrowserLauncher.openURL(this.getFullUrl("intro/index.html"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void jchemAboutMenuItemActionPerformed() {
        String s = "JChem Manager " + VersionInfo.JCHEM_VERSION + "\n" + "\n" + "JVM : " + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + "\n" + "OS  : " + System.getProperty("os.arch") + " " + System.getProperty("os.name") + " " + System.getProperty("os.version");
        Object[] options = new Object[]{"OK"};
        JOptionPane.showOptionDialog(this, s, "About", -1, 1, null, options, options[0]);
    }

    private void exitForm() {
        try {
            this.settingsHandler.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.conh != null && this.conh.getConnection() != null) {
                this.conh.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.conh = null;
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect() {
        Cursor prevCursor;
        block9: {
            ConnectionHandler newConh;
            block7: {
                block8: {
                    prevCursor = this.getCursor();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JChemFrame.this.setCursor(new Cursor(3));
                            JChemFrame.this.setEnabled(false);
                        }
                    });
                    try {
                        Connector connector = new Connector(this, this.settingsHandler.getSettings());
                        newConh = connector.go();
                        if (newConh != null) break block7;
                        if (this.conh != null) break block8;
                        this.exitForm();
                        break block7;
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(prevCursor){
                            final /* synthetic */ Cursor val$prevCursor;
                            {
                                this.val$prevCursor = cursor;
                            }

                            @Override
                            public void run() {
                                JChemFrame.this.setCursor(this.val$prevCursor);
                                JChemFrame.this.setEnabled(true);
                                JChemFrame.this.toFront();
                            }
                        });
                        throw throwable;
                    }
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                return;
            }
            if (newConh.getConnection() != null) {
                try {
                    if (this.conh != null) {
                        this.conh.close();
                    }
                }
                catch (SQLException e) {
                    // empty catch block
                }
                this.conh = newConh;
                break block9;
            }
            if (this.conh != null) break block9;
            this.exitForm();
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private String getPathFromPathList(String fileName, String pathList) {
        String path = null;
        try {
            String s = System.getProperty("path.separator");
            StringTokenizer st = new StringTokenizer(pathList, s.substring(0, 1));
            while (path == null && st.hasMoreTokens()) {
                String token = st.nextToken();
                if (!token.endsWith(this.fs + fileName) && !token.equals(fileName)) continue;
                path = token;
            }
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        return path;
    }

    private String getJChemPath() {
        String path = null;
        String jarPath = this.getPathFromPathList(JARNAME, this.cp);
        if (jarPath != null) {
            path = StringUtil.replaceString(jarPath, JARNAME, "..");
        }
        return path;
    }

    private String getFullUrl(String relativePath) throws IOException {
        String path = this.jchemPath;
        if (path != null) {
            String rp = StringUtil.replaceString(relativePath, "/", this.fs);
            path = path + this.fs + rp;
            path = new File(path).getCanonicalFile().toURI().toURL().toString();
        } else {
            path = "http://www.chemaxon.com/jchem/" + relativePath;
        }
        return path;
    }

    public Connection getConnection() {
        if (this.conh != null) {
            return this.conh.getConnection();
        }
        return null;
    }

    public Properties getSettings() {
        return this.settingsHandler.getSettings();
    }

    public static void main(String[] args) {
        new JChemFrame().show();
    }

    private void setLFButtons(ButtonGroup bg) {
        Enumeration<AbstractButton> buttons = bg.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton o = buttons.nextElement();
            if (!(o instanceof JRadioButtonMenuItem)) continue;
            JRadioButtonMenuItem rb = (JRadioButtonMenuItem)o;
            rb.setSelected(rb.getName().equals(UIManager.getLookAndFeel().getClass().getName()));
        }
    }

    private boolean validLookAndFeel(String lf) {
        boolean valid = true;
        LookAndFeel currentLF = UIManager.getLookAndFeel();
        try {
            UIManager.setLookAndFeel(lf);
        }
        catch (Exception e) {
            valid = false;
        }
        try {
            UIManager.setLookAndFeel(currentLF);
        }
        catch (UnsupportedLookAndFeelException e1) {
            System.err.println("Error while testing Look and Feels.");
            System.err.print("Cannot restore system Look And Feel: ");
            System.err.println(currentLF.getName());
        }
        return valid;
    }

    public static Component getComponentByName(Component comp, String name) {
        if (comp == null) {
            return null;
        }
        if (comp.getName() != null && comp.getName().equalsIgnoreCase(name)) {
            return comp;
        }
        if (comp instanceof Container) {
            Container container = (Container)comp;
            int nmembers = container.getComponentCount();
            for (int i = 0; i < nmembers; ++i) {
                Component m = container.getComponent(i);
                if ((m = JChemFrame.getComponentByName(m, name)) == null) continue;
                return m;
            }
        }
        return null;
    }

    private class ConnectThread
    extends Thread {
        private ConnectThread() {
        }

        @Override
        public void run() {
            JChemFrame.this.connect();
        }
    }
}

