/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import chemaxon.jchem.gui.MessageDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class LayoutDialog13
extends JDialog {
    private int rows = 0;
    private int columns = 0;
    private JTextField rowSpinner = null;
    private JTextField columnSpinner = null;

    public LayoutDialog13(int rows, int columns) {
        try {
            this.rows = rows;
            this.columns = columns;
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    private void init() throws Exception {
        this.setTitle("Table dimensions");
        Container cp = this.getContentPane();
        cp.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        cp.add((Component)new JLabel("Rows:"), gc);
        ++gc.gridy;
        cp.add((Component)new JLabel("Columns:"), gc);
        gc.gridx = 1;
        gc.gridy = 0;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        this.rowSpinner = this.getSpinner(this.rows);
        cp.add((Component)this.rowSpinner, gc);
        ++gc.gridy;
        this.columnSpinner = this.getSpinner(this.columns);
        cp.add((Component)this.columnSpinner, gc);
        ++gc.gridy;
        gc.fill = 0;
        gc.anchor = 14;
        cp.add((Component)this.getOKButton(), gc);
        this.pack();
        this.setSize(new Dimension(200, 100));
        this.setResizable(false);
    }

    private JTextField getSpinner(int value) {
        JTextField spinner = new JTextField("" + value, 6);
        return spinner;
    }

    private JButton getOKButton() {
        JButton button = new JButton("OK");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayoutDialog13.this.okPressed();
            }
        });
        return button;
    }

    private void okPressed() {
        String rowString = this.rowSpinner.getText().trim();
        String columnString = this.columnSpinner.getText().trim();
        try {
            this.rows = new Integer(rowString);
        }
        catch (NumberFormatException e) {
            MessageDialog.showMessage(this, "Wrong number format for rows : " + rowString);
            return;
        }
        try {
            this.columns = new Integer(columnString);
        }
        catch (NumberFormatException e) {
            MessageDialog.showMessage(this, "Wrong number format for columns : " + columnString);
            return;
        }
        this.hide();
    }
}

