/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import chemaxon.jchem.gui.ProgressReporter;
import java.awt.Component;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

public class ProgressReporterInputStream
extends FilterInputStream {
    private static int LIMIT = 16384;
    private int disp = 0;
    private int nread = 0;
    private int size = 0;
    private ProgressReporter rep;

    public ProgressReporterInputStream(Component parent, String message, boolean tExpNeeded, InputStream in, long fileSize) {
        super(in);
        try {
            this.size = in.available();
        }
        catch (IOException ioe) {
            this.size = 0;
        }
        this.rep = new ProgressReporter(parent, message, "", tExpNeeded, 0L, fileSize);
    }

    public ProgressReporter getProgressReporter() {
        return this.rep;
    }

    @Override
    public int read() throws IOException {
        int c = this.in.read();
        if (c >= 0) {
            ++this.nread;
            ++this.disp;
            if (this.disp >= LIMIT) {
                this.disp = 0;
                this.rep.setProgress(this.nread);
            }
        }
        if (this.rep.isCanceled()) {
            InterruptedIOException x = new InterruptedIOException("Work has been cancelled.");
            x.bytesTransferred = this.nread;
            throw x;
        }
        return c;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int nr = this.in.read(b);
        if (nr > 0) {
            this.nread += nr;
            this.disp += nr;
            if (this.disp >= LIMIT) {
                this.disp = 0;
                this.rep.setProgress(this.nread);
            }
        }
        if (this.rep.isCanceled()) {
            InterruptedIOException x = new InterruptedIOException("Work has been cancelled.");
            x.bytesTransferred = this.nread;
            throw x;
        }
        return nr;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int nr = this.in.read(b, off, len);
        if (nr > 0) {
            this.nread += nr;
            this.disp += nr;
            if (this.disp >= LIMIT) {
                this.disp = 0;
                this.rep.setProgress(this.nread);
            }
        }
        if (this.rep.isCanceled()) {
            InterruptedIOException x = new InterruptedIOException("Work has been cancelled.");
            x.bytesTransferred = this.nread;
            throw x;
        }
        return nr;
    }

    @Override
    public long skip(long n) throws IOException {
        long nr = this.in.skip(n);
        if (nr > 0L) {
            this.nread = (int)((long)this.nread + nr);
            this.disp = (int)((long)this.disp + nr);
            if (this.disp >= LIMIT) {
                this.disp = 0;
                this.rep.setProgress(this.nread);
            }
        }
        return nr;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.rep.close();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
        this.nread = this.size - this.in.available();
        this.rep.setProgress(this.nread);
    }
}

