/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.TransferDialogData;
import chemaxon.jchem.db.UpdateHandler;
import chemaxon.jchem.gui.MessageDialog;
import chemaxon.jchem.gui.ProgressReporter;
import chemaxon.jchem.gui.TransferDialog;
import chemaxon.util.ConnectionHandler;
import java.awt.Cursor;
import java.awt.Frame;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class Regenerator
implements Runnable {
    private JFrame parent;
    private ConnectionHandler conh;
    private Properties settings;

    public Regenerator(JFrame parent, ConnectionHandler conh, Properties settings) {
        this.parent = parent;
        this.conh = conh;
        this.settings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.parent.getJMenuBar().setEnabled(false);
        try {
            Vector<String> tables;
            Cursor prevCursor = this.parent.getCursor();
            this.parent.setCursor(new Cursor(3));
            try {
                tables = new DatabaseProperties(this.conh).getStructureTableNames();
            }
            finally {
                this.parent.setCursor(prevCursor);
            }
            if (tables.size() == 0) {
                MessageDialog.showMessage(this.parent, "No tables to recalculate.");
                this.parent.getJMenuBar().setEnabled(true);
                return;
            }
            TransferDialogData tdd = this.selectTable(tables);
            if (tdd != null) {
                Boolean value;
                String msg = null;
                ArrayList<String> tableNames = new ArrayList<String>();
                if (tdd.regenerateAll) {
                    tableNames.addAll(tables);
                } else {
                    tableNames.add(tdd.selectedTable);
                }
                int count = tableNames.size();
                String[] tableList = new String[count];
                for (int i = 0; i < count; ++i) {
                    tableList[i] = (String)tableNames.get(i);
                }
                Boolean isCTNeeded = tdd.regenerationOptions.get(1);
                Boolean isWithoutCTNeeded = tdd.regenerationOptions.get(2);
                if (isCTNeeded != null && isCTNeeded.booleanValue() && isWithoutCTNeeded != null && isWithoutCTNeeded.booleanValue()) {
                    tdd.regenerationOptions.remove(1);
                    tdd.regenerationOptions.remove(2);
                    tdd.regenerationOptions.put(0, true);
                }
                msg = tdd.regenerateAll ? "Are you sure you want to recalculate the following data for all tables?\n\n" : "Are you sure you want to recalculate the following data for table '" + tdd.selectedTable + "'?\n\n";
                int i = 1;
                for (Integer key : tdd.regenerationOptions.keySet()) {
                    value = tdd.regenerationOptions.get(key);
                    if (value == null || !value.booleanValue()) continue;
                    if (key == 1) {
                        msg = msg + i + ". Chemical Terms\n";
                    } else if (key == 0) {
                        msg = msg + i + ". JChem table data\n";
                        msg = msg + ++i + ". Chemical Terms\n";
                    } else if (key == 2) {
                        msg = msg + i + ". JChem table data\n";
                    } else if (key == 3) {
                        msg = msg + i + ". Molecular descriptors\n";
                    }
                    ++i;
                }
                msg = msg + "\n";
                if (i == 1) {
                    MessageDialog.showMessage(this.parent, "No options selected.");
                    this.parent.getJMenuBar().setEnabled(true);
                    return;
                }
                if (JOptionPane.showConfirmDialog(this.parent, msg, "", 0) == 1) {
                    return;
                }
                for (Integer key : tdd.regenerationOptions.keySet()) {
                    value = tdd.regenerationOptions.get(key);
                    if (value == null || !value.booleanValue()) continue;
                    if (key == 1) {
                        Regenerator.regenerateCTColumns(tableList, this.conh, this.parent);
                        continue;
                    }
                    if (key == 0) {
                        Regenerator.regenerateTables(tableList, this.conh, this.parent, true);
                        continue;
                    }
                    if (key == 2) {
                        Regenerator.regenerateTables(tableList, this.conh, this.parent, false);
                        continue;
                    }
                    if (key != 3) continue;
                    Regenerator.regenerateMDTables(tdd.regenerateAll ? null : tdd.selectedTable, this.conh, this.parent);
                }
            }
        }
        catch (SQLException ex) {
            MessageDialog.showSQLMessage(this.parent, ex);
        }
        catch (Throwable ex) {
            MessageDialog.showErrorMessage(this.parent, ex);
        }
        finally {
            this.parent.getJMenuBar().setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void regenerateTables(String[] tableNames, ConnectionHandler conh, JFrame parent, boolean chemTermCalcNeeded) {
        try {
            boolean canceled = false;
            boolean success = true;
            for (int x = 0; x < tableNames.length; ++x) {
                String tableName = tableNames[x];
                ProgressReporter m = new ProgressReporter(parent, "Recalculating " + tableName + " ...", "Molecule: ", true, 1L, 1L);
                Cursor prevCursor = null;
                if (parent != null) {
                    prevCursor = parent.getCursor();
                    parent.setCursor(new Cursor(3));
                    parent.setEnabled(false);
                }
                try {
                    if (chemTermCalcNeeded) {
                        if (!UpdateHandler.recalculateTable(conh, tableName, false, null, null, null, m)) {
                            success = false;
                        }
                    } else if (!UpdateHandler.recalculateWithoutCTColumns(conh, tableName, false, null, null, m)) {
                        success = false;
                    }
                    if (m.isCanceled()) {
                        canceled = true;
                    }
                }
                finally {
                    if (parent != null) {
                        parent.setCursor(prevCursor);
                        parent.setEnabled(true);
                    }
                    m.close();
                }
                if (!canceled) continue;
                if (success) {
                    MessageDialog.showMessage(parent, "Recalculation cancelled");
                    break;
                }
                MessageDialog.showMessage(parent, "Recalculation cancelled. Please, check the console output because errors have occured during regeneration");
                break;
            }
            if (!canceled) {
                if (success) {
                    MessageDialog.showMessage(parent, "JChem tables have been recalculated successfully");
                } else {
                    MessageDialog.showMessage(parent, "Errors have occurred during recalculation, please, check the console output for details");
                }
            }
        }
        catch (Throwable ex) {
            MessageDialog.showErrorMessage(parent, ex);
        }
        finally {
            if (parent != null) {
                parent.getJMenuBar().setEnabled(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void regenerateCTColumns(String[] tableNames, ConnectionHandler conh, JFrame parent) {
        try {
            boolean canceled = false;
            boolean success = true;
            DatabaseProperties dbProp = new DatabaseProperties(conh);
            for (int i = 0; i < tableNames.length; ++i) {
                String tableName = tableNames[i];
                ProgressReporter m = new ProgressReporter(parent, "Recalculating Chemical Terms in " + tableName + " ...", "Molecule: ", true, 1L, 1L);
                Cursor prevCursor = null;
                if (parent != null) {
                    prevCursor = parent.getCursor();
                    parent.setCursor(new Cursor(3));
                    parent.setEnabled(false);
                }
                String[] columns = dbProp.getChemTermColumns(tableName);
                try {
                    if (columns.length > 0 && !UpdateHandler.recalculateCTColumns(conh, tableName, columns, m)) {
                        success = false;
                    }
                    if (m.isCanceled()) {
                        canceled = true;
                    }
                }
                finally {
                    if (parent != null) {
                        parent.setCursor(prevCursor);
                        parent.setEnabled(true);
                    }
                    m.close();
                }
                if (!canceled) continue;
                if (success) {
                    MessageDialog.showMessage(parent, "Chemical Terms recalculation cancelled");
                    break;
                }
                MessageDialog.showMessage(parent, "Chemical Terms recalculation cancelled. Please, check the console output because errors have occured during recalculation");
                break;
            }
            if (!canceled) {
                if (success) {
                    MessageDialog.showMessage(parent, "Chemical Terms have been recalculated successfully");
                } else {
                    MessageDialog.showMessage(parent, "Errors have occurred during Chemical Terms recalculation, please, check the console output for details");
                }
            }
        }
        catch (Throwable ex) {
            MessageDialog.showErrorMessage(parent, ex);
        }
        finally {
            if (parent != null) {
                parent.getJMenuBar().setEnabled(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void regenerateMDTables(String tableName, ConnectionHandler conh, JFrame parent) {
        try {
            boolean canceled = false;
            boolean success = true;
            ProgressReporter m = new ProgressReporter(parent, "Recalculating Molecular Descriptors " + (tableName == null ? "..." : "for " + tableName + " ..."), "Molecule: ", true, 1L, 1L);
            Cursor prevCursor = null;
            if (parent != null) {
                prevCursor = parent.getCursor();
                parent.setCursor(new Cursor(3));
                parent.setEnabled(false);
            }
            try {
                if (!UpdateHandler.recalculateMDTables(conh, tableName, m)) {
                    success = false;
                }
                if (m.isCanceled()) {
                    canceled = true;
                }
            }
            finally {
                if (parent != null) {
                    parent.setCursor(prevCursor);
                    parent.setEnabled(true);
                }
                m.close();
            }
            if (canceled) {
                if (success) {
                    MessageDialog.showMessage(parent, "Molecular Descriptor recalculation cancelled");
                } else {
                    MessageDialog.showMessage(parent, "Molecular Descriptor recalculation cancelled. Please, check the console output because errors have occured during recalculation");
                }
            } else if (success) {
                MessageDialog.showMessage(parent, "Molecular Descriptors have been recalculated successfully");
            } else {
                MessageDialog.showMessage(parent, "Errors have occurred during Molecular Descriptor recalculation, please, check the console output for details");
            }
        }
        catch (Throwable ex) {
            MessageDialog.showErrorMessage(parent, ex);
        }
        finally {
            if (parent != null) {
                parent.getJMenuBar().setEnabled(true);
            }
        }
    }

    private TransferDialogData selectTable(Vector<String> tables) {
        TransferDialogData tdd = TransferDialogData.getFromSettings(this.settings, 3);
        tdd.tables = tables;
        TransferDialog d = new TransferDialog((Frame)this.parent, 3, this.conh);
        d.setData(tdd);
        d.setVisible(true);
        tdd = d.getData();
        if (tdd != null) {
            tdd.save(this.settings);
        }
        return tdd;
    }
}

