/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import chemaxon.common.util.IntVector;
import chemaxon.jchem.db.UpdateHandler;
import chemaxon.jchem.gui.LayoutDialog;
import chemaxon.jchem.gui.LayoutDialog13;
import chemaxon.jchem.gui.LinkedButtons;
import chemaxon.jchem.gui.MessageDialog;
import chemaxon.jchem.gui.SelectPageDialog;
import chemaxon.jchem.gui.SelectPageDialog13;
import chemaxon.marvin.beans.MViewPane;
import chemaxon.struc.Molecule;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.DatabaseTools;
import chemaxon.util.MolHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;

public class ResultBrowserPanel
extends JPanel {
    private final ConnectionHandler conh;
    private final Connection con;
    private String tableName = null;
    private IntVector hits = null;
    private MViewPane mpan = null;
    private int page = 1;
    private int cellCount = 1;
    private JLabel pageLabel = null;
    private JLabel strucCountLabel = null;
    private JLabel statusLabel = null;
    private final LinkedButtons nextPageButtons = new LinkedButtons();
    private final LinkedButtons prevPageButtons = new LinkedButtons();
    private final LinkedButtons firstPageButtons = new LinkedButtons();
    private final LinkedButtons lastPageButtons = new LinkedButtons();
    private final LinkedButtons goToButtons = new LinkedButtons();
    private final LinkedButtons layoutButtons = new LinkedButtons();
    private int maxPage = 1;
    private boolean statusPanelEnabled = true;
    private boolean buttonPanelEnabled = true;
    private boolean deleteButtonEnabled = false;
    private JPanel buttonPanel = null;
    private boolean dynamicHitList = false;
    private UpdateThread updateThread = null;
    private int rows = 2;
    private int columns = 2;
    volatile boolean statusChanged = false;
    volatile boolean fetch = false;
    volatile boolean newHits = false;
    volatile String statusText = null;
    volatile String newLayout = null;

    public ResultBrowserPanel(ConnectionHandler conh) throws SQLException {
        this(conh, false);
    }

    public ResultBrowserPanel(ConnectionHandler conh, boolean dynamicHitList) throws SQLException {
        this.conh = new ConnectionHandler(conh);
        try {
            this.conh.connect();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        this.dynamicHitList = dynamicHitList;
        this.con = this.conh.getConnection();
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setHits(IntVector hits) {
        this.hits = hits;
        this.page = 1;
        if (this.dynamicHitList) {
            if (this.updateThread == null) {
                this.updateThread = new UpdateThread();
                this.updateThread.setPriority(1);
                this.updateThread.start();
            } else {
                this.updateThread.lastSize = -1;
            }
        }
        this.updateStatus(null);
        this.newHits = true;
    }

    public void setStatusPanelEnabled(boolean value) {
        this.statusPanelEnabled = value;
    }

    public void setButtonPanelEnabled(boolean value) {
        this.buttonPanelEnabled = value;
    }

    public void setDeleteButtonEnabled(boolean value) {
        this.deleteButtonEnabled = value;
    }

    public void addNextPageButton(JButton button) {
        this.nextPageButtons.add(button);
    }

    public void addPrevPageButton(JButton button) {
        this.prevPageButtons.add(button);
    }

    public void addFirstPageButton(JButton button) {
        this.firstPageButtons.add(button);
    }

    public void addLastPageButton(JButton button) {
        this.lastPageButtons.add(button);
    }

    public void addGoToButton(JButton button) {
        this.goToButtons.add(button);
    }

    public void addLayoutButton(JButton button) {
        this.layoutButtons.add(button);
    }

    private void updateButtons() {
        if (this.page >= this.maxPage) {
            this.nextPageButtons.setEnabled(false);
            this.lastPageButtons.setEnabled(false);
        } else {
            this.nextPageButtons.setEnabled(true);
            this.lastPageButtons.setEnabled(true);
        }
        if (this.page > 1) {
            this.prevPageButtons.setEnabled(true);
            this.firstPageButtons.setEnabled(true);
        } else {
            this.prevPageButtons.setEnabled(false);
            this.firstPageButtons.setEnabled(false);
        }
        if (this.hits != null && this.maxPage > 1) {
            this.goToButtons.setEnabled(true);
        } else {
            this.goToButtons.setEnabled(false);
        }
    }

    public JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 1;
            gc.gridx = 0;
            gc.gridy = 0;
            this.buttonPanel.add((Component)this.getButtonFirstPage(), gc);
            ++gc.gridy;
            this.buttonPanel.add((Component)this.getButtonPrevPage(), gc);
            ++gc.gridy;
            this.buttonPanel.add((Component)this.getButtonGoTo(), gc);
            ++gc.gridy;
            this.buttonPanel.add((Component)this.getButtonNextPage(), gc);
            ++gc.gridy;
            this.buttonPanel.add((Component)this.getButtonLastPage(), gc);
            ++gc.gridy;
            this.buttonPanel.add((Component)this.getButtonLayout(), gc);
            ++gc.gridy;
            if (this.deleteButtonEnabled) {
                this.buttonPanel.add((Component)this.getButtonDelete(), gc);
            }
            gc.gridy = 99;
            gc.weighty = 1.0;
            this.buttonPanel.add((Component)Box.createVerticalBox(), gc);
            this.buttonPanel.setBorder(new BevelBorder(0));
        }
        return this.buttonPanel;
    }

    public void init() throws Exception {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 1;
        gc.anchor = 11;
        gc.weightx = 0.0;
        gc.weighty = 1.0;
        gc.gridx = 0;
        gc.gridy = 0;
        this.buttonPanel = this.getButtonPanel();
        this.setMarvin();
        gc.gridheight = 2;
        if (this.buttonPanelEnabled) {
            this.add((Component)this.buttonPanel, gc);
        }
        gc.gridheight = 1;
        gc.gridx = 1;
        gc.weightx = 1.0;
        gc.weighty = 0.01;
        gc.fill = 2;
        if (this.statusPanelEnabled) {
            this.add((Component)this.getStatusPanel(), gc);
        }
        gc.gridy = 1;
        gc.weighty = 1.0;
        gc.fill = 1;
        this.add((Component)this.mpan, gc);
        this.mpan.setVisible(false);
        this.updateButtons();
    }

    public void close() {
        if (this.updateThread != null) {
            this.updateThread.canRun = false;
        }
        if (this.con != null) {
            try {
                this.con.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private String getMarvinLayout(int rows, int columns) {
        String layout = "rows=" + rows + "\n" + "cols=" + columns + "\n" + "border=1\n" + "layout0=:2:2:" + "M:1:0:1:2:c:b:1:1:" + "L:0:0:1:1:w:n:0:1:" + "L:0:1:1:1:e:n:0:1\n" + "param0=:M:100:100:L:10b:L:10b\n";
        return layout;
    }

    private void updateStatus(String text) {
        this.statusChanged = true;
        if (text != null) {
            this.statusText = text;
        }
    }

    private synchronized void fetchStructures() throws Exception {
        this.fetchStructures(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void fetchStructures(int minIndex) throws Exception {
        this.updateStatus(null);
        this.updateButtons();
        Statement stmt = this.con.createStatement();
        try {
            int start = (this.page - 1) * this.cellCount;
            for (int i = 0; i < this.cellCount; ++i) {
                int index = start + i;
                if (index < minIndex) continue;
                if (this.hits.size() <= index) {
                    this.mpan.setM(i, "");
                    this.mpan.setL(2 * i, "");
                    continue;
                }
                int id = this.hits.elementAt(index);
                Molecule mol = null;
                String sql = "SELECT cd_structure FROM " + this.tableName + " WHERE " + "cd_id = " + id;
                ResultSet rs = stmt.executeQuery(sql);
                try {
                    if (rs.next()) {
                        String structure = new String(DatabaseTools.readBytes(rs, 1), "ASCII");
                        mol = new MolHandler(structure).getMolecule();
                    }
                    if (mol != null) {
                        this.mpan.setM(i, mol);
                        String label = "ID: " + id;
                        this.mpan.setL(2 * i, label);
                        continue;
                    }
                    this.mpan.setM(i, "");
                    this.mpan.setL(2 * i, "DELETED" + id);
                    continue;
                }
                finally {
                    rs.close();
                }
            }
        }
        finally {
            stmt.close();
        }
    }

    public void setLayout(String layout) {
        this.newLayout = layout;
    }

    public int getSelectedID() {
        int index = this.mpan.getSelectedIndex();
        if (index != -1) {
            index = this.getIDByCellIndex(index);
        }
        return index;
    }

    private void setMarvin() {
        this.mpan = new MViewPane();
        this.mpan.setParams(this.getMarvinLayout(this.rows, this.columns));
        this.cellCount = this.mpan.getCellCount();
    }

    private JButton getButtonNextPage() {
        JButton button = new JButton("Next Page");
        this.nextPageButtons.add(button);
        this.nextPageButtons.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    if (ResultBrowserPanel.this.page < ResultBrowserPanel.this.maxPage) {
                        ResultBrowserPanel.this.page++;
                        ResultBrowserPanel.this.page();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return button;
    }

    private JButton getButtonPrevPage() {
        JButton button = new JButton("Prev. Page");
        this.prevPageButtons.add(button);
        this.prevPageButtons.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    if (ResultBrowserPanel.this.page > 1) {
                        ResultBrowserPanel.this.page--;
                        ResultBrowserPanel.this.page();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return button;
    }

    private void page() throws Exception {
        this.fetch = true;
    }

    private JButton getButtonFirstPage() {
        JButton button = new JButton("First Page");
        this.firstPageButtons.add(button);
        this.firstPageButtons.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    if (ResultBrowserPanel.this.page > 1) {
                        ResultBrowserPanel.this.page = 1;
                        ResultBrowserPanel.this.page();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return button;
    }

    private JButton getButtonLastPage() {
        JButton button = new JButton("Last Page");
        this.lastPageButtons.add(button);
        this.lastPageButtons.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    if (ResultBrowserPanel.this.page < ResultBrowserPanel.this.maxPage) {
                        ResultBrowserPanel.this.page = ResultBrowserPanel.this.maxPage;
                        ResultBrowserPanel.this.page();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return button;
    }

    private JButton getButtonGoTo() {
        JButton button = new JButton("Go to ...");
        this.goToButtons.add(button);
        this.goToButtons.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    ResultBrowserPanel.this.goToPressed();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return button;
    }

    private JButton getButtonLayout() {
        JButton button = new JButton("Layout");
        this.layoutButtons.add(button);
        this.layoutButtons.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    ResultBrowserPanel.this.layoutPressed();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return button;
    }

    private int getIDByCellIndex(int cellIndex) {
        return this.hits.elementAt((this.page - 1) * this.cellCount + cellIndex);
    }

    private JButton getButtonDelete() {
        JButton button = new JButton("Delete");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    int index = ResultBrowserPanel.this.mpan.getSelectedIndex();
                    if (index == -1) {
                        MessageDialog.showMessage(ResultBrowserPanel.this.mpan, "No structure is selected");
                    } else {
                        int id = ResultBrowserPanel.this.getIDByCellIndex(index);
                        UpdateHandler.deleteRows(ResultBrowserPanel.this.conh, ResultBrowserPanel.this.tableName, "WHERE cd_id=" + id);
                        ResultBrowserPanel.this.page();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return button;
    }

    private JLabel getStatusLabel() {
        if (this.statusLabel == null) {
            this.statusLabel = new JLabel();
        }
        return this.statusLabel;
    }

    public void setStatus(String text) {
        this.updateStatus(text);
    }

    private JPanel getStatusPanel() {
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.insets = new Insets(0, 5, 0, 5);
        this.strucCountLabel = new JLabel(" ");
        statusPanel.add((Component)this.strucCountLabel, gc);
        gc.gridx = 2;
        this.pageLabel = new JLabel();
        statusPanel.add((Component)this.pageLabel, gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        gc.anchor = 10;
        statusPanel.add((Component)this.getStatusLabel(), gc);
        statusPanel.setBorder(new BevelBorder(0));
        return statusPanel;
    }

    void goToPressed() throws Exception {
        String javaVer = System.getProperty("java.version");
        int sPage = 0;
        if (javaVer.startsWith("1.2") || javaVer.startsWith("1.3")) {
            SelectPageDialog13 spd = new SelectPageDialog13(this.hits, this.cellCount, this.page);
            spd.setModal(true);
            spd.setLocationRelativeTo(this);
            spd.show();
            sPage = spd.getSelectedPage();
        } else {
            SelectPageDialog spd = new SelectPageDialog(this.hits, this.cellCount, this.page);
            spd.setModal(true);
            spd.setLocationRelativeTo(this);
            spd.show();
            sPage = spd.getSelectedPage();
        }
        if (sPage != 0) {
            this.page = sPage;
            this.page();
        }
    }

    public void layoutPressed() throws Exception {
        String javaVer = System.getProperty("java.version");
        if (javaVer.startsWith("1.2") || javaVer.startsWith("1.3")) {
            LayoutDialog13 ld = new LayoutDialog13(this.rows, this.columns);
            ld.setModal(true);
            ld.setLocationRelativeTo(this);
            ld.show();
            this.rows = ld.getRows();
            this.columns = ld.getColumns();
        } else {
            LayoutDialog ld = new LayoutDialog(this.rows, this.columns);
            ld.setModal(true);
            ld.setLocationRelativeTo(this);
            ld.show();
            this.rows = ld.getRows();
            this.columns = ld.getColumns();
        }
        this.setLayout(this.getMarvinLayout(this.rows, this.columns));
        if (this.hits != null) {
            this.page = 1;
            this.page();
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            ConnectionHandler ch = new ConnectionHandler();
            ch.setDriver("org.gjt.mm.mysql.Driver");
            ch.setUrl("jdbc:mysql://localhost/cdexample");
            ch.setLoginName("cduser");
            ch.setPassword("secret");
            ch.connect();
            Frame nullframe = null;
            JDialog resultFrame = new JDialog(nullframe, true);
            resultFrame.getContentPane().setLayout(new BorderLayout());
            ResultBrowserPanel resultPanel = new ResultBrowserPanel(ch);
            resultPanel.setTableName("3D");
            resultPanel.setStatusPanelEnabled(true);
            resultPanel.setButtonPanelEnabled(true);
            resultPanel.setDeleteButtonEnabled(true);
            resultPanel.init();
            resultFrame.getContentPane().add(resultPanel);
            resultFrame.setSize(500, 400);
            resultFrame.setTitle("Search results");
            resultFrame.show();
            ch.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class UpdateThread
    extends Thread {
        private volatile boolean canRun;
        public volatile int lastSize;

        UpdateThread() {
            super("updater");
            this.canRun = true;
            this.lastSize = 0;
        }

        @Override
        public void run() {
            while (this.canRun) {
                int sizeNow;
                if (ResultBrowserPanel.this.newLayout != null) {
                    try {
                        ResultBrowserPanel.this.init();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ResultBrowserPanel.this.cellCount = ResultBrowserPanel.this.mpan.getCellCount();
                    ResultBrowserPanel.this.newLayout = null;
                    ResultBrowserPanel.this.fetch = true;
                }
                if ((sizeNow = ResultBrowserPanel.this.hits.size()) == 0) {
                    ResultBrowserPanel.this.mpan.setVisible(false);
                } else {
                    ResultBrowserPanel.this.mpan.setVisible(true);
                }
                if (sizeNow != this.lastSize && !ResultBrowserPanel.this.newHits && ResultBrowserPanel.this.page * ResultBrowserPanel.this.cellCount >= this.lastSize) {
                    try {
                        ResultBrowserPanel.this.fetchStructures(this.lastSize - 1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.lastSize = sizeNow;
                if (ResultBrowserPanel.this.newHits) {
                    ResultBrowserPanel.this.newHits = false;
                    ResultBrowserPanel.this.fetch = true;
                }
                if (ResultBrowserPanel.this.fetch) {
                    try {
                        ResultBrowserPanel.this.fetchStructures();
                        ResultBrowserPanel.this.fetch = false;
                        ResultBrowserPanel.this.mpan.setSelectedIndex(-1);
                        ResultBrowserPanel.this.mpan.repaint();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (ResultBrowserPanel.this.statusChanged) {
                    if (ResultBrowserPanel.this.hits != null) {
                        ResultBrowserPanel.this.maxPage = (int)Math.ceil((double)ResultBrowserPanel.this.hits.size() / (double)ResultBrowserPanel.this.cellCount);
                        ResultBrowserPanel.this.pageLabel.setText("Page: " + ResultBrowserPanel.this.page + "/" + ResultBrowserPanel.this.maxPage);
                        ResultBrowserPanel.this.strucCountLabel.setText(ResultBrowserPanel.this.hits.size() + " structures");
                    }
                    if (ResultBrowserPanel.this.statusText != null) {
                        String text = new String(ResultBrowserPanel.this.statusText);
                        ResultBrowserPanel.this.statusLabel.setText(text);
                    }
                    ResultBrowserPanel.this.updateButtons();
                    ResultBrowserPanel.this.statusChanged = false;
                }
                try {
                    UpdateThread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

