/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import chemaxon.alchemist.configbuilder.ConfigBuilderPanel;
import chemaxon.alchemist.configbuilder.ConfigBuilderPanelFactory;
import chemaxon.alchemist.configbuilder.ConfigElement;
import chemaxon.alchemist.configbuilder.ConfigurationReaderFactory;
import chemaxon.alchemist.configbuilder.standardizer.StandardizerConfigurationWriter;
import chemaxon.alchemist.utils.AlchemistErrorDialog;
import chemaxon.alchemist.utils.AlchemistFileChooser;
import chemaxon.alchemist.utils.AlchemistIconFactory;
import chemaxon.config.struct.XMLFileFilter;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.gui.MessageDialog;
import chemaxon.jchem.gui.StructureFileFilter;
import chemaxon.reaction.Standardizer;
import chemaxon.util.ConfigTools;
import chemaxon.util.ConnectionHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

class StandardizationChooser {
    final Dialog owner;
    private String stConfig;
    private String category;
    private JRadioButton customStandRadioButton;
    private JRadioButton defaultStandRadioButton;
    private JButton browseButton;
    private JButton editorButton;
    private JDialog stEditor;
    private ConnectionHandler conh = null;
    private String tableName = null;
    protected ConfigElement[] lastConfig;

    public StandardizationChooser(Dialog owner) {
        this.owner = owner;
        this.category = "molecule";
    }

    public StandardizationChooser(Dialog owner, ConnectionHandler conh, String tableName) {
        this.owner = owner;
        this.conh = conh;
        this.tableName = tableName;
        this.category = "molecule";
    }

    public StandardizationChooser(Dialog owner, ConnectionHandler conh, String tableName, String category) {
        this.owner = owner;
        this.conh = conh;
        this.tableName = tableName;
        this.category = category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
        this.setSelectedRadioButton();
    }

    public JPanel getPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new BevelBorder(0));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.anchor = 17;
        final JTextField fileNameTextField = new JTextField();
        this.customStandRadioButton = this.getCustomStandRadioButton();
        this.defaultStandRadioButton = new JRadioButton("Default standardization");
        this.defaultStandRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StandardizationChooser.this.stEditor != null && StandardizationChooser.this.stEditor.isShowing()) {
                    StandardizationChooser.this.defaultStandRadioButton.setSelected(false);
                    StandardizationChooser.this.customStandRadioButton.setSelected(true);
                }
                if (StandardizationChooser.this.defaultStandRadioButton.isSelected()) {
                    StandardizationChooser.this.stConfig = null;
                    fileNameTextField.setText("");
                    StandardizationChooser.this.browseButton.setEnabled(false);
                    StandardizationChooser.this.editorButton.setEnabled(false);
                }
            }
        });
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.customStandRadioButton);
        bg.add(this.defaultStandRadioButton);
        fileNameTextField.setName("FileNameTextField");
        fileNameTextField.setToolTipText("Path of standardizer configuration file");
        fileNameTextField.setText("");
        fileNameTextField.setPreferredSize(new Dimension(110, 20));
        fileNameTextField.setEnabled(false);
        this.browseButton = new JButton();
        this.browseButton.setName("BrowseButton");
        this.browseButton.setText("Browse");
        this.browseButton.setPreferredSize(new Dimension(80, 25));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    StandardizationChooser.this.fileBrowseActionPerformed(fileNameTextField);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.editorButton = new JButton();
        this.editorButton.setText("Open Standardizer Editor");
        this.editorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    StandardizationChooser.this.configureStandardizationActionPerformed(StandardizationChooser.this.owner, fileNameTextField);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.setSelectedRadioButton();
        gc.gridwidth = 2;
        panel.add((Component)new JLabel("Standardization"), gc);
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.gridheight = 2;
        panel.add(Box.createRigidArea(new Dimension(30, 10)), gc);
        gc.gridy = 1;
        gc.gridx = 1;
        gc.gridheight = 1;
        panel.add((Component)this.defaultStandRadioButton, gc);
        ++gc.gridy;
        panel.add((Component)this.customStandRadioButton, gc);
        gc.gridx = 0;
        ++gc.gridy;
        gc.gridwidth = 2;
        gc.anchor = 17;
        gc.insets = new Insets(10, 10, 0, 100);
        panel.add((Component)fileNameTextField, gc);
        gc.anchor = 13;
        gc.insets = new Insets(10, 220, 0, 10);
        panel.add((Component)this.browseButton, gc);
        ++gc.gridy;
        gc.insets = new Insets(10, 60, 5, 60);
        gc.anchor = 10;
        panel.add((Component)this.editorButton, gc);
        return panel;
    }

    public String getConfig() {
        return this.stConfig;
    }

    private void setSelectedRadioButton() {
        try {
            if (this.conh != null && this.tableName != null && TableInfo.getStandardizerConfig(this.conh, this.tableName) != null) {
                this.defaultStandRadioButton.setSelected(false);
                this.customStandRadioButton.setSelected(true);
                this.browseButton.setEnabled(true);
                this.editorButton.setEnabled(true);
            } else {
                this.defaultStandRadioButton.setSelected(true);
                this.customStandRadioButton.setSelected(false);
                this.browseButton.setEnabled(false);
                this.editorButton.setEnabled(false);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.defaultStandRadioButton.setSelected(true);
            this.customStandRadioButton.setSelected(false);
            this.browseButton.setEnabled(false);
            this.editorButton.setEnabled(false);
        }
    }

    private JRadioButton getCustomStandRadioButton() {
        JRadioButton button = new JRadioButton("Custom standardization");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    StandardizationChooser.this.browseButton.setEnabled(true);
                    StandardizationChooser.this.editorButton.setEnabled(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return button;
    }

    private String standardizeCheck(File configFile) {
        String config = null;
        if (configFile != null) {
            try {
                config = ConfigTools.convertStructures(configFile);
                try {
                    new Standardizer(config);
                }
                catch (Exception e) {
                    MessageDialog.showMessage(this.owner, "Invalid standardizer configuration file.");
                    config = null;
                }
            }
            catch (IOException e) {
                MessageDialog.showMessage(this.owner, "Error while reading custom standardizer configuration from file: " + e.getMessage());
                config = null;
            }
        }
        return config;
    }

    private void fileBrowseActionPerformed(JTextField fileNameTextField) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        StructureFileFilter filter = new StructureFileFilter(new String[]{"xml"}, "Standardizer configuration files");
        fc.addChoosableFileFilter(filter);
        try {
            fc.setAcceptAllFileFilterUsed(false);
        }
        catch (Exception e) {
            // empty catch block
        }
        fc.showOpenDialog(null);
        File configFile = fc.getSelectedFile();
        this.stConfig = this.standardizeCheck(configFile);
        if (this.stConfig != null) {
            fileNameTextField.setText(configFile.getPath());
        }
    }

    private void configureStandardizationActionPerformed(Dialog owner, final JTextField fileNameTextField) throws MarshalException, ValidationException, FileNotFoundException {
        final JDialog dialog = new JDialog(owner, "Configure standardization");
        dialog.setDefaultCloseOperation(2);
        dialog.setLayout(new BorderLayout());
        final ConfigBuilderPanel panel = ConfigBuilderPanelFactory.createStandardizerPanel();
        panel.setDefaultTag(this.category);
        final AlchemistFileChooser fc = new AlchemistFileChooser();
        fc.setFileFilter(new XMLFileFilter());
        fc.setMultiSelectionEnabled(false);
        AbstractAction openFileAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fc.setDialogTitle("Open Standardizer configuration file");
                if (fc.showOpenDialog(panel) == 0) {
                    try {
                        panel.readConfiguration(ConfigurationReaderFactory.createStandardizerConfigurationReader(fc.getSelectedFile()));
                        File configFile = fc.getSelectedFile();
                        StandardizationChooser.this.stConfig = StandardizationChooser.this.standardizeCheck(configFile);
                        if (StandardizationChooser.this.stConfig != null) {
                            fileNameTextField.setText(configFile.getPath());
                        }
                        StandardizationChooser.this.lastConfig = panel.getConfiguration();
                    }
                    catch (FileNotFoundException e1) {
                        AlchemistErrorDialog.showError("Could not open file", (Exception)e1);
                    }
                }
            }
        };
        AbstractAction saveFileAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StandardizationChooser.this.saveConfiguration(panel, fc, fileNameTextField);
            }
        };
        openFileAction.putValue("ShortDescription", "Open configuration file");
        openFileAction.putValue("SmallIcon", AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/toolbar/opendocument.gif"));
        saveFileAction.putValue("ShortDescription", "Save configuration file");
        saveFileAction.putValue("SmallIcon", AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/toolbar/savedocument.gif"));
        panel.setOpenFileAction(openFileAction);
        panel.setSaveFileAction(saveFileAction);
        panel.setFileSupportEnabled(true);
        dialog.add((Component)panel, "Center");
        dialog.addWindowListener(new WindowListener(){

            @Override
            public void windowClosing(WindowEvent e) {
                Object[] config = panel.getConfiguration();
                if (config.length > 0 && !Arrays.equals(config, StandardizationChooser.this.lastConfig) && JOptionPane.showConfirmDialog(dialog, "Configuration has changed.\nDo you want to save the current configuration?", "", 0) == 0) {
                    StandardizationChooser.this.saveConfiguration(panel, fc, fileNameTextField);
                }
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        this.stEditor = dialog;
    }

    private void saveConfiguration(ConfigBuilderPanel panel, AlchemistFileChooser fc, JTextField fileNameTextField) {
        fc.setDialogTitle("Save Standardizer configuration");
        if (fc.showSaveDialog(panel) == 0) {
            try {
                panel.writeConfiguration(new StandardizerConfigurationWriter(new FileOutputStream(fc.getSelectedFile())));
                File configFile = fc.getSelectedFile();
                this.stConfig = this.standardizeCheck(configFile);
                if (this.stConfig != null) {
                    fileNameTextField.setText(configFile.getPath());
                }
                this.lastConfig = panel.getConfiguration();
            }
            catch (IOException e1) {
                AlchemistErrorDialog.showError("Could not save file", (Exception)e1);
            }
        }
    }
}

