/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.filechooser.FileFilter;

public class StructureFileFilter
extends FileFilter {
    private Hashtable<String, StructureFileFilter> filters = null;
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;

    public StructureFileFilter() {
        this("sdf", "SD files");
    }

    public StructureFileFilter(String[] filters) {
        this(filters, null);
    }

    public StructureFileFilter(String[] filters, String description) {
        this.filters = new Hashtable(filters.length);
        for (int i = 0; i < filters.length; ++i) {
            this.addExtension(filters[i]);
        }
        this.setDescription(description);
    }

    public StructureFileFilter(String extension) {
        this(extension, null);
    }

    public StructureFileFilter(String extension, String description) {
        this(new String[]{extension}, description);
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f);
            if (extension != null) {
                Enumeration<String> en = this.filters.keys();
                while (en.hasMoreElements()) {
                    String fext = en.nextElement();
                    if (!extension.startsWith(fext)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void addExtension(String extension) {
        if (this.filters == null) {
            this.filters = new Hashtable(5);
        }
        this.filters.put(extension.toLowerCase(), this);
        this.fullDescription = null;
    }

    @Override
    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                if (this.description != null) {
                    this.fullDescription = this.description;
                }
                this.fullDescription = this.fullDescription + " ( ";
                Enumeration<String> extensions = this.filters.keys();
                if (extensions != null) {
                    this.fullDescription = this.fullDescription + "." + extensions.nextElement();
                    while (extensions.hasMoreElements()) {
                        this.fullDescription = this.fullDescription + ", ." + extensions.nextElement();
                    }
                }
                this.fullDescription = this.fullDescription + " )";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public Set<String> getAllExtensions() {
        return this.filters.keySet();
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean b) {
        this.useExtensionsInDescription = b;
        this.fullDescription = null;
    }
}

