/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import chemaxon.jchem.db.DatabaseOptions;
import chemaxon.jchem.db.StructureTableOptions;
import chemaxon.jchem.db.TableTypeConstants;
import chemaxon.jchem.db.UpdateHandler;
import chemaxon.jchem.gui.MessageDialog;
import chemaxon.jchem.gui.StandardizationChooser;
import chemaxon.jchem.gui.StructureFileFilter;
import chemaxon.sss.screen.StrucFPConfig;
import chemaxon.util.ConnectionHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class TableCreateDialog
extends JDialog
implements TableTypeConstants {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    public static int[] FP_MIN_UNITS = new int[]{8, 2, 8, 8, 8};
    public static int[] FP_MAX_UNITS = new int[]{64, 16, 64, 64, 64};
    public static int[] FP_UNIT_MULIPLIER = new int[]{1, 16, 1, 8, 1};
    private static ConnectionHandler conh = null;
    private StrucFPConfig structuralKeyConfig = null;
    private ActionListener tableModeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int x = 0; x < TableCreateDialog.this.tableModeButtons.length; ++x) {
                if (!TableCreateDialog.this.tableModeButtons[x].isSelected()) continue;
                int type = ((TableCreateDialog)TableCreateDialog.this).tableModeButtons[x].tableType;
                TableCreateDialog.this.setFingerprintsForTableMode(type);
                TableCreateDialog.this.tautomerDuplicateCheckDisabler(type);
                TableCreateDialog.this.setStandardizationCategory(type);
                break;
            }
        }
    };
    private JPanel buttonPanel;
    private JPanel jPanel1;
    private Panel panel2;
    private Panel panel1;
    private Panel panel3;
    private JButton okButton;
    private JButton cancelButton;
    private JLabel jLabel2;
    private JTextField tableNameTextField;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JComboBox numberOfIntsComboBox;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JComboBox numberOfOnesComboBox;
    private JLabel jLabel1;
    private JComboBox numberOfEdgesComboBox;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JCheckBox structuralKeysCheckBox;
    private JCheckBox absoluteStereoCheckBox;
    private JCheckBox tautomerDuplicateCheckCheckBox;
    private JCheckBox duplicateFilteringCheckBox;
    private StandardizationChooser stChooser;
    private TableModeRadioButton[] tableModeButtons;
    private int returnStatus = 0;

    public TableCreateDialog(Frame parent, boolean modal) {
        this(parent, modal, null);
    }

    public TableCreateDialog(Frame parent, boolean modal, ConnectionHandler connHandler) {
        super(parent, modal);
        conh = connHandler;
        this.initComponents();
        this.setTitle("Create a Table");
        this.pack();
        this.setResizable(false);
    }

    private int getDBMS() {
        if (conh != null) {
            return DatabaseOptions.getDBMSType(conh);
        }
        return -1;
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    void setStandardizationCategory(int tableType) {
        String category = "molecule";
        if (tableType == 4) {
            category = "query";
        } else if (tableType == 1) {
            category = "reaction";
        }
        this.stChooser.setCategory(category);
    }

    void tautomerDuplicateCheckDisabler(int tableType) {
        if (tableType == 4 || tableType == 3) {
            this.tautomerDuplicateCheckCheckBox.setEnabled(false);
            this.tautomerDuplicateCheckCheckBox.setSelected(false);
        } else {
            this.tautomerDuplicateCheckCheckBox.setEnabled(true);
        }
    }

    public static int intCountToIndex(int mode, int intCount) {
        int minUnits = FP_MIN_UNITS[mode];
        int multiplier = FP_UNIT_MULIPLIER[mode];
        return intCount / multiplier - minUnits;
    }

    public static int indexToIntCount(int mode, int index) {
        int minUnits = FP_MIN_UNITS[mode];
        int multiplier = FP_UNIT_MULIPLIER[mode];
        return (index + minUnits) * multiplier;
    }

    private void setFingerprintsForTableMode(int mode) {
        this.numberOfIntsComboBox.removeAllItems();
        int minUnits = FP_MIN_UNITS[mode];
        int maxUnits = FP_MAX_UNITS[mode];
        int multiplier = FP_UNIT_MULIPLIER[mode];
        for (int i = minUnits; i <= maxUnits; ++i) {
            this.numberOfIntsComboBox.addItem(new Integer(i * multiplier).toString());
        }
        this.numberOfIntsComboBox.setSelectedIndex(TableCreateDialog.intCountToIndex(mode, UpdateHandler.FP_DEFAULT_LENGTH_IN_INTS[mode]));
        this.numberOfEdgesComboBox.setSelectedIndex(UpdateHandler.FP_DEFAULT_PATTERN_LENGTH[mode] - 1);
        this.numberOfOnesComboBox.setSelectedIndex(UpdateHandler.FP_DEFAULT_BITS_PER_PATTERN[mode] - 1);
    }

    private void initComponents() {
        int x;
        int i;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TableCreateDialog.this.closeDialog();
            }
        });
        this.getContentPane().setLayout(new BorderLayout(20, 20));
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout(2, 5, 5));
        this.okButton = new JButton();
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableCreateDialog.this.okButtonActionPerformed();
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton = new JButton();
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableCreateDialog.this.cancelButtonActionPerformed();
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.jPanel1 = new JPanel();
        this.jPanel1.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        this.jLabel2 = new JLabel();
        this.jLabel2.setText("Name of new table: ");
        gc.gridwidth = 1;
        gc.fill = 1;
        gc.anchor = 13;
        this.jPanel1.add((Component)this.jLabel2, gc);
        this.tableNameTextField = new JTextField();
        this.tableNameTextField.setPreferredSize(new Dimension(200, 20));
        this.tableNameTextField.setToolTipText("Name of table to be created");
        this.tableNameTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableCreateDialog.this.tableNameTextFieldActionPerformed();
            }
        });
        gc.fill = 1;
        gc.anchor = 17;
        this.jPanel1.add((Component)this.tableNameTextField, gc);
        JSeparator sep = new JSeparator();
        sep.setMinimumSize(new Dimension(1, 1));
        gc = new GridBagConstraints();
        gc.gridwidth = 0;
        gc.fill = 2;
        gc.insets = new Insets(10, 0, 5, 0);
        gc.gridy = 2;
        this.jPanel1.add((Component)sep, gc);
        this.jLabel5 = new JLabel();
        this.jLabel5.setText("Expert features");
        gc = new GridBagConstraints();
        gc.gridwidth = 0;
        gc.anchor = 17;
        this.jPanel1.add((Component)this.jLabel5, gc);
        gc = new GridBagConstraints();
        this.jPanel1.add(Box.createRigidArea(new Dimension(40, 0)), gc);
        this.jLabel7 = new JLabel();
        this.jLabel7.setText("Fingerprint length: ");
        gc = new GridBagConstraints();
        gc.fill = 1;
        gc.anchor = 17;
        this.jPanel1.add((Component)this.jLabel7, gc);
        this.numberOfIntsComboBox = new JComboBox();
        this.numberOfIntsComboBox.setPreferredSize(new Dimension(60, 20));
        this.numberOfIntsComboBox.setName("Length of fingerprint in INTEGER units");
        this.numberOfIntsComboBox.setToolTipText("Length of fingerprints in INTEGER size units");
        gc = new GridBagConstraints();
        gc.fill = 1;
        gc.anchor = 17;
        this.jPanel1.add((Component)this.numberOfIntsComboBox, gc);
        this.jLabel3 = new JLabel();
        this.jLabel3.setText(" X 4 bytes");
        gc = new GridBagConstraints();
        gc.gridwidth = 0;
        gc.fill = 3;
        gc.anchor = 17;
        this.jPanel1.add((Component)this.jLabel3, gc);
        this.jLabel4 = new JLabel();
        this.jLabel4.setText("Bits to be set for patterns: ");
        gc = new GridBagConstraints();
        gc.gridx = 1;
        gc.fill = 1;
        gc.anchor = 13;
        this.jPanel1.add((Component)this.jLabel4, gc);
        this.numberOfOnesComboBox = new JComboBox();
        this.numberOfOnesComboBox.setPreferredSize(new Dimension(60, 20));
        this.numberOfOnesComboBox.setToolTipText("Number of bits set to 1 in the fingerprint of patterns");
        for (i = 1; i < 20; ++i) {
            this.numberOfOnesComboBox.addItem(new Integer(i).toString());
        }
        gc = new GridBagConstraints();
        gc.gridwidth = 0;
        gc.fill = 3;
        gc.anchor = 17;
        this.jPanel1.add((Component)this.numberOfOnesComboBox, gc);
        this.jLabel1 = new JLabel();
        this.jLabel1.setText("Maximum pattern length: ");
        gc = new GridBagConstraints();
        gc.gridx = 1;
        gc.anchor = 17;
        this.jPanel1.add((Component)this.jLabel1, gc);
        this.numberOfEdgesComboBox = new JComboBox();
        this.numberOfEdgesComboBox.setPreferredSize(new Dimension(60, 20));
        this.numberOfEdgesComboBox.setToolTipText("Size of the longest patterns used for the creation of fingerprints");
        for (i = 1; i < 20; ++i) {
            this.numberOfEdgesComboBox.addItem(new Integer(i).toString());
        }
        gc = new GridBagConstraints();
        this.jPanel1.add((Component)this.numberOfEdgesComboBox, gc);
        this.jLabel6 = new JLabel();
        this.jLabel6.setText(" bonds");
        gc = new GridBagConstraints();
        gc.anchor = 17;
        gc.gridwidth = 0;
        this.jPanel1.add((Component)this.jLabel6, gc);
        this.absoluteStereoCheckBox = new JCheckBox("Assume absolute stereo flag", true);
        gc = new GridBagConstraints();
        gc.gridx = 1;
        gc.anchor = 17;
        gc.gridwidth = 0;
        this.jPanel1.add((Component)this.absoluteStereoCheckBox, gc);
        this.structuralKeysCheckBox = new JCheckBox("Structural keys", false);
        this.structuralKeysCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    TableCreateDialog.this.structuralFingerprintCheckBoxActionPerformed();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        gc = new GridBagConstraints();
        gc.gridx = 1;
        gc.anchor = 17;
        gc.gridwidth = 0;
        this.jPanel1.add((Component)this.structuralKeysCheckBox, gc);
        this.duplicateFilteringCheckBox = new JCheckBox("Filter out duplicate structures", false);
        gc = new GridBagConstraints();
        gc.gridx = 1;
        gc.anchor = 17;
        gc.gridwidth = 0;
        this.jPanel1.add((Component)this.duplicateFilteringCheckBox, gc);
        this.tautomerDuplicateCheckCheckBox = new JCheckBox("Duplicate search uses tautomers", false);
        gc = new GridBagConstraints();
        gc.gridx = 1;
        gc.anchor = 17;
        gc.gridwidth = 0;
        this.jPanel1.add((Component)this.tautomerDuplicateCheckCheckBox, gc);
        gc.gridy = 11;
        gc.gridx = 0;
        gc.gridwidth = 4;
        gc.anchor = 10;
        this.stChooser = new StandardizationChooser(this);
        this.jPanel1.add((Component)this.stChooser.getPanel(), gc);
        ++gc.gridy;
        gc.gridx = 0;
        sep = new JSeparator();
        sep.setMinimumSize(new Dimension(1, 1));
        gc.gridwidth = 0;
        gc.fill = 2;
        gc.insets = new Insets(10, 0, 5, 0);
        this.jPanel1.add((Component)sep, gc);
        this.jLabel8 = new JLabel();
        this.jLabel8.setText("Table type");
        gc = new GridBagConstraints();
        gc.gridwidth = 0;
        gc.anchor = 17;
        this.jPanel1.add((Component)this.jLabel8, gc);
        gc = new GridBagConstraints();
        this.jPanel1.add(Box.createRigidArea(new Dimension(40, 0)), gc);
        int tableTypeCount = UpdateHandler.TABLE_TYPE_NAMES.length;
        this.tableModeButtons = new TableModeRadioButton[tableTypeCount];
        ButtonGroup tableModeButtonGroup = new ButtonGroup();
        for (x = 0; x < tableTypeCount; ++x) {
            this.tableModeButtons[x] = new TableModeRadioButton(UpdateHandler.TABLE_TYPE_NAMES[x], x);
            if (this.getDBMS() == 4 && TABLE_TYPE_NAMES[x].equals("Markush libraries")) {
                this.tableModeButtons[x].setToolTipText("This table type is not allowed for MS Access");
                this.tableModeButtons[x].setEnabled(false);
                continue;
            }
            this.tableModeButtons[x].setToolTipText(UpdateHandler.TABLE_TYPE_EXPLANATIONS[x]);
            this.tableModeButtons[x].addActionListener(this.tableModeListener);
            tableModeButtonGroup.add(this.tableModeButtons[x]);
        }
        this.tableModeButtons[0].setSelected(true);
        this.setFingerprintsForTableMode(0);
        for (x = 0; x < tableTypeCount; ++x) {
            gc = new GridBagConstraints();
            gc.gridwidth = 0;
            gc.anchor = 17;
            if (x > 0) {
                gc.gridx = 1;
            }
            this.jPanel1.add((Component)this.tableModeButtons[x], gc);
        }
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.panel2 = new Panel();
        this.panel2.setLayout(new FlowLayout());
        this.getContentPane().add((Component)this.panel2, "East");
        this.panel1 = new Panel();
        this.panel1.setLayout(new FlowLayout());
        this.getContentPane().add((Component)this.panel1, "West");
        this.panel3 = new Panel();
        this.panel3.setLayout(new FlowLayout());
        this.getContentPane().add((Component)this.panel3, "North");
    }

    private void structuralFingerprintCheckBoxActionPerformed() {
        if (this.structuralKeysCheckBox.isSelected()) {
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(0);
            File file = null;
            fc.setName("FileChooser");
            StructureFileFilter filter = new StructureFileFilter(new String[]{"sd", "sdf", "jtf", "smi", "mol", "rd", "rdf", "rxn", "mrv"}, "All structure files");
            fc.addChoosableFileFilter(filter);
            StructureFileFilter def = filter;
            filter = new StructureFileFilter(new String[]{"sd", "sdf"}, "MDL SDfiles");
            fc.addChoosableFileFilter(filter);
            filter = new StructureFileFilter(new String[]{"sma", "smarts"}, "Daylight SMARTS files");
            fc.addChoosableFileFilter(filter);
            if (filter.accept(file)) {
                def = filter;
            }
            filter = new StructureFileFilter("smi", "Daylight SMILES files");
            fc.addChoosableFileFilter(filter);
            if (filter.accept(file)) {
                def = filter;
            }
            filter = new StructureFileFilter("mol", "MDL Molfiles");
            fc.addChoosableFileFilter(filter);
            if (filter.accept(file)) {
                def = filter;
            }
            filter = new StructureFileFilter(new String[]{"rd", "rdf"}, "MDL RDfiles");
            fc.addChoosableFileFilter(filter);
            if (filter.accept(file)) {
                def = filter;
            }
            filter = new StructureFileFilter("rxn", "MDL Rxnfiles");
            fc.addChoosableFileFilter(filter);
            if (filter.accept(file)) {
                def = filter;
            }
            filter = new StructureFileFilter("mrv", "Marvin document");
            fc.addChoosableFileFilter(filter);
            if (filter.accept(file)) {
                def = filter;
            }
            fc.setFileFilter(def);
            fc.addChoosableFileFilter(filter);
            try {
                fc.setAcceptAllFileFilterUsed(false);
            }
            catch (Exception e) {
                // empty catch block
            }
            fc.showOpenDialog(null);
            File structureFile = fc.getSelectedFile();
            if (structureFile != null) {
                try {
                    String filename = structureFile.getName();
                    String extension = filename.substring(filename.lastIndexOf(".") + 1);
                    StrucFPConfig sc = new StrucFPConfig();
                    boolean structuralKeySmartsMode = extension.startsWith("sma");
                    sc.readMolecules(new FileInputStream(structureFile), structuralKeySmartsMode);
                    int count = sc.getNumberOfKeys();
                    int integers = sc.getNumberOfIntegersNeeded();
                    MessageDialog.showMessage(this, "Structures : " + count + "\nNumber of extra fingerpint " + "columns to be used : " + integers);
                    this.structuralKeyConfig = sc;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    MessageDialog.showMessage(this, "Error while reading custom structural key structures from file.");
                    this.structuralKeyConfig = null;
                }
            }
            if (this.structuralKeyConfig == null) {
                this.structuralKeysCheckBox.setSelected(false);
            }
        } else {
            this.structuralKeyConfig = null;
        }
    }

    private void tableNameTextFieldActionPerformed() {
    }

    private void okButtonActionPerformed() {
        this.doClose(1);
    }

    private void cancelButtonActionPerformed() {
        this.doClose(0);
    }

    private void closeDialog() {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new TableCreateDialog(new Frame(), false).setVisible(true);
    }

    public StructureTableOptions getData() {
        StructureTableOptions data = null;
        if (this.returnStatus == 1) {
            data = new StructureTableOptions();
            data.name = this.tableNameTextField.getText();
            for (int x = 0; x < this.tableModeButtons.length; ++x) {
                if (!this.tableModeButtons[x].isSelected()) continue;
                data.tableType = this.tableModeButtons[x].tableType;
                break;
            }
            data.fp_numberOfInts = TableCreateDialog.indexToIntCount(data.tableType, this.numberOfIntsComboBox.getSelectedIndex());
            data.fp_numberOfOnes = Integer.parseInt((String)this.numberOfOnesComboBox.getSelectedItem());
            data.fp_numberOfEdges = Integer.parseInt((String)this.numberOfEdgesComboBox.getSelectedItem());
            data.standardizerConfig = this.stChooser.getConfig();
            data.absoluteStereo = this.absoluteStereoCheckBox.isSelected();
            data.structuralKeyConfig = this.structuralKeyConfig;
            data.tautomerDuplicateChecking = this.tautomerDuplicateCheckCheckBox.isSelected();
            data.duplicateFiltering = this.duplicateFilteringCheckBox.isSelected();
        }
        return data;
    }

    private class TableModeRadioButton
    extends JRadioButton {
        public int tableType;

        TableModeRadioButton(String text, int tableType) {
            super(text);
            this.tableType = 0;
            this.tableType = tableType;
        }
    }
}

