/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.interop;

import chemaxon.formats.MolExporter;
import chemaxon.formats.MolImporter;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.interop.InteropMiscellanious;
import chemaxon.jchem.interop.InteropUtil;
import chemaxon.jchem.interop.Pools;
import chemaxon.jep.ChemJEP;
import chemaxon.jep.context.MolContext;
import chemaxon.reaction.Standardizer;
import chemaxon.struc.Molecule;
import java.io.ByteArrayOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InteropEval {
    private static Logger logger = Logger.getLogger(InteropEval.class.getName());

    public Object evaluate(String query, String standizerConfig, String expression, String outFormat, boolean toArray, boolean numberResultOnly) throws Exception {
        Object result = null;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("query=" + query + ", standizerConfig=" + standizerConfig + ", expression=" + expression + ", outFormat=" + outFormat + ", toArray=" + toArray + ", numberResultOnly=" + numberResultOnly);
        }
        if (query == null || query.equals(" ")) {
            query = "\n  Empty structure\n\n  0  0  0  0  0  0            999 V2000\nM  END";
        }
        Molecule mol = null;
        try {
            mol = MolImporter.importMol(query);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Problem importing query structure: " + query + ": " + e);
        }
        if (outFormat == null) {
            outFormat = mol.getInputFormat();
        }
        if ((result = this.evaluate(mol, standizerConfig, expression, numberResultOnly)) != null) {
            if (result instanceof Molecule || result instanceof Molecule[]) {
                result = toArray ? InteropMiscellanious.exportMoleculesToArray(result, outFormat) : InteropEval.exportMolecules(result, outFormat);
            } else if (!(result instanceof String)) {
                try {
                    result = InteropUtil.getNumberFormat().format(result);
                }
                catch (IllegalArgumentException iae) {
                    result = String.valueOf(result);
                }
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Returning '" + result + "'");
        }
        return result;
    }

    public Object evaluate(Molecule mol, String standizerConfig, String expression, boolean numberResultOnly) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("mol=" + mol.toFormat("cxsmarts") + ", standardizerConfig=" + standizerConfig + ", expression=" + expression + ", numberResultOnly=" + numberResultOnly);
        }
        Object result = null;
        Standardizer standardizer = null;
        if (standizerConfig != null) {
            standardizer = Pools.getCreateStandardizer(standizerConfig);
        }
        TableInfo.standardize(mol, standardizer, true);
        Pools.recycleStandardizer(standizerConfig, standardizer);
        MolContext context = new MolContext();
        context.setMolecule(mol);
        ChemJEP jep = Pools.getCreateChemJep(expression);
        result = jep.evaluate(context);
        Pools.recycleChemJep(expression, jep);
        if (result instanceof Boolean) {
            Boolean b = (Boolean)result;
            Object object = result = b != false ? new Integer(1) : new Integer(0);
        }
        if (!(result instanceof Double || result instanceof Integer || result instanceof Float || result instanceof Long)) {
            if (numberResultOnly) {
                throw new Exception("Expression " + expression + " yields " + result.getClass().getName() + ". Expressions must yield one single number!");
            }
        } else if (result instanceof Double) {
            if (Double.isNaN((Double)result)) {
                result = null;
            }
        } else if (result instanceof Float && Float.isNaN(((Float)result).floatValue())) {
            result = null;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Returning '" + result + "'");
        }
        return result;
    }

    private static final String exportMolecules(Object molecules, String outFormat) throws Exception {
        return InteropEval.exportMolecules(molecules, outFormat, null);
    }

    private static final String exportMolecules(Object molecules, String outFormat, String[] productIds) throws Exception {
        String result = null;
        if (molecules != null) {
            if (molecules instanceof Molecule[]) {
                Molecule[] mols = (Molecule[])molecules;
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                MolExporter exporter = new MolExporter(bout, outFormat);
                for (int ix = 0; ix < mols.length; ++ix) {
                    exporter.write(mols[ix]);
                }
                result = new String(bout.toByteArray(), "US-ASCII");
            } else if (molecules instanceof Molecule) {
                Molecule mol = (Molecule)molecules;
                result = MolExporter.exportToFormat(mol, outFormat);
            } else {
                throw new IllegalArgumentException("Invalid argument type: " + molecules.getClass().getName());
            }
        }
        return result;
    }
}

