/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.interop;

import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.descriptors.RFParameters;
import chemaxon.descriptors.ReactionFingerprint;
import chemaxon.enumeration.supergraph.Supergraph;
import chemaxon.formats.MolConverter;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.db.UpdateHandler;
import chemaxon.jchem.db.UpdateHandlerException;
import chemaxon.jchem.interop.Pools;
import chemaxon.reaction.Standardizer;
import chemaxon.sss.screen.CombinedFingerprint;
import chemaxon.struc.Molecule;
import chemaxon.util.BinaryDataUtil;
import chemaxon.util.MolHandler;
import chemaxon.util.cache.CachedPools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InteropMiscellanious {
    public static Logger logger = Logger.getLogger(InteropMiscellanious.class.getName());
    private static final CombinedFpMakerCache fpMakerCache = new CombinedFpMakerCache();

    protected static void checkTableType(int tableType, Molecule mol) throws Exception {
        if (tableType == 0 && (mol.isQuery() || Supergraph.isMarkushMolecule(mol))) {
            throw new UpdateHandlerException("Inserting a query or Markush structure is not allowed for the type of this table");
        }
        boolean isReaction = mol.isReaction();
        if (isReaction && tableType != 1 && tableType != 2) {
            throw new UpdateHandlerException("Inserting reactions not allowed for the type of this table");
        }
        if (tableType == 1 && !isReaction) {
            throw new UpdateHandlerException("Only reactions can be stored in this table");
        }
    }

    protected static int[] getFingerprints(MolPropQueryParams molPropQueryParams, Molecule mol, int tableType) throws Exception {
        if (logger.isLoggable(Level.FINER)) {
            StringBuffer b = new StringBuffer();
            for (int i = 0; i < molPropQueryParams.getFpProps().length; ++i) {
                int fpp = molPropQueryParams.getFpProps()[i];
                b.append("fp_props").append(i).append("=").append(fpp).append(",");
            }
            logger.finer(b.toString());
        }
        Supergraph superGraph = null;
        boolean isMarkush = Supergraph.isMarkushMolecule(mol);
        molPropQueryParams.setMarkush(isMarkush);
        if (isMarkush && tableType == 3) {
            superGraph = new Supergraph(mol);
        }
        CombinedFingerprint cFP = InteropMiscellanious.getCreateCombinedFPMaker(molPropQueryParams);
        Molecule molToCalcFpOn = null;
        molToCalcFpOn = isMarkush ? superGraph : mol;
        int[] fp = cFP.getCombinedFingerprint(molToCalcFpOn, null, false, false, tableType != 3);
        InteropMiscellanious.recycleFpMaker(molPropQueryParams, cFP);
        if (logger.isLoggable(Level.FINER)) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < fp.length; ++i) {
                int j = fp[i];
                sb.append("fp").append(i).append("=").append(j).append(",");
            }
            logger.finer(sb.toString());
        }
        return fp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void standardize(Molecule mol, String stdrConfig, boolean stdrOptionals) throws Exception {
        Standardizer standardizer = Pools.getCreateStandardizer(stdrConfig);
        try {
            TableInfo.standardize(mol, standardizer, stdrOptionals);
        }
        finally {
            Pools.recycleStandardizer(stdrConfig, standardizer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void standardize(MolPropQueryParams molPropQueryParams, Molecule mol) throws Exception {
        String stdrConfig = molPropQueryParams.getStdrConfig();
        String stdrParam = molPropQueryParams.getStdrConfigParam();
        Standardizer standardizer = Pools.getCreateStandardizer(stdrConfig);
        try {
            InteropMiscellanious.standardize(standardizer, mol, stdrParam, null);
        }
        finally {
            Pools.recycleStandardizer(stdrConfig, standardizer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String standardize(String target, String stdrConfig, String outFormat) throws Exception {
        Molecule mol = new MolHandler(target).getMolecule();
        Standardizer standardizer = Pools.getCreateStandardizer(stdrConfig);
        try {
            standardizer.standardize(mol);
            if (outFormat == null) {
                outFormat = mol.getInputFormat();
            }
            String string = MolExporter.exportToFormat(mol, outFormat);
            return string;
        }
        finally {
            Pools.recycleStandardizer(stdrConfig, standardizer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Molecule[] batchStandardize(Molecule[] inMols, String stdrConfig, String outFormat) throws Exception {
        Standardizer standardizer = Pools.getCreateStandardizer(stdrConfig);
        try {
            for (int ix = 0; ix < inMols.length; ++ix) {
                standardizer.standardize(inMols[ix]);
            }
        }
        finally {
            Pools.recycleStandardizer(stdrConfig, standardizer);
        }
        return inMols;
    }

    public static String standardize(Standardizer standardizer, Molecule mol, String param, String outFormat) throws Exception {
        TableInfo.standardize(mol, standardizer, param.equals("tru"));
        if (outFormat == null) {
            outFormat = mol.getInputFormat();
        }
        return MolExporter.exportToFormat(mol, outFormat);
    }

    public static String standardize(Standardizer standardizer, Molecule mol, String outFormat) throws Exception {
        standardizer.standardize(mol);
        if (outFormat == null) {
            outFormat = mol.getInputFormat();
        }
        return MolExporter.exportToFormat(mol, outFormat);
    }

    public static String standardize(Standardizer standardizer, Molecule mol, boolean optionals, String outFormat) throws Exception {
        TableInfo.standardize(mol, standardizer, optionals);
        if (outFormat == null) {
            outFormat = mol.getInputFormat();
        }
        return MolExporter.exportToFormat(mol, outFormat);
    }

    public static MolecularDescriptor createMd(String mdType, String mdSettings, String mdScreenConfig) throws MDGeneratorException, Exception {
        MolecularDescriptor md = null;
        if (mdSettings == null) {
            md = MolecularDescriptor.newInstance(mdType);
            md.setParameters((String)null);
        } else {
            md = MolecularDescriptor.newInstanceFromXML(mdSettings);
        }
        if (mdScreenConfig != null) {
            md.setScreeningConfiguration(mdScreenConfig);
        }
        if (logger.isLoggable(Level.FINEST)) {
            String s = md.toString();
            logger.finest("returning " + s + "...");
        }
        return md;
    }

    public static void setMdContent(String struct, byte[] structFp, String stdrConfig, MolecularDescriptor md) throws MDGeneratorException, Exception {
        if (structFp == null) {
            md.generate(InteropMiscellanious.unmarshallStandardize(struct, stdrConfig));
        } else {
            md.fromData(structFp);
        }
    }

    private static Molecule unmarshallStandardize(String struct, String stdrConfig) throws Exception {
        Molecule mol = null;
        Standardizer standardizer = null;
        MolHandler molHandler = new MolHandler(struct);
        if (stdrConfig != null && stdrConfig.length() > 0 && !stdrConfig.equals("null")) {
            standardizer = Pools.getCreateStandardizer(stdrConfig);
        }
        TableInfo.standardize(molHandler, standardizer, true);
        if (standardizer != null) {
            Pools.recycleStandardizer(stdrConfig, standardizer);
        }
        mol = molHandler.getMolecule();
        return mol;
    }

    public static double getReactionDissimilarity(int[] fp_t, String target, String query, int[] fp_props, String stdrConfig, boolean stdrOptionals, String dissimilarityMetric) throws Exception {
        ReactionFingerprint queryRf = new ReactionFingerprint();
        RFParameters params = new RFParameters();
        params.setBitCount(fp_props[1]);
        params.setBondCount(fp_props[2]);
        params.setLength(fp_props[0]);
        queryRf.setParameters(params);
        MolHandler mh_q = new MolHandler(query);
        InteropMiscellanious.standardize(mh_q.getMolecule(), stdrConfig, stdrOptionals);
        queryRf.generate(mh_q.getMolecule());
        ReactionFingerprint targetRf = queryRf.clone();
        if (fp_t == null) {
            targetRf.setParameters(params);
            MolHandler mh_t = new MolHandler(target);
            InteropMiscellanious.standardize(mh_t.getMolecule(), stdrConfig, stdrOptionals);
            targetRf.generate(mh_t.getMolecule());
        } else {
            targetRf.fromData(BinaryDataUtil.getFingerprintInBytes(fp_t));
        }
        int metricIndex = queryRf.getDefaultMetricIndex();
        if (dissimilarityMetric != null && dissimilarityMetric.length() > 0 && !dissimilarityMetric.equalsIgnoreCase("null")) {
            metricIndex = queryRf.getMetricIndex(dissimilarityMetric);
        }
        double dissimilarity = queryRf.getDissimilarity(targetRf, metricIndex);
        return dissimilarity;
    }

    public static int[] getFp(String target, boolean targetStdrNeeded, String stdrConfig, boolean stdrOptionals, int[] fpProps) throws Exception {
        MolHandler mh_t = null;
        if (targetStdrNeeded) {
            mh_t = new MolHandler(target);
            InteropMiscellanious.standardize(mh_t.getMolecule(), stdrConfig, stdrOptionals);
        }
        return mh_t.generateFingerprintInInts(fpProps[0] / 32, fpProps[1], fpProps[2]);
    }

    private static CombinedFingerprint getCreateCombinedFPMaker(MolPropQueryParams molPropQueryParams) throws Exception {
        return (CombinedFingerprint)fpMakerCache.getCreatePoolItem(molPropQueryParams);
    }

    private static void recycleFpMaker(Object key, Object obj) {
        fpMakerCache.recyclePoolItem(key, obj);
    }

    public static void checkFpProps(int[] fp_props, int tableType) {
        if (tableType == 10000) {
            return;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("fp_props[0]=" + fp_props[0] + ", tableType=" + tableType);
        }
        if (fp_props[0] == -1) {
            int fp_bit = UpdateHandler.FP_DEFAULT_BITS_PER_PATTERN[tableType];
            int pat_length = UpdateHandler.FP_DEFAULT_PATTERN_LENGTH[tableType];
            int fp_size = UpdateHandler.FP_DEFAULT_LENGTH_IN_INTS[tableType];
            fp_props[0] = fp_size * 32;
            fp_props[1] = fp_bit;
            fp_props[2] = pat_length;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("fp_props[0]=" + fp_props[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] molconvert(byte[] query, String inputFormat, String options) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayInputStream bais = new ByteArrayInputStream(query);
        String[] args = InteropMiscellanious.tokenizeOptions(options);
        MolInputStream molInStream = new MolInputStream((InputStream)bais, inputFormat);
        try {
            InteropMiscellanious.convertBytes(molInStream, baos, args, false);
        }
        finally {
            if (molInStream != null) {
                molInStream.close();
            }
        }
        return InteropMiscellanious.postProcessByteArrayResult(options, baos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] batchMolConvert(byte[] query, String inputFormat, String options) throws MolFormatException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayInputStream bais = new ByteArrayInputStream(query);
        String[] conversionOptions = InteropMiscellanious.tokenizeOptions(options);
        MolInputStream molInStream = new MolInputStream((InputStream)bais, inputFormat);
        try {
            InteropMiscellanious.convertBytes(molInStream, baos, conversionOptions, true);
        }
        finally {
            if (molInStream != null) {
                molInStream.close();
            }
        }
        byte[] result = InteropMiscellanious.postProcessByteArrayResult(options, baos);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[][] batchImageMolConvert(byte[] query, String inputFormat, String options) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(query);
        String[] conversionOptions = InteropMiscellanious.tokenizeOptions(options);
        ArrayList<byte[]> byteArrayList = new ArrayList<byte[]>();
        MolInputStream molInStream = new MolInputStream((InputStream)bais, inputFormat);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MolConverter mc = MolConverter.createMolConverter(molInStream, baos, conversionOptions, null);
        try {
            boolean ableToReadMolecule = true;
            while (ableToReadMolecule = InteropMiscellanious.convertBytes(mc, false)) {
                byte[] tempResult = InteropMiscellanious.postProcessByteArrayResult(options, baos);
                baos.reset();
                byteArrayList.add(tempResult);
            }
        }
        finally {
            if (mc != null) {
                mc.close();
            }
            if (molInStream != null) {
                molInStream.close();
            }
        }
        byte[][] result = new byte[byteArrayList.size()][];
        for (int i = 0; i < byteArrayList.size(); ++i) {
            result[i] = (byte[])byteArrayList.get(i);
        }
        return result;
    }

    private static byte[] postProcessByteArrayResult(String options, ByteArrayOutputStream baos) {
        byte[] tempResult = options.toLowerCase().indexOf("smiles") != -1 ? InteropMiscellanious.trimByteArray(baos) : baos.toByteArray();
        return tempResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean convertBytes(MolInputStream molInStream, ByteArrayOutputStream baos, String[] conversionOptions, boolean convertAll) throws IOException {
        MolConverter mc = MolConverter.createMolConverter(molInStream, baos, conversionOptions, null);
        try {
            boolean bl = InteropMiscellanious.convertBytes(mc, convertAll);
            return bl;
        }
        finally {
            mc.close();
        }
    }

    private static boolean convertBytes(MolConverter mc, boolean convertAll) throws IOException {
        boolean ableToReadMolecule;
        block5: {
            ableToReadMolecule = false;
            try {
                if (mc != null) {
                    ableToReadMolecule = mc.convert();
                }
                if (convertAll) {
                    while (ableToReadMolecule) {
                        ableToReadMolecule = mc.convert();
                    }
                }
            }
            catch (InternalError ie) {
                if (ie.getMessage().indexOf("X11") == -1) break block5;
                throw new RuntimeException("To enable image generation, restart Tomcat with the system property 'java.awt.headless' set to 'true'");
            }
        }
        return ableToReadMolecule;
    }

    private static String[] tokenizeOptions(String options) {
        StringTokenizer st = new StringTokenizer(options);
        ArrayList<String> optionList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            optionList.add(st.nextToken());
        }
        String[] args = optionList.toArray(new String[optionList.size()]);
        return args;
    }

    private static byte[] trimByteArray(ByteArrayOutputStream baos) {
        int tempIndexAtEnd;
        byte[] ba = baos.toByteArray();
        int arrayLength = ba.length;
        for (tempIndexAtEnd = arrayLength - 1; tempIndexAtEnd > -1 && (ba[tempIndexAtEnd] == 10 || ba[tempIndexAtEnd] == 13); --tempIndexAtEnd) {
        }
        ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
        baos1.write(ba, 0, tempIndexAtEnd + 1);
        return baos1.toByteArray();
    }

    public static void main(String[] args) throws Exception {
        byte[] in = new byte[]{67};
        byte[] out = InteropMiscellanious.molconvert(in, null, "mol -v");
        System.err.println(out.length + " byte(s): " + new String(out));
    }

    public static final String[] exportMoleculesToArray(Object molecules, String outFormat) throws Exception {
        if (molecules == null) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>();
        if (molecules instanceof Molecule[]) {
            Molecule[] mols = (Molecule[])molecules;
            for (int ix = 0; ix < mols.length; ++ix) {
                String s = MolExporter.exportToFormat(mols[ix], outFormat);
                l.add(s);
            }
            String[] r = new String[l.size()];
            l.toArray(r);
            return r;
        }
        if (molecules instanceof Molecule) {
            Molecule mol = (Molecule)molecules;
            return new String[]{MolExporter.exportToFormat(mol, outFormat)};
        }
        return null;
    }

    private static class CombinedFpMakerCache
    extends CachedPools {
        private CombinedFpMakerCache() {
        }

        @Override
        public Object createPoolItem(Object key) throws Exception {
            int reactionTableType;
            MolPropQueryParams molPropQueryParams = (MolPropQueryParams)key;
            String structFPConfig = molPropQueryParams.getStructFPConfig();
            String stdrConfig = molPropQueryParams.getStdrConfig();
            int numBits = molPropQueryParams.getFpProps()[0];
            int intCount = BinaryDataUtil.translateBitCountToIntCount(numBits);
            int tableType = molPropQueryParams.getTableType();
            boolean reactionTable = tableType == (reactionTableType = 1);
            return new CombinedFingerprint(molPropQueryParams.getNrStructFPCols(), structFPConfig, Pools.getCreateStandardizer(stdrConfig), intCount, molPropQueryParams.getFpProps()[2], molPropQueryParams.getFpProps()[1], reactionTable);
        }
    }

    public static class MolPropQueryParams {
        private int tableType = -1;
        private String stdrConfig;
        private String stdrConfigParam;
        private int[] fpProps;
        private boolean compressTarget;
        private int nrStructFPCols;
        private String structFPConfig;
        private String flags;
        private boolean haltOnBadFormat;
        private String[][] userDefColMap;
        public String[][] molDescList;
        private boolean isMarkush;

        public boolean isHaltOnBadFormat() {
            return this.haltOnBadFormat;
        }

        public void setHaltOnBadFormat(boolean haltOnBadFormat) {
            this.haltOnBadFormat = haltOnBadFormat;
        }

        public String getFlags() {
            return this.flags;
        }

        public void setFlags(String flags) {
            this.flags = flags;
        }

        public String getStdrConfig() {
            return this.stdrConfig;
        }

        public void setStdrConfig(String stdrConfig) {
            this.stdrConfig = stdrConfig;
        }

        public String getStdrConfigParam() {
            return this.stdrConfigParam;
        }

        public void setStdrConfigParam(String stdrConfigParam) {
            this.stdrConfigParam = stdrConfigParam;
        }

        public int[] getFpProps() {
            return this.fpProps;
        }

        public void setFpProps(int[] fpProps) {
            this.fpProps = fpProps;
        }

        public String toString() {
            return this.getClass().getName() + "[stdrConfig=" + this.stdrConfig + ", stdrConfigParam=" + this.stdrConfigParam + ", fpProps=[" + this.fpProps[0] + ", " + this.fpProps[1] + ", " + this.fpProps[2] + "]]";
        }

        public int getNrStructFPCols() {
            return this.nrStructFPCols;
        }

        public void setNrStructFPCols(int nrStructFPCols) {
            this.nrStructFPCols = nrStructFPCols;
        }

        public String getStructFPConfig() {
            return this.structFPConfig;
        }

        public void setStructFPConfig(String structFPConfig) {
            this.structFPConfig = structFPConfig;
        }

        public int hashCode() {
            if (this.structFPConfig != null) {
                return this.structFPConfig.hashCode();
            }
            return (this.fpProps[0] + ";" + this.fpProps[1] + ";" + this.fpProps[2]).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof MolPropQueryParams) {
                MolPropQueryParams other = (MolPropQueryParams)obj;
                if (this.fpProps.length != other.fpProps.length) {
                    return false;
                }
                for (int ix = 0; ix < this.fpProps.length; ++ix) {
                    if (this.fpProps[ix] == other.fpProps[ix]) continue;
                    return false;
                }
                if (logger.isLoggable(Level.FINEST)) {
                    StringBuffer b = new StringBuffer();
                    b.append("this.stdrConfig=");
                    b.append(this.stdrConfig);
                    b.append(", other.stdrConfig=");
                    b.append(other.stdrConfig);
                    b.append(", this.stdrConfigParam=");
                    b.append(this.stdrConfigParam);
                    b.append(", other.stdrConfigParam=");
                    b.append(other.stdrConfigParam);
                    b.append(", this.nrStructFPCols=");
                    b.append(this.nrStructFPCols);
                    b.append(", other.nrStructFPCols=");
                    b.append(other.nrStructFPCols);
                    b.append(", this.structFPConfig=");
                    b.append(this.structFPConfig);
                    b.append(", other.structFPConfig=");
                    b.append(other.structFPConfig);
                    logger.finest(b.toString());
                }
                if (!this.eq(this.stdrConfig, other.stdrConfig)) {
                    return false;
                }
                if (!this.eq(this.stdrConfigParam, other.stdrConfigParam)) {
                    return false;
                }
                if (this.nrStructFPCols != other.nrStructFPCols) {
                    return false;
                }
                if (!this.eq(this.structFPConfig, other.structFPConfig)) {
                    return false;
                }
            }
            return true;
        }

        private boolean eq(Object a, Object b) {
            if (a == null && b != null) {
                return false;
            }
            if (b == null && a != null) {
                return false;
            }
            if (a == null && b == null) {
                return true;
            }
            return a.equals(b);
        }

        public boolean isCompressTarget() {
            return this.compressTarget;
        }

        public void setCompressTarget(boolean compressTarget) {
            this.compressTarget = compressTarget;
        }

        public synchronized String[][] getUserDefColMap() {
            return this.userDefColMap;
        }

        public synchronized void setUserDefColMap(String[][] userDefColMap) {
            this.userDefColMap = userDefColMap;
        }

        public String[][] getMolDescList() {
            return this.molDescList;
        }

        public void setMolDescList(String[][] molDescList) {
            this.molDescList = molDescList;
        }

        public int getTableType() {
            return this.tableType;
        }

        public void setTableType(int tableType) {
            this.tableType = tableType;
        }

        public boolean isMarkush() {
            return this.isMarkush;
        }

        public void setMarkush(boolean isMarkush) {
            this.isMarkush = isMarkush;
        }
    }
}

