/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.interop;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;

public class InteropUtil {
    private static ByteArrayOutputStream mdFpTmpBuffer = new ByteArrayOutputStream();
    public static final String CUSTOM_OUTMOL_SEP = "{OUTMOL_STOP}";

    private InteropUtil() {
    }

    public static String getTableBaseName(String tableName) {
        int dotPos = tableName.indexOf(46);
        if (dotPos != -1) {
            return tableName.substring(dotPos + 1);
        }
        return tableName;
    }

    public static String mdByteArrayToString(byte[] bytes) {
        StringBuffer sbuffer = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            sbuffer.append(Byte.toString(b)).append('\t');
        }
        return sbuffer.toString();
    }

    public static byte[] mdDataStringToBytes(String mdFpString) {
        mdFpTmpBuffer.reset();
        StringTokenizer fpTokenizer = new StringTokenizer(mdFpString, "\t");
        while (fpTokenizer.hasMoreTokens()) {
            String byteString = fpTokenizer.nextToken();
            byte b = Byte.parseByte(byteString);
            mdFpTmpBuffer.write(b);
        }
        return mdFpTmpBuffer.toByteArray();
    }

    public static void main(String[] args) throws Exception {
        byte[] bytes = new byte[255];
        for (int i = 0; i < 255; ++i) {
            bytes[i] = (byte)i;
        }
        String tmp = InteropUtil.mdByteArrayToString(bytes);
        byte[] result = InteropUtil.mdDataStringToBytes(tmp);
        System.err.println(result);
        for (int i = 0; i < result.length; ++i) {
            if (result.length != bytes.length) {
                throw new Exception("result.length=" + result.length + ", byte.length=" + bytes.length);
            }
            if (result[i] == bytes[i]) continue;
            throw new Exception("result[" + i + "]=" + result[i] + ", but bytes[" + i + "]=" + bytes[i]);
        }
        System.err.println("OK");
    }

    public static String[] parseStringList(String str, String separator) {
        if (str == null) {
            return null;
        }
        ArrayList<String> strList = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(str, separator);
        while (tokenizer.hasMoreTokens()) {
            strList.add(tokenizer.nextToken());
        }
        if (strList.size() == 0) {
            return null;
        }
        return strList.toArray(new String[strList.size()]);
    }

    public static String flattenStringArrays(String[][] sa) {
        if (sa == null) {
            return "null";
        }
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < sa.length; ++i) {
            String[] strings = sa[i];
            if (strings == null) {
                b.append("null");
            } else {
                for (int j = 0; j < strings.length; ++j) {
                    if (j > 0) {
                        b.append(",");
                    }
                    String string = strings[j];
                    b.append(string);
                }
            }
            if (i <= 0) continue;
            b.append(";");
        }
        return b.toString();
    }

    public static String flattenStringArray(String[] sa) {
        if (sa == null) {
            return "null";
        }
        StringBuffer b = new StringBuffer();
        String[] strings = sa;
        for (int j = 0; j < strings.length; ++j) {
            if (j > 0) {
                b.append(",");
            }
            String string = strings[j];
            b.append(string);
        }
        return b.toString();
    }

    public static int[] parseIntList(String str, String separator) {
        if (str == null) {
            return null;
        }
        ArrayList<String> intList = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(str, separator);
        while (tokenizer.hasMoreTokens()) {
            intList.add(tokenizer.nextToken());
        }
        int[] intArray = new int[intList.size()];
        for (int ix = 0; ix < intList.size(); ++ix) {
            intArray[ix] = Integer.parseInt((String)intList.get(ix));
        }
        return intArray;
    }

    public static String getStackTrace(Throwable tbl) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        tbl.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public static void throwRtWithStackTrace(Throwable tbl) {
        throw new RuntimeException(InteropUtil.getStackTrace(tbl));
    }

    public static NumberFormat getNumberFormat() {
        NumberFormat nf = NumberFormat.getInstance(Locale.getDefault());
        nf.setMaximumFractionDigits(30);
        nf.setGroupingUsed(false);
        return nf;
    }
}

