/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.interop;

import chemaxon.sss.search.JChemSearchOptions;
import chemaxon.util.CxOptions;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JChemSearchOptionsAdapter
extends JChemSearchOptions {
    private static final Logger logger = Logger.getLogger(JChemSearchOptionsAdapter.class.getName());
    private boolean requireCommit = true;
    private String earlyResults;

    public JChemSearchOptionsAdapter(int searchType) {
        super(searchType);
    }

    public JChemSearchOptionsAdapter(String options) {
        super(2);
        this.setOptions(options);
    }

    @Override
    public void setOption(String name, String value) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("name=" + name + ", value=" + value);
        }
        if (name == null) {
            throw new IllegalArgumentException("optionName must not be null");
        }
        if (value == null) {
            return;
        }
        if (!name.equalsIgnoreCase("threadCnt")) {
            if (name.equalsIgnoreCase("earlyResults")) {
                this.earlyResults = value;
            } else if (name.equalsIgnoreCase("requireCommit")) {
                this.requireCommit = CxOptions.getBooleanValue("requireCommit", value, true);
            } else if (!(name.equalsIgnoreCase("transport") || name.equalsIgnoreCase("usrOpId") || name.equalsIgnoreCase("indexCost") || name.equalsIgnoreCase("funcCost"))) {
                if (name.equalsIgnoreCase("ignoreMixtureBrackets")) {
                    boolean b = CxOptions.getBooleanValue(name, value, false);
                    this.setMixSgroupMatching(!b);
                } else if (name.equalsIgnoreCase("screenConfig")) {
                    this.setDescriptorConfig(value);
                } else if (name.equalsIgnoreCase("ctFilter")) {
                    this.setChemTermsFilter(value);
                } else if (name.equalsIgnoreCase("filterQuery")) {
                    this.setFilterQuery(value);
                } else if (name.equalsIgnoreCase("simThreshold")) {
                    this.setDissimilarityThreshold(1.0f - Float.parseFloat(value));
                } else {
                    if (name.equalsIgnoreCase("resultTimeout")) {
                        return;
                    }
                    super.setOption(name, value);
                }
            }
        }
    }

    public boolean isRequireCommit() {
        return this.requireCommit;
    }

    public String getEarlyResults() {
        return this.earlyResults;
    }
}

