/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.interop.reactor;

import chemaxon.util.CxOptions;

public class InteropReactOption {
    public static final InteropReactOption METHOD = new InteropReactOption("method");
    public static final InteropReactOption MAPPING_STYLE = new InteropReactOption("mappingStyle");
    public static final InteropReactOption PERMUTE_REACTANTS = new InteropReactOption("permuteReactants");
    public static final InteropReactOption REACTANT_MATCHING = new InteropReactOption("reactantMatching");
    public static final InteropReactOption EXTRACT = new InteropReactOption("extract");
    public static final InteropReactOption OUTFORMAT = new InteropReactOption("outFormat");
    public static final InteropReactOption REACTION_ID = new InteropReactOption("reactionId");
    public static final InteropReactOption REACTION_ID_TAG = new InteropReactOption("reactionIdTag");
    public static final InteropReactOption REACTANT_IDS = new InteropReactOption("reactantIds");
    public static final InteropReactOption REACTANT_ID_TAGS = new InteropReactOption("reactantIdTags");
    public static final InteropReactOption PRODUCT_ID_TAG = new InteropReactOption("productIdTag");
    public static final InteropReactOption PRODUCT_TABLE = new InteropReactOption("productTable");
    public static final InteropReactOption PRODUCT_TABLE_JCPT = new InteropReactOption("productTableJcpt");
    public static final InteropReactOption PRODUCT_COLNAME = new InteropReactOption("productColName");
    public static final InteropReactOption PRODUCT_ID_COLNAME = new InteropReactOption("productIdColName");
    public static final InteropReactOption STANDARDIZER = new InteropReactOption("standardizer");
    public static final InteropReactOption PRODUCT_STANDARDIZER = new InteropReactOption("productStandardizer");
    public static final InteropReactOption REVERSE = new InteropReactOption("reverse");
    public static final InteropReactOption UNAMBIGUOUS_REACTIONS = new InteropReactOption("unambiguousReactionsOnly");
    public static final InteropReactOption IGNORE_RULES = new InteropReactOption("ignoreRules");
    public static final InteropReactOption IGNORE_ERRORS = new InteropReactOption("ignoreErrors");
    public static final InteropReactOption ALLOW_DUPL_PRODUCTS = new InteropReactOption("allowDuplProdLists");
    public static final InteropReactOption REMOVE_DUPL_PROD_REFS = new InteropReactOption("removeDuplProdRefs");
    public static final InteropReactOption OUTPUT_TYPE = new InteropReactOption("outputType");
    public static final InteropReactOption OUT_REACTION_MAPSTYLE = new InteropReactOption("outputReactionMappingStyle");
    public static final InteropReactOption RATIO = new InteropReactOption("ratio");
    private static String[] names;
    private static InteropReactOption[] all;
    private String name;

    private InteropReactOption(String name) {
        this.name = name;
        InteropReactOption.addOptionName(name);
        InteropReactOption.addOption(this);
    }

    public String getStringValue(CxOptions jcOptions) {
        return jcOptions.getStringValue(this.name);
    }

    public boolean getBooleanValue(CxOptions jcOptions, boolean defaultValue) {
        return jcOptions.getBoolValue(this.name, defaultValue);
    }

    public char[] getValue(CxOptions jcOptions) {
        return jcOptions.getValue(this.name);
    }

    public String getName() {
        return this.name;
    }

    private static synchronized void addOptionName(String name) {
        if (names == null) {
            names = new String[1];
            InteropReactOption.names[0] = name;
        } else {
            int len = names.length;
            String[] tmp = new String[len + 1];
            System.arraycopy(names, 0, tmp, 0, len);
            tmp[len] = name;
            names = tmp;
        }
    }

    private static synchronized void addOption(InteropReactOption option) {
        if (all == null) {
            all = new InteropReactOption[1];
            InteropReactOption.all[0] = option;
        } else {
            int len = all.length;
            InteropReactOption[] tmp = new InteropReactOption[len + 1];
            System.arraycopy(all, 0, tmp, 0, len);
            tmp[len] = option;
            all = tmp;
        }
    }

    public static String[] getNames() {
        return names;
    }

    public static InteropReactOption[] getAll() {
        return all;
    }
}

