/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.interop.reactor;

import chemaxon.jchem.interop.InteropUtil;
import chemaxon.jchem.interop.reactor.InteropReactOption;
import chemaxon.reaction.Reactor;
import chemaxon.struc.Molecule;
import chemaxon.util.CxOptions;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SynthCodeInfo {
    private static Logger logger = Logger.getLogger(SynthCodeInfo.class.getName());
    private String reactionId;
    private String reactionIdTag;
    private int reactantCount;
    private String[] reactantIdTags;
    private String unifiedReactantIdTag;
    private String[] myProductIdTags;
    private String[] productIdTags;
    private Random random = new Random(System.currentTimeMillis());

    public SynthCodeInfo(CxOptions opts, int reactantCount) {
        this.reactantCount = reactantCount;
        this.reactionId = SynthCodeInfo.getReactionId(opts);
        this.reactionIdTag = SynthCodeInfo.getReactionIdTag(opts);
        this.setReactantIdTags(opts);
        this.initProductIdTags(opts);
        if (this.reactionId != null && this.reactionIdTag != null) {
            throw new IllegalArgumentException("Specify either " + InteropReactOption.REACTION_ID.getName() + " or " + InteropReactOption.REACTION_ID_TAG.getName() + ", not both.");
        }
    }

    private void initProductIdTags(CxOptions opts) {
        this.productIdTags = InteropUtil.parseStringList(InteropReactOption.PRODUCT_ID_TAG.getStringValue(opts), ",");
        if (this.myProductIdTags == null) {
            if (this.productIdTags == null) {
                this.myProductIdTags = new String[1];
                this.myProductIdTags[0] = "myproductid";
            } else {
                this.myProductIdTags = new String[this.productIdTags.length];
                for (int i = 0; i < this.productIdTags.length; ++i) {
                    String productIdTag;
                    this.myProductIdTags[i] = productIdTag = this.productIdTags[i];
                }
            }
        }
    }

    public synchronized void setReactantIdTags(CxOptions jcOptions) {
        String newReactantIdTagList = InteropReactOption.REACTANT_ID_TAGS.getStringValue(jcOptions);
        if (newReactantIdTagList == null || newReactantIdTagList.length() == 0) {
            if (this.reactantIdTags == null) {
                this.reactantIdTags = new String[this.reactantCount];
            }
            return;
        }
        this.reactantIdTags = InteropUtil.parseStringList(newReactantIdTagList, ",");
    }

    public void setReactantIdsAsTags(Molecule[] reactants, String[] reactantIds) throws Exception {
        if (reactantIds != null) {
            for (int ix = 0; ix < reactantIds.length; ++ix) {
                Molecule mol = reactants[ix];
                this.getCreateReactantIdTag(ix, mol);
                mol.setProperty(this.reactantIdTags[ix], reactantIds[ix]);
            }
        }
    }

    public String getCreateReactantIdTag(int rtantIndex, Molecule reactant) throws Exception {
        if (this.reactantIdTags[rtantIndex] != null) {
            return this.reactantIdTags[rtantIndex];
        }
        String myStamp = String.valueOf(System.currentTimeMillis());
        String tag = "__genreactanttagid_" + myStamp;
        String prop = reactant.getProperty(tag);
        int count = 0;
        while (prop != null) {
            if (count++ > 1000) {
                throw new Exception("No free mol property for reactant id tag after the 1000th trial.");
            }
            tag = "__genreactanttagid_" + myStamp + "_" + this.random.nextInt(100000);
            prop = reactant.getProperty(tag);
        }
        this.reactantIdTags[rtantIndex] = tag;
        return tag;
    }

    private void unifyReactantIdTags(Molecule[] reactants) {
        int i;
        String tmpIdTag = null;
        if (this.reactantIdTags[0] == null) {
            return;
        }
        for (i = 0; i < this.reactantIdTags.length; ++i) {
            String rtantIdTag = this.reactantIdTags[i];
            if (i == 0) {
                tmpIdTag = rtantIdTag;
                continue;
            }
            if (tmpIdTag.equalsIgnoreCase(rtantIdTag)) continue;
            tmpIdTag = null;
            break;
        }
        if (tmpIdTag != null) {
            this.unifiedReactantIdTag = tmpIdTag;
        }
        while (tmpIdTag == null) {
            tmpIdTag = "__genunifiedRtantIdTag";
            String myStamp = System.currentTimeMillis() + "" + this.random.nextInt(100000);
            block2: for (int i2 = 0; i2 < reactants.length; ++i2) {
                Molecule rtant = reactants[i2];
                while (rtant.getProperty(tmpIdTag) != null) {
                    if (i2 > 0) {
                        tmpIdTag = null;
                        continue block2;
                    }
                    tmpIdTag = tmpIdTag + myStamp;
                }
            }
        }
        this.unifiedReactantIdTag = tmpIdTag;
        for (i = 0; i < reactants.length; ++i) {
            Molecule rtant = reactants[i];
            String rtantId = rtant.getProperty(this.reactantIdTags[i]);
            rtant.setProperty(this.unifiedReactantIdTag, rtantId);
        }
    }

    public String[] getProductIds(Molecule[] products) {
        String[] productIds = new String[products.length];
        for (int i = 0; i < products.length; ++i) {
            Molecule product = products[i];
            String productIdTag = this.myProductIdTags[0];
            if (this.myProductIdTags.length > 1) {
                productIdTag = this.myProductIdTags[i];
            }
            productIds[i] = product.getProperty(productIdTag);
            if (!logger.isLoggable(Level.FINEST)) continue;
            logger.finest("product id '" + productIds[i] + "' is returned for " + productIdTag);
        }
        return productIds;
    }

    public void setComponentIDPropertyNames(Reactor reactor) {
        reactor.setComponentIDPropertyNames(this.reactantIdTags, this.myProductIdTags);
    }

    public void setComponentIDPropertyNamesUnified(Reactor reactor, Molecule[] reactants) {
        this.unifyReactantIdTags(reactants);
        if (logger.isLoggable(Level.FINEST)) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.myProductIdTags.length; ++i) {
                String tag = this.myProductIdTags[i];
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append(tag);
            }
            logger.finest("Setting " + this.unifiedReactantIdTag + ", " + sb.toString());
        }
        reactor.setComponentIDPropertyNames(new String[]{this.unifiedReactantIdTag}, this.myProductIdTags);
    }

    public synchronized String getReactionId() {
        return this.reactionId;
    }

    public synchronized String getReactionIdTag() {
        return this.reactionIdTag;
    }

    private static String getReactionId(CxOptions options) {
        return InteropReactOption.REACTION_ID.getStringValue(options);
    }

    private static String getReactionIdTag(CxOptions options) {
        return InteropReactOption.REACTION_ID_TAG.getStringValue(options);
    }

    public static String getReactionId(Molecule mol, CxOptions options) {
        String reactionId = SynthCodeInfo.getReactionId(options);
        String reactionIdTag = SynthCodeInfo.getReactionIdTag(options);
        if (reactionIdTag != null && mol != null) {
            reactionId = mol.getProperty(reactionIdTag);
        }
        return reactionId;
    }
}

