/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.regsys;

import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.StructureTableOptions;
import chemaxon.jchem.db.UpdateHandler;
import chemaxon.util.ConnectionHandler;
import java.sql.SQLException;
import java.sql.Statement;

public class CreateDatabase {
    public static void main(String[] args) {
        String driverName = "oracle.jdbc.driver.OracleDriver";
        try {
            Class.forName(driverName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        String serverName = "10.0.0.30";
        String portNumber = "1521";
        String sid = "mydb";
        String url = "jdbc:oracle:thin:@" + serverName + ":" + portNumber + ":" + sid;
        String username = "compregsys2";
        String password = "tiger";
        ConnectionHandler ch = new ConnectionHandler();
        ch.setDriver(driverName);
        ch.setUrl(url);
        ch.setLoginName(username);
        ch.setPassword(password);
        try {
            ch.connect();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        CreateDatabase.createPropertyTable(ch);
        CreateDatabase.dropThenCreateStructureTable(ch, "Structures", ", RegistrationID VARCHAR2(30), PrimaryFlag NUMBER(1), SaltFlag NUMBER(1), SolventFlag NUMBER(1), AuxFlag NUMBER(1), ReagentFlag NUMBER(1), SaltCode VARCHAR2(5), SolventCode VARCHAR2(5), AuxCode VARCHAR2(5), ReagentCode VARCHAR2(5), Name VARCHAR2(30)");
        CreateDatabase.dropThenCreateStructureTable(ch, "Compounds", ", DisplayedRegistrationID VARCHAR2(30), UserID Number(10), RegistrationTaskID NUMBER(10), RegistrationTimestamp DATE, Registrar VARCHAR2(20)");
        CreateDatabase.dropThenCreateStructureTable(ch, "OriginalStructures", ", CmpdID NUMBER(10), OrigCode VARCHAR2(100)");
        CreateDatabase.dropThenCreateRelationalTable(ch, "Components", "ComponentID NUMBER(10) PRIMARY KEY NOT NULL, CmpdID NUMBER(10), StrID NUMBER(10), ComponentType VARCHAR2(10), ComponentPctg NUMBER(4,2)");
        CreateDatabase.dropThenCreateStructureTable(ch, "StructuresTemp", ", RegistrationID VARCHAR2(30), PrimaryFlag NUMBER(1), SaltFlag NUMBER(1), SolventFlag NUMBER(1), AuxFlag NUMBER(1), ReagentFlag NUMBER(1), SaltCode VARCHAR2(5), SolventCode VARCHAR2(5), AuxCode VARCHAR2(5), ReagentCode VARCHAR2(5), Name VARCHAR2(30)");
        CreateDatabase.dropThenCreateStructureTable(ch, "CompoundsTemp", ", DisplayedRegistrationID VARCHAR2(30), UserID NUMBER(10), RegistrationTaskID NUMBER(10), RegistrationTimestamp DATE, Status VARCHAR2(20)");
        CreateDatabase.dropThenCreateStructureTable(ch, "OriginalStructuresTemp", ", CmpdID NUMBER(10), OrigCode VARCHAR2(100)");
        CreateDatabase.dropThenCreateRelationalTable(ch, "ComponentsTemp", "ComponentID NUMBER(10) PRIMARY KEY NOT NULL, CmpdID NUMBER(10), StrID NUMBER(10), StrType VARCHAR2(1), ComponentType VARCHAR2(10), ComponentPctg NUMBER(4,2)");
        CreateDatabase.dropThenCreateRelationalTable(ch, "RegistrationTask", "ID NUMBER(10) PRIMARY KEY NOT NULL, UserID NUMBER(10), TaskStartTime DATE");
        try {
            ch.getConnection().commit();
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        try {
            ch.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private static void createPropertyTable(ConnectionHandler ch) {
        try {
            DatabaseProperties.createPropertyTable(ch);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private static void dropThenCreateStructureTable(ConnectionHandler ch, String tableName, String extraColumnDefinitions) {
        try {
            UpdateHandler.dropStructureTable(ch, tableName);
        }
        catch (SQLException e) {
            // empty catch block
        }
        StructureTableOptions sto = new StructureTableOptions();
        sto.name = tableName;
        sto.extraColumnDefinitions = extraColumnDefinitions;
        sto.structureColumnType = 0;
        sto.tableType = 0;
        sto.standardizerConfig = null;
        sto.fp_numberOfInts = 8;
        try {
            UpdateHandler.createStructureTable(ch, sto);
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
    }

    private static void dropThenCreateRelationalTable(ConnectionHandler ch, String tableName, String columnsOptions) {
        Statement st;
        try {
            st = ch.getConnection().createStatement();
            st.executeUpdate("DROP TABLE " + tableName);
            st = ch.getConnection().createStatement();
            st.executeUpdate("DROP SEQUENCE " + tableName + "_SEQ");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            st = ch.getConnection().createStatement();
            st.executeUpdate("CREATE TABLE " + tableName + "(" + columnsOptions + ")");
            st = ch.getConnection().createStatement();
            st.executeUpdate("CREATE SEQUENCE " + tableName + "_SEQ");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

