/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.regsys;

import chemaxon.formats.MolImporter;
import chemaxon.jchem.regsys.RegistrationException;
import chemaxon.jchem.regsys.cmpdreg.BatchRegistration;
import chemaxon.jchem.regsys.cmpdreg.CompoundRegistration;
import chemaxon.jchem.regsys.cmpdreg.RegistrationInputRecord;
import chemaxon.jchem.regsys.cmpdreg.result.CompoundRegistrationResult;
import chemaxon.struc.Molecule;
import chemaxon.util.ConnectionHandler;
import java.io.IOException;

public class TestThread
extends Thread {
    private MolImporter privmi;
    private ConnectionHandler ch;
    private static int count = 0;
    private static Object lock = new Object();
    private static long starttime = System.currentTimeMillis();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Molecule read() throws IOException {
        Object object = lock;
        synchronized (object) {
            return this.privmi.read();
        }
    }

    public TestThread(MolImporter mi, ConnectionHandler conh) {
        this.privmi = mi;
        this.ch = conh;
    }

    public static void writeout() {
        if (++count % 1000 == 0) {
            System.out.println();
            System.out.println("" + count + " " + (System.currentTimeMillis() - starttime));
        }
    }

    @Override
    public void run() {
        try {
            CompoundRegistration cr = new CompoundRegistration(this.ch, null);
            BatchRegistration br = new BatchRegistration(this.ch);
            Molecule m = this.read();
            while (m != null) {
                if (!m.toFormat("smarts").equals("")) {
                    try {
                        CompoundRegistrationResult crr = cr.register(new RegistrationInputRecord(m));
                        try {
                            String batchResult = br.register(crr);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    catch (RegistrationException e) {
                        e.printStackTrace();
                    }
                }
                TestThread.writeout();
                m = this.read();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

