/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.regsys.registrar;

import chemaxon.jchem.db.PropertyNotSetException;
import chemaxon.jchem.db.UpdateHandler;
import chemaxon.struc.Molecule;
import chemaxon.util.ConnectionHandler;
import java.sql.SQLException;
import java.sql.Statement;

public class FinalAreaTasks {
    private ConnectionHandler ch;

    public FinalAreaTasks(ConnectionHandler conh) {
        this.ch = conh;
    }

    public int addSalt(Molecule mol) throws SQLException, PropertyNotSetException {
        if (mol == null) {
            return 0;
        }
        if (mol.findFrags().length > 1) {
            System.err.println("Not a single fragment molecule: " + mol.toFormat("smarts"));
            return -1;
        }
        UpdateHandler uh = new UpdateHandler(this.ch, 1, "StructuralUnits", "PrimaryRegistrationID, PrimaryFlag, SaltFlag, SolventFlag, AuxFlag, ReagentFlag, SaltCode, SolventCode, AuxCode, ReagentCode");
        uh.setDuplicateFiltering(true);
        uh.setValueForAdditionalColumn(1, null);
        uh.setValueForAdditionalColumn(2, "0");
        uh.setValueForAdditionalColumn(3, "1");
        uh.setValueForAdditionalColumn(7, "SALT");
        uh.setValueForAdditionalColumn(4, "0");
        uh.setValueForAdditionalColumn(8, null);
        uh.setValueForAdditionalColumn(5, "0");
        uh.setValueForAdditionalColumn(9, null);
        uh.setValueForAdditionalColumn(6, "0");
        uh.setValueForAdditionalColumn(10, null);
        uh.setStructure(mol.toFormat("mrv"));
        int lastStrID = uh.execute(true);
        uh.close();
        return lastStrID;
    }

    public int addSolvent(Molecule mol) throws SQLException, PropertyNotSetException {
        System.out.println("OK1");
        if (mol == null) {
            return 0;
        }
        System.out.println("OK2");
        if (mol.findFrags().length > 1) {
            System.err.println("Not a single fragment molecule: " + mol.toFormat("smarts"));
            return -1;
        }
        System.out.println("OK3");
        UpdateHandler uh = new UpdateHandler(this.ch, 1, "StructuralUnits", "PrimaryRegistrationID, PrimaryFlag, SaltFlag, SolventFlag, AuxFlag, ReagentFlag, SaltCode, SolventCode, AuxCode, ReagentCode");
        uh.setDuplicateFiltering(true);
        uh.setValueForAdditionalColumn(1, null);
        uh.setValueForAdditionalColumn(2, "0");
        uh.setValueForAdditionalColumn(3, "0");
        uh.setValueForAdditionalColumn(7, null);
        uh.setValueForAdditionalColumn(4, "1");
        uh.setValueForAdditionalColumn(8, "SOLV");
        uh.setValueForAdditionalColumn(5, "0");
        uh.setValueForAdditionalColumn(9, null);
        uh.setValueForAdditionalColumn(6, "0");
        uh.setValueForAdditionalColumn(10, null);
        System.out.println("OK4");
        System.out.println("OK5");
        uh.setStructure(mol.toFormat("mrv"));
        System.out.println("OK6");
        int lastStrID = uh.execute(true);
        uh.close();
        System.out.println("Yes: " + lastStrID);
        return lastStrID;
    }

    public void clearAll() throws SQLException {
        UpdateHandler.deleteRows(this.ch, "Structures", "");
        UpdateHandler.deleteRows(this.ch, "StructuresTemp", "");
        UpdateHandler.deleteRows(this.ch, "Compounds", "");
        UpdateHandler.deleteRows(this.ch, "CompoundsTemp", "");
        Statement st = this.ch.getConnection().createStatement();
        st.executeUpdate("DELETE FROM ComponentsTemp");
        st.close();
        st = this.ch.getConnection().createStatement();
        st.executeUpdate("DELETE FROM Components");
        st.close();
    }
}

