/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.regsys.search;

import chemaxon.formats.MolFormatException;
import chemaxon.jchem.db.DatabaseSearchException;
import chemaxon.jchem.db.JChemSearch;
import chemaxon.jchem.db.PropertyNotSetException;
import chemaxon.sss.search.JChemSearchOptions;
import chemaxon.struc.Molecule;
import chemaxon.util.ConnectionHandler;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class RegistrationSearchBase {
    protected ConnectionHandler ch;

    protected int[] idsInDatabase(Molecule mol, String tableName, String filter) throws MolFormatException, DatabaseSearchException, SQLException, IOException, PropertyNotSetException {
        JChemSearch s = new JChemSearch();
        s.setQueryStructure(mol);
        s.setConnectionHandler(this.ch);
        s.setStructureTable(tableName);
        JChemSearchOptions so = new JChemSearchOptions(5);
        if (filter != null) {
            so.setFilterQuery("SELECT CD_ID FROM " + tableName + " " + filter);
        }
        s.setSearchOptions(so);
        s.setRunMode(0);
        s.run();
        return s.getResults();
    }

    protected void insertIntoComponents(int cmpdID, int strID, String type, String componentType, float pctg, String tableName) throws SQLException {
        Statement st = this.ch.getConnection().createStatement();
        String query = "INSERT INTO " + tableName + " VALUES(" + tableName + "_SEQ.NEXTVAL, " + cmpdID + ", " + strID + ", '";
        if (type != null) {
            query = query + type + "', '";
        }
        query = query + componentType + "', " + pctg + ")";
        st.executeQuery(query);
        st.close();
    }
}

