/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jep;

import chemaxon.common.util.BasicEnvironment;
import chemaxon.marvin.util.ExternalFileLoader;
import chemaxon.util.DotfileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigurationReader {
    private static Logger logger = Logger.getLogger(ConfigurationReader.class.getName());

    public static InputStream getResourceAsStream(Class<?> cl, String path) {
        return cl != null && path != null ? BasicEnvironment.getResourceAsStream(cl, path) : null;
    }

    public static InputStream getConfigAsStream(String path) {
        block3: {
            if (path != null) {
                try {
                    return new ExternalFileLoader(path).openFileOutJar();
                }
                catch (SecurityException e) {
                    if (!logger.isLoggable(Level.WARNING)) break block3;
                    logger.log(Level.WARNING, "Cannot read file: '" + path + "'. Access denied.", e);
                }
            }
        }
        return null;
    }

    public static InputStream getUserConfigAsStream(String path) {
        block5: {
            if (path != null) {
                String fullPath = DotfileUtil.getDotDirName() + File.separator + path;
                try {
                    return new FileInputStream(DotfileUtil.getDotFile(path));
                }
                catch (FileNotFoundException e) {
                    if (logger.isLoggable(Level.CONFIG)) {
                        logger.log(Level.CONFIG, "File not found: '" + fullPath + "'.");
                    }
                }
                catch (SecurityException e) {
                    if (!logger.isLoggable(Level.WARNING)) break block5;
                    logger.log(Level.WARNING, "Cannot read file in user home directory: '" + fullPath + "'. Access denied.", e);
                }
            }
        }
        return null;
    }
}

