/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jep;

import chemaxon.jep.ChemFunction;
import chemaxon.nfunk.jep.ParseException;
import java.util.Stack;

public class DissimilarityFunction
extends ChemFunction {
    private String className;
    protected String[] descriptors;
    private transient DissimilarityFunction df;

    protected DissimilarityFunction(String className, String[] descriptors) {
        super(-1);
        this.className = className;
        this.descriptors = descriptors;
    }

    protected void setDescriptors(String[] descriptors) {
        this.descriptors = descriptors;
    }

    private DissimilarityFunction newSubClassInstance(String subClassName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        DissimilarityFunction f = (DissimilarityFunction)Class.forName(subClassName).newInstance();
        f.setJEP(this.getJEP());
        f.setCurNumberOfParameters(this.curNumberOfParameters);
        f.setDescriptors(this.descriptors);
        return f;
    }

    @Override
    public void run(Stack s) throws ParseException {
        try {
            if (this.df == null) {
                this.df = this.newSubClassInstance(this.className);
            }
            this.df.run(s);
        }
        catch (ClassNotFoundException e) {
            throw new ParseException("Class not found: " + this.className, e);
        }
        catch (ClassCastException e) {
            throw new ParseException(e);
        }
        catch (IllegalAccessException e) {
            throw new ParseException(e);
        }
        catch (InstantiationException e) {
            throw new ParseException(e);
        }
    }
}

