/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jep;

import chemaxon.formats.MolExporter;
import chemaxon.formats.MolImporter;
import chemaxon.jep.CTFunctionData;
import chemaxon.jep.ChemFunction;
import chemaxon.jep.ChemJEP;
import chemaxon.jep.ConfigurationReader;
import chemaxon.jep.EvaluatorConfiguration;
import chemaxon.jep.EvaluatorFunction;
import chemaxon.jep.EvaluatorUtils;
import chemaxon.jep.FingerprintGenerator;
import chemaxon.jep.FunctionalGroup;
import chemaxon.jep.FunctionalGroupIterator;
import chemaxon.jep.Standardizer;
import chemaxon.jep.context.MolContext;
import chemaxon.marvin.util.ExternalFileLoader;
import chemaxon.marvin.version.VersionInfo;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.nfunk.jep.SymbolTable;
import chemaxon.nfunk.jep.function.PostfixMathCommandI;
import chemaxon.struc.Molecule;
import chemaxon.util.CLQ;
import chemaxon.util.ConfigUtils;
import chemaxon.util.DotfileUtil;
import chemaxon.util.StringUtil;
import chemaxon.util.XPathUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Evaluator
implements Serializable {
    private static final String lineSep = System.getProperty("line.separator");
    private static final String helptext = lineSep + "Evaluator, (C) 1999-2012 ChemAxon Ltd." + lineSep + "version " + VersionInfo.MARVIN_VERSION + lineSep + "Licenses of additionally used third party programs can be found in license.html" + lineSep + "Online version: http://www.chemaxon.com/marvin/license.html" + lineSep + "Evaluates Chemical Terms expressions." + lineSep + lineSep + "Usage:" + lineSep + "  evaluate [options] [input file(s)]" + lineSep + lineSep + "Options:" + lineSep + "  -h, --help                          this help message" + lineSep + "  -l, --list-functions                list Chemical Terms functions" + lineSep + lineSep + "Input Options:" + lineSep + "  -c, --config <filepath>             configuration XML file" + lineSep + "                                      (if omitted then default" + lineSep + "                                      configuration is applied)" + lineSep + "  -n, --no-input-mol                  expression should be evaluated" + lineSep + "                                      without input molecule" + lineSep + "  -e, --expr-string <str|filepath>    expression string or file" + lineSep + lineSep + "Output Options:" + lineSep + "  -o, --output <filepath>             output file path (default: stdout)" + lineSep + "  -g, --ignore-error                  continue with next molecule on error" + lineSep + "  -v, --verbose                       verbose output" + lineSep + "  -C, --clean <dim[:opts]>            clean output molecules (dim: 2 or 3)" + lineSep + "                                      with options" + lineSep + "                                      (default: t2000 - time limit: 2 sec)" + lineSep + "           (see http://www.chemaxon.com/marvin/help/sci/cleanoptions.html)" + lineSep + "  -f, --format <format>               output format if result is molecule" + lineSep + "                                      (default: smiles or smarts)" + lineSep + "                                      (ignores the output options below)" + lineSep + "  -x, --extract <format>              extract mode: write exactly those" + lineSep + "                                      molecules in the specified format that" + lineSep + "                                      satisfy the input boolean expression" + lineSep + "                                      (ignores the output options below)" + lineSep + "  -p, --precision <precision>         max. number of fractional digits" + lineSep + "                                      in the output (default: 2)" + lineSep + "  -S, --sdf-output                    SDF output (otherwise text output)" + lineSep + "  -t, --tag                           name of the SDFile tag to store the" + lineSep + "                                      evaluation result (default: CALC)" + lineSep + "  -i, --include-expr                  output expression string" + lineSep + lineSep + "Examples:" + lineSep + "  evaluate -e \"charge(2)\" m.mol" + lineSep + "  evaluate -e \"mass() > 200\" -x sdf -o o.sdf m.sdf" + lineSep + "  evaluate -e \"markushEnumerations()\" -f mrv -C 2:t5000 m.mrv" + lineSep + "  evaluate -e chemterm.txt -c Evaluator.xml -S -t TERM -o o.sdf m.sdf" + lineSep;
    private static final String EVALUATOR_TABLES_URL = "http://www.chemaxon.com/marvin/help/chemicalterms/EvaluatorTables.html";
    private static final String CHEMICAL_TERMS_FUNCTION_LIST_HELP_HEADER = lineSep + "Evaluator, (C) 1999-2012 ChemAxon Ltd." + lineSep + "version " + VersionInfo.MARVIN_VERSION + lineSep + lineSep + "List of Chemical Terms functions: " + lineSep + lineSep;
    private static final String CHEMICAL_TERMS_FUNCTION_LIST_HELP_FOOTER = lineSep + lineSep + "See: " + "http://www.chemaxon.com/marvin/help/chemicalterms/EvaluatorTables.html" + lineSep;
    private static final int MAX_LINE_LENGTH = 79;
    public static final String EVALUATOR_DEFAULTS_FILE = "evaluator.xml";
    public static final String EVALUATOR_NAMED_MOLS_FILE = "mols.smarts";
    public static final String CONFIG_DIR = "config";
    public static final String EVALUATOR_SCRIPT_FILE = "jep.script";
    public static final String DEFAULT_TAG_NAME = "CALC";
    private static final String FUNCTIONAL_GROUPS_RESOURCE_PATH = "/chemaxon/marvin/templates/functionalgroups.cxsmi";
    private static final String FUNCTIONAL_GROUPS_CONFIG_DIR_PATH = "config/marvin/templates/functionalgroups.cxsmi";
    private static final String FUNCTIONAL_GROUPS_USER_HOME_DIR_PATH = "marvin/templates/functionalgroups.cxsmi";
    private static FilenameFilter molsFilenameFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith("mols") && !name.endsWith("~");
        }
    };
    private EvaluatorConfiguration builtInConfig = null;
    private EvaluatorConfiguration externalConfig = null;
    private EvaluatorConfiguration userConfig = null;
    private EvaluatorConfiguration config = null;
    private Hashtable<String, PostfixMathCommandI> servicesFunctionTable = null;
    private SymbolTable symtab = new SymbolTable();
    private Hashtable<String, String> functionalGroupDisplayMolTable = new Hashtable();
    private boolean verbose = false;
    private String licenseEnvironment = "";

    public Evaluator() throws ParseException {
        this((File)null, (Standardizer)null);
    }

    public Evaluator(Standardizer standardizer) throws ParseException {
        this((File)null, standardizer);
    }

    public Evaluator(File file) throws ParseException {
        this(file, null);
    }

    public Evaluator(String configString) throws ParseException {
        this(configString, null);
    }

    public Evaluator(File file, Standardizer standardizer) throws ParseException {
        this(file, standardizer, null, null);
    }

    public Evaluator(File file, Standardizer standardizer, MolImporter importer, String script) throws ParseException {
        this.loadDefaultConfigurations(standardizer);
        if (file != null) {
            this.config = new EvaluatorConfiguration(file, standardizer);
            this.symtab.putAll(this.config.getVartab());
        }
        try {
            this.loadFunctionalGroups();
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
        if (importer != null) {
            this.loadNamedMols(importer, standardizer);
        }
        if (script == null) {
            this.runDefaultScripts();
        } else {
            this.runScript(script);
        }
    }

    Evaluator(Element element, String dir, Standardizer standardizer) throws ParseException {
        this.loadDefaultConfigurations(standardizer);
        if (element != null) {
            this.config = new EvaluatorConfiguration(element, dir, standardizer);
            this.symtab.putAll(this.config.getVartab());
        }
        try {
            this.loadFunctionalGroups();
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
        this.runDefaultScripts();
    }

    public Evaluator(String configString, Standardizer standardizer) throws ParseException {
        this(configString, standardizer, null, null);
    }

    public Evaluator(String configString, Standardizer standardizer, MolImporter importer, String script) throws ParseException {
        this.loadDefaultConfigurations(standardizer);
        if (configString != null) {
            this.config = new EvaluatorConfiguration(configString, null, standardizer);
            this.symtab.putAll(this.config.getVartab());
        }
        try {
            this.loadFunctionalGroups();
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
        if (importer != null) {
            this.loadNamedMols(importer, standardizer);
        }
        if (script == null) {
            this.runDefaultScripts();
        } else {
            this.runScript(script);
        }
    }

    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDefaultConfigurations(Standardizer standardizer) throws ParseException {
        InputStream is = null;
        try {
            is = Evaluator.class.getResourceAsStream(EVALUATOR_DEFAULTS_FILE);
            if (is != null) {
                this.builtInConfig = new EvaluatorConfiguration(is, standardizer);
                this.symtab.putAll(this.builtInConfig.getVartab());
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new ParseException(e);
            }
        }
        try {
            is = new ExternalFileLoader("config/evaluator.xml").openFileOutJar();
            if (is != null) {
                this.externalConfig = new EvaluatorConfiguration(is, standardizer);
                this.symtab.putAll(this.externalConfig.getVartab());
            }
        }
        catch (SecurityException e) {
            System.err.println("Can not load file: config/evaluator.xml. Access denied.");
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new ParseException(e);
            }
        }
        try {
            File dotFile = DotfileUtil.getDotFile(VersionInfo.MARVIN_MAJOR_VERSION + File.separator + EVALUATOR_DEFAULTS_FILE);
            is = new BufferedInputStream(new FileInputStream(dotFile));
            if (is != null) {
                this.userConfig = new EvaluatorConfiguration(is, standardizer);
                this.symtab.putAll(this.userConfig.getVartab());
            }
        }
        catch (FileNotFoundException e) {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e2) {
                throw new ParseException(e2);
            }
        }
        catch (SecurityException e) {
            System.err.println("Access denied: read user.home property");
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new ParseException(e);
            }
        }
    }

    private void loadFunctionalGroups() throws IOException {
        this.loadFunctionalGroupsFromStream(ConfigurationReader.getResourceAsStream(Evaluator.class, FUNCTIONAL_GROUPS_RESOURCE_PATH));
        this.loadFunctionalGroupsFromStream(ConfigurationReader.getConfigAsStream(FUNCTIONAL_GROUPS_CONFIG_DIR_PATH));
        this.loadFunctionalGroupsFromStream(ConfigurationReader.getUserConfigAsStream(FUNCTIONAL_GROUPS_USER_HOME_DIR_PATH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFunctionalGroupsFromStream(InputStream stream) throws IOException {
        if (stream == null) {
            return;
        }
        try {
            FunctionalGroupIterator it = new FunctionalGroupIterator(stream);
            while (it.hasNext()) {
                FunctionalGroup fg = it.next();
                String name = fg.getName().trim().replaceAll(" ", "_");
                this.symtab.put(name, fg.getQuery());
                if (fg.getRgroupRepresentation() == null || fg.getRgroupRepresentation().length() <= 0) continue;
                this.functionalGroupDisplayMolTable.put(name, fg.getRgroupRepresentation());
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private void loadNamedMols(MolImporter importer, Standardizer standardizer) throws ParseException {
        if (importer == null) {
            return;
        }
        Hashtable<String, Object> molsets = new Hashtable<String, Object>();
        try {
            String name = null;
            importer.setQueryMode(true);
            Molecule mol = null;
            while ((mol = importer.read()) != null) {
                HashSet<String> set;
                String molname = mol.getName();
                if (molname.length() > 0) {
                    name = molname;
                }
                if (name == null) {
                    throw new ParseException("Molecule without group name\n" + mol.toFormat(importer.getFormat()));
                }
                if (standardizer != null) {
                    standardizer.standardize(mol);
                }
                String molstr = mol.toFormat("smarts:u");
                Object o = molsets.get(name);
                if (o == null) {
                    molsets.put(name, molstr);
                    continue;
                }
                if (o instanceof HashSet) {
                    set = (HashSet<String>)o;
                    set.add(molstr);
                    continue;
                }
                set = new HashSet<String>();
                set.add((String)o);
                set.add(molstr);
                molsets.put(name, set);
            }
            this.symtab.putAll(molsets);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
        finally {
            if (importer != null) {
                try {
                    importer.close();
                }
                catch (IOException e) {
                    throw new ParseException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDefaultScripts() throws ParseException {
        BufferedReader reader;
        InputStream is = null;
        try {
            is = Evaluator.class.getResourceAsStream(EVALUATOR_SCRIPT_FILE);
            if (is != null) {
                reader = new BufferedReader(new InputStreamReader(is));
                String script = ConfigUtils.getContent(reader);
                this.runScript(script);
            }
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new ParseException(e);
            }
        }
        reader = null;
        try {
            File dotFile = DotfileUtil.getDotFile(VersionInfo.MARVIN_MAJOR_VERSION + File.separator + EVALUATOR_SCRIPT_FILE);
            reader = new BufferedReader(new FileReader(dotFile));
            String script = ConfigUtils.getContent(reader);
            this.runScript(script);
        }
        catch (FileNotFoundException e) {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e2) {
                throw new ParseException(e2);
            }
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
        catch (SecurityException e) {
            System.err.println("Access denied: read user.home property");
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new ParseException(e);
            }
        }
    }

    public void runScript(String script) throws ParseException {
        if (!script.equals("")) {
            script = script.replace('\n', ';');
            ChemJEP jep = this.compile(script);
            jep.evaluate(null);
            this.symtab.putAll(jep.getSymbolTable());
        }
    }

    public Hashtable getFunctionParameterData() throws ParseException {
        Hashtable<Object, Object> data = new Hashtable();
        if (this.builtInConfig != null) {
            data = this.builtInConfig.getFunctionParameterData();
        }
        if (this.externalConfig != null) {
            data.putAll(this.externalConfig.getFunctionParameterData());
        }
        if (this.userConfig != null) {
            data.putAll(this.userConfig.getFunctionParameterData());
        }
        if (this.config != null) {
            data.putAll(this.config.getFunctionParameterData());
        }
        return data;
    }

    public String[] getPluginIDs() throws ParseException {
        HashSet<String> ids0 = this.builtInConfig != null ? this.builtInConfig.getPluginIDs() : new HashSet<String>();
        HashSet<String> ids1 = this.externalConfig != null ? this.externalConfig.getPluginIDs() : new HashSet<String>();
        HashSet<String> ids2 = this.userConfig != null ? this.userConfig.getPluginIDs() : new HashSet<String>();
        HashSet<String> ids3 = this.config != null ? this.config.getPluginIDs() : new HashSet<String>();
        ids0.addAll(ids1);
        ids0.addAll(ids2);
        ids0.addAll(ids3);
        return ids0.toArray(new String[ids0.size()]);
    }

    public Hashtable<String, CTFunctionData> getFunctionData() throws ParseException {
        return this.getFunctionData(false);
    }

    public Hashtable<String, CTFunctionData> getFunctionData(boolean addServices) throws ParseException {
        Hashtable<Object, Object> data = new Hashtable();
        if (this.builtInConfig != null) {
            data = this.builtInConfig.getFunctionData();
        }
        if (this.externalConfig != null) {
            data.putAll(this.externalConfig.getFunctionData());
        }
        if (this.userConfig != null) {
            data.putAll(this.userConfig.getFunctionData());
        }
        if (this.config != null) {
            data.putAll(this.config.getFunctionData());
        }
        if (addServices) {
            data.putAll(EvaluatorConfiguration.getServiceFunctionData());
        }
        return data;
    }

    public SymbolTable getSymbolTable() {
        return this.symtab;
    }

    public Hashtable<String, String> getFunctionalGroupDisplayMolTable() {
        return this.functionalGroupDisplayMolTable;
    }

    public void setFingerprintGenerator(FingerprintGenerator fg) {
        if (this.builtInConfig != null) {
            this.builtInConfig.setFingerprintGenerator(fg);
        }
        if (this.externalConfig != null) {
            this.externalConfig.setFingerprintGenerator(fg);
        }
        if (this.userConfig != null) {
            this.userConfig.setFingerprintGenerator(fg);
        }
        if (this.config != null) {
            this.config.setFingerprintGenerator(fg);
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public ChemJEP compile(String expression) throws ParseException {
        return this.compile(expression, null);
    }

    public ChemJEP compile(String expression, Class contextClass) throws ParseException {
        return this.compile(expression, contextClass, null);
    }

    public ChemJEP compile(String expression, Class contextClass, SymbolTable stab) throws ParseException {
        ChemJEP jep = new ChemJEP(contextClass);
        if (this.verbose) {
            jep.setTraverse(true);
        }
        if (stab == null) {
            Evaluator.addVariables(jep, this.symtab);
        } else {
            jep.setSymbolTable(stab);
        }
        Hashtable<String, PostfixMathCommandI> funtab = null;
        if (this.builtInConfig != null || this.externalConfig != null || this.userConfig != null || this.config != null) {
            funtab = new Hashtable<String, PostfixMathCommandI>();
            if (this.builtInConfig != null) {
                this.builtInConfig.setLicenseEnvironment(this.licenseEnvironment);
                funtab.putAll(this.builtInConfig.getFuntab());
            }
            if (this.externalConfig != null) {
                this.externalConfig.setLicenseEnvironment(this.licenseEnvironment);
                funtab.putAll(this.externalConfig.getFuntab());
            }
            if (this.userConfig != null) {
                this.userConfig.setLicenseEnvironment(this.licenseEnvironment);
                funtab.putAll(this.userConfig.getFuntab());
            }
            if (this.config != null) {
                this.config.setLicenseEnvironment(this.licenseEnvironment);
                funtab.putAll(this.config.getFuntab());
            }
        }
        if (this.servicesFunctionTable == null) {
            this.servicesFunctionTable = EvaluatorConfiguration.getServiceFunctions();
        }
        if (this.servicesFunctionTable != null) {
            funtab.putAll(this.servicesFunctionTable);
        }
        if (funtab != null) {
            Enumeration names = funtab.keys();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                PostfixMathCommandI function = (PostfixMathCommandI)funtab.get(name);
                if (function instanceof ChemFunction) {
                    ((ChemFunction)function).setJEP(jep);
                }
                if (function instanceof EvaluatorFunction) {
                    ((EvaluatorFunction)function).setEvaluator(this);
                }
                jep.addFunction(name, function);
            }
        }
        jep.compile(expression);
        return jep;
    }

    private static void addVariables(ChemJEP jep, Hashtable vartab) {
        Enumeration names = vartab.keys();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            jep.addVariableAsObject(name, vartab.get(name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getChemicalTermsFunctionListHelp() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(CHEMICAL_TERMS_FUNCTION_LIST_HELP_HEADER);
        InputStream[] evaluatorConfigs = null;
        try {
            InputStream builtInConfig = Evaluator.class.getResourceAsStream(EVALUATOR_DEFAULTS_FILE);
            InputStream externalConfig = new ExternalFileLoader("config/evaluator.xml").openFileOutJar();
            BufferedInputStream userConfig = null;
            File userConfigFile = DotfileUtil.getDotFile(EVALUATOR_DEFAULTS_FILE);
            if (userConfigFile.exists()) {
                userConfig = new BufferedInputStream(new FileInputStream(userConfigFile));
            }
            evaluatorConfigs = new InputStream[]{builtInConfig, externalConfig, userConfig};
            sb.append(StringUtil.convertToMultiLine(Evaluator.getChemicalTermsFunctionList(evaluatorConfigs), " ", 79));
        }
        finally {
            if (evaluatorConfigs != null) {
                for (InputStream inputStream : evaluatorConfigs) {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        sb.append(CHEMICAL_TERMS_FUNCTION_LIST_HELP_FOOTER);
        return sb.toString();
    }

    private static String getChemicalTermsFunctionList(InputStream[] evaluatorConfigs) throws Exception {
        StringBuffer sb = new StringBuffer();
        TreeSet ts = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < evaluatorConfigs.length; ++i) {
            InputStream is = evaluatorConfigs[i];
            if (is == null) continue;
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
            Element root = doc.getDocumentElement();
            Evaluator.addIDsFromNodesListToTreeSet(XPathUtil.getFirstNodeListFromPath("Functions/Function", root), ts);
            Evaluator.addIDsFromNodesListToTreeSet(XPathUtil.getFirstNodeListFromPath("Plugins/Plugin", root), ts);
            Evaluator.addIDsFromNodesListToTreeSet(root.getElementsByTagName("Matching"), ts);
            Evaluator.addIDsFromNodesListToTreeSet(root.getElementsByTagName("Dissimilarity"), ts);
        }
        Iterator it = ts.iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            sb.append(id + "()");
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private static void addIDsFromNodesListToTreeSet(NodeList nodeList, TreeSet treeSet) {
        if (nodeList != null && treeSet != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                Element element = (Element)node;
                String id = element.getAttribute("ID");
                treeSet.add(id);
            }
        }
    }

    public static String toString(Object o) {
        return EvaluatorUtils.toString(o);
    }

    public static String toString(Object o, int precision) {
        return EvaluatorUtils.toString(o, precision);
    }

    public static String toString(Object o, DecimalFormat df) {
        return EvaluatorUtils.toString(o, df);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        boolean cloning;
        String cleanStr;
        int len;
        boolean extract;
        CLQ clq = new CLQ(args, null);
        if (args.length == 0 || clq.lookup("-h", "--help", "", 1, false, false) != null) {
            System.out.println(helptext);
            return;
        }
        if (clq.lookup("-l", "--list-functions", "", 1, false, false) != null) {
            System.out.println(Evaluator.getChemicalTermsFunctionListHelp());
            return;
        }
        CLQ.Parameter pConfig = clq.lookup("-c", "--config", "", 2, false, false);
        File config = pConfig != null ? new File(pConfig.getString()) : null;
        boolean noInput = clq.lookup("-n", "--no-input-mol", "", 1, false, false) != null;
        CLQ.Parameter pVerbose = clq.lookup("-v", "--verbose", "", 1, false, false);
        boolean verbose = pVerbose != null;
        CLQ.Parameter pExprStr = clq.lookup("-e", "--expr-string", "", 2, false, false);
        if (pExprStr == null) {
            System.out.println("no expression specified");
            return;
        }
        String exprStr = pExprStr.getString();
        String expression = new File(exprStr).exists() ? ConfigUtils.getContent(new BufferedReader(new FileReader(exprStr))) : exprStr;
        CLQ.Parameter pExtract = clq.lookup("-x", "--extract", "", 2, false, false);
        CLQ.Parameter pFormat = clq.lookup("-f", "--format", "", 2, false, false);
        boolean bl = extract = pExtract != null;
        String format2 = extract ? pExtract.getString() : (pFormat != null ? pFormat.getString() : null);
        CLQ.Parameter pClean = clq.lookup("-C", "--clean", "", 2, false, false);
        int cleanDim = 0;
        String cleanOpts = "t2000";
        if (pClean != null && (len = (cleanStr = pClean.getString()).length()) > 0) {
            cleanDim = Integer.parseInt(cleanStr.substring(0, 1));
            if (len > 2) {
                cleanOpts = cleanStr.substring(2);
            } else if (len == 2) {
                cleanOpts = null;
            }
        }
        boolean strOutput = clq.lookup("-S", "--sdf-output", "", 1, false, false) == null;
        CLQ.Parameter pTag = clq.lookup("-t", "--tag", "", 2, false, false);
        String tag = pTag != null ? pTag.getString() : DEFAULT_TAG_NAME;
        boolean includeExpr = clq.lookup("-i", "--include-expr", "", 1, false, false) != null;
        boolean ignoreError = clq.lookup("-g", "--ignore-error", "", 1, false, false) != null;
        CLQ.Parameter pPrecision = clq.lookup("-p", "--precision", "", 2, false, false);
        int precision = pPrecision != null ? pPrecision.getInt() : 2;
        CLQ.Parameter pOut = clq.lookup("-o", "--output", "", 2, false, false);
        PrintStream os = null;
        os = pOut != null ? new PrintStream(new BufferedOutputStream(new FileOutputStream(pOut.getString()))) : new PrintStream(new BufferedOutputStream(System.out));
        Element eroot = null;
        String dir = null;
        if (config != null) {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(config);
            Element root = doc.getDocumentElement();
            NodeList nodeList = XPathUtil.getFirstNodeListFromPath("Evaluator", root);
            if (nodeList != null) {
                eroot = (Element)nodeList.item(0);
            }
            if (eroot == null) {
                eroot = root;
            }
            dir = config.getParent();
        }
        boolean bl2 = cloning = extract || !strOutput;
        MolExporter exporter = format2 != null ? new MolExporter(os, format2) : (strOutput ? null : new MolExporter(os, "sdf"));
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(precision);
        Evaluator evaluator = new Evaluator(eroot, dir, null);
        evaluator.setVerbose(verbose);
        ChemJEP jep = evaluator.compile(expression, MolContext.class);
        if (noInput) {
            if (extract) {
                System.out.println("Extract mode requires input molecules.");
                return;
            }
            if (!strOutput) {
                System.out.println("SDF output requires input molecules.");
                return;
            }
            try {
                Object result = jep.evaluate(null);
                String str = includeExpr ? expression + "\n" + EvaluatorUtils.toString(result, df) : EvaluatorUtils.toString(result, df);
                os.println(str);
            }
            finally {
                os.flush();
                if (pOut != null) {
                    os.close();
                }
            }
            return;
        }
        int molCount = 0;
        MolContext context = new MolContext();
        MolImporter[] ins = ConfigUtils.getTargetMolImporters(clq);
        try {
            for (int i = 0; i < ins.length; ++i) {
                MolImporter importer = ins[i];
                Molecule mol = null;
                while ((mol = ConfigUtils.readMol(importer, ignoreError)) != null) {
                    String str;
                    ++molCount;
                    if (ConfigUtils.isReadErrorMol(mol)) {
                        System.err.println("Import error when reading molecule " + molCount + ": " + ConfigUtils.getReadErrorMessage(mol));
                    }
                    Molecule mol2 = mol;
                    if (cloning) {
                        mol2 = (Molecule)mol.clone();
                    }
                    context.setMolecule(mol);
                    if (extract) {
                        boolean result = jep.evaluate_boolean(context);
                        if (!result) continue;
                        if (cleanDim != 0) {
                            mol2.clean(cleanDim, cleanOpts);
                        } else if (exporter.isCleanable() && mol2.getDim() == 0) {
                            mol2.clean(2, cleanOpts);
                        }
                        ConfigUtils.writeMol(mol2, exporter, ignoreError);
                        continue;
                    }
                    try {
                        Object result = jep.evaluate(context);
                        if (exporter != null && (result instanceof Molecule || result instanceof Molecule[])) {
                            if (result instanceof Molecule) {
                                Molecule rmol = (Molecule)result;
                                if (cleanDim != 0) {
                                    rmol.clean(cleanDim, cleanOpts);
                                } else if (exporter.isCleanable() && rmol.getDim() == 0) {
                                    rmol.clean(2, cleanOpts);
                                }
                                ConfigUtils.writeMol(rmol, exporter, ignoreError);
                                continue;
                            }
                            Molecule[] mols = (Molecule[])result;
                            for (int j = 0; j < mols.length; ++j) {
                                if (cleanDim != 0) {
                                    mols[j].clean(cleanDim, cleanOpts);
                                } else if (exporter.isCleanable() && mols[j].getDim() == 0) {
                                    mols[j].clean(2, cleanOpts);
                                }
                                ConfigUtils.writeMol(mols[j], exporter, ignoreError);
                            }
                            continue;
                        }
                        String string = str = includeExpr ? expression + "\n" + EvaluatorUtils.toString(result, df) : EvaluatorUtils.toString(result, df);
                        if (strOutput) {
                            if (result instanceof byte[]) {
                                os.write((byte[])result, 0, ((byte[])result).length);
                                continue;
                            }
                            os.println(str);
                            continue;
                        }
                        if (result instanceof byte[]) {
                            System.err.println("Binary result can not be stored in SDF tag.");
                            continue;
                        }
                        mol2.setProperty(tag, str);
                        if (cleanDim != 0) {
                            mol2.clean(cleanDim, cleanOpts);
                        } else if (mol2.getDim() == 0) {
                            mol2.clean(2, cleanOpts);
                        }
                        ConfigUtils.writeMol(mol2, exporter, ignoreError);
                    }
                    catch (ParseException e) {
                        if (ignoreError) {
                            if (strOutput) {
                                str = includeExpr ? expression + "\n" + "" : "";
                                os.println(str);
                            } else {
                                str = includeExpr ? expression + "\n" + "\n" : "\n";
                                mol2.setProperty(tag, str);
                                if (cleanDim != 0) {
                                    mol2.clean(cleanDim, cleanOpts);
                                } else if (mol2.getDim() == 0) {
                                    mol2.clean(2, cleanOpts);
                                }
                                ConfigUtils.writeMol(mol2, exporter, ignoreError);
                            }
                            e.printStackTrace();
                            continue;
                        }
                        throw e;
                    }
                }
            }
        }
        finally {
            if (exporter != null) {
                exporter.close();
            } else {
                os.flush();
                if (pOut != null) {
                    os.close();
                }
            }
        }
    }
}

