/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jep;

import chemaxon.struc.Molecule;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Iterator;

public class EvaluatorUtils {
    public static String toString(Object o) {
        return EvaluatorUtils.toString(o, 2);
    }

    public static String toString(Object o, int precision) {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(precision);
        return EvaluatorUtils.toString(o, df);
    }

    public static String toString(Object o, DecimalFormat df) {
        if (o == null) {
            return "null";
        }
        if (o instanceof Collection) {
            Iterator it = ((Collection)o).iterator();
            StringBuffer buffer = new StringBuffer();
            buffer.append("{");
            while (it.hasNext()) {
                buffer.append(EvaluatorUtils.toString(it.next(), df));
                if (!it.hasNext()) continue;
                buffer.append(",");
            }
            buffer.append("}");
            return new String(buffer);
        }
        if (o instanceof Molecule) {
            Molecule m = (Molecule)o;
            return m.isQuery() ? m.toFormat("smarts") : m.toFormat("smiles");
        }
        if (o instanceof Double) {
            double v = (Double)o;
            if (!Double.isNaN(v)) {
                return df.format(v);
            }
            return "";
        }
        if (o instanceof double[]) {
            StringBuffer s = new StringBuffer();
            double[] a = (double[])o;
            for (int i = 0; i < a.length; ++i) {
                if (i > 0) {
                    s.append(";");
                }
                if (Double.isNaN(a[i])) continue;
                s.append(df.format(a[i]));
            }
            return new String(s);
        }
        if (o instanceof int[][]) {
            int[][] xx = (int[][])o;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < xx.length; ++i) {
                int[] x = xx[i];
                sb.append("[");
                for (int j = 0; j < x.length; ++j) {
                    if (Double.isNaN(x[j])) {
                        sb.append("");
                    } else {
                        sb.append(x[j]);
                    }
                    if (j >= x.length - 1) continue;
                    sb.append(";");
                }
                sb.append("]");
            }
            return sb.toString();
        }
        if (o instanceof int[]) {
            StringBuffer s = new StringBuffer();
            int[] a = (int[])o;
            for (int i = 0; i < a.length; ++i) {
                if (i > 0) {
                    s.append(";");
                }
                s.append(a[i]);
            }
            return new String(s);
        }
        if (o instanceof long[]) {
            StringBuffer s = new StringBuffer();
            long[] a = (long[])o;
            for (int i = 0; i < a.length; ++i) {
                if (i > 0) {
                    s.append(";");
                }
                s.append(a[i]);
            }
            return new String(s);
        }
        if (o instanceof Molecule[]) {
            StringBuffer s = new StringBuffer();
            Molecule[] a = (Molecule[])o;
            for (int i = 0; i < a.length; ++i) {
                if (i > 0) {
                    s.append("\n");
                }
                s.append(a[i].isQuery() ? a[i].toFormat("smarts") : a[i].toFormat("smiles"));
            }
            return new String(s);
        }
        if (o instanceof Object[]) {
            StringBuffer s = new StringBuffer();
            Object[] a = (Object[])o;
            for (int i = 0; i < a.length; ++i) {
                if (i > 0) {
                    s.append(";");
                }
                s.append(EvaluatorUtils.toString(a[i], df));
            }
            return new String(s);
        }
        return o.toString();
    }
}

