/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jep.context;

import chemaxon.jep.context.MolContext;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.struc.Molecule;
import java.util.Arrays;

public class SearchContext
extends MolContext {
    public static String[] CFNS = new String[]{"mol", "target", "query", "m", "hit", "h", "hm", "hitmap", "fingerprint", "tfingerprint", "qfingerprint"};
    protected static final int MAXMAPS = 1024;
    private Molecule query = null;
    private int[] queryFingerprint = null;
    private int[] map = new int[1024];
    private int[] hit = null;

    @Override
    public String[] getContextFunctionNames() {
        return CFNS;
    }

    @Override
    public Object callback(String method, Object arg) {
        Object result = super.callback(method, arg);
        if (result != null) {
            return result;
        }
        if (method.equalsIgnoreCase("target")) {
            return this.getMolecule();
        }
        if (method.equalsIgnoreCase("tfingerprint")) {
            return this.getFingerprint(arg);
        }
        if (method.equalsIgnoreCase("query")) {
            if (this.query == null && this.queryFingerprint == null) {
                return new ParseException("Undefined symbol: query");
            }
            return this.query;
        }
        if (method.equalsIgnoreCase("qfingerprint")) {
            return this.getQueryFingerprint(arg);
        }
        if (method.equalsIgnoreCase("m")) {
            if (this.query == null) {
                return new ParseException("Undefined symbol: query");
            }
            int i = ((Number)arg).intValue();
            if (this.map[i] == -1) {
                return new ParseException("Undefined map: " + i);
            }
            return new Integer(this.map[i]);
        }
        if (method.equalsIgnoreCase("hit") || method.equalsIgnoreCase("h")) {
            if (this.hit == null) {
                return new ParseException("Undefined symbols: hit, h");
            }
            if (arg != null) {
                int i = ((Number)arg).intValue();
                int h = this.hit[i];
                if (this.isValidTargetAtomIndex(h)) {
                    return new Integer(h);
                }
                return null;
            }
            return this.hit;
        }
        if (method.equalsIgnoreCase("hitmap") || method.equalsIgnoreCase("hm")) {
            if (this.query == null || this.hit == null) {
                return new ParseException("Undefined symbols: hitmap, hm");
            }
            int i = ((Number)arg).intValue();
            if (this.map[i] == -1) {
                return new ParseException("Undefined map: " + i);
            }
            int h = this.hit[this.map[i]];
            if (this.isValidTargetAtomIndex(h)) {
                return new Integer(h);
            }
            return null;
        }
        return null;
    }

    private boolean isValidTargetAtomIndex(int i) {
        return i >= 0 && i < this.getMolecule().getAtomCount();
    }

    public void setTarget(Molecule target) {
        this.setMolecule(target);
    }

    public Molecule getTarget() {
        return this.getMolecule();
    }

    public void setQuery(Molecule query) {
        this.query = query;
        Arrays.fill(this.map, -1);
        if (query != null) {
            for (int i = query.getAtomCount() - 1; i >= 0; --i) {
                int m = query.getAtom(i).getAtomMap();
                if (m == 0) continue;
                this.map[m] = i;
            }
        }
    }

    public Molecule getQuery() {
        return this.query;
    }

    public void setTargetFingerprint(int[] fingerprint) {
        this.setFingerprint(fingerprint);
    }

    public int[] getTargetFingerprint() {
        return this.getFingerprint();
    }

    public void setQueryFingerprint(int[] fingerprint) {
        this.queryFingerprint = fingerprint;
    }

    public int[] getQueryFingerprint() {
        return this.queryFingerprint;
    }

    protected int[] getQueryFingerprint(Object arg) {
        return this.query == arg ? this.queryFingerprint : null;
    }

    public void setHit(int[] hit) {
        this.hit = hit;
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this.map, -1);
        this.query = null;
        this.hit = null;
    }
}

