/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jep.function;

import chemaxon.jep.ChemJEP;
import chemaxon.jep.EvaluatorFunction;
import chemaxon.jep.context.AtomContext;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.nfunk.jep.function.PostfixMathCommandI;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.Stack;

public class AtomEvaluatorFunction
extends EvaluatorFunction {
    protected ChemJEP innerJEP = null;
    protected AtomContext innerContext = new AtomContext();
    protected Molecule target = null;
    protected int[] atoms = null;
    protected Object arg = null;

    public AtomEvaluatorFunction() {
        super(-1);
    }

    protected AtomEvaluatorFunction newInstance() {
        return new AtomEvaluatorFunction();
    }

    protected Object evaluate() throws ParseException {
        int size = this.atoms != null ? this.atoms.length : this.target.getAtomCount();
        double[] result = new double[size];
        for (int i = 0; i < size; ++i) {
            int atom = this.atoms != null ? this.atoms[i] : i;
            this.innerContext.setAtom(atom);
            result[i] = this.innerJEP.evaluate_double(this.innerContext);
        }
        return result;
    }

    @Override
    public void run(Stack s) throws ParseException {
        int n = 0;
        int c = this.curNumberOfParameters - 1;
        ArrayList list = new ArrayList(this.curNumberOfParameters);
        for (int i = c; i >= 0; --i) {
            Object p = s.pop();
            if (p instanceof Molecule) {
                this.target = (Molecule)p;
                continue;
            }
            list.add(p);
            if ((i >= c || !(p instanceof Number)) && !(p instanceof MolAtom)) continue;
            ++n;
        }
        if (this.target == null) {
            this.target = (Molecule)this.callback("mol", null);
        }
        if (n > 0) {
            this.atoms = new int[n];
        }
        int t = 0;
        String condition = null;
        for (int i = list.size() - 1; i >= 0; --i) {
            Object p = list.get(i);
            if (i > 0 && p instanceof Number) {
                this.atoms[t++] = AtomEvaluatorFunction.getInt(p);
                continue;
            }
            if (p instanceof MolAtom) {
                int index;
                MolAtom atom = (MolAtom)p;
                if (this.target == null) {
                    this.target = (Molecule)atom.getParent();
                }
                if ((index = this.target.indexOf((MolAtom)p)) == -1) {
                    throw new ParseException("atom parameter does not belong to the target molecule");
                }
                this.atoms[t++] = index;
                continue;
            }
            if (p instanceof int[]) {
                this.atoms = (int[])p;
                continue;
            }
            if (p instanceof String) {
                condition = (String)p;
                continue;
            }
            if (this.arg == null) {
                this.arg = p;
                continue;
            }
            throw new ParseException("Illegal argument: " + p);
        }
        if (this.target == null) {
            s.push(UNDECIDED);
            return;
        }
        if (condition == null) {
            throw new ParseException("No filtering condition specified.");
        }
        if (this.innerJEP == null) {
            this.innerJEP = this.compile(condition, AtomContext.class);
        }
        this.innerContext.setMolecule(this.target);
        Object result = this.evaluate();
        this.innerContext.setMolecule(null);
        this.target = null;
        this.atoms = null;
        this.arg = null;
        s.push(result);
    }

    @Override
    public PostfixMathCommandI getFunction() {
        AtomEvaluatorFunction fun = this.newInstance();
        fun.setJEP(this.getJEP());
        fun.setEvaluator(this.getEvaluator());
        return fun;
    }
}

