/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jep.function;

import chemaxon.jep.ChemFunction;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import java.util.Properties;
import java.util.Stack;

public class AtomProperties
extends ChemFunction {
    public static final String CHARGE = "charge";
    public static final String HCOUNT = "hcount";
    public static final String CONNECTIONS = "connections";
    public static final String VALENCE = "valence";
    public static final String RADICAL_COUNT = "radicalcount";
    public static final String ATNO = "atno";
    public static final String MAP = "map";
    public static final String AROM = "arom";
    public static final String[] PROPS = new String[]{"charge", "hcount", "connections", "valence", "radicalcount", "atno", "map", "arom"};
    private String property = null;

    public AtomProperties() {
        super(-1);
    }

    @Override
    protected void setParameters(Properties params) throws ParseException {
        this.property = params.getProperty("property");
        if (this.property != null && !this.checkProperty(this.property)) {
            throw new ParseException("Atomic property not implemented: " + this.property);
        }
    }

    private boolean checkProperty(String prop) {
        for (int i = 0; i < PROPS.length; ++i) {
            if (!PROPS[i].equalsIgnoreCase(prop)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void run(Stack s) throws ParseException {
        MoleculeGraph mol = null;
        String prop = this.property;
        int index = -1;
        MolAtom atom = null;
        boolean valid = true;
        for (int i = this.curNumberOfParameters - 1; i >= 0; --i) {
            Object p = s.pop();
            if (p == null) {
                valid = false;
                continue;
            }
            if (p instanceof String) {
                prop = (String)p;
                continue;
            }
            if (p instanceof Number) {
                index = AtomProperties.getInt(p);
                continue;
            }
            if (p instanceof Molecule) {
                mol = (Molecule)p;
                continue;
            }
            if (p instanceof MolAtom) {
                atom = (MolAtom)p;
                continue;
            }
            throw new ParseException("Illegal argument: " + p);
        }
        if (!valid) {
            s.push(NAN);
            return;
        }
        if (atom == null) {
            if (index == -1) {
                Object p = this.callback("atom", null);
                if (p != null) {
                    index = AtomProperties.getInt(p);
                }
                if (index == -1) {
                    index = 0;
                }
            }
            if (mol == null) {
                mol = (Molecule)this.callback("mol", null);
            }
            if (mol == null) {
                s.push(UNDECIDED);
                return;
            }
            atom = mol.getAtom(index);
        }
        if (CHARGE.equalsIgnoreCase(prop)) {
            s.push(new Double(atom.getCharge()));
        } else if (HCOUNT.equalsIgnoreCase(prop)) {
            s.push(new Double(atom.getExplicitHcount() + atom.getImplicitHcount()));
        } else if (CONNECTIONS.equalsIgnoreCase(prop)) {
            s.push(new Double(atom.getBondCount() + atom.getImplicitHcount()));
        } else if (VALENCE.equalsIgnoreCase(prop)) {
            s.push(new Double(atom.getValence()));
        } else if (RADICAL_COUNT.equalsIgnoreCase(prop)) {
            s.push(new Double(atom.getRadicalCount()));
        } else if (ATNO.equalsIgnoreCase(prop)) {
            s.push(new Double(atom.getAtno()));
        } else if (MAP.equalsIgnoreCase(prop)) {
            s.push(new Double(atom.getAtomMap()));
        } else if (AROM.equalsIgnoreCase(prop)) {
            s.push(atom.hasAromaticBond() ? TRUE : FALSE);
        } else {
            throw new ParseException("Atomic property not implemented: " + prop);
        }
    }
}

