/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jep.function;

import chemaxon.jep.ChemFunction;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import java.util.Stack;

public class HasRadical
extends ChemFunction {
    public HasRadical() {
        super(-1);
    }

    @Override
    public void run(Stack s) throws ParseException {
        MoleculeGraph mol = null;
        boolean hasRadical = false;
        for (int i = this.curNumberOfParameters - 1; i >= 0; --i) {
            Object p = s.pop();
            if (!(p instanceof Molecule)) {
                throw new ParseException("Illegal argument: " + p);
            }
            mol = (Molecule)p;
        }
        if (mol == null && (mol = (Molecule)this.callback("mol", null)) == null) {
            throw new ParseException("No input molecule.");
        }
        for (MolAtom atom : mol.getAtomArray()) {
            if (atom.getRadicalCount() == 0) continue;
            hasRadical = true;
            break;
        }
        s.push(new Boolean(hasRadical));
    }
}

